<?php

namespace Eventman;
require_once( __DIR__ . '/vendor/autoload.php' );
use Eventman\Includes\MsEventman;
use Eventman\Includes\MsEventmanActivator;
use Eventman\Includes\MsEventmanDeactivator;
use threewp_broadcast\api\api;

/**
 * Plugin Name: Multi-site Event Content Manager
 * Author:			Beau Fiechter (For RTM Business)
 * Author Email:	beau.fiechter@rtmmedia.nl
 * Description:	    Event content manager for multi-site setups.
 * Version:		    1.0.3
 */


// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 */
define( 'MS-EVENTMAN', '1.0.3' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-ms-eventman-activator.php
 */
function activateMsEventman() {
    MsEventmanActivator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-ms-eventman-deactivator.php
 */
function deactivateMsEventman() {
	MsEventmanDeactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_ms_eventman' );
register_deactivation_hook( __FILE__, 'deactivate_ms_eventman' );

if ( ! function_exists('dd') ) {

    function dd() {
        call_user_func_array( 'dump' , func_get_args() );
        die();
    }

}

function interevent_get_attachment_url($id, $size) {
    $api = new api();
    $controller = $api->linking($id);
    if ($controller->is_child()) {
        $parent = $controller->parent();
        $currentHome = get_home_url();

        switch_to_blog($parent['blog_id']);

        $image_url = str_replace(get_home_url(), $currentHome, wp_get_attachment_image_url($parent['post_id'], $size));
        restore_current_blog();
    } else {
        $image_url = wp_get_attachment_image_url($id, $size);
    }
    return $image_url;
}

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function runMsEventman() {

	$plugin = new MsEventman();
	$plugin->run();

}
runMsEventman();
