<?php

namespace Eventman\Admin;

class NavEdit
{

    public function __construct()
    {
        remove_filter('wp_edit_nav_menu_walker', 'elision_qode_edit_walker');
        add_action('wp_nav_menu_item_custom_fields', [$this, 'nav_item_menu_custom_fields'], 10, 5);

    }

    public function enqueue_styles_and_scripts()
    {
        wp_enqueue_style( 'font-awesome-5-free', '//use.fontawesome.com/releases/v5.7.2/css/all.css"' );

        //Add the Select2 CSS file
        wp_enqueue_style( 'select2-css', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css', array(), '4.1.0-rc.0');

        //Add the Select2 JavaScript file
        wp_enqueue_script( 'select2-js', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', 'jquery', '4.1.0-rc.0');

        //Add a JavaScript file to initialize the Select2 elements
        wp_enqueue_script( 'select2-init', plugin_dir_url(__FILE__) . 'js/nav-menu.js', 'jquery', '1.1.0');

    }

    public function nav_item_menu_custom_fields($item_id, $item, $depth, $args, $id)
    {
        $original_title = false;

        if ( 'taxonomy' === $item->type ) {
            $original_object = get_term( (int) $item->object_id, $item->object );
            if ( $original_object && ! is_wp_error( $original_object ) ) {
                $original_title = $original_object->name;
            }
        } elseif ( 'post_type' === $item->type ) {
            $original_object = get_post( $item->object_id );
            if ( $original_object ) {
                $original_title = get_the_title( $original_object->ID );
            }
        } elseif ( 'post_type_archive' === $item->type ) {
            $original_object = get_post_type_object( $item->object );
            if ( $original_object ) {
                $original_title = $original_object->labels->archives;
            }
        }
        $removed_args = array(
            'action',
            'customlink-tab',
            'edit-menu-item',
            'menu-item',
            'page-tab',
            '_wpnonce',
        );

        ?>
        <p class="field-custom description description-thin description-thin-custom">
									<label for="edit-menu-item-anchor-<?php echo esc_attr($item_id); ?>">
	                    <?php esc_html_e( 'Anchor', 'elision' ); ?><br />
	                    <input type="text" id="edit-menu-item-anchor-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-anchor" name="menu-item-anchor[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->anchor ); ?>" />
	                </label>
							</p>
							<p class="field-custom description description-wide">
								<?php
									$value = $item->nolink;
									if($value != "") $value = "checked='checked'";
								?>
									<label for="edit-menu-item-nolink-<?php echo esc_attr($item_id); ?>">
										<input type="checkbox" id="edit-menu-item-nolink-<?php echo esc_attr($item_id); ?>" class="code edit-menu-item-custom" name="menu-item-nolink[<?php echo esc_attr($item_id); ?>]" value="nolink" <?php echo elision_qode_get_module_part($value); ?> />
										<?php esc_html_e( "Don't link", 'elision' ); ?>
									</label>
							</p>
							<p class="field-custom description description-wide">
								<?php
									$value = $item->hide;
									if($value != "") $value = "checked='checked'";
								?>
									<label for="edit-menu-item-hide-<?php echo esc_attr($item_id); ?>">
										<input type="checkbox" id="edit-menu-item-hide-<?php echo esc_attr($item_id); ?>" class="code edit-menu-item-custom" name="menu-item-hide[<?php echo esc_attr($item_id); ?>]" value="hide" <?php echo elision_qode_get_module_part($value); ?> />
										<?php esc_html_e( "Don't show", 'elision' ); ?>
									</label>
							</p>
							<p class="field-custom description description-thin description-thin-custom">
	                			<label for="edit-menu-item-type-menu-<?php echo esc_attr($item_id); ?>">
	                    		<?php esc_html_e( 'Type', 'elision' ); ?><br />
								<select id="edit-menu-item-type-menu<?php echo esc_attr($item_id); ?>" name="menu-item-type_menu[<?php echo esc_attr($item_id); ?>]">
									<option value="" <?php if(esc_attr($item->type_menu) == ""){echo 'selected="selected"';} ?>></option>
									<option value="wide" <?php if(esc_attr($item->type_menu) == "wide"){echo 'selected="selected"';} ?>><?php esc_html_e( 'wide', 'elision' ); ?></option>
									<option value="wide_icons" <?php if(esc_attr($item->type_menu) == "wide_icons"){echo 'selected="selected"';} ?>><?php esc_html_e( 'wide with icons', 'elision' ); ?></option>
								</select>
				                </label>
				            </p>
				            <p class="field-custom description description-thin description-thin-custom">
	                			<label for="edit-menu-item-wide-position-<?php echo esc_attr($item_id); ?>">
	                    		<?php esc_html_e( 'Wide menu position', 'elision' ); ?><br />
								<select id="edit-menu-item-wide-position<?php echo esc_attr($item_id); ?>" name="menu-item-wide_position[<?php echo esc_attr($item_id); ?>]">
									<option value="" <?php if(esc_attr($item->wide_position) == ""){echo 'selected="selected"';} ?>></option>
									<option value="left" <?php if(esc_attr($item->wide_position) == "left"){echo 'selected="selected"';} ?>><?php esc_html_e( 'left', 'elision' ); ?></option>
									<option value="right" <?php if(esc_attr($item->wide_position) == "right"){echo 'selected="selected"';} ?>><?php esc_html_e( 'right', 'elision' ); ?></option>
								</select>
				                </label>
				            </p>
							<p class="field-custom description description-thin description-thin-custom">
								<label for="edit-menu-item-icon-<?php echo esc_attr($item_id); ?>">
								<?php esc_html_e( 'Icon', 'elision' ); ?><br />
								<select id="edit-menu-item-icon-<?php echo esc_attr($item_id); ?>" name="menu-item-icon[<?php echo esc_attr($item_id); ?>]" class="menu-item-icon-select select2">
									<option value="" <?php if(esc_attr($item->icon) == ""){echo 'selected="selected"';} ?>></option>
									<?php
									$fa_icons = elision_qode_get_font_awesome_icon_array();
									foreach ($fa_icons as $key => $value) {
									?>
									<option value="<?php echo esc_attr($key); ?>" <?php if(esc_attr($item->icon) == $key){echo 'selected="selected"';} ?>><?= $key ?></option>
									<?php
									}
									?>
								</select>
								<br/><?php esc_html_e( 'Only with "wide with icons" menu type', 'elision' ); ?>
								</label>
				            </p>
							<p class="field-custom description description-thin description-thin-custom">
							</p>
							<p class="field-custom description description-thin description-thin-custom">
								<label for="edit-menu-item-sidebar-<?php echo esc_attr($item_id); ?>">
								<?php esc_html_e( 'Custom widget area', 'elision' ); ?><br />
								<select id="edit-menu-item-sidebar<?php echo esc_attr($item_id); ?>" name="menu-item-sidebar[<?php echo esc_attr($item_id); ?>]">
									<option value="" <?php if(esc_attr($item->sidebar) == ""){echo 'selected="selected"';} ?>></option>
									<?php
										foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
											if(elision_qode_is_user_made_sidebar(ucwords($sidebar['name']))){
										?>

												 <option value="<?php echo ucwords( $sidebar['id'] ); ?>" <?php if (esc_attr($item->sidebar) == ucwords( $sidebar['id'] ) ) { ?> selected="selected" <?php } ?>>
														<?php echo ucwords( $sidebar['name'] ); ?>
												 </option>

										<?php	}
											}
										?>
								</select>
								<br/><?php esc_html_e( 'Only with "wide & wide with icons" menu type', 'elision' ); ?>
	              </label>
	            </p>
	            <?php
	            /* New fields insertion ends here */
	            ?>
	            <div class="menu-item-actions description-wide submitbox">
	                <?php if( 'custom' != $item->type && $original_title !== false ) : ?>
	                    <p class="link-to-original">
	                        <?php printf( esc_html__('Original: %s', 'elision'), '<a href="' . esc_attr( $item->url ) . '">' . esc_html( $original_title ) . '</a>' ); ?>
	                    </p>
	                <?php endif; ?>
	                <a class="item-delete submitdelete deletion" id="delete-<?php echo esc_attr($item_id); ?>" href="<?php
	                echo esc_url(wp_nonce_url(
	                    add_query_arg(
	                        array(
	                            'action' => 'delete-menu-item',
	                            'menu-item' => $item_id,
	                        ),
	                        remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
	                    ),
	                    'delete-menu_item_' . $item_id
	                )); ?>"><?php esc_html_e('Remove', 'elision'); ?></a> <span class="meta-sep"> | </span> <a class="item-cancel submitcancel" id="cancel-<?php echo esc_attr($item_id); ?>" href="<?php echo esc_url( add_query_arg( array('edit-menu-item' => $item_id, 'cancel' => time()), remove_query_arg( $removed_args, admin_url( 'nav-menus.php' ) ) ) );
	                    ?>#menu-item-settings-<?php echo esc_attr($item_id); ?>"><?php esc_html_e('Cancel', 'elision'); ?></a>
	            </div>
        <?php
    }

}