
(function( $ ) {
	'use strict';

	$( window ).load(function() {
		if ($('.partners-glide').length !== 0) {
			var ticker = $('.partners-glide .img_slides').webTicker({
				height: '50px',
				duplicate: true,
				rssfrequency: 0,
				startEmpty:	false,
				hoverpause:	false,
				transition: "linear",
				moving: true,
				speed: 30
			});
			ticker.webTicker('update');
		}

		if ($('.event_masonry').length !== 0 || $('.blog_holder.masonry article[id^="exhibitor-"]').length !== 0) {
			$('article[id^="exhibitor-"] .img_slides').slick({
				accessibility: false,
				autoplay: false,
				autoplaySpeed: 2000,
				arrows: false,
				centerMode: true,
				centerPadding: 5,
				dots: true,
				mobileFirst: true,
				lazyLoad: 'ondemand'
			});
		}

		if ($('.post_right .exhibitor-preview-glide').length !== 0) {
			$('a.fl-gallery-item').featherlightGallery({
				previousIcon: "<i class='icon icon-arrow-left medium'></i>",
				nextIcon: "<i class='icon icon-arrow-right medium'></i>"
			});
			let imgSlides = $(".post_right .exhibitor-preview-glide .img_slides");
			imgSlides.slick({
				accessibility: true,
				arrows: true,
				centerMode: true,
				centerPadding: 5,
				dots: true,
				mobileFirst: true,
				prevArrow: "<a type=\"button\" class=\"slick-prev\"><i class='icon icon-arrow-left medium'></i></a>",
				nextArrow: "<a type=\"button\" class=\"slick-next\"><i class='icon icon-arrow-right medium'></i></a>",
				lazyLoad: 'ondemand',
				adaptiveHeight: true
			});
			let descSlides = $(".post_right .exhibitor-preview-glide .desc_slides");
			descSlides.slick({
				accessibility: true,
				arrows: false,
				centerMode: true,
				centerPadding: 5,
				dots: false,
				mobileFirst: true,
				adaptiveHeight: true
			});

			imgSlides.on('setPosition', function (event, opts) {
				if (descSlides.slick('slickCurrentSlide') !== opts.currentSlide) {
					descSlides.slick('slickGoTo', opts.currentSlide, true);
				}
			});
			descSlides.on('setPosition', function (event, opts) {
				if (imgSlides.slick('slickCurrentSlide') !== opts.currentSlide) {
					imgSlides.slick('slickGoTo', opts.currentSlide, true);
				}
			});

			$(".slick-arrow").each(function (i) {
				if ($(this).hasClass('slick-next')) {
					$(this).value = '>';
				} else {
					$(this).value = '<';
				}
			});
		}
	});

})( jQuery );

