<?php


namespace Eventman\Includes;


use Eventman\Admin\LogTrait;

class HookLogger
{

    use LogTrait {
        log as _log;
    }

    public function log()
    {
        global $wp_current_filter, $wp_filter;

        $currentFilter = end($wp_current_filter);
        try {
            $prettyArguments = $this->pretty([
                'argAmount' => func_num_args(),
                'arguments' => func_get_args()
            ]);
        } catch (\Throwable $t) {
            $this->_log('arguments too big');
        }

//        $hook = $wp_filter[$currentFilter];

        $this->_log('Hook Called: "'. $currentFilter .'", arguments: '. $prettyArguments
            . ', From: ' . $this->pretty($wp_current_filter)
        );
    }

    /**
     * HookLogger constructor.
     */
    public function __construct($hooksToLog = [])
    {
        foreach ($hooksToLog as $hook) {
            add_action($hook, [$this, 'log'], 999, 100);
        }
    }

    public function logSwitchStack() {
        global $_wp_switched_stack;
        $this->_log('Current Switch Stack: ' . $this->pretty($_wp_switched_stack));
    }
}