<?php


namespace Eventman\Includes\Post;


class Partner extends CustomPostType
{

    public function __construct()
    {
        parent::__construct('partners', [
            'menu_position' => 4,
            'supports' => [
                'title',
                'thumbnail'
            ]
        ]);
        $this->menuIcon = 'dashicons-admin-users';
        $this->addField('name',             ['type' => 'text',
            'label' => __('Name', 'ms-eventman')
        ]);
        $this->addField('city',             ['type' => 'text',
            'label' => __('City', 'ms-eventman')
        ]);
        $this->addField('address',          ['type' => 'text',
            'label' => __('Address', 'ms-eventman')
        ]);
        $this->addField('country',          ['type' => 'text',
            'label' => __('Country', 'ms-eventman')
        ]);
        $this->addField('email',            ['type' => 'text',
            'label' => __('Email', 'ms-eventman')
        ]);
        $this->addField('website',          ['type' => 'text',
            'label' => __('Website', 'ms-eventman')
        ]);
        $this->addField('phone_number',     ['type' => 'text',
            'label' => __('Phone Number', 'ms-eventman')
        ]);
        $this->addField('description',      ['type' => 'textarea',
            'label' => __('Description', 'ms-eventman')
        ]);
        $this->addField('logo_position',    ['type' => 'select',
            'options' => [
                __('Left', 'ms-eventman'),
                __('Right', 'ms-eventman')
            ],
            'label' => __('Logo Position', 'ms-eventman')
        ]);
    }

}