(function( $ ) {
    'use strict';

    var media_uploader = null;

    function open_media_uploader_new() {
        media_uploader = wp.media({
            frame: "post",
            state: "insert",
            multiple: true
        });

        media_uploader.on("insert", function () {
            media_uploader.state().get("selection").models.forEach(function(image) {
                let image_id = image.attributes.id;

                let image_url = image.attributes.url;
                if ('url' in image.changed) {
                    image_url = image.changed.url;
                }

                let box = $('#gallery-main-box-template').html();
                $(box).appendTo('#img-box-container');
                let element = $('#img-box-container .gallery-single-row:last-child').find('.image-container');
                let html = $('<img class="gallery-img-img" src="' + image_url + '" height="55" width="55"/>');
                element.append(html);
                element.find('.meta-image-id').val(image_id);

                element.click(function(evt) {
                    evt.preventDefault();
                    open_media_uploader_for_image(this);
                })

                element.siblings().find('.button.remove').click(function(evt) {
                    evt.preventDefault();
                    remove_img(this);
                });
            });
        });
        media_uploader.open();
    }

    function remove_img(value) {
        let parent = $(value).parent().parent();
        parent.remove();
    }

    function open_media_uploader_for_image(imageContainer) {
        media_uploader = wp.media({
            frame: "post",
            state: "insert",
            multiple: false
        });
        media_uploader.on('open', function() {
            let selection = media_uploader.state().get("selection");

            let attachment = wp.media.attachment($(imageContainer).children('.meta-image-id').val());
            attachment.fetch();

            selection.add(attachment);
        })
        media_uploader.on("insert", function () {
            var json = media_uploader.state().get("selection").first().toJSON();
            var image_url = json.url;
            var image_id = json.id;
            $(imageContainer).children('img').attr('src', image_url);
            $(imageContainer).children('.meta-image-id').val(image_id);
        });
        media_uploader.open();
    }

    $(window).load(function () {
        let addButton = $('#add-gallery-single-row');

        let imageContainers = $('#gallery-dynamic-container .gallery-area-div.image-container');

        imageContainers.each(function(container) {
            $(this).click(function(evt) {
                evt.preventDefault();
                open_media_uploader_for_image(this);
            });

            $(this).siblings().find('.button.remove').click(function(evt) {
                evt.preventDefault();
                remove_img(this);
            });
        });

        addButton.click(function(evt) {
            evt.preventDefault();
            open_media_uploader_new();
        });

        $(function ($) {
            $("#img_box_container").sortable();
        });
    });
})( jQuery );
