<?php
$elision_options = elision_qode_return_global_options();
$qode_page_id    = elision_qode_get_page_id();

if ( get_post_meta( $qode_page_id, "qode_responsive-title-image", true ) != "" ) {
	$responsive_title_image = get_post_meta( $qode_page_id, "qode_responsive-title-image", true );
} else {
	$responsive_title_image = $elision_options['responsive_title_image'];
}

if ( get_post_meta( $qode_page_id, "qode_fixed-title-image", true ) != "" ) {
	$fixed_title_image = get_post_meta( $qode_page_id, "qode_fixed-title-image", true );
} else {
	$fixed_title_image = $elision_options['fixed_title_image'];
}

if ( get_post_meta( $qode_page_id, "qode_title-image", true ) != "" ) {
	$title_image = get_post_meta( $qode_page_id, "qode_title-image", true );
} else {
	$title_image = $elision_options['title_image'];
}

$title_image_width  = '';
if ( ! empty( $title_image ) ) {
	$image_dimension = elision_qode_get_image_dimensions( $title_image );
	
	if ( ! empty( $image_dimension ) ) {
		$title_image_width = $image_dimension['width'];
	}
}

if ( get_post_meta( $qode_page_id, "qode_title-height", true ) != "" ) {
	$title_height = get_post_meta( $qode_page_id, "qode_title-height", true );
} else {
	$title_height = $elision_options['title_height'];
}

$title_background_color = '';
if ( get_post_meta( $qode_page_id, "qode_page-title-background-color", true ) != "" ) {
	$title_background_color = get_post_meta( $qode_page_id, "qode_page-title-background-color", true );
} else {
	$title_background_color = $elision_options['title_background_color'];
}

$show_title_image = true;
if ( get_post_meta( $qode_page_id, "qode_show-page-title-image", true ) ) {
	$show_title_image = false;
}

$qode_page_title_style = "standard";
if ( get_post_meta( $qode_page_id, "qode_page_title_style", true ) != "" ) {
	$qode_page_title_style = get_post_meta( $qode_page_id, "qode_page_title_style", true );
} else {
	if ( isset( $elision_options['title_style'] ) ) {
		$qode_page_title_style = $elision_options['title_style'];
	} else {
		$qode_page_title_style = "standard";
	}
}

$title_classes = array();
if ( $qode_page_title_style == "title_on_bottom" ) {
	$title_classes[] = "title_on_bottom";
}

if ( $responsive_title_image == 'no' && $title_image != "" && ( $fixed_title_image == "yes" || $fixed_title_image == "yes_zoom" ) && $show_title_image == true ) {
	$title_classes[] = 'has_fixed_background';
	
	if ( $fixed_title_image == "yes_zoom" ) {
		$title_classes[] = 'zoom_out';
	}
}

if ( $responsive_title_image == 'no' && $title_image != "" && $fixed_title_image == "no" && $show_title_image == true ) {
	$title_classes[] = 'has_background';
}

if ( $responsive_title_image == 'yes' && $show_title_image == true ) {
	$title_classes[] = 'with_image';
}

$title_styles = array();
if ( $responsive_title_image == 'no' && $title_image != "" && $show_title_image == true ) {
	if ( $title_image_width != '' ) {
		$title_styles[] = 'background-size:' . intval($title_image_width) . 'px auto;';
	}
	
	$title_styles[] = 'background-image:url(' . $title_image . ');';
}

if ( $title_height != '' ) {
	$title_styles[] = 'height:' . intval( $title_height ) . 'px;';
}

if ( $title_background_color != '' ) {
	$title_styles[] = 'background-color:' . $title_background_color . ';';
}

$title_styles_attr = '';
if ( ! empty( $title_styles ) ) {
	$title_styles_attr = 'style="' . implode( ' ', $title_styles ) . '"';
}

$title_img_classes = array();
if ( $responsive_title_image == 'yes' && $title_image != "" && $show_title_image == true ) {
	$title_img_classes[] = "responive";
} else {
	$title_img_classes[] = "not_responsive";
}

$title_holder_styles_attr = '';
if ( get_post_meta( $qode_page_id, "qode_page_title_holder_color", true ) !== '' ) {
	$title_holder_styles_attr = 'style="background-color: ' . get_post_meta( $qode_page_id, "qode_page_title_holder_color", true ) . '"';
}

$title_label_styles_attr = '';
if ( get_post_meta( $qode_page_id, "qode_page-title-color", true ) !== '' ) {
	$title_label_styles_attr = 'style="color: ' . get_post_meta( $qode_page_id, "qode_page-title-color", true ) . '"';
}
$title             = get_the_title( $qode_page_id );
$enable_page_title = get_post_meta( $qode_page_id, "qode_page-title-text", true );
if ( is_home() && is_front_page() ) {
	$title = get_option( 'blogname' );
} elseif ( is_tag() ) {
	$title = single_term_title( '', false ) . esc_html__( ' Tag', 'elision' );
} elseif ( is_date() ) {
	$title = get_the_time( 'F Y' );
} elseif ( is_author() ) {
	$title = esc_html__( 'Author: ', 'elision' ) . get_the_author();
} elseif ( is_category() ) {
	$title = single_cat_title( '', false );
} elseif ( is_archive() ) {
    $optTitle = get_the_archive_title();
    if (!empty($optTitle)) {
        $title = $optTitle;
    } else {
        $title = esc_html__( 'Archive', 'elision' );
    }
} elseif ( is_search() ) {
	$title = esc_html__( 'SEARCH: ', 'elision' ) . get_search_query();
} elseif ( is_singular( 'post' ) && empty( $enable_page_title ) ) {
	$title              = esc_html__( 'Blog', 'elision' );
	$custom_title_label = get_post_meta( $qode_page_id, "qode_page_title_text_single_post", true );
    $post = get_post($qode_page_id);
    if ( ! empty( $custom_title_label ) ) {
        $title = esc_html( $custom_title_label );
    } elseif (post_type_supports($post->post_type, 'title') && !empty($post->post_title)) {
        $title = $post->post_title;
    } else {
        $title = esc_html__('News');
    }
}

if ( elision_qode_is_woocommerce_shop() || is_singular( 'product' ) ) {
	$shop_id = elision_qode_get_woo_shop_page_id();
	$title   = ! empty( $shop_id ) ? get_the_title( $shop_id ) : esc_html__( 'Shop', 'elision' );
} elseif ( ( function_exists( 'is_product_category' ) && is_product_category() ) || ( function_exists( 'is_product_tag' ) && is_product_tag() ) ) {
	$tax = get_queried_object();
	
	if ( ! empty( $tax ) ) {
		$title = $tax->name ;
	}
}

if ( ! get_post_meta( $qode_page_id, "qode_show-page-title", true ) ) { ?>
	<div class="title <?php echo esc_attr( implode( ' ', $title_classes ) ); ?>" <?php echo elision_qode_get_module_part( $title_styles_attr ); ?>>
		<div class="image  <?php echo esc_attr( implode( ' ', $title_img_classes ) ); ?>">
			<?php if ( ! empty( $title_image ) ) { ?>
				    <img src="<?php echo esc_url( $title_image ); ?>" alt="<?php esc_attr_e( 'Title Image', 'elision' ); ?>" />
			<?php } ?>
		</div>
		<?php if ( ! get_post_meta( $qode_page_id, "qode_show-page-title-text", true ) ) { ?>
        <a href="<?=get_home_url()?>">

        <div class="title_holder">
				<div class="container">
					<div class="container_inner clearfix">
						<?php if ( $qode_page_title_style == "title_on_bottom" ) { ?>
							<div class="title_on_bottom_wrap">
								<div class="title_on_bottom_holder">
									<div class="title_on_bottom_holder_inner" <?php echo elision_qode_get_module_part( $title_holder_styles_attr ); ?>>
										<h1 <?php echo elision_qode_get_module_part( $title_label_styles_attr ); ?>><span><?php echo wp_kses_post( $title ); ?></span></h1>
									</div>
								</div>
							</div>
						<?php } else { ?>
							<h1 <?php echo elision_qode_get_module_part( $title_label_styles_attr ); ?>><span><?php echo wp_kses_post( $title ); ?></span></h1>
						<?php } ?>
					</div>
				</div>
			</div>
        </a>

        <?php } ?>
	</div>
<?php } ?>