<?php
include get_stylesheet_directory() . '/includes/modules/DesktopMenuWalker.php';
include get_stylesheet_directory() . '/includes/modules/MobileMenuWalker.php';
$elision_options = elision_qode_return_global_options();
$qode_page_id = elision_qode_get_page_id();

$header_in_grid = true;
if (isset($elision_options['header_in_grid'])) {
    if ($elision_options['header_in_grid'] == "no") {
        $header_in_grid = false;
    }
}

$menu_in_center = false;
if (isset($elision_options['menu_in_center'])) {
    if ($elision_options['menu_in_center'] == "yes") {
        $menu_in_center = true;
    }
}

$centered_logo = false;
if (isset($elision_options['center_logo_image'])) {
    if ($elision_options['center_logo_image'] == "yes") {
        $centered_logo = true;
    }
}

$display_header_top = "yes";
if (isset($elision_options['header_top_area'])) {
    $display_header_top = $elision_options['header_top_area'];
}

if (!empty($_SESSION['qode_elision_header_top'])) {
    $display_header_top = $_SESSION['qode_elision_header_top'];
}

if (!empty($_SESSION['qode_header_top'])) {
    if ($_SESSION['qode_header_top'] == "no") {
        $header_top_area_scroll = "no";
    }
    if ($_SESSION['qode_header_top'] == "yes") {
        $header_top_area_scroll = "yes";
    }
}

$header_sticky = true;
if (isset($elision_options['header_sticky']) && $elision_options['header_sticky'] == "no") {
    $header_sticky = false;
}

$header_style = "";
if (get_post_meta($qode_page_id, "qode_header-style", true) != "") {
    $header_style = get_post_meta($qode_page_id, "qode_header-style", true);
} else if (isset($elision_options['header_style']) && $elision_options['header_style'] !== '') {
    $header_style = $elision_options['header_style'];
}

$header_classes = array($header_style);

if ($display_header_top == "yes") {
    $header_classes[] = 'has_top';
}

if ($centered_logo) {
    $header_classes[] = "centered_logo";
}

if (!$header_sticky) {
    $header_classes[] = "no_sticky";
}
?>
<header class="elision-header-replacement">
    <div class="header_inner_ie clearfix">
        <div class="header_inner_left_ie">
            <div class="default-buttons">
                <ul class="button-list">
                    <?php if (has_nav_menu('top-navigation')) { ?>
                    <li class="mobile_menu_button_ie">
                        <a>
                            <i class="fa fa-bars"></i>
                        </a>
                    </li><!--
                    --><?php } ?><!--
                    -->
                    <li class="search">
                        <a class="unset-all" id="search-button">
                            <i class="fa fa-search"></i>
                        </a>
                    </li><!--
                    -->
                    <li class="search-box-container">
                        <form id="search" name="search" action="<?= get_site_url() ?>/">
                            <input type="submit" hidden>
                        </form>
                        <input form="search" name="s" type="text" id="search-box"
                               class="search-box<?= (isset($_GET['s']) ? ' opened' : '') ?>"
                               value="<?= isset($_GET['s']) ? $_GET['s'] : '' ?>"/>
                    </li><!--
                    -->
                    <li class="top-left-navigation-item"><?php if (has_nav_menu('top-additional-navigation-left')) {
                            echo wp_nav_menu([
                                'container' => '',
                                'theme_location' => 'top-additional-navigation-left',
                                'container_class' => 'menu-top-left-menu-container',
                                'menu_id' => 'menu-top-left-menu',
                                'depth' => 1,
                                'walker' => new DesktopMenuWalker()
                            ]);
                        }
                        ?>
                    </li>
                </ul>
            </div>
        </div>
        <div class="header_bottom_ie clearfix">
            <nav class="drop_down_ie<?php if (!$menu_in_center) {
                echo ' right';
            } ?>">
                <?php
                echo wp_nav_menu(array(
                    'theme_location' => 'top-navigation',
                    'container' => 'div',
                    'container_class' => 'top-navigation menu_ie main_menu_ie',
                    'menu_class' => '',
                    'menu_id' => '',
                    'fallback_cb' => 'elision_qode_top_navigation_fallback',
                    'link_before' => '<span>',
                    'link_after' => '</span>',
                    'walker' => new DesktopMenuWalker()
                ));
                ?>
            </nav>
            <?php if (has_nav_menu('top-navigation')) { ?>
                <nav class="mobile_menu_ie_wrapper">
                    <ul class="search-box-container-mobile">
                        <li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-home ">
                            <form id="search-form-mobile" method="get" action="<?= get_site_url() ?>/">
                                <input name="s" type="text" id="search-box-mobile" class="search-box-mobile"
                                       value="<?= isset($_GET['s']) ? $_GET['s'] : '' ?>"/>
                                <input type="submit" hidden>
                            </form>
                        </li>
                    </ul>
                    <?php
                    echo wp_nav_menu(array(
                        'theme_location' => 'top-navigation',
                        'container' => 'div',
                        'container_class' => 'top-navigation-mobile menu_ie mobile_menu_ie',
                        'menu_class' => '',
                        'menu_id' => '',
                        'fallback_cb' => 'elision_qode_top_navigation_fallback',
                        'link_before' => '<span>',
                        'link_after' => '</span>',
                        'walker' => new MobileMenuWalker()
                    ));
                    ?>
                </nav>
            <?php } ?>
        </div>
        <div class="header_inner_right_ie">
            <?php if (has_nav_menu('top-additional-navigation')) {
                echo wp_nav_menu([
                    'theme_location' => 'top-additional-navigation',
                    'container_class' => 'menu-top-menu-container',
                    'menu_id' => 'menu-top-menu',
                    'depth' => 1
                ]);
            } ?>
            <?php if (has_nav_menu('top-social-navigation')) {
                echo wp_nav_menu([
                    'theme_location' => 'top-social-navigation',
                    'container_class' => 'menu-social-media-top-container',
                    'walker' => new DesktopMenuWalker(),
                    'menu_id' => 'menu-social-media-top'
                ]);
            } ?>
        </div>
    </div>
</header>