<?php

include_once 'shortcodes.php';
include_once 'nav.php';

/**
 * Add stylesheets.
 */
function styles()
{
    wp_enqueue_style('interevent-theme', get_stylesheet_directory_uri() . '/style.css');
    wp_enqueue_style('interevent-theme-styles', get_stylesheet_directory_uri() . '/css/stylesheet-sass.css', ['elision-stylesheet', 'elision-style-dynamic']);
    wp_enqueue_style( 'font-awesome-5-free', '//use.fontawesome.com/releases/v5.7.2/css/all.css' );
}

add_action('wp_enqueue_scripts', 'styles', 11);


/**
 * Add menu javascript.
 */
function scripts()
{
    wp_enqueue_script('interevent-menu-script', get_stylesheet_directory_uri() . '/js/menu.js');
    wp_enqueue_script( 'font-awesome-5-free', '//use.fontawesome.com/releases/v5.7.2/js/all.js' );
}

add_action('wp_enqueue_scripts', 'scripts', 999);


/**
 * Add new navigation sections.
 */
function registerTopBarMenus()
{
    register_nav_menu('top-additional-navigation', __('Additional Top Menu (Right)'));
    register_nav_menu('top-additional-navigation-left', __('Additional Top Menu (Left)'));
    register_nav_menu('top-social-navigation', __('Social Media Top Menu'));
}

add_action('init', 'registerTopBarMenus');

function addWPBExtras() {
    vc_add_param('button', [
        'type' => 'checkbox',
        'heading' => "No Gutters",
        'param_name' => 'no_gutters',
        'value' => ['No Gutters' => 'no-gutters'],
        'description' => __( "Button Internal Spacing", "ms-eventman" )
    ]);
    vc_add_param('button', [
        'type' => 'textfield',
        'heading' => "Padding",
        'param_name' => 'padding',
        'value' => ['Padding' => ''],
        'description' => __( "Button Internal Spacing", "ms-eventman" )
    ]);

    $posts = [];
    foreach (['post', 'page', 'exhibitors', 'partners'] as $type) {
        $posts = array_merge($posts, get_posts([
            'numberposts' => -1,
            'post_status' => 'publish',
            'post_type' => $type,
            'orderby' => 'post_title',
            'order' => 'ASC'
        ]));
    }

    $dropdownOptions = [];
    $dropdownOptions['None'] = '';
    $dropdownOptions = array_merge($dropdownOptions, array_reduce($posts, function($carry, $el) {
        $lang = function_exists('wpml_get_language_information') ? wpml_get_language_information(null, $el->ID)['locale'] : "";
        $name = isset($el->post_title) ? $el->post_title : $el->post_name;

        if ($lang) {
            $name .= " ($lang)";
        }

        $visual = "$name (".ucfirst($el->post_type).") (ID: $el->ID)";
        $carry[$visual] = $el->ID;
        return $carry;
    }));

    vc_add_param('button', [
        'type' => 'dropdown',
        'heading' => "Post",
        'param_name' => 'post',
        'value' => $dropdownOptions,
        'description' => __( "Link to post", "ms-eventman" )
    ]);

//    $qodeOpts = elision_qode_return_global_options();

//    vc_remove_element('gmaps_ie');
    vc_map([
        "name"                      => esc_html__( "Google Maps Extended", "ms-eventman" ),
        "description"               => 'Google Maps via Javascript API',
        "base"                      => "gmaps_ie",
        "category"                  => esc_html__( 'by Beau', 'elision' ),
        "icon"                      => "icon-wpb-map-pin",
        "allowed_container_element" => 'vc_row',
        "params"                    => [
            [
                "type"       => "textfield",
                "holder"     => "div",
                "heading"    => esc_html__( "API Key", "ms-eventman" ),
                "param_name" => "api_key",
                'value'     =>  ''
            ],
            [
                "type"       => "textfield",
                "holder"     => "div",
                "heading"    => esc_html__( "Latitude", "ms-eventman" ),
                "param_name" => "coord_x",
                'value'     =>  ''
            ],
            [
                "type"       => "textfield",
                "holder"     => "div",
                "heading"    => esc_html__( "Longitude", "ms-eventman" ),
                "param_name" => "coord_y",
                'value'     =>  ''
            ],
            [
                "type"       => "textfield",
                "holder"     => "div",
                "heading"    => esc_html__( "Zoom level (8 is default)", "ms-eventman" ),
                "param_name" => "zoom",
                'value'     => ''
            ],
            [
                "type"       => "checkbox",
                "holder"     => "div",
                "heading"    => esc_html__( "Show Points of Interest", "ms-eventman" ),
                "param_name" => "show_pois",
                'value'      => ['' => 'show'],
            ],
            [
                "type"       => "textfield",
                "holder"     => "div",
                "heading"    => esc_html__( "Height (in pixels)", "ms-eventman" ),
                "param_name" => "map_height",
                'value'     => ''
            ],
        ]
    ]);

}

add_action('admin_init', 'addWPBExtras', 9999);


/**
 * Remove author, date, category from post preview.
 */
function overwriteLatestPostShortcode()
{
    remove_shortcode('latest_post');
    add_shortcode('latest_post', 'latest_post');

    remove_shortcode('button');
    add_shortcode('button', 'button');

    add_shortcode('gmaps_ie', 'gmaps');
}

add_action('wp_loaded', 'overwriteLatestPostShortcode');

/**
 * Add dynamic elision styles.
 */
function dynamicCss()
{
    global $qode_options_elision;
    $firstColor = $qode_options_elision['first_color'];
    $secondColor = $qode_options_elision['second_color'];
    $linkColor = $qode_options_elision['link_color'];
    $linkHoverColor = $qode_options_elision['link_hovercolor'];

    $socialMediaHoverColor = empty($linkHoverColor) ? $firstColor : $linkHoverColor;
    echo "
<style>
.button-list button:hover {
    color: $firstColor;
}

.social-icons a {
    color: $linkColor;
}
.social-icons a:hover {
    color: $socialMediaHoverColor;
}

article[id^='exhibitor-'] .post_text,
article[id^='partner-'] .post_text {
    background-color: $secondColor;
}
</style>";
}

add_action('wp_head', 'dynamicCss');

/**
 * Overwrite GravityForms default submit button css classes.
 */
if (is_plugin_active('gravityforms/gravityforms.php')) {
    function form_submit_button($button, $form)
    {
        return '<input type="submit" class="button qbutton" id="gform_submit_button_' . $form['id'] . '" value="' . $form['button']['text'] . '">';
    }

    add_filter('gform_submit_button', 'form_submit_button', 10, 2);
}

if (class_exists('MultiPostThumbnails')) {
    new MultiPostThumbnails(
        array(
            'label' => __( 'Overview Thumbnail', 'ms-eventman'),
            'id' => 'overview-thumbnail',
            'post_type' => 'exhibitors'
        )
    );
    new MultiPostThumbnails(
        array(
            // Replace [YOUR THEME TEXT DOMAIN] below with the text domain of your theme (found in the theme's `style.css`).
            'label' => __( 'Logo', 'ms-eventman'),
            'id' => 'logo-image',
            'post_type' => 'exhibitors',
            'priority' => 'high',
            'context' => 'normal'
        )
    );
}

function interevent_get_fa_icon($icon) {
    return 'fa-' . strtolower($icon);
}

function elision_qode_get_font_awesome_icon_array()
{
    return [
        'fa-ad' => '\f641',
        'fa-address-book' => '\f2b9',
        'fa-address-card' => '\f2bb',
        'fa-adjust' => '\f042',
        'fa-air-freshener' => '\f5d0',
        'fa-align-center' => '\f037',
        'fa-align-justify' => '\f039',
        'fa-align-left' => '\f036',
        'fa-align-right' => '\f038',
        'fa-allergies' => '\f461',
        'fa-ambulance' => '\f0f9',
        'fa-american-sign-language-interpreting' => '\f2a3',
        'fa-anchor' => '\f13d',
        'fa-angle-double-down' => '\f103',
        'fa-angle-double-left' => '\f100',
        'fa-angle-double-right' => '\f101',
        'fa-angle-double-up' => '\f102',
        'fa-angle-down' => '\f107',
        'fa-angle-left' => '\f104',
        'fa-angle-right' => '\f105',
        'fa-angle-up' => '\f106',
        'fa-angry' => '\f556',
        'fa-ankh' => '\f644',
        'fa-apple-alt' => '\f5d1',
        'fa-archive' => '\f187',
        'fa-archway' => '\f557',
        'fa-arrow-alt-circle-down' => '\f358',
        'fa-arrow-alt-circle-left' => '\f359',
        'fa-arrow-alt-circle-right' => '\f35a',
        'fa-arrow-alt-circle-up' => '\f35b',
        'fa-arrow-circle-down' => '\f0ab',
        'fa-arrow-circle-left' => '\f0a8',
        'fa-arrow-circle-right' => '\f0a9',
        'fa-arrow-circle-up' => '\f0aa',
        'fa-arrow-down' => '\f063',
        'fa-arrow-left' => '\f060',
        'fa-arrow-right' => '\f061',
        'fa-arrow-up' => '\f062',
        'fa-arrows-alt' => '\f0b2',
        'fa-arrows-alt-h' => '\f337',
        'fa-arrows-alt-v' => '\f338',
        'fa-assistive-listening-systems' => '\f2a2',
        'fa-asterisk' => '\f069',
        'fa-at' => '\f1fa',
        'fa-atlas' => '\f558',
        'fa-atom' => '\f5d2',
        'fa-audio-description' => '\f29e',
        'fa-award' => '\f559',
        'fa-baby' => '\f77c',
        'fa-baby-carriage' => '\f77d',
        'fa-backspace' => '\f55a',
        'fa-backward' => '\f04a',
        'fa-bacon' => '\f7e5',
        'fa-bahai' => '\f666',
        'fa-balance-scale' => '\f24e',
        'fa-balance-scale-left' => '\f515',
        'fa-balance-scale-right' => '\f516',
        'fa-ban' => '\f05e',
        'fa-band-aid' => '\f462',
        'fa-barcode' => '\f02a',
        'fa-bars' => '\f0c9',
        'fa-baseball-ball' => '\f433',
        'fa-basketball-ball' => '\f434',
        'fa-bath' => '\f2cd',
        'fa-battery-empty' => '\f244',
        'fa-battery-full' => '\f240',
        'fa-battery-half' => '\f242',
        'fa-battery-quarter' => '\f243',
        'fa-battery-three-quarters' => '\f241',
        'fa-bed' => '\f236',
        'fa-beer' => '\f0fc',
        'fa-bell' => '\f0f3',
        'fa-bell-slash' => '\f1f6',
        'fa-bezier-curve' => '\f55b',
        'fa-bible' => '\f647',
        'fa-bicycle' => '\f206',
        'fa-biking' => '\f84a',
        'fa-binoculars' => '\f1e5',
        'fa-biohazard' => '\f780',
        'fa-birthday-cake' => '\f1fd',
        'fa-blender' => '\f517',
        'fa-blender-phone' => '\f6b6',
        'fa-blind' => '\f29d',
        'fa-blog' => '\f781',
        'fa-bold' => '\f032',
        'fa-bolt' => '\f0e7',
        'fa-bomb' => '\f1e2',
        'fa-bone' => '\f5d7',
        'fa-bong' => '\f55c',
        'fa-book' => '\f02d',
        'fa-book-dead' => '\f6b7',
        'fa-book-medical' => '\f7e6',
        'fa-book-open' => '\f518',
        'fa-book-reader' => '\f5da',
        'fa-bookmark' => '\f02e',
        'fa-border-all' => '\f84c',
        'fa-border-none' => '\f850',
        'fa-border-style' => '\f853',
        'fa-bowling-ball' => '\f436',
        'fa-box' => '\f466',
        'fa-box-open' => '\f49e',
        'fa-boxes' => '\f468',
        'fa-braille' => '\f2a1',
        'fa-brain' => '\f5dc',
        'fa-bread-slice' => '\f7ec',
        'fa-briefcase' => '\f0b1',
        'fa-briefcase-medical' => '\f469',
        'fa-broadcast-tower' => '\f519',
        'fa-broom' => '\f51a',
        'fa-brush' => '\f55d',
        'fa-bug' => '\f188',
        'fa-building' => '\f1ad',
        'fa-bullhorn' => '\f0a1',
        'fa-bullseye' => '\f140',
        'fa-burn' => '\f46a',
        'fa-bus' => '\f207',
        'fa-bus-alt' => '\f55e',
        'fa-business-time' => '\f64a',
        'fa-calculator' => '\f1ec',
        'fa-calendar' => '\f133',
        'fa-calendar-alt' => '\f073',
        'fa-calendar-check' => '\f274',
        'fa-calendar-day' => '\f783',
        'fa-calendar-minus' => '\f272',
        'fa-calendar-plus' => '\f271',
        'fa-calendar-times' => '\f273',
        'fa-calendar-week' => '\f784',
        'fa-camera' => '\f030',
        'fa-camera-retro' => '\f083',
        'fa-campground' => '\f6bb',
        'fa-candy-cane' => '\f786',
        'fa-cannabis' => '\f55f',
        'fa-capsules' => '\f46b',
        'fa-car' => '\f1b9',
        'fa-car-alt' => '\f5de',
        'fa-car-battery' => '\f5df',
        'fa-car-crash' => '\f5e1',
        'fa-car-side' => '\f5e4',
        'fa-caravan' => '\f8ff',
        'fa-caret-down' => '\f0d7',
        'fa-caret-left' => '\f0d9',
        'fa-caret-right' => '\f0da',
        'fa-caret-square-down' => '\f150',
        'fa-caret-square-left' => '\f191',
        'fa-caret-square-right' => '\f152',
        'fa-caret-square-up' => '\f151',
        'fa-caret-up' => '\f0d8',
        'fa-carrot' => '\f787',
        'fa-cart-arrow-down' => '\f218',
        'fa-cart-plus' => '\f217',
        'fa-cash-register' => '\f788',
        'fa-cat' => '\f6be',
        'fa-certificate' => '\f0a3',
        'fa-chair' => '\f6c0',
        'fa-chalkboard' => '\f51b',
        'fa-chalkboard-teacher' => '\f51c',
        'fa-charging-station' => '\f5e7',
        'fa-chart-area' => '\f1fe',
        'fa-chart-bar' => '\f080',
        'fa-chart-line' => '\f201',
        'fa-chart-pie' => '\f200',
        'fa-check' => '\f00c',
        'fa-check-circle' => '\f058',
        'fa-check-double' => '\f560',
        'fa-check-square' => '\f14a',
        'fa-cheese' => '\f7ef',
        'fa-chess' => '\f439',
        'fa-chess-bishop' => '\f43a',
        'fa-chess-board' => '\f43c',
        'fa-chess-king' => '\f43f',
        'fa-chess-knight' => '\f441',
        'fa-chess-pawn' => '\f443',
        'fa-chess-queen' => '\f445',
        'fa-chess-rook' => '\f447',
        'fa-chevron-circle-down' => '\f13a',
        'fa-chevron-circle-left' => '\f137',
        'fa-chevron-circle-right' => '\f138',
        'fa-chevron-circle-up' => '\f139',
        'fa-chevron-down' => '\f078',
        'fa-chevron-left' => '\f053',
        'fa-chevron-right' => '\f054',
        'fa-chevron-up' => '\f077',
        'fa-child' => '\f1ae',
        'fa-church' => '\f51d',
        'fa-circle' => '\f111',
        'fa-circle-notch' => '\f1ce',
        'fa-city' => '\f64f',
        'fa-clinic-medical' => '\f7f2',
        'fa-clipboard' => '\f328',
        'fa-clipboard-check' => '\f46c',
        'fa-clipboard-list' => '\f46d',
        'fa-clock' => '\f017',
        'fa-clone' => '\f24d',
        'fa-closed-captioning' => '\f20a',
        'fa-cloud' => '\f0c2',
        'fa-cloud-download-alt' => '\f381',
        'fa-cloud-meatball' => '\f73b',
        'fa-cloud-moon' => '\f6c3',
        'fa-cloud-moon-rain' => '\f73c',
        'fa-cloud-rain' => '\f73d',
        'fa-cloud-showers-heavy' => '\f740',
        'fa-cloud-sun' => '\f6c4',
        'fa-cloud-sun-rain' => '\f743',
        'fa-cloud-upload-alt' => '\f382',
        'fa-cocktail' => '\f561',
        'fa-code' => '\f121',
        'fa-code-branch' => '\f126',
        'fa-coffee' => '\f0f4',
        'fa-cog' => '\f013',
        'fa-cogs' => '\f085',
        'fa-coins' => '\f51e',
        'fa-columns' => '\f0db',
        'fa-comment' => '\f075',
        'fa-comment-alt' => '\f27a',
        'fa-comment-dollar' => '\f651',
        'fa-comment-dots' => '\f4ad',
        'fa-comment-medical' => '\f7f5',
        'fa-comment-slash' => '\f4b3',
        'fa-comments' => '\f086',
        'fa-comments-dollar' => '\f653',
        'fa-compact-disc' => '\f51f',
        'fa-compass' => '\f14e',
        'fa-compress' => '\f066',
        'fa-compress-alt' => '\f422',
        'fa-compress-arrows-alt' => '\f78c',
        'fa-concierge-bell' => '\f562',
        'fa-cookie' => '\f563',
        'fa-cookie-bite' => '\f564',
        'fa-copy' => '\f0c5',
        'fa-copyright' => '\f1f9',
        'fa-couch' => '\f4b8',
        'fa-credit-card' => '\f09d',
        'fa-crop' => '\f125',
        'fa-crop-alt' => '\f565',
        'fa-cross' => '\f654',
        'fa-crosshairs' => '\f05b',
        'fa-crow' => '\f520',
        'fa-crown' => '\f521',
        'fa-crutch' => '\f7f7',
        'fa-cube' => '\f1b2',
        'fa-cubes' => '\f1b3',
        'fa-cut' => '\f0c4',
        'fa-database' => '\f1c0',
        'fa-deaf' => '\f2a4',
        'fa-democrat' => '\f747',
        'fa-desktop' => '\f108',
        'fa-dharmachakra' => '\f655',
        'fa-diagnoses' => '\f470',
        'fa-dice' => '\f522',
        'fa-dice-d20' => ' f6cf',
        'fa-dice-d6' => 'f6d1',
        'fa-dice-five' => '\f523',
        'fa-dice-four' => '\f524',
        'fa-dice-one' => '\f525',
        'fa-dice-six' => '\f526',
        'fa-dice-three' => '\f527',
        'fa-dice-two' => '\f528',
        'fa-digital-tachograph' => '\f566',
        'fa-directions' => '\f5eb',
        'fa-divide' => '\f529',
        'fa-dizzy' => '\f567',
        'fa-dna' => '\f471',
        'fa-dog' => '\f6d3',
        'fa-dollar-sign' => '\f155',
        'fa-dolly' => '\f472',
        'fa-dolly-flatbed' => '\f474',
        'fa-donate' => '\f4b9',
        'fa-door-closed' => '\f52a',
        'fa-door-open' => '\f52b',
        'fa-dot-circle' => '\f192',
        'fa-dove' => '\f4ba',
        'fa-download' => '\f019',
        'fa-drafting-compass' => '\f568',
        'fa-dragon' => '\f6d5',
        'fa-draw-polygon' => '\f5ee',
        'fa-drum' => '\f569',
        'fa-drum-steelpan' => '\f56a',
        'fa-drumstick-bite' => '\f6d7',
        'fa-dumbbell' => '\f44b',
        'fa-dumpster' => '\f793',
        'fa-dumpster-fire' => '\f794',
        'fa-dungeon' => '\f6d9',
        'fa-edit' => '\f044',
        'fa-egg' => '\f7fb',
        'fa-eject' => '\f052',
        'fa-ellipsis-h' => '\f141',
        'fa-ellipsis-v' => '\f142',
        'fa-envelope' => '\f0e0',
        'fa-envelope-open' => '\f2b6',
        'fa-envelope-open-text' => '\f658',
        'fa-envelope-square' => '\f199',
        'fa-equals' => '\f52c',
        'fa-eraser' => '\f12d',
        'fa-ethernet' => '\f796',
        'fa-euro-sign' => '\f153',
        'fa-exchange-alt' => '\f362',
        'fa-exclamation' => '\f12a',
        'fa-exclamation-circle' => '\f06a',
        'fa-exclamation-triangle' => '\f071',
        'fa-expand' => '\f065',
        'fa-expand-alt' => '\f424',
        'fa-expand-arrows-alt' => '\f31e',
        'fa-external-link-alt' => '\f35d',
        'fa-external-link-square-alt' => '\f360',
        'fa-eye' => '\f06e',
        'fa-eye-dropper' => '\f1fb',
        'fa-eye-slash' => '\f070',
        'fa-fan' => '\f863',
        'fa-fast-backward' => '\f049',
        'fa-fast-forward' => '\f050',
        'fa-fax' => '\f1ac',
        'fa-feather' => '\f52d',
        'fa-feather-alt' => '\f56b',
        'fa-female' => '\f182',
        'fa-fighter-jet' => '\f0fb',
        'fa-file' => '\f15b',
        'fa-file-alt' => '\f15c',
        'fa-file-archive' => '\f1c6',
        'fa-file-audio' => '\f1c7',
        'fa-file-code' => '\f1c9',
        'fa-file-contract' => '\f56c',
        'fa-file-csv' => '\f6dd',
        'fa-file-download' => '\f56d',
        'fa-file-excel' => '\f1c3',
        'fa-file-export' => '\f56e',
        'fa-file-image' => '\f1c5',
        'fa-file-import' => '\f56f',
        'fa-file-invoice' => '\f570',
        'fa-file-invoice-dollar' => '\f571',
        'fa-file-medical' => '\f477',
        'fa-file-medical-alt' => '\f478',
        'fa-file-pdf' => '\f1c1',
        'fa-file-powerpoint' => '\f1c4',
        'fa-file-prescription' => '\f572',
        'fa-file-signature' => '\f573',
        'fa-file-upload' => '\f574',
        'fa-file-video' => '\f1c8',
        'fa-file-word' => '\f1c2',
        'fa-fill' => '\f575',
        'fa-fill-drip' => '\f576',
        'fa-film' => '\f008',
        'fa-filter' => '\f0b0',
        'fa-fingerprint' => '\f577',
        'fa-fire' => '\f06d',
        'fa-fire-alt' => '\f7e4',
        'fa-fire-extinguisher' => '\f134',
        'fa-first-aid' => '\f479',
        'fa-fish' => '\f578',
        'fa-fist-raised' => '\f6de',
        'fa-flag' => '\f024',
        'fa-flag-checkered' => '\f11e',
        'fa-flag-usa' => '\f74d',
        'fa-flask' => '\f0c3',
        'fa-flushed' => '\f579',
        'fa-folder' => '\f07b',
        'fa-folder-minus' => '\f65d',
        'fa-folder-open' => '\f07c',
        'fa-folder-plus' => '\f65e',
        'fa-font' => '\f031',
        'fa-football-ball' => '\f44e',
        'fa-forward' => '\f04e',
        'fa-frog' => '\f52e',
        'fa-frown' => '\f119',
        'fa-frown-open' => '\f57a',
        'fa-funnel-dollar' => '\f662',
        'fa-futbol' => '\f1e3',
        'fa-gamepad' => '\f11b',
        'fa-gas-pump' => '\f52f',
        'fa-gavel' => '\f0e3',
        'fa-gem' => '\f3a5',
        'fa-genderless' => '\f22d',
        'fa-ghost' => '\f6e2',
        'fa-gift' => '\f06b',
        'fa-gifts' => '\f79c',
        'fa-glass-cheers' => '\f79f',
        'fa-glass-martini' => '\f000',
        'fa-glass-martini-alt' => '\f57b',
        'fa-glass-whiskey' => '\f7a0',
        'fa-glasses' => '\f530',
        'fa-globe' => '\f0ac',
        'fa-globe-africa' => '\f57c',
        'fa-globe-americas' => '\f57d',
        'fa-globe-asia' => '\f57e',
        'fa-globe-europe' => '\f7a2',
        'fa-golf-ball' => '\f450',
        'fa-gopuram' => '\f664',
        'fa-graduation-cap' => '\f19d',
        'fa-greater-than' => '\f531',
        'fa-greater-than-equal' => '\f532',
        'fa-grimace' => '\f57f',
        'fa-grin' => '\f580',
        'fa-grin-alt' => '\f581',
        'fa-grin-beam' => '\f582',
        'fa-grin-beam-sweat' => '\f583',
        'fa-grin-hearts' => '\f584',
        'fa-grin-squint' => '\f585',
        'fa-grin-squint-tears' => '\f586',
        'fa-grin-stars' => '\f587',
        'fa-grin-tears' => '\f588',
        'fa-grin-tongue' => '\f589',
        'fa-grin-tongue-squint' => '\f58a',
        'fa-grin-tongue-wink' => '\f58b',
        'fa-grin-wink' => '\f58c',
        'fa-grip-horizontal' => '\f58d',
        'fa-grip-lines' => '\f7a4',
        'fa-grip-lines-vertical' => '\f7a5',
        'fa-grip-vertical' => '\f58e',
        'fa-guitar' => '\f7a6',
        'fa-h-square' => '\f0fd',
        'fa-hamburger' => '\f805',
        'fa-hammer' => '\f6e3',
        'fa-hamsa' => '\f665',
        'fa-hand-holding' => '\f4bd',
        'fa-hand-holding-heart' => '\f4be',
        'fa-hand-holding-usd' => '\f4c0',
        'fa-hand-lizard' => '\f258',
        'fa-hand-middle-finger' => '\f806',
        'fa-hand-paper' => '\f256',
        'fa-hand-peace' => '\f25b',
        'fa-hand-point-down' => '\f0a7',
        'fa-hand-point-left' => '\f0a5',
        'fa-hand-point-right' => '\f0a4',
        'fa-hand-point-up' => '\f0a6',
        'fa-hand-pointer' => '\f25a',
        'fa-hand-rock' => '\f255',
        'fa-hand-scissors' => '\f257',
        'fa-hand-spock' => '\f259',
        'fa-hands' => '\f4c2',
        'fa-hands-helping' => '\f4c4',
        'fa-handshake' => '\f2b5',
        'fa-hanukiah' => '\f6e6',
        'fa-hard-hat' => '\f807',
        'fa-hashtag' => '\f292',
        'fa-hat-cowboy' => '\f8c0',
        'fa-hat-cowboy-side' => '\f8c1',
        'fa-hat-wizard' => '\f6e8',
        'fa-hdd' => '\f0a0',
        'fa-heading' => '\f1dc',
        'fa-headphones' => '\f025',
        'fa-headphones-alt' => '\f58f',
        'fa-headset' => '\f590',
        'fa-heart' => '\f004',
        'fa-heart-broken' => '\f7a9',
        'fa-heartbeat' => '\f21e',
        'fa-helicopter' => '\f533',
        'fa-highlighter' => '\f591',
        'fa-hiking' => '\f6ec',
        'fa-hippo' => '\f6ed',
        'fa-history' => '\f1da',
        'fa-hockey-puck' => '\f453',
        'fa-holly-berry' => '\f7aa',
        'fa-home' => '\f015',
        'fa-horse' => '\f6f0',
        'fa-horse-head' => '\f7ab',
        'fa-hospital' => '\f0f8',
        'fa-hospital-alt' => '\f47d',
        'fa-hospital-symbol' => '\f47e',
        'fa-hot-tub' => '\f593',
        'fa-hotdog' => '\f80f',
        'fa-hotel' => '\f594',
        'fa-hourglass' => '\f254',
        'fa-hourglass-end' => '\f253',
        'fa-hourglass-half' => '\f252',
        'fa-hourglass-start' => '\f251',
        'fa-house-damage' => '\f6f1',
        'fa-hryvnia' => '\f6f2',
        'fa-i-cursor' => '\f246',
        'fa-ice-cream' => '\f810',
        'fa-icicles' => '\f7ad',
        'fa-icons' => '\f86d',
        'fa-id-badge' => '\f2c1',
        'fa-id-card' => '\f2c2',
        'fa-id-card-alt' => '\f47f',
        'fa-igloo' => '\f7ae',
        'fa-image' => '\f03e',
        'fa-images' => '\f302',
        'fa-inbox' => '\f01c',
        'fa-indent' => '\f03c',
        'fa-industry' => '\f275',
        'fa-infinity' => '\f534',
        'fa-info' => '\f129',
        'fa-info-circle' => '\f05a',
        'fa-italic' => '\f033',
        'fa-jedi' => '\f669',
        'fa-joint' => '\f595',
        'fa-journal-whills' => '\f66a',
        'fa-kaaba' => '\f66b',
        'fa-key' => '\f084',
        'fa-keyboard' => '\f11c',
        'fa-khanda' => '\f66d',
        'fa-kiss' => '\f596',
        'fa-kiss-beam' => '\f597',
        'fa-kiss-wink-heart' => '\f598',
        'fa-kiwi-bird' => '\f535',
        'fa-landmark' => '\f66f',
        'fa-language' => '\f1ab',
        'fa-laptop' => '\f109',
        'fa-laptop-code' => '\f5fc',
        'fa-laptop-medical' => '\f812',
        'fa-laugh' => '\f599',
        'fa-laugh-beam' => '\f59a',
        'fa-laugh-squint' => '\f59b',
        'fa-laugh-wink' => '\f59c',
        'fa-layer-group' => '\f5fd',
        'fa-leaf' => '\f06c',
        'fa-lemon' => '\f094',
        'fa-less-than' => '\f536',
        'fa-less-than-equal' => '\f537',
        'fa-level-down-alt' => '\f3be',
        'fa-level-up-alt' => '\f3bf',
        'fa-life-ring' => '\f1cd',
        'fa-lightbulb' => '\f0eb',
        'fa-link' => '\f0c1',
        'fa-lira-sign' => '\f195',
        'fa-list' => '\f03a',
        'fa-list-alt' => '\f022',
        'fa-list-ol' => '\f0cb',
        'fa-list-ul' => '\f0ca',
        'fa-location-arrow' => '\f124',
        'fa-lock' => '\f023',
        'fa-lock-open' => '\f3c1',
        'fa-long-arrow-alt-down' => '\f309',
        'fa-long-arrow-alt-left' => '\f30a',
        'fa-long-arrow-alt-right' => '\f30b',
        'fa-long-arrow-alt-up' => '\f30c',
        'fa-low-vision' => '\f2a8',
        'fa-luggage-cart' => '\f59d',
        'fa-magic' => '\f0d0',
        'fa-magnet' => '\f076',
        'fa-mail-bulk' => '\f674',
        'fa-male' => '\f183',
        'fa-map' => '\f279',
        'fa-map-marked' => '\f59f',
        'fa-map-marked-alt' => '\f5a0',
        'fa-map-marker' => '\f041',
        'fa-map-marker-alt' => '\f3c5',
        'fa-map-pin' => '\f276',
        'fa-map-signs' => '\f277',
        'fa-marker' => '\f5a1',
        'fa-mars' => '\f222',
        'fa-mars-double' => '\f227',
        'fa-mars-stroke' => '\f229',
        'fa-mars-stroke-h' => '\f22b',
        'fa-mars-stroke-v' => '\f22a',
        'fa-mask' => '\f6fa',
        'fa-medal' => '\f5a2',
        'fa-medkit' => '\f0fa',
        'fa-meh' => '\f11a',
        'fa-meh-blank' => '\f5a4',
        'fa-meh-rolling-eyes' => '\f5a5',
        'fa-memory' => '\f538',
        'fa-menorah' => '\f676',
        'fa-mercury' => '\f223',
        'fa-meteor' => '\f753',
        'fa-microchip' => '\f2db',
        'fa-microphone' => '\f130',
        'fa-microphone-alt' => '\f3c9',
        'fa-microphone-alt-slash' => '\f539',
        'fa-microphone-slash' => '\f131',
        'fa-microscope' => '\f610',
        'fa-minus' => '\f068',
        'fa-minus-circle' => '\f056',
        'fa-minus-square' => '\f146',
        'fa-mitten' => '\f7b5',
        'fa-mobile' => '\f10b',
        'fa-mobile-alt' => '\f3cd',
        'fa-money-bill' => '\f0d6',
        'fa-money-bill-alt' => '\f3d1',
        'fa-money-bill-wave' => '\f53a',
        'fa-money-bill-wave-alt' => '\f53b',
        'fa-money-check' => '\f53c',
        'fa-money-check-alt' => '\f53d',
        'fa-monument' => '\f5a6',
        'fa-moon' => '\f186',
        'fa-mortar-pestle' => '\f5a7',
        'fa-mosque' => '\f678',
        'fa-motorcycle' => '\f21c',
        'fa-mountain' => '\f6fc',
        'fa-mouse' => '\f8cc',
        'fa-mouse-pointer' => '\f245',
        'fa-mug-hot' => '\f7b6',
        'fa-music' => '\f001',
        'fa-network-wired' => '\f6ff',
        'fa-neuter' => '\f22c',
        'fa-newspaper' => '\f1ea',
        'fa-not-equal' => '\f53e',
        'fa-notes-medical' => '\f481',
        'fa-object-group' => '\f247',
        'fa-object-ungroup' => '\f248',
        'fa-oil-can' => '\f613',
        'fa-om' => '\f679',
        'fa-otter' => '\f700',
        'fa-outdent' => '\f03b',
        'fa-pager' => '\f815',
        'fa-paint-brush' => '\f1fc',
        'fa-paint-roller' => '\f5aa',
        'fa-palette' => '\f53f',
        'fa-pallet' => '\f482',
        'fa-paper-plane' => '\f1d8',
        'fa-paperclip' => '\f0c6',
        'fa-parachute-box' => '\f4cd',
        'fa-paragraph' => '\f1dd',
        'fa-parking' => '\f540',
        'fa-passport' => '\f5ab',
        'fa-pastafarianism' => '\f67b',
        'fa-paste' => '\f0ea',
        'fa-pause' => '\f04c',
        'fa-pause-circle' => '\f28b',
        'fa-paw' => '\f1b0',
        'fa-peace' => '\f67c',
        'fa-pen' => '\f304',
        'fa-pen-alt' => '\f305',
        'fa-pen-fancy' => '\f5ac',
        'fa-pen-nib' => '\f5ad',
        'fa-pen-square' => '\f14b',
        'fa-pencil-alt' => '\f303',
        'fa-pencil-ruler' => '\f5ae',
        'fa-people-carry' => '\f4ce',
        'fa-pepper-hot' => '\f816',
        'fa-percent' => '\f295',
        'fa-percentage' => '\f541',
        'fa-person-booth' => '\f756',
        'fa-phone' => '\f095',
        'fa-phone-alt' => '\f879',
        'fa-phone-slash' => '\f3dd',
        'fa-phone-square' => '\f098',
        'fa-phone-square-alt' => '\f87b',
        'fa-phone-volume' => '\f2a0',
        'fa-photo-video' => '\f87c',
        'fa-piggy-bank' => '\f4d3',
        'fa-pills' => '\f484',
        'fa-pizza-slice' => '\f818',
        'fa-place-of-worship' => '\f67f',
        'fa-plane' => '\f072',
        'fa-plane-arrival' => '\f5af',
        'fa-plane-departure' => '\f5b0',
        'fa-play' => '\f04b',
        'fa-play-circle' => '\f144',
        'fa-plug' => '\f1e6',
        'fa-plus' => '\f067',
        'fa-plus-circle' => '\f055',
        'fa-plus-square' => '\f0fe',
        'fa-podcast' => '\f2ce',
        'fa-poll' => '\f681',
        'fa-poll-h' => '\f682',
        'fa-poo' => '\f2fe',
        'fa-poo-storm' => '\f75a',
        'fa-poop' => '\f619',
        'fa-portrait' => '\f3e0',
        'fa-pound-sign' => '\f154',
        'fa-power-off' => '\f011',
        'fa-pray' => '\f683',
        'fa-praying-hands' => '\f684',
        'fa-prescription' => '\f5b1',
        'fa-prescription-bottle' => '\f485',
        'fa-prescription-bottle-alt' => '\f486',
        'fa-print' => '\f02f',
        'fa-procedures' => '\f487',
        'fa-project-diagram' => '\f542',
        'fa-puzzle-piece' => '\f12e',
        'fa-qrcode' => '\f029',
        'fa-question' => '\f128',
        'fa-question-circle' => '\f059',
        'fa-quidditch' => '\f458',
        'fa-quote-left' => '\f10d',
        'fa-quote-right' => '\f10e',
        'fa-quran' => '\f687',
        'fa-radiation' => '\f7b9',
        'fa-radiation-alt' => '\f7ba',
        'fa-rainbow' => '\f75b',
        'fa-random' => '\f074',
        'fa-receipt' => '\f543',
        'fa-record-vinyl' => '\f8d9',
        'fa-recycle' => '\f1b8',
        'fa-redo' => '\f01e',
        'fa-redo-alt' => '\f2f9',
        'fa-registered' => '\f25d',
        'fa-remove-format' => '\f87d',
        'fa-reply' => '\f3e5',
        'fa-reply-all' => '\f122',
        'fa-republican' => '\f75e',
        'fa-restroom' => '\f7bd',
        'fa-retweet' => '\f079',
        'fa-ribbon' => '\f4d6',
        'fa-ring' => '\f70b',
        'fa-road' => '\f018',
        'fa-robot' => '\f544',
        'fa-rocket' => '\f135',
        'fa-route' => '\f4d7',
        'fa-rss' => '\f09e',
        'fa-rss-square' => '\f143',
        'fa-ruble-sign' => '\f158',
        'fa-ruler' => '\f545',
        'fa-ruler-combined' => '\f546',
        'fa-ruler-horizontal' => '\f547',
        'fa-ruler-vertical' => '\f548',
        'fa-running' => '\f70c',
        'fa-rupee-sign' => '\f156',
        'fa-sad-cry' => '\f5b3',
        'fa-sad-tear' => '\f5b4',
        'fa-satellite' => '\f7bf',
        'fa-satellite-dish' => '\f7c0',
        'fa-save' => '\f0c7',
        'fa-school' => '\f549',
        'fa-screwdriver' => '\f54a',
        'fa-scroll' => '\f70e',
        'fa-sd-card' => '\f7c2',
        'fa-search' => '\f002',
        'fa-search-dollar' => '\f688',
        'fa-search-location' => '\f689',
        'fa-search-minus' => '\f010',
        'fa-search-plus' => '\f00e',
        'fa-seedling' => '\f4d8',
        'fa-server' => '\f233',
        'fa-shapes' => '\f61f',
        'fa-share' => '\f064',
        'fa-share-alt' => '\f1e0',
        'fa-share-alt-square' => '\f1e1',
        'fa-share-square' => '\f14d',
        'fa-shekel-sign' => '\f20b',
        'fa-shield-alt' => '\f3ed',
        'fa-ship' => '\f21a',
        'fa-shipping-fast' => '\f48b',
        'fa-shoe-prints' => '\f54b',
        'fa-shopping-bag' => '\f290',
        'fa-shopping-basket' => '\f291',
        'fa-shopping-cart' => '\f07a',
        'fa-shower' => '\f2cc',
        'fa-shuttle-van' => '\f5b6',
        'fa-sign' => '\f4d9',
        'fa-sign-in-alt' => '\f2f6',
        'fa-sign-language' => '\f2a7',
        'fa-sign-out-alt' => '\f2f5',
        'fa-signal' => '\f012',
        'fa-signature' => '\f5b7',
        'fa-sim-card' => '\f7c4',
        'fa-sitemap' => '\f0e8',
        'fa-skating' => '\f7c5',
        'fa-skiing' => '\f7c9',
        'fa-skiing-nordic' => '\f7ca',
        'fa-skull' => '\f54c',
        'fa-skull-crossbones' => '\f714',
        'fa-slash' => '\f715',
        'fa-sleigh' => '\f7cc',
        'fa-sliders-h' => '\f1de',
        'fa-smile' => '\f118',
        'fa-smile-beam' => '\f5b8',
        'fa-smile-wink' => '\f4da',
        'fa-smog' => '\f75f',
        'fa-smoking' => '\f48d',
        'fa-smoking-ban' => '\f54d',
        'fa-sms' => '\f7cd',
        'fa-snowboarding' => '\f7ce',
        'fa-snowflake' => '\f2dc',
        'fa-snowman' => '\f7d0',
        'fa-snowplow' => '\f7d2',
        'fa-socks' => '\f696',
        'fa-solar-panel' => '\f5ba',
        'fa-sort' => '\f0dc',
        'fa-sort-alpha-down' => '\f15d',
        'fa-sort-alpha-down-alt' => '\f881',
        'fa-sort-alpha-up' => '\f15e',
        'fa-sort-alpha-up-alt' => '\f882',
        'fa-sort-amount-down' => '\f160',
        'fa-sort-amount-down-alt' => '\f884',
        'fa-sort-amount-up' => '\f161',
        'fa-sort-amount-up-alt' => '\f885',
        'fa-sort-down' => '\f0dd',
        'fa-sort-numeric-down' => '\f162',
        'fa-sort-numeric-down-alt' => '\f886',
        'fa-sort-numeric-up' => '\f163',
        'fa-sort-numeric-up-alt' => '\f887',
        'fa-sort-up' => '\f0de',
        'fa-spa' => '\f5bb',
        'fa-space-shuttle' => '\f197',
        'fa-spell-check' => '\f891',
        'fa-spider' => '\f717',
        'fa-spinner' => '\f110',
        'fa-splotch' => '\f5bc',
        'fa-spray-can' => '\f5bd',
        'fa-square' => '\f0c8',
        'fa-square-full' => '\f45c',
        'fa-square-root-alt' => '\f698',
        'fa-stamp' => '\f5bf',
        'fa-star' => '\f005',
        'fa-star-and-crescent' => '\f699',
        'fa-star-half' => '\f089',
        'fa-star-half-alt' => '\f5c0',
        'fa-star-of-david' => '\f69a',
        'fa-star-of-life' => '\f621',
        'fa-step-backward' => '\f048',
        'fa-step-forward' => '\f051',
        'fa-stethoscope' => '\f0f1',
        'fa-sticky-note' => '\f249',
        'fa-stop' => '\f04d',
        'fa-stop-circle' => '\f28d',
        'fa-stopwatch' => '\f2f2',
        'fa-store' => '\f54e',
        'fa-store-alt' => '\f54f',
        'fa-stream' => '\f550',
        'fa-street-view' => '\f21d',
        'fa-strikethrough' => '\f0cc',
        'fa-stroopwafel' => '\f551',
        'fa-subscript' => '\f12c',
        'fa-subway' => '\f239',
        'fa-suitcase' => '\f0f2',
        'fa-suitcase-rolling' => '\f5c1',
        'fa-sun' => '\f185',
        'fa-superscript' => '\f12b',
        'fa-surprise' => '\f5c2',
        'fa-swatchbook' => '\f5c3',
        'fa-swimmer' => '\f5c4',
        'fa-swimming-pool' => '\f5c5',
        'fa-synagogue' => '\f69b',
        'fa-sync' => '\f021',
        'fa-sync-alt' => '\f2f1',
        'fa-syringe' => '\f48e',
        'fa-table' => '\f0ce',
        'fa-table-tennis' => '\f45d',
        'fa-tablet' => '\f10a',
        'fa-tablet-alt' => '\f3fa',
        'fa-tablets' => '\f490',
        'fa-tachometer-alt' => '\f3fd',
        'fa-tag' => '\f02b',
        'fa-tags' => '\f02c',
        'fa-tape' => '\f4db',
        'fa-tasks' => '\f0ae',
        'fa-taxi' => '\f1ba',
        'fa-teeth' => '\f62e',
        'fa-teeth-open' => '\f62f',
        'fa-temperature-high' => '\f769',
        'fa-temperature-low' => '\f76b',
        'fa-tenge' => '\f7d7',
        'fa-terminal' => '\f120',
        'fa-text-height' => '\f034',
        'fa-text-width' => '\f035',
        'fa-th' => '\f00a',
        'fa-th-large' => '\f009',
        'fa-th-list' => '\f00b',
        'fa-theater-masks' => '\f630',
        'fa-thermometer' => '\f491',
        'fa-thermometer-empty' => '\f2cb',
        'fa-thermometer-full' => '\f2c7',
        'fa-thermometer-half' => '\f2c9',
        'fa-thermometer-quarter' => '\f2ca',
        'fa-thermometer-three-quarters' => '\f2c8',
        'fa-thumbs-down' => '\f165',
        'fa-thumbs-up' => '\f164',
        'fa-thumbtack' => '\f08d',
        'fa-ticket-alt' => '\f3ff',
        'fa-times' => '\f00d',
        'fa-times-circle' => '\f057',
        'fa-tint' => '\f043',
        'fa-tint-slash' => '\f5c7',
        'fa-tired' => '\f5c8',
        'fa-toggle-off' => '\f204',
        'fa-toggle-on' => '\f205',
        'fa-toilet' => '\f7d8',
        'fa-toilet-paper' => '\f71e',
        'fa-toolbox' => '\f552',
        'fa-tools' => '\f7d9',
        'fa-tooth' => '\f5c9',
        'fa-torah' => '\f6a0',
        'fa-torii-gate' => '\f6a1',
        'fa-tractor' => '\f722',
        'fa-trademark' => '\f25c',
        'fa-traffic-light' => '\f637',
        'fa-trailer' => '\f941',
        'fa-train' => '\f238',
        'fa-tram' => '\f7da',
        'fa-transgender' => '\f224',
        'fa-transgender-alt' => '\f225',
        'fa-trash' => '\f1f8',
        'fa-trash-alt' => '\f2ed',
        'fa-trash-restore' => '\f829',
        'fa-trash-restore-alt' => '\f82a',
        'fa-tree' => '\f1bb',
        'fa-trophy' => '\f091',
        'fa-truck' => '\f0d1',
        'fa-truck-loading' => '\f4de',
        'fa-truck-monster' => '\f63b',
        'fa-truck-moving' => '\f4df',
        'fa-truck-pickup' => '\f63c',
        'fa-tshirt' => '\f553',
        'fa-tty' => '\f1e4',
        'fa-tv' => '\f26c',
        'fa-umbrella' => '\f0e9',
        'fa-umbrella-beach' => '\f5ca',
        'fa-underline' => '\f0cd',
        'fa-undo' => '\f0e2',
        'fa-undo-alt' => '\f2ea',
        'fa-universal-access' => '\f29a',
        'fa-university' => '\f19c',
        'fa-unlink' => '\f127',
        'fa-unlock' => '\f09c',
        'fa-unlock-alt' => '\f13e',
        'fa-upload' => '\f093',
        'fa-user' => '\f007',
        'fa-user-alt' => '\f406',
        'fa-user-alt-slash' => '\f4fa',
        'fa-user-astronaut' => '\f4fb',
        'fa-user-check' => '\f4fc',
        'fa-user-circle' => '\f2bd',
        'fa-user-clock' => '\f4fd',
        'fa-user-cog' => '\f4fe',
        'fa-user-edit' => '\f4ff',
        'fa-user-friends' => '\f500',
        'fa-user-graduate' => '\f501',
        'fa-user-injured' => '\f728',
        'fa-user-lock' => '\f502',
        'fa-user-md' => '\f0f0',
        'fa-user-minus' => '\f503',
        'fa-user-ninja' => '\f504',
        'fa-user-nurse' => '\f82f',
        'fa-user-plus' => '\f234',
        'fa-user-secret' => '\f21b',
        'fa-user-shield' => '\f505',
        'fa-user-slash' => '\f506',
        'fa-user-tag' => '\f507',
        'fa-user-tie' => '\f508',
        'fa-user-times' => '\f235',
        'fa-users' => '\f0c0',
        'fa-users-cog' => '\f509',
        'fa-utensil-spoon' => '\f2e5',
        'fa-utensils' => '\f2e7',
        'fa-vector-square' => '\f5cb',
        'fa-venus' => '\f221',
        'fa-venus-double' => '\f226',
        'fa-venus-mars' => '\f228',
        'fa-vial' => '\f492',
        'fa-vials' => '\f493',
        'fa-video' => '\f03d',
        'fa-video-slash' => '\f4e2',
        'fa-vihara' => '\f6a7',
        'fa-voicemail' => '\f897',
        'fa-volleyball-ball' => '\f45f',
        'fa-volume-down' => '\f027',
        'fa-volume-mute' => '\f6a9',
        'fa-volume-off' => '\f026',
        'fa-volume-up' => '\f028',
        'fa-vote-yea' => '\f772',
        'fa-vr-cardboard' => '\f729',
        'fa-walking' => '\f554',
        'fa-wallet' => '\f555',
        'fa-warehouse' => '\f494',
        'fa-water' => '\f773',
        'fa-wave-square' => '\f83e',
        'fa-weight' => '\f496',
        'fa-weight-hanging' => '\f5cd',
        'fa-wheelchair' => '\f193',
        'fa-wifi' => '\f1eb',
        'fa-wind' => '\f72e',
        'fa-window-close' => '\f410',
        'fa-window-maximize' => '\f2d0',
        'fa-window-minimize' => '\f2d1',
        'fa-window-restore' => '\f2d2',
        'fa-wine-bottle' => '\f72f',
        'fa-wine-glass' => '\f4e3',
        'fa-wine-glass-alt' => '\f5ce',
        'fa-won-sign' => '\f159',
        'fa-wrench' => '\f0ad',
        'fa-x-ray' => '\f497',
        'fa-yen-sign' => '\f157',
        'fa-yin-yang' => '\f6ad',
        'far fa-address-book'  => '\f2b9',
        'far fa-address-card'  => '\f2bb',
        'far fa-angry'  => '\f556',
        'far fa-arrow-alt-circle-down'  => '\f358',
        'far fa-arrow-alt-circle-left'  => '\f359',
        'far fa-arrow-alt-circle-right'  => '\f35a',
        'far fa-arrow-alt-circle-up'  => '\f35b',
        'far fa-bell'  => '\f0f3',
        'far fa-bell-slash'  => '\f1f6',
        'far fa-bookmark'  => '\f02e',
        'far fa-building'  => '\f1ad',
        'far fa-calendar'  => '\f133',
        'far fa-calendar-alt'  => '\f073',
        'far fa-calendar-check'  => '\f274',
        'far fa-calendar-minus'  => '\f272',
        'far fa-calendar-plus'  => '\f271',
        'far fa-calendar-times'  => '\f273',
        'far fa-caret-square-down'  => '\f150',
        'far fa-caret-square-left'  => '\f191',
        'far fa-caret-square-right'  => '\f152',
        'far fa-caret-square-up'  => '\f151',
        'far fa-chart-bar'  => '\f080',
        'far fa-check-circle'  => '\f058',
        'far fa-check-square'  => '\f14a',
        'far fa-circle'  => '\f111',
        'far fa-clipboard'  => '\f328',
        'far fa-clock'  => '\f017',
        'far fa-clone'  => '\f24d',
        'far fa-closed-captioning'  => '\f20a',
        'far fa-comment'  => '\f075',
        'far fa-comment-alt'  => '\f27a',
        'far fa-comment-dots'  => '\f4ad',
        'far fa-comments'  => '\f086',
        'far fa-compass'  => '\f14e',
        'far fa-copy'  => '\f0c5',
        'far fa-copyright'  => '\f1f9',
        'far fa-credit-card'  => '\f09d',
        'far fa-dizzy'  => '\f567',
        'far fa-dot-circle'  => '\f192',
        'far fa-edit'  => '\f044',
        'far fa-envelope'  => '\f0e0',
        'far fa-envelope-open'  => '\f2b6',
        'far fa-eye'  => '\f06e',
        'far fa-eye-slash'  => '\f070',
        'far fa-file'  => '\f15b',
        'far fa-file-alt'  => '\f15c',
        'far fa-file-archive'  => '\f1c6',
        'far fa-file-audio'  => '\f1c7',
        'far fa-file-code'  => '\f1c9',
        'far fa-file-excel'  => '\f1c3',
        'far fa-file-image'  => '\f1c5',
        'far fa-file-pdf'  => '\f1c1',
        'far fa-file-powerpoint'  => '\f1c4',
        'far fa-file-video'  => '\f1c8',
        'far fa-file-word'  => '\f1c2',
        'far fa-flag'  => '\f024',
        'far fa-flushed'  => '\f579',
        'far fa-folder'  => '\f07b',
        'far fa-folder-open'  => '\f07c',
        'far fa-frown'  => '\f119',
        'far fa-frown-open'  => '\f57a',
        'far fa-futbol'  => '\f1e3',
        'far fa-gem'  => '\f3a5',
        'far fa-grimace'  => '\f57f',
        'far fa-grin'  => '\f580',
        'far fa-grin-alt'  => '\f581',
        'far fa-grin-beam'  => '\f582',
        'far fa-grin-beam-sweat'  => '\f583',
        'far fa-grin-hearts'  => '\f584',
        'far fa-grin-squint'  => '\f585',
        'far fa-grin-squint-tears'  => '\f586',
        'far fa-grin-stars'  => '\f587',
        'far fa-grin-tears'  => '\f588',
        'far fa-grin-tongue'  => '\f589',
        'far fa-grin-tongue-squint'  => '\f58a',
        'far fa-grin-tongue-wink'  => '\f58b',
        'far fa-grin-wink'  => '\f58c',
        'far fa-hand-lizard'  => '\f258',
        'far fa-hand-paper'  => '\f256',
        'far fa-hand-peace'  => '\f25b',
        'far fa-hand-point-down'  => '\f0a7',
        'far fa-hand-point-left'  => '\f0a5',
        'far fa-hand-point-right'  => '\f0a4',
        'far fa-hand-point-up'  => '\f0a6',
        'far fa-hand-pointer'  => '\f25a',
        'far fa-hand-rock'  => '\f255',
        'far fa-hand-scissors'  => '\f257',
        'far fa-hand-spock'  => '\f259',
        'far fa-handshake'  => '\f2b5',
        'far fa-hdd'  => '\f0a0',
        'far fa-heart'  => '\f004',
        'far fa-hospital'  => '\f0f8',
        'far fa-hourglass'  => '\f254',
        'far fa-id-badge'  => '\f2c1',
        'far fa-id-card'  => '\f2c2',
        'far fa-image'  => '\f03e',
        'far fa-images'  => '\f302',
        'far fa-keyboard'  => '\f11c',
        'far fa-kiss'  => '\f596',
        'far fa-kiss-beam'  => '\f597',
        'far fa-kiss-wink-heart'  => '\f598',
        'far fa-laugh'  => '\f599',
        'far fa-laugh-beam'  => '\f59a',
        'far fa-laugh-squint'  => '\f59b',
        'far fa-laugh-wink'  => '\f59c',
        'far fa-lemon'  => '\f094',
        'far fa-life-ring'  => '\f1cd',
        'far fa-lightbulb'  => '\f0eb',
        'far fa-list-alt'  => '\f022',
        'far fa-map'  => '\f279',
        'far fa-meh'  => '\f11a',
        'far fa-meh-blank'  => '\f5a4',
        'far fa-meh-rolling-eyes'  => '\f5a5',
        'far fa-minus-square'  => '\f146',
        'far fa-money-bill-alt'  => '\f3d1',
        'far fa-moon'  => '\f186',
        'far fa-newspaper'  => '\f1ea',
        'far fa-object-group'  => '\f247',
        'far fa-object-ungroup'  => '\f248',
        'far fa-paper-plane'  => '\f1d8',
        'far fa-pause-circle'  => '\f28b',
        'far fa-play-circle'  => '\f144',
        'far fa-plus-square'  => '\f0fe',
        'far fa-question-circle'  => '\f059',
        'far fa-registered'  => '\f25d',
        'far fa-sad-cry'  => '\f5b3',
        'far fa-sad-tear'  => '\f5b4',
        'far fa-save'  => '\f0c7',
        'far fa-share-square'  => '\f14d',
        'far fa-smile'  => '\f118',
        'far fa-smile-beam'  => '\f5b8',
        'far fa-smile-wink'  => '\f4da',
        'far fa-snowflake'  => '\f2dc',
        'far fa-square'  => '\f0c8',
        'far fa-star'  => '\f005',
        'far fa-star-half'  => '\f089',
        'far fa-sticky-note'  => '\f249',
        'far fa-stop-circle'  => '\f28d',
        'far fa-sun'  => '\f185',
        'far fa-surprise'  => '\f5c2',
        'far fa-thumbs-down'  => '\f165',
        'far fa-thumbs-up'  => '\f164',
        'far fa-times-circle'  => '\f057',
        'far fa-tired'  => '\f5c8',
        'far fa-trash-alt'  => '\f2ed',
        'far fa-user'  => '\f007',
        'far fa-user-circle'  => '\f2bd',
        'far fa-window-close'  => '\f410',
        'far fa-window-maximize'  => '\f2d0',
        'far fa-window-minimize'  => '\f2d1',
        'far fa-window-restore'  => '\f2d2',
        'fab fa-500px'  => '\f26e',
        'fab fa-accessible-icon'  => '\f368',
        'fab fa-accusoft'  => '\f369',
        'fab fa-acquisitions-incorporated'  => '\f6af',
        'fab fa-adn'  => '\f170',
        'fab fa-adobe'  => '\f778',
        'fab fa-adversal'  => '\f36a',
        'fab fa-affiliatetheme'  => '\f36b',
        'fab fa-airbnb'  => '\f834',
        'fab fa-algolia'  => '\f36c',
        'fab fa-alipay'  => '\f642',
        'fab fa-amazon'  => '\f270',
        'fab fa-amazon-pay'  => '\f42c',
        'fab fa-amilia'  => '\f36d',
        'fab fa-android'  => '\f17b',
        'fab fa-angellist'  => '\f209',
        'fab fa-angrycreative'  => '\f36e',
        'fab fa-angular'  => '\f420',
        'fab fa-app-store'  => '\f36f',
        'fab fa-app-store-ios'  => '\f370',
        'fab fa-apper'  => '\f371',
        'fab fa-apple'  => '\f179',
        'fab fa-apple-pay'  => '\f415',
        'fab fa-artstation'  => '\f77a',
        'fab fa-asymmetrik'  => '\f372',
        'fab fa-atlassian'  => '\f77b',
        'fab fa-audible'  => '\f373',
        'fab fa-autoprefixer'  => '\f41c',
        'fab fa-avianex'  => '\f374',
        'fab fa-aviato'  => '\f421',
        'fab fa-aws'  => '\f375',
        'fab fa-bandcamp'  => '\f2d5',
        'fab fa-battle-net'  => '\f835',
        'fab fa-behance'  => '\f1b4',
        'fab fa-behance-square'  => '\f1b5',
        'fab fa-bimobject'  => '\f378',
        'fab fa-bitbucket'  => '\f171',
        'fab fa-bitcoin'  => '\f379',
        'fab fa-bity'  => '\f37a',
        'fab fa-black-tie'  => '\f27e',
        'fab fa-blackberry'  => '\f37b',
        'fab fa-blogger'  => '\f37c',
        'fab fa-blogger-b'  => '\f37d',
        'fab fa-bluetooth'  => '\f293',
        'fab fa-bluetooth-b'  => '\f294',
        'fab fa-bootstrap'  => '\f836',
        'fab fa-btc'  => '\f15a',
        'fab fa-buffer'  => '\f837',
        'fab fa-buromobelexperte'  => '\f37f',
        'fab fa-buy-n-large'  => '\f8a6',
        'fab fa-buysellads'  => '\f20d',
        'fab fa-canadian-maple-leaf'  => '\f785',
        'fab fa-cc-amazon-pay'  => '\f42d',
        'fab fa-cc-amex'  => '\f1f3',
        'fab fa-cc-apple-pay'  => '\f416',
        'fab fa-cc-diners-club'  => '\f24c',
        'fab fa-cc-discover'  => '\f1f2',
        'fab fa-cc-jcb'  => '\f24b',
        'fab fa-cc-mastercard'  => '\f1f1',
        'fab fa-cc-paypal'  => '\f1f4',
        'fab fa-cc-stripe'  => '\f1f5',
        'fab fa-cc-visa'  => '\f1f0',
        'fab fa-centercode'  => '\f380',
        'fab fa-centos'  => '\f789',
        'fab fa-chrome'  => '\f268',
        'fab fa-chromecast'  => '\f838',
        'fab fa-cloudscale'  => '\f383',
        'fab fa-cloudsmith'  => '\f384',
        'fab fa-cloudversify'  => '\f385',
        'fab fa-codepen'  => '\f1cb',
        'fab fa-codiepie'  => '\f284',
        'fab fa-confluence'  => '\f78d',
        'fab fa-connectdevelop'  => '\f20e',
        'fab fa-contao'  => '\f26d',
        'fab fa-cotton-bureau'  => '\f89e',
        'fab fa-cpanel'  => '\f388',
        'fab fa-creative-commons'  => '\f25e',
        'fab fa-creative-commons-by'  => '\f4e7',
        'fab fa-creative-commons-nc'  => '\f4e8',
        'fab fa-creative-commons-nc-eu'  => '\f4e9',
        'fab fa-creative-commons-nc-jp'  => '\f4ea',
        'fab fa-creative-commons-nd'  => '\f4eb',
        'fab fa-creative-commons-pd'  => '\f4ec',
        'fab fa-creative-commons-pd-alt'  => '\f4ed',
        'fab fa-creative-commons-remix'  => '\f4ee',
        'fab fa-creative-commons-sa'  => '\f4ef',
        'fab fa-creative-commons-sampling'  => '\f4f0',
        'fab fa-creative-commons-sampling-plus'  => '\f4f1',
        'fab fa-creative-commons-share'  => '\f4f2',
        'fab fa-creative-commons-zero'  => '\f4f3',
        'fab fa-critical-role'  => '\f6c9',
        'fab fa-css3'  => '\f13c',
        'fab fa-css3-alt'  => '\f38b',
        'fab fa-cuttlefish'  => '\f38c',
        'fab fa-d-and-d'  => '\f38d',
        'fab fa-d-and-d-beyond'  => '\f6ca',
        'fab fa-dailymotion'  => '\f952',
        'fab fa-dashcube'  => '\f210',
        'fab fa-delicious'  => '\f1a5',
        'fab fa-deploydog'  => '\f38e',
        'fab fa-deskpro'  => '\f38f',
        'fab fa-dev'  => '\f6cc',
        'fab fa-deviantart'  => '\f1bd',
        'fab fa-dhl'  => '\f790',
        'fab fa-diaspora'  => '\f791',
        'fab fa-digg'  => '\f1a6',
        'fab fa-digital-ocean'  => '\f391',
        'fab fa-discord'  => '\f392',
        'fab fa-discourse'  => '\f393',
        'fab fa-dochub'  => '\f394',
        'fab fa-docker'  => '\f395',
        'fab fa-draft2digital'  => '\f396',
        'fab fa-dribbble'  => '\f17d',
        'fab fa-dribbble-square'  => '\f397',
        'fab fa-dropbox'  => '\f16b',
        'fab fa-drupal'  => '\f1a9',
        'fab fa-dyalog'  => '\f399',
        'fab fa-earlybirds'  => '\f39a',
        'fab fa-ebay'  => '\f4f4',
        'fab fa-edge'  => '\f282',
        'fab fa-elementor'  => '\f430',
        'fab fa-ello'  => '\f5f1',
        'fab fa-ember'  => '\f423',
        'fab fa-empire'  => '\f1d1',
        'fab fa-envira'  => '\f299',
        'fab fa-erlang'  => '\f39d',
        'fab fa-ethereum'  => '\f42e',
        'fab fa-etsy'  => '\f2d7',
        'fab fa-evernote'  => '\f839',
        'fab fa-expeditedssl'  => '\f23e',
        'fab fa-facebook'  => '\f09a',
        'fab fa-facebook-f'  => '\f39e',
        'fab fa-facebook-messenger'  => '\f39f',
        'fab fa-facebook-square'  => '\f082',
        'fab fa-fantasy-flight-games'  => '\f6dc',
        'fab fa-fedex'  => '\f797',
        'fab fa-fedora'  => '\f798',
        'fab fa-figma'  => '\f799',
        'fab fa-firefox'  => '\f269',
        'fab fa-firefox-browser'  => '\f907',
        'fab fa-first-order'  => '\f2b0',
        'fab fa-first-order-alt'  => '\f50a',
        'fab fa-firstdraft'  => '\f3a1',
        'fab fa-flickr'  => '\f16e',
        'fab fa-flipboard'  => '\f44d',
        'fab fa-fly'  => '\f417',
        'fab fa-font-awesome'  => '\f2b4',
        'fab fa-font-awesome-alt'  => '\f35c',
        'fab fa-font-awesome-flag'  => '\f425',
        'fab fa-fonticons'  => '\f280',
        'fab fa-fonticons-fi'  => '\f3a2',
        'fab fa-fort-awesome'  => '\f286',
        'fab fa-fort-awesome-alt'  => '\f3a3',
        'fab fa-forumbee'  => '\f211',
        'fab fa-foursquare'  => '\f180',
        'fab fa-free-code-camp'  => '\f2c5',
        'fab fa-freebsd'  => '\f3a4',
        'fab fa-fulcrum'  => '\f50b',
        'fab fa-galactic-republic'  => '\f50c',
        'fab fa-galactic-senate'  => '\f50d',
        'fab fa-get-pocket'  => '\f265',
        'fab fa-gg'  => '\f260',
        'fab fa-gg-circle'  => '\f261',
        'fab fa-git'  => '\f1d3',
        'fab fa-git-alt'  => '\f841',
        'fab fa-git-square'  => '\f1d2',
        'fab fa-github'  => '\f09b',
        'fab fa-github-alt'  => '\f113',
        'fab fa-github-square'  => '\f092',
        'fab fa-gitkraken'  => '\f3a6',
        'fab fa-gitlab'  => '\f296',
        'fab fa-gitter'  => '\f426',
        'fab fa-glide'  => '\f2a5',
        'fab fa-glide-g'  => '\f2a6',
        'fab fa-gofore'  => '\f3a7',
        'fab fa-goodreads'  => '\f3a8',
        'fab fa-goodreads-g'  => '\f3a9',
        'fab fa-google'  => '\f1a0',
        'fab fa-google-drive'  => '\f3aa',
        'fab fa-google-play'  => '\f3ab',
        'fab fa-google-plus'  => '\f2b3',
        'fab fa-google-plus-g'  => '\f0d5',
        'fab fa-google-plus-square'  => '\f0d4',
        'fab fa-google-wallet'  => '\f1ee',
        'fab fa-gratipay'  => '\f184',
        'fab fa-grav'  => '\f2d6',
        'fab fa-gripfire'  => '\f3ac',
        'fab fa-grunt'  => '\f3ad',
        'fab fa-gulp'  => '\f3ae',
        'fab fa-hacker-news'  => '\f1d4',
        'fab fa-hacker-news-square'  => '\f3af',
        'fab fa-hackerrank'  => '\f5f7',
        'fab fa-hips'  => '\f452',
        'fab fa-hire-a-helper'  => '\f3b0',
        'fab fa-hooli'  => '\f427',
        'fab fa-hornbill'  => '\f592',
        'fab fa-hotjar'  => '\f3b1',
        'fab fa-houzz'  => '\f27c',
        'fab fa-html5'  => '\f13b',
        'fab fa-hubspot'  => '\f3b2',
        'fab fa-ideal'  => '\f913',
        'fab fa-imdb'  => '\f2d8',
        'fab fa-instagram'  => '\f16d',
        'fab fa-instagram-square'  => '\f955',
        'fab fa-intercom'  => '\f7af',
        'fab fa-internet-explorer'  => '\f26b',
        'fab fa-invision'  => '\f7b0',
        'fab fa-ioxhost'  => '\f208',
        'fab fa-itch-io'  => '\f83a',
        'fab fa-itunes'  => '\f3b4',
        'fab fa-itunes-note'  => '\f3b5',
        'fab fa-java'  => '\f4e4',
        'fab fa-jedi-order'  => '\f50e',
        'fab fa-jenkins'  => '\f3b6',
        'fab fa-jira'  => '\f7b1',
        'fab fa-joget'  => '\f3b7',
        'fab fa-joomla'  => '\f1aa',
        'fab fa-js'  => '\f3b8',
        'fab fa-js-square'  => '\f3b9',
        'fab fa-jsfiddle'  => '\f1cc',
        'fab fa-kaggle'  => '\f5fa',
        'fab fa-keybase'  => '\f4f5',
        'fab fa-keycdn'  => '\f3ba',
        'fab fa-kickstarter'  => '\f3bb',
        'fab fa-kickstarter-k'  => '\f3bc',
        'fab fa-korvue'  => '\f42f',
        'fab fa-laravel'  => '\f3bd',
        'fab fa-lastfm'  => '\f202',
        'fab fa-lastfm-square'  => '\f203',
        'fab fa-leanpub'  => '\f212',
        'fab fa-less'  => '\f41d',
        'fab fa-line'  => '\f3c0',
        'fab fa-linkedin'  => '\f08c',
        'fab fa-linkedin-in'  => '\f0e1',
        'fab fa-linode'  => '\f2b8',
        'fab fa-linux'  => '\f17c',
        'fab fa-lyft'  => '\f3c3',
        'fab fa-magento'  => '\f3c4',
        'fab fa-mailchimp'  => '\f59e',
        'fab fa-mandalorian'  => '\f50f',
        'fab fa-markdown'  => '\f60f',
        'fab fa-mastodon'  => '\f4f6',
        'fab fa-maxcdn'  => '\f136',
        'fab fa-mdb'  => '\f8ca',
        'fab fa-medapps'  => '\f3c6',
        'fab fa-medium'  => '\f23a',
        'fab fa-medium-m'  => '\f3c7',
        'fab fa-medrt'  => '\f3c8',
        'fab fa-meetup'  => '\f2e0',
        'fab fa-megaport'  => '\f5a3',
        'fab fa-mendeley'  => '\f7b3',
        'fab fa-microblog'  => '\f91a',
        'fab fa-microsoft'  => '\f3ca',
        'fab fa-mix'  => '\f3cb',
        'fab fa-mixcloud'  => '\f289',
        'fab fa-mixer'  => '\f956',
        'fab fa-mizuni'  => '\f3cc',
        'fab fa-modx'  => '\f285',
        'fab fa-monero'  => '\f3d0',
        'fab fa-napster'  => '\f3d2',
        'fab fa-neos'  => '\f612',
        'fab fa-nimblr'  => '\f5a8',
        'fab fa-node'  => '\f419',
        'fab fa-node-js'  => '\f3d3',
        'fab fa-npm'  => '\f3d4',
        'fab fa-ns8'  => '\f3d5',
        'fab fa-nutritionix'  => '\f3d6',
        'fab fa-odnoklassniki'  => '\f263',
        'fab fa-odnoklassniki-square'  => '\f264',
        'fab fa-old-republic'  => '\f510',
        'fab fa-opencart'  => '\f23d',
        'fab fa-openid'  => '\f19b',
        'fab fa-opera'  => '\f26a',
        'fab fa-optin-monster'  => '\f23c',
        'fab fa-orcid'  => '\f8d2',
        'fab fa-osi'  => '\f41a',
        'fab fa-page4'  => '\f3d7',
        'fab fa-pagelines'  => '\f18c',
        'fab fa-palfed'  => '\f3d8',
        'fab fa-patreon'  => '\f3d9',
        'fab fa-paypal'  => '\f1ed',
        'fab fa-penny-arcade'  => '\f704',
        'fab fa-periscope'  => '\f3da',
        'fab fa-phabricator'  => '\f3db',
        'fab fa-phoenix-framework'  => '\f3dc',
        'fab fa-phoenix-squadron'  => '\f511',
        'fab fa-php'  => '\f457',
        'fab fa-pied-piper'  => '\f2ae',
        'fab fa-pied-piper-alt'  => '\f1a8',
        'fab fa-pied-piper-hat'  => '\f4e5',
        'fab fa-pied-piper-pp'  => '\f1a7',
        'fab fa-pied-piper-square'  => '\f91e',
        'fab fa-pinterest'  => '\f0d2',
        'fab fa-pinterest-p'  => '\f231',
        'fab fa-pinterest-square'  => '\f0d3',
        'fab fa-playstation'  => '\f3df',
        'fab fa-product-hunt'  => '\f288',
        'fab fa-pushed'  => '\f3e1',
        'fab fa-python'  => '\f3e2',
        'fab fa-qq'  => '\f1d6',
        'fab fa-quinscape'  => '\f459',
        'fab fa-quora'  => '\f2c4',
        'fab fa-r-project'  => '\f4f7',
        'fab fa-raspberry-pi'  => '\f7bb',
        'fab fa-ravelry'  => '\f2d9',
        'fab fa-react'  => '\f41b',
        'fab fa-reacteurope'  => '\f75d',
        'fab fa-readme'  => '\f4d5',
        'fab fa-rebel'  => '\f1d0',
        'fab fa-red-river'  => '\f3e3',
        'fab fa-reddit'  => '\f1a1',
        'fab fa-reddit-alien'  => '\f281',
        'fab fa-reddit-square'  => '\f1a2',
        'fab fa-redhat'  => '\f7bc',
        'fab fa-renren'  => '\f18b',
        'fab fa-replyd'  => '\f3e6',
        'fab fa-researchgate'  => '\f4f8',
        'fab fa-resolving'  => '\f3e7',
        'fab fa-rev'  => '\f5b2',
        'fab fa-rocketchat'  => '\f3e8',
        'fab fa-rockrms'  => '\f3e9',
        'fab fa-safari'  => '\f267',
        'fab fa-salesforce'  => '\f83b',
        'fab fa-sass'  => '\f41e',
        'fab fa-schlix'  => '\f3ea',
        'fab fa-scribd'  => '\f28a',
        'fab fa-searchengin'  => '\f3eb',
        'fab fa-sellcast'  => '\f2da',
        'fab fa-sellsy'  => '\f213',
        'fab fa-servicestack'  => '\f3ec',
        'fab fa-shirtsinbulk'  => '\f214',
        'fab fa-shopify'  => '\f957',
        'fab fa-shopware'  => '\f5b5',
        'fab fa-simplybuilt'  => '\f215',
        'fab fa-sistrix'  => '\f3ee',
        'fab fa-sith'  => '\f512',
        'fab fa-sketch'  => '\f7c6',
        'fab fa-skyatlas'  => '\f216',
        'fab fa-skype'  => '\f17e',
        'fab fa-slack'  => '\f198',
        'fab fa-slack-hash'  => '\f3ef',
        'fab fa-slideshare'  => '\f1e7',
        'fab fa-snapchat'  => '\f2ab',
        'fab fa-snapchat-ghost'  => '\f2ac',
        'fab fa-snapchat-square'  => '\f2ad',
        'fab fa-soundcloud'  => '\f1be',
        'fab fa-sourcetree'  => '\f7d3',
        'fab fa-speakap'  => '\f3f3',
        'fab fa-speaker-deck'  => '\f83c',
        'fab fa-spotify'  => '\f1bc',
        'fab fa-squarespace'  => '\f5be',
        'fab fa-stack-exchange'  => '\f18d',
        'fab fa-stack-overflow'  => '\f16c',
        'fab fa-stackpath'  => '\f842',
        'fab fa-staylinked'  => '\f3f5',
        'fab fa-steam'  => '\f1b6',
        'fab fa-steam-square'  => '\f1b7',
        'fab fa-steam-symbol'  => '\f3f6',
        'fab fa-sticker-mule'  => '\f3f7',
        'fab fa-strava'  => '\f428',
        'fab fa-stripe'  => '\f429',
        'fab fa-stripe-s'  => '\f42a',
        'fab fa-studiovinari'  => '\f3f8',
        'fab fa-stumbleupon'  => '\f1a4',
        'fab fa-stumbleupon-circle'  => '\f1a3',
        'fab fa-superpowers'  => '\f2dd',
        'fab fa-supple'  => '\f3f9',
        'fab fa-suse'  => '\f7d6',
        'fab fa-swift'  => '\f8e1',
        'fab fa-symfony'  => '\f83d',
        'fab fa-teamspeak'  => '\f4f9',
        'fab fa-telegram'  => '\f2c6',
        'fab fa-telegram-plane'  => '\f3fe',
        'fab fa-tencent-weibo'  => '\f1d5',
        'fab fa-the-red-yeti'  => '\f69d',
        'fab fa-themeco'  => '\f5c6',
        'fab fa-themeisle'  => '\f2b2',
        'fab fa-think-peaks'  => '\f731',
        'fab fa-trade-federation'  => '\f513',
        'fab fa-trello'  => '\f181',
        'fab fa-tripadvisor'  => '\f262',
        'fab fa-tumblr'  => '\f173',
        'fab fa-tumblr-square'  => '\f174',
        'fab fa-twitch'  => '\f1e8',
        'fab fa-twitter'  => '\f099',
        'fab fa-twitter-square'  => '\f081',
        'fab fa-typo3'  => '\f42b',
        'fab fa-uber'  => '\f402',
        'fab fa-ubuntu'  => '\f7df',
        'fab fa-uikit'  => '\f403',
        'fab fa-umbraco'  => '\f8e8',
        'fab fa-uniregistry'  => '\f404',
        'fab fa-unity'  => '\f949',
        'fab fa-untappd'  => '\f405',
        'fab fa-ups'  => '\f7e0',
        'fab fa-usb'  => '\f287',
        'fab fa-usps'  => '\f7e1',
        'fab fa-ussunnah'  => '\f407',
        'fab fa-vaadin'  => '\f408',
        'fab fa-viacoin'  => '\f237',
        'fab fa-viadeo'  => '\f2a9',
        'fab fa-viadeo-square'  => '\f2aa',
        'fab fa-viber'  => '\f409',
        'fab fa-vimeo'  => '\f40a',
        'fab fa-vimeo-square'  => '\f194',
        'fab fa-vimeo-v'  => '\f27d',
        'fab fa-vine'  => '\f1ca',
        'fab fa-vk'  => '\f189',
        'fab fa-vnv'  => '\f40b',
        'fab fa-vuejs'  => '\f41f',
        'fab fa-waze'  => '\f83f',
        'fab fa-weebly'  => '\f5cc',
        'fab fa-weibo'  => '\f18a',
        'fab fa-weixin'  => '\f1d7',
        'fab fa-whatsapp'  => '\f232',
        'fab fa-whatsapp-square'  => '\f40c',
        'fab fa-whmcs'  => '\f40d',
        'fab fa-wikipedia-w'  => '\f266',
        'fab fa-windows'  => '\f17a',
        'fab fa-wix'  => '\f5cf',
        'fab fa-wizards-of-the-coast'  => '\f730',
        'fab fa-wolf-pack-battalion'  => '\f514',
        'fab fa-wordpress'  => '\f19a',
        'fab fa-wordpress-simple'  => '\f411',
        'fab fa-wpbeginner'  => '\f297',
        'fab fa-wpexplorer'  => '\f2de',
        'fab fa-wpforms'  => '\f298',
        'fab fa-wpressr'  => '\f3e4',
        'fab fa-xbox'  => '\f412',
        'fab fa-xing'  => '\f168',
        'fab fa-xing-square'  => '\f169',
        'fab fa-y-combinator'  => '\f23b',
        'fab fa-yahoo'  => '\f19e',
        'fab fa-yammer'  => '\f840',
        'fab fa-yandex'  => '\f413',
        'fab fa-yandex-international'  => '\f414',
        'fab fa-yarn'  => '\f7e3',
        'fab fa-yelp'  => '\f1e9',
        'fab fa-yoast'  => '\f2b1',
        'fab fa-youtube'  => '\f167',
        'fab fa-youtube-square'  => '\f431',
        'fab fa-zhihu'  => '\f63f',
    ];
}