<?php
$elision_options = elision_qode_return_global_options();
$qode_sidebar = elision_qode_get_sidebar_layout(false);

if (isset($elision_options['twitter_via']) && !empty($elision_options['twitter_via'])) {
    $twitter_via = " via " . $elision_options['twitter_via'];
} else {
    $twitter_via = "";
}
$meta = get_post_meta(get_post()->ID, 'custom_post_fields', true);
get_header(); ?>
<?php if (have_posts()) : ?>
    <?php while (have_posts()) : the_post(); ?>
        <?php get_template_part('includes/modules/title'); ?>
        <?php get_template_part('slider'); ?>
        <div class="container">
        <div class="container_inner">
        <div class="container_upper button-group">
            <?php $terms = get_the_terms(get_post(), 'events');
            $hasTerms = is_array($terms);
            if ($hasTerms) { ?>
                <div class="exhibitor-link">
                    <a class="qbutton tiny partner-prev-btn"
                       href="<?= get_permalink(get_previous_post(true, '', 'events')); ?>">
                        <?= _x("previous", "ms-eventman") . ' ' . _x("Partner", "ms-eventman") ?>
                    </a>
                </div>
            <?php } ?>

            <div class="exhibitor-link">
                <?php
                if ($hasTerms) {
                    $publishedTerms = array_filter($terms, function ($term) {
                        return get_term_meta($term->term_id, 'publish', true) == 'on';
                    });

                    $url = get_term_link(array_pop($publishedTerms));
                    if ($url instanceof WP_Error) {
                        $url = get_post_type_archive_link('partners');
                    } elseif (strpos($url, '?lang=') !== false) {
                        $lang = '';
                        if (strpos($url, '?lang=') !== false) {
                            $lang = substr($url, strpos($url, '?lang='));
                            $url = substr($url, 0, strpos($url, '?lang=') - 1) . '/';
                        }
                        $url .= 'partners' . $lang;
                    }else {
                        $url .= 'partners';
                    }

                } else {
                    $url = get_post_type_archive_link('partners');
                }
                ?>
                <a class="qbutton tiny" href="<?= $url ?>">
                    <?= _x("Overview", "ms-eventman") ?>
                </a>
            </div>
            <?php if ($hasTerms) { ?>
                <div class="exhibitor-link">
                    <a class="qbutton tiny partner-next-btn"
                       href="<?= get_permalink(get_next_post(true, '', 'events')); ?>">
                        <?= _x("next", "ms-eventman") . ' ' . _x("Partner", "ms-eventman") ?>
                    </a>
                </div>
            <?php } ?>
        </div>
        <?php if (($qode_sidebar == "default") || ($qode_sidebar == "")) : ?>
            <div class="blog_holder blog_single">
                <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="post_<?= $meta['logo_position'] == 'left' ? 'right' : 'left' ?>">
                        <div class="post_content_holder">
                            <div class="post_text">
                                <?php echo do_shortcode('[social_share]'); ?>
                                <table class="exhibitor-details-table">
                                    <?php $meta = get_post_meta(get_post()->ID, 'custom_post_fields', true);
                                    foreach ($meta as $name => $value) {
                                        if ($value !== '' && strpos($name, 'social_') !== 0 && !in_array($name, ['description', 'logo_position'])) {
                                            $parts = array_map(function ($p) {
                                                return ucfirst($p);
                                            }, explode("_", $name));

                                            $formattedName = implode(" ", $parts);
                                            ?>
                                            <tr>
                                                <th scope="row"><?php _e($formattedName, 'ms-eventman') ?></th>
                                                <td><?php
                                                    if (strtolower($name) == "website") {
                                                        $value = strpos($value, 'http') === 0 ? substr($value, strpos($value, ':' ) + 3) : $value;
                                                        echo '<a target="_blank" href="//' . $value . '">' . $value . "</a>";
                                                    } elseif (strtolower($name) == "email") {
                                                        echo '<a href="mailto:' . $value . '">' . $value . "</a>";
                                                    } elseif (strtolower($name) == "phone_number") {
                                                        echo '<a href="tel:' . $value . '">' . $value . "</a>";
                                                    } else {
                                                        echo $value;
                                                    }
                                                    ?></td>
                                            </tr>
                                        <?php }
                                    } ?>
                                </table>
                                <div class="partner-description">
                                <?= isset($meta['description']) ? nl2br($meta['description']) : ''; ?>
                                </div>
                            </div>
                        </div>
                        <div class="post_info">
                            <div class="inner">
                                <?php if (isset($meta['website']) && !empty($meta['website'])) { ?>
                                    <div class="inner website<?= $meta['logo_position'] == 'left' ? ' align-right' : '' ?>">
                                        <a class="qbutton small"
                                           target="_blank"
                                           href="<?= $websiteUrl = (strpos($meta['website'], 'https://') !== false || strpos($meta['website'], 'http://') !== false) ? $meta['website'] : '//' . $meta['website'];
                                           $websiteUrl ?>">Website</a>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="post_<?= $meta['logo_position'] == 'left' ? 'left' : 'right' ?> logo">
                        <?php if (get_post_meta(get_the_ID(), "qode_hide-featured-image", true) != "yes") {
                            if (has_post_thumbnail()) { ?>
                                <div class="post_image">
                                    <a target="_blank"
                                       href="<?= isset($meta['website']) ? $websiteUrl : ''; ?>"
                                       title="<?php the_title_attribute(); ?>">
                                        <img class="post_image" src="<?= get_the_post_thumbnail_url() ?>"
                                             alt="<?= get_the_post_thumbnail_caption() ?>"/>
                                    </a>
                                </div>
                            <?php }
                        } ?>
                    </div>
                </div>
            </div>
            <?php
            if (elision_qode_is_comments_enabled()) {
                comments_template('', true);
            } else {
                echo "<br/><br/>";
            }
            ?>

        <?php elseif ($qode_sidebar == "1" || $qode_sidebar == "2"): ?>
            <?php if ($qode_sidebar == "1") : ?>
                <div class="two_columns_66_33 background_color_sidebar grid2 clearfix">
                <div class="column1">
            <?php elseif ($qode_sidebar == "2") : ?>
                <div class="two_columns_75_25 background_color_sidebar grid2 clearfix">
                <div class="column1">
            <?php endif; ?>

            <div class="column_inner">
                <div class="blog_holder blog_single">
                    <?php
                    get_template_part('blog_single', 'loop');
                    ?>
                </div>

                <?php
                if (elision_qode_is_comments_enabled()) {
                    comments_template('', true);
                } else {
                    echo "<br/><br/>";
                }
                ?>
            </div>
            </div>
            <div class="column2">
                <?php get_sidebar(); ?>
            </div>
            </div>
        <?php elseif ($qode_sidebar == "3" || $qode_sidebar == "4"): ?>
            <?php if ($qode_sidebar == "3") : ?>
                <div class="two_columns_33_66 background_color_sidebar grid2 clearfix">
                <div class="column1">
                    <?php get_sidebar(); ?>
                </div>
                <div class="column2">
            <?php elseif ($qode_sidebar == "4") : ?>
                <div class="two_columns_25_75 background_color_sidebar grid2 clearfix">
                <div class="column1">
                    <?php get_sidebar(); ?>
                </div>
                <div class="column2">
            <?php endif; ?>

            <div class="column_inner">
                <div class="blog_holder blog_single">
                    <?php
                    get_template_part('blog_single', 'loop');
                    ?>
                </div>
                <?php
                if (elision_qode_is_comments_enabled()) {
                    comments_template('', true);
                } else {
                    echo "<br/><br/>";
                }
                ?>
            </div>
            </div>
            </div>
        <?php endif; ?>
        </div>
        </div>
        </div>
    <?php endwhile; ?>
<?php endif; ?>


<?php get_footer(); ?>