<?php
$elision_options = elision_qode_return_global_options();
$qode_sidebar = elision_qode_get_sidebar_layout(false);

if (isset($elision_options['twitter_via']) && !empty($elision_options['twitter_via'])) {
    $twitter_via = " via " . $elision_options['twitter_via'];
} else {
    $twitter_via = "";
}
get_header(); ?>
<?php if (have_posts()) : ?>
    <?php while (have_posts()) : the_post(); ?>
        <?php get_template_part('includes/modules/title'); ?>
        <?php get_template_part('slider'); ?>
        <div class="container">
        <div class="container_inner">
        <div class="container_upper button-group">
            <?php
            $postTerms = get_the_terms(get_post(), 'events');
            if ($postTerms && !($postTerms instanceof WP_Error)) {
                $publishedTerms = array_filter($postTerms, function ($term) {
                    return get_term_meta($term->term_id, 'publish', true) == 'on';
                });

                if ($publishedTerms) {
                    usort($publishedTerms, function($t, $t2) {
                        return intval($t->name) > intval($t2->name);
                    });

                    $latestTerm = array_pop($publishedTerms);
                    $excludedTerms = array_map(function($term) {
                        return $term->term_id;
                    }, $publishedTerms);
                    $url = get_term_link($latestTerm);
                    if ($url instanceof WP_Error) {
                        $url = get_post_type_archive_link('exhibitors');
                    } elseif (strpos($url, '?lang=') !== false) {
                        $lang = '';
                        if (strpos($url, '?lang=') !== false) {
                            $lang = substr($url, strpos($url, '?lang='));
                            $url = substr($url, 0, strpos($url, '?lang=') - 1) . '/';
                        }
                        $url .= 'exhibitors' . $lang;
                    }
                }
            }
            $url = isset($url) ? $url : get_post_type_archive_link('exhibitors');
            ?>
            <?php if ($postTerms) { ?>
                <div class="exhibitor-link">
                    <a class="qbutton tiny exhibitor-prev-btn"
                       href="<?= get_permalink(get_previous_post(false, $excludedTerms, 'events')); ?>">
                        <?= _x("previous", "ms-eventman") . ' ' . _x("Exhibitor", "ms-eventman") ?>
                    </a>
                </div>
            <?php } ?>

            <div class="exhibitor-link">
                <a class="qbutton tiny" href="<?= $url ?>">
                    <?= _x("Overview", "ms-eventman") ?>
                </a>
            </div>
            <?php if ($postTerms) { ?>
                <div class="exhibitor-link">
                    <a class="qbutton tiny exhibitor-next-btn"
                       href="<?= get_permalink(get_next_post(false, $excludedTerms, 'events')); ?>">
                        <?= _x("next", "ms-eventman") . ' ' . _x("Exhibitor", "ms-eventman") ?>
                    </a>
                </div>
            <?php } ?>
        </div>
        <?php if (($qode_sidebar == "default") || ($qode_sidebar == "")) : ?>
            <div class="blog_holder blog_single">
                <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="post_left">
                        <div class="post_content_holder">
                            <?php if (get_post_meta(get_the_ID(), "qode_hide-featured-image", true) != "yes") {
                                if (has_post_thumbnail()) { ?>
                                    <div class="post_image">
                                        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                            <img class="post_image_small" src="<?= get_the_post_thumbnail_url() ?>"
                                                 alt="<?= get_the_post_thumbnail_caption() ?>"/>
                                        </a>
                                    </div>
                                <?php }
                            } ?>
                            <div class="post_text">
                                <h2 class="post_title_label"><?php the_title(); ?></h2>
                                <?php
                                $meta = get_post_meta(get_post()->ID, 'custom_post_fields', true);
                                 if (isset($meta['exhibitor_type'])) {?>
                                <small class="exhibitor-type">
                                    <?php
                                    echo isset($meta['exhibitor_type']) ? $meta['exhibitor_type'] : ''; ?>
                                </small>
                                <?php } ?>
                                <table class="exhibitor-details-table">
                                    <?php foreach ($meta as $name => $value) {
                                        if ($value !== '' && strpos($name, 'social_') !== 0 && !in_array($name, ['exhibitor_type', 'description', 'bound_user'])) {
                                            $parts = array_map(function ($p) {
                                                return ucfirst($p);
                                            }, explode("_", $name));

                                            $formattedName = implode(" ", $parts);
                                            ?>
                                            <tr>
                                                <th scope="row"><?php _e($formattedName, 'ms-eventman') ?></th>
                                                <td><?php
                                                    if (strtolower($name) == "website") {
                                                        $value = strpos($value, 'http') === 0 ? substr($value, strpos($value, ':' ) + 3) : $value;
                                                        echo '<a target="_blank" href="//' . $value . '">' . $value . "</a>";
                                                    } elseif (strtolower($name) == "email") {
                                                        echo '<a href="mailto:' . $value . '">' . $value . "</a>";
                                                    } elseif (strtolower($name) == "phone_number") {
                                                        echo '<a href="tel:' . $value . '">' . $value . "</a>";
                                                    } else {
                                                        echo $value;
                                                    }
                                                    ?></td>
                                            </tr>
                                        <?php }
                                    } ?>
                                </table>
                                <div class="exhibitor-description">
                                    <?= isset($meta['description']) ? nl2br($meta['description']) : ''; ?>
                                </div>
                                <ul class="social-icons">
                                    <?php foreach ($meta as $name => $value) {
                                        if ($value && substr($name, 0, 7) == 'social_') {
                                            $socialLink = getSocialLink(strtolower(substr($name, 7)), $value);
                                            $parts = array_map(function ($p) {
                                                return ucfirst($p);
                                            }, explode("_", str_replace('social_', '', $name)));
                                            $name = implode(" ", $parts);
                                            ?>
                                            <li>
                                                <a target="_blank" href="<?= $socialLink ?>" title="<?=$name?>">
                                                    <i class="<?=getSocialIcon($name)?>"></i>
                                                </a>
                                            </li>
                                        <?php }
                                    } ?>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <?php $postMeta = get_post_meta($post->ID, 'gallery_data', true);
                    if (!is_array($postMeta) || sizeof($postMeta) !== 0) { ?>
                        <div class="post_right">
                            <div class="exhibitor-preview-glide">
                                <!-- Images -->
                                <div class="img_slides">
                                    <?php
                                    $galleryData = get_post_meta(get_the_ID(), 'gallery_data', true);
                                    if (!empty($galleryData) && isset($galleryData['image_id'])) {
                                        foreach ($galleryData['image_id'] as $id) {
                                            $fullImageUrl = \Eventman\interevent_get_attachment_url($id, 'full');
                                            ?>
                                            <div class="img_slide">
                                                <a class="fl-gallery-item" href="<?= $fullImageUrl ?>"><img class=""
                                                                                                            src="<?= $fullImageUrl ?>"
                                                                                                            alt="<?= get_post_meta($id, '_wp_attachment_image_alt', TRUE) ?>"></a>
                                            </div>
                                    <?php } ?>
                                    <?php } else { ?>
                                        <div class="img_slide">
                                            <?= _x("No Images", 'ms-eventman') ?>
                                        </div>
                                    <?php } ?>
                                </div>
                                <?php echo do_shortcode('[social_share]'); ?>
                                <!-- descriptions -->
                                <div class="desc_slides">
                                    <?php
                                    $galleryData = get_post_meta(get_the_ID(), 'gallery_data', true);
                                    if (!empty($galleryData) && isset($galleryData['image_url'])) {
                                        foreach ($galleryData['image_id'] as $id) {
                                            ?>
                                            <div class="caption">
                                                <?= wp_get_attachment_caption($id) ?>
                                            </div>
                                            <?php
                                        }
                                    } ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
            <?php
            if (elision_qode_is_comments_enabled()) {
                comments_template('', true);
            } else {
                echo "<br/><br/>";
            }
            ?>

        <?php elseif ($qode_sidebar == "1" || $qode_sidebar == "2"): ?>
            <?php if ($qode_sidebar == "1") : ?>
                <div class="two_columns_66_33 background_color_sidebar grid2 clearfix">
                <div class="column1">
            <?php elseif ($qode_sidebar == "2") : ?>
                <div class="two_columns_75_25 background_color_sidebar grid2 clearfix">
                <div class="column1">
            <?php endif; ?>

            <div class="column_inner">
                <div class="blog_holder blog_single">
                    <?php
                    get_template_part('blog_single', 'loop');
                    ?>
                </div>

                <?php
                if (elision_qode_is_comments_enabled()) {
                    comments_template('', true);
                } else {
                    echo "<br/><br/>";
                }
                ?>
            </div>
            </div>
            <div class="column2">
                <?php get_sidebar(); ?>
            </div>
            </div>
        <?php elseif ($qode_sidebar == "3" || $qode_sidebar == "4"): ?>
            <?php if ($qode_sidebar == "3") : ?>
                <div class="two_columns_33_66 background_color_sidebar grid2 clearfix">
                <div class="column1">
                    <?php get_sidebar(); ?>
                </div>
                <div class="column2">
            <?php elseif ($qode_sidebar == "4") : ?>
                <div class="two_columns_25_75 background_color_sidebar grid2 clearfix">
                <div class="column1">
                    <?php get_sidebar(); ?>
                </div>
                <div class="column2">
            <?php endif; ?>

            <div class="column_inner">
                <div class="blog_holder blog_single">
                    <?php
                    get_template_part('blog_single', 'loop');
                    ?>
                </div>
                <?php
                if (elision_qode_is_comments_enabled()) {
                    comments_template('', true);
                } else {
                    echo "<br/><br/>";
                }
                ?>
            </div>
            </div>

            </div>
        <?php endif; ?>
        </div>
        </div>
        </div>
    <?php endwhile; ?>
<?php endif; ?>


<?php get_footer(); ?>

<?php function getSocialLink($name, $value)
{
    $out = '';
    switch ($name) {
        case 'instagram':
        case 'pinterest':
        case 'facebook':
        case 'twitter':
            $out = 'https://' . $name . '.com/' . $value;
            break;
        case 'linkedin':
            $out = 'https://linkedin.com/in/' . $value;
            break;
        default:
            break;
    }
    return $out;
}

function getSocialIcon($name) {
    $out = '';
    switch (strtolower($name)) {
        case 'instagram':
            $out = 'fab fa-instagram';
            break;
        case 'pinterest':
            $out = 'fab fa-pinterest';
            break;
        case 'facebook':
            $out = 'fab fa-facebook-f';
        break;
        case 'twitter':
            $out = 'fab fa-twitter';
            break;
        case 'linkedin':
            $out = 'fab fa-linkedin';
            break;
        default:
            $out = 'fa fa-share';
            break;
    }
    return $out;
}
