<?php
function latest_post($atts, $content = null) {
    $args = array(
        "post_number_per_row"   => "",
        "rows"                  => "",
        "order_by"              => "",
        "order"                 => "",
        "category"              => "",
        "text_length"           => "",
        "title_tag"             => "h4",
        "enable_video"          => ""
    );

    extract(shortcode_atts($args, $atts));

    $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

    //get correct heading value. If provided heading isn't valid get the default one
    $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

    $query_loop = new WP_Query(
        array('post_status' => 'publish', 'orderby' => $order_by, 'order' => $order, 'posts_per_page' => $post_number_per_row * $rows, 'category_name' => $category)
    );

    $html = "";
    $html .= "<div class='latest_post_holder'>";
    $html .= "<ul>";
    $postCount = 0;

    while ($query_loop->have_posts()) : $query_loop->the_post();

        $postCount++;

        $li_classes = "";

        $cat = get_the_category();

        if ($post_number_per_row == 2) {
            $li_classes .= 'two ';
        } else if ($post_number_per_row == 3) {
            $li_classes .= 'three';
        } else if ($post_number_per_row == 4) {
            $li_classes .= 'four';
        }

        $html .= '<li class="' . $li_classes . '">';
        $html .= '<div class="latest_post">';

        $_video_type = get_post_meta(get_the_ID(), "video_format_choose", true);
        $_video_link = get_post_meta(get_the_ID(), "video_format_link", true);

        if($_video_type == "youtube" && $_video_link != "" && $enable_video == "yes") {
            $html .= '<iframe src="https://www.youtube.com/embed/' . $_video_link . '?wmode=transparent" wmode="Opaque" frameborder="0" allowfullscreen></iframe>';
        } elseif ($_video_type == "vimeo" && $_video_link != "" && $enable_video == "yes"){
            $html .= '<iframe src="https://player.vimeo.com/video/' . $_video_link . '?title=0&amp;byline=0&amp;portrait=0" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>';
        } else {
            $html .= '<a href="' . get_permalink() . '" class="latest_post_wrapper">' . get_the_post_thumbnail(get_the_id(), 'full') . '</a>'; //get post thumbnail
        }

        $html .= '<div class="latest_post_text">';
        $html .= '<div class="latest_post_inner">';

//        $html .= '<span class="post_infos">';
//        $html .= '<span class="date_holder"><span class="date">' . get_post_time('d', true, get_the_ID(), true) . ' </span><span class="month">' . get_post_time('F', true, get_the_ID(), true) . '</span></span>';
//        $html .= '<span class="latest-vert-separator">  |  </span>';
//        $html .= '<a class="post_author" href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' . get_the_author_meta('display_name') . ' </a>';
//        $html .= '<span class="latest-vert-separator">  |  </span>';
//        foreach ($cat as $categ) {
//            $html .=' <a href="' . get_category_link($categ->term_id) . '">' . $categ->cat_name . ' </a> ';
//        }
//        $html .= '<span class="latest-vert-separator">  |  </span>';
//
//        //generate comments part of description
//        if (elision_qode_is_comments_enabled()) {
//            $comments_count = get_comments_number();
//
//            switch ($comments_count) {
//                case 0:
//                    $comments_count_text = esc_html__('No comment', 'elision-core');
//                    break;
//                case 1:
//                    $comments_count_text = $comments_count . ' ' . esc_html__('Comment','ms-eventman');
//                    break;
//                default:
//                    $comments_count_text = $comments_count . ' ' . esc_html__('Comments','ms-eventman');
//                    break;
//            }
//            $html .= '<a class="post_comments" href="' . get_comments_link() . '">' . $comments_count_text . '</a>';
//        }
//
//        $html .= '</span>'; //close post_infos span

        $html .= '<'.$title_tag.' class="latest_post_title"><a href="' . get_permalink() . '">' . get_the_title() . '</a></'.$title_tag.'>';
        $html .= '</div>'; //close latest_post_inner div

        if ($text_length > 0) {
            $html .= '<p>' . substr(get_the_excerpt(), 0, intval($text_length)) . '...</p>';
        }

        $html .= '</div>'; //close latest_post_text div
        $html .= '</div>'; //close latest_post div
        $html .= '</li>';

        if ($post_number_per_row == 2) {
            if($postCount == 2 || $postCount == 4 || $postCount == 6){
                $html .= '<span class="latest_post_clear"></span>';
            }
        } else if ($post_number_per_row == 3) {
            if($postCount == 3 || $postCount == 6 || $postCount == 9){
                $html .= '<span class="latest_post_clear"></span>';
            }
        } else if ($post_number_per_row == 4) {
            if($postCount == 4 || $postCount == 8 || $postCount == 12){
                $html .= '<span class="latest_post_clear"></span>';
            }
        }
    endwhile;
    wp_reset_postdata();

    $html .= "</ul></div>";
    return $html;
}

function button($atts, $content = null) {
    $args = array(
        "size"              => "",
        "text"              => "",
        "icon"              => "",
        "icon_size"         => "",
        "icon_color"        => "",
        "post"              => "",
        "link"              => "",
        "target"            => "",
        "color"             => "",
        "background_color"  => "",
        "border_color"      => "",
        "font_style"        => "",
        "font_weight"       => "",
        "text_align"        => "",
        'no_gutters'        => "",
        'padding'           => "",
    );

    extract(shortcode_atts($args, $atts));
    if($target == ""){
        $target = "_self";
    }

    //init variables
    $html  = "";
    $button_classes = "qbutton ";
    $button_styles  = "";
    $add_icon       = "";

    if($size != "") {
        $button_classes .= " {$size}";
    }

    if($text_align != "") {
        $button_classes .= " {$text_align}";
    }

    if($no_gutters != "") {
        $button_classes .= " {$no_gutters}";
    } elseif ($padding != "") {
        $button_styles .= 'padding: 0 '.$padding.'; ';
    }

    if($color != ""){
        $button_styles .= 'color: '.$color.'; ';
    }

    if($background_color != ""){
        $button_styles .= 'background-color: '.$background_color.'; ';
    }

    if($border_color != ""){
        $button_styles .= 'border: 1px solid '.$border_color.'; ';
    }

    if($font_style != ""){
        $button_styles .= 'font-style: '.$font_style.'; ';
    }

    if($font_weight != ""){
        $button_styles .= 'font-weight: '.$font_weight.'; ';
    }

    if($icon != ""){
        $icon_style = "";
        if($icon_color != ""){
            $icon_style .= 'color: '.$icon_color.';';
        }
        $add_icon .= '<i class="fa '.$icon.' '.$icon_size.'" style="'.$icon_style.'"></i>';
    }

    if (empty($link) && !empty($post)) {
        global $sitepress;
        if ($sitepress) {
            $langinfo = function_exists('wpml_get_language_information') ? wpml_get_language_information(null, $post) : [];
            if (!is_wp_error($langinfo)) {
            $code = $langinfo['language_code'] !== $sitepress->get_default_language() ? $langinfo['language_code'] : '';
            $url = get_permalink($post) /*. ($code ? '?lang=' . $code : '')*/;

            }
        } else {
            $url = get_permalink($post);
        }
    } elseif (!empty($link)) {
        $url = $link;
    }

    $html .=  '<a href="'.$url.'" target="'.$target.'" class="'.$button_classes.'" style="'.$button_styles.'">'.$text.$add_icon.'</a>';

    return $html;
}

function gmaps($atts, $content = null) {
//    wp_die(print_r($atts));
    $args = array(
        "coord_x"           => "",
        "coord_y"           => "",
        "zoom"              => "",
        "show_pois"         => "",
        "api_key"           => "",
        "map_height"           => "",
    );

    extract(shortcode_atts($args, $atts));

    if (empty($coord_x) || empty($coord_y)) {
        return 'One or both coordinates is empty.';
    }

    $qodeOpts = elision_qode_return_global_options();
    if (empty($api_key)) {
        if (empty($qodeOpts['google_maps_api_key'])) {
            return 'The Google Maps API Key cannot be empty, please enter the key in the WPBakery element or the Qode Options.';
        } else {
            $api_key = $qodeOpts['google_maps_api_key'];
        }
    }

    if (empty($map_height)) {
        $map_height = '100';
    }

    if (empty($zoom)) {
        $zoom = 8;
    }

    $style = '[]';
    if (empty($show_pois)) {
        $style = '[
        {
            featureType: "poi",
            elementType: "labels",
            stylers: [
                  { visibility: "off" }
            ]
        }
    ]';
    }

    $id = uniqid();
    $fnName = 'initMap'.$id;
    return "<div id=\"$id\" style=\"height: {$map_height}px\"></div>
<script>
var map;
function $fnName() {
    let center = {lat: {$coord_x}, lng: {$coord_y}};
    map = new google.maps.Map(document.getElementById('$id'), {
      center: center,
      zoom: {$zoom},
      styles: {$style}
    });
    var marker = new google.maps.Marker({position: center, map: map});
}

</script>
    <script src=\"https://maps.googleapis.com/maps/api/js?key=$api_key&callback=$fnName&region=NL\"
    async defer></script>
";
}
