export default {
  init() {
    // JavaScript to be fired on all pages
    // Navigation bar scrolled state.
      $(window).scroll(function () {
          if ($(document).scrollTop() > 75) {
              $("header.banner nav.navbar").addClass("scrolled").removeClass("before-scroll");
          } else {
              $("header.banner nav.navbar").removeClass("scrolled").addClass("before-scroll");
          }
      });

      // Mobile side menu.
      $("#side-menu-list").mCustomScrollbar({theme: "minimal"});

      // When opening the side-menu.
      $('#sideMenuCollapse').on('click', function () {
          // open sidebar
          $('#side-menu').addClass('active');
          // fade in the overlay
          $('#overlay').fadeIn();
          $('.collapse.in').toggleClass('in');
          $('a[aria-expanded=true]').attr('aria-expanded', 'false');
      });


      // If menu-item or overlay was clicked.
      $('#overlay, ul.navbar-nav.side-menu li.nav-item a.nav-link').on('click', function () {
          // hide the sidebar
          $('#side-menu').removeClass('active');
          // fade out the overlay
          $('#overlay').fadeOut();
      });


      // Smooth scroll to ID
      $('a[href*="#"]').on('click', function (e) {
          e.preventDefault();

          $('html, body').animate({
              scrollTop: $($(this).attr('href')).offset().top,
          }, 500, 'linear');
      });
  },
  finalize() {
    // JavaScript to be fired on all pages, after page specific JS is fired
  },
};
