<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery',
	'woocommerce-product-gallery--' . ( has_post_thumbnail() ? 'with-images' : 'without-images' ),
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
) );

// Custom variables
$id                     = get_the_ID();
$product_prefix   = "product-{$id}";
$attributes             = $product->get_attributes();
?>

<div class="row align-center product__image">
    <div class="product__image-column product__image-column--thumbnail column small-12 large-11">
        <div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>"
             style="opacity: 0; transition: opacity .25s ease-in-out;">
            <figure class="woocommerce-product-gallery__wrapper">
                <?php
                if ( has_post_thumbnail() ) {
                    $html  = wc_get_gallery_image_html( $post_thumbnail_id, true );
                } else {
                    $html  = '<div class="woocommerce-product-gallery__image--placeholder">';
                    $html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
                    $html .= '</div>';
                }

                echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id );

                do_action( 'woocommerce_product_thumbnails' );
                ?>
                <?php foreach ($attributes as $key => $attribute) :
                    $name = "attribute-{$key}-{$id}";
                    ?>
                    <figcaption class="product__image-caption">
                        <?php foreach ($attribute->get_options() as $i => $option) :
                            $option_id = "attribute-{$option}-{$id}";
                            ?>
                            <span class="<?php echo $i === 0 ? 'is-active' : ''; ?>"  data-option-id="<?php echo esc_attr($option_id); ?>">
                                <?php echo esc_html($option); ?>
                            </span>
                        <?php endforeach; ?>
                    </figcaption>
                <?php endforeach; ?>
            </figure>
        </div>
    </div>
</div>
