<?php
/**
 * Variable product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/variable.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

$attribute_keys = array_keys( $attributes );

$custom_template    = true;
$id                 = get_the_ID();
$attributes         = $product->get_attributes();
$children           = $product->get_children();

do_action( 'woocommerce_before_add_to_cart_form' ); ?>

<?php if (!empty($attributes)) : ?>
    <div class="vo-add-to-cart vo-add-to-cart--white">
        <div class="products__price">
            <span class="products__price-amount"><?php echo vo_get_variation_price($children[0]); ?></span>
        </div>
        <div class="products__actions">
            <div class="products__attributes">
                <?php foreach ($attributes as $key => $attribute) :
                    $name = "attribute-{$key}-{$id}";
                    ?>

                    <label class="products__label">
                        <?php echo esc_html($attribute->get_name()); ?>
                    </label>

                    <?php foreach ($attribute->get_options() as $i => $option) :
                        $option_id = "attribute-{$option}-{$id}";
                        ?>

                        <input
                                type="radio"
                                data-variation-id="<?php echo esc_attr($children[$i]); ?>"
                                data-variation-price="<?php echo vo_html_price_to_float(vo_get_variation_price($children[$i])); ?>"
                                data-attribute-name="<?php echo esc_attr($key); ?>"
                                value="<?php echo esc_attr($option); ?>"
                                name="<?php echo esc_attr($name); ?>"
                                id="<?php echo esc_attr($option_id); ?>"
                            <?php echo $i === 0 ? 'checked="checked"' : ''; ?>
                        >

                        <label class="products__attribute-label" for="<?php echo esc_attr($option_id); ?>" data-option-id="<?php echo esc_attr($option_id); ?>">
                            <?php echo esc_html($option); ?>
                        </label>

                    <?php endforeach; ?>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="products__button-qty">
            <div class="row collapse">
                <div class="column shrink">
                    <div class="quantity">
                        <label class="products__label"><?php _e('Quantity', THEME_SLUG); ?></label>
                        <div class="quantity__input-container">
                            <button class="quantity__change quantity__change--minus">–</button>
                            <button class="quantity__change quantity__change--plus">+</button>
                            <input type="number" readonly class="quantity__input input-text qty text" step="1" min="1" name="quantity" value="1" title="Qty" size="4" pattern="[0-9]*" inputmode="numeric" aria-labelledby="" max="">
                        </div>
                    </div>
                </div>
                <div class="column">
                    <button class="vo-add-to-cart__button products__button button button--black" data-product-id="<?php echo esc_attr($id); ?>">
                        <span class="products__button-text"><?php esc_html_e('Add to cart', THEME_SLUG); ?></span>
                    </button>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php
if ($custom_template) {
    return;
}
?>
<form class="variations_form cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo htmlspecialchars( wp_json_encode( $available_variations ) ) ?>">
	<?php do_action( 'woocommerce_before_variations_form' ); ?>

	<?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>
		<p class="stock out-of-stock"><?php _e( 'This product is currently out of stock and unavailable.', 'woocommerce' ); ?></p>
	<?php else : ?>
		<table class="variations" cellspacing="0">
			<tbody>
				<?php foreach ( $attributes as $attribute_name => $options ) : ?>
					<tr>
						<td class="label"><label for="<?php echo sanitize_title( $attribute_name ); ?>"><?php echo wc_attribute_label( $attribute_name ); ?></label></td>
						<td class="value">
							<?php
								$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( stripslashes( urldecode( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ) ) : $product->get_variation_default_attribute( $attribute_name );
								wc_dropdown_variation_attribute_options( array( 'options' => $options, 'attribute' => $attribute_name, 'product' => $product, 'selected' => $selected ) );
								echo end( $attribute_keys ) === $attribute_name ? apply_filters( 'woocommerce_reset_variations_link', '<a class="reset_variations" href="#">' . esc_html__( 'Clear', 'woocommerce' ) . '</a>' ) : '';
							?>
						</td>
					</tr>
				<?php endforeach;?>
			</tbody>
		</table>

		<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

		<div class="single_variation_wrap">
			<?php
				/**
				 * woocommerce_before_single_variation Hook.
				 */
				do_action( 'woocommerce_before_single_variation' );

				/**
				 * woocommerce_single_variation hook. Used to output the cart button and placeholder for variation data.
				 * @since 2.4.0
				 * @hooked woocommerce_single_variation - 10 Empty div for variation data.
				 * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
				 */
				do_action( 'woocommerce_single_variation' );

				/**
				 * woocommerce_after_single_variation Hook.
				 */
				do_action( 'woocommerce_after_single_variation' );
			?>
		</div>

		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>
	<?php endif; ?>

	<?php do_action( 'woocommerce_after_variations_form' ); ?>
</form>

<?php
do_action( 'woocommerce_after_add_to_cart_form' );
