<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}

$bg_color = get_post_meta(get_the_ID(), 'vo_product_bg_color', true);
$bg_image_id = get_post_meta(get_the_ID(), 'vo_product_bg_image', true);
$bg_image = !empty($bg_image_id) ? wp_get_attachment_image_src($bg_image_id, 'large')[0] : '';
$tabs = (int) get_post_meta(get_the_ID(), 'vo_product_tabs', true);

$class = !empty($bg_color) ? 'product-block--' . $bg_color : '';
?>

<div class="product-block <?php echo esc_attr($class); ?>" style="background-image: url(<?php echo $bg_image; ?>)">
    <div class="product-block__inner">
        <div class="row">
            <div class="small-12 columns">
                <?php do_action('woocommerce_before_single_product'); ?>
            </div>
        </div>

        <div id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
            <div class="row align-center">
                <div class="product__images small-12 medium-6 large-7 columns" data-animated>
                    <?php do_action('woocommerce_before_single_product_summary'); ?>
                </div>
                <div class="product__information small-12 medium-6 large-5 columns" data-animated>
                    <?php do_action('woocommerce_single_product_summary'); ?>
                </div>
            </div>
        </div>

        <?php if (!empty($tabs)) : ?>
            <div class="row">
                <div class="small-12 columns">
                    <div class="product-block__tabs">
                        <ul class="product-block__tab-links">
                            <?php for ($i = 0; $i < $tabs; $i++) :
                                $tab_name = get_post_meta(get_the_ID(), 'vo_product_tabs_' . $i . '_name', true);
                                ?>

                                <?php if (!empty($tab_name)) : ?>
                                    <li>
                                        <a class="product-block__tab-link" href="#<?php echo "tab-{$i}"; ?>" id="<?php echo "tab-title-{$i}"; ?>" aria-selected="<?php echo $i === 0 ? 'true' : 'false'; ?>">
                                            <?php echo esc_html($tab_name); ?>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </ul>

                        <?php for ($i = 0; $i < $tabs; $i++) :
                            $tab_title = get_post_meta(get_the_ID(), 'vo_product_tabs_' . $i . '_title', true);
                            $tab_content = get_post_meta(get_the_ID(), 'vo_product_tabs_' . $i . '_content', true);
                            ?>

                            <div class="product-block__tab-content" id="<?php echo "tab-{$i}"; ?>" aria-hidden="<?php echo $i === 0 ? 'false' : 'true'; ?>" aria-labelledby="<?php echo "tab-title-{$i}"; ?>">

                                <?php if (!empty($tab_title)) : ?>
                                    <h3 class="product-block__tab-title"><?php echo esc_html($tab_title); ?></h3>
                                <?php endif; ?>

                                <?php if (!empty($tab_content)) : ?>
                                    <?php echo apply_filters('the_content', wp_kses_post($tab_content)); ?>
                                <?php endif; ?>
                            </div>
                        <?php endfor; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php do_action('woocommerce_after_single_product'); ?>
