<?php
$title          = get_option('options_settings_age_verify_title');
$subtitle       = get_option('options_settings_age_verify_subtitle');
$age_limit      = (int) get_option('options_settings_age_verify_age_limit');
$age_limit_text = get_option('options_settings_age_verify_age_limit_text');
$checkbox_text  = get_option('options_settings_age_verify_checkbox_text');
$button_text    = get_option('options_settings_age_verify_button_text');
$agreement_text = get_option('options_settings_age_verify_agreement_text');
$show_age_limit = true; // change this to cookie value

if ( !empty($_POST) ) {
    $month      = (isset($_POST['month'])) ? $_POST['month']: '';
    $month_int  = (!empty($month)) ? (int) $month : 0;
    $year       = (isset($_POST['year'])) ? $_POST['year']: '';
    $year_int   = (!empty($year)) ? (int) $year : 0;
    $remember   = (isset($_POST['remember'])) ? (bool) $_POST['remember']: false;

    $max_month      = 12;
    $current_year   = date('Y');
    $current_month  = (int) date('m');

    if ( (!empty($month_int) && !empty($year_int) && !empty($age_limit)) ) {
        $age = ($current_year - $year_int);

        if ($age > $age_limit) {
            $show_age_limit = false;
        } elseif ($age === $age_limit && $current_month >= $month_int && $month_int <= $max_month) {
            $show_age_limit = false;
        } else {
            $show_age_limit = true;
        }

        // set cookie for age
    }
}
?>

<?php if ($show_age_limit) : ?>
<section>
    <div class="row">
        <div class="column">
            <form id="age-verify" action="<?php echo get_permalink(get_the_ID()); ?>" method="post" data-age-limit="<?php echo esc_attr($age_limit); ?>">
                <div>
                    <h2><?php echo esc_html($title); ?></h2>
                    <h3><?php echo esc_html($subtitle); ?></h3>
                </div>
                <label for="month">
                    <input type="number" name="month" id="month" placeholder="MM">
                </label>
                <label for="year">
                    <input type="number" name="year" id="year" placeholder="YYYY">
                </label>
                <div>
                    <?php echo esc_html($age_limit_text); ?>
                </div>
                <label for="remember">
                    <input type="checkbox" name="remember" id="remember" value="true">
                    <span><?php echo esc_html($checkbox_text); ?></span>
                </label>
                <input type="submit" name="" id="" class="button" value="<?php echo esc_attr($button_text); ?>">
                <div class="">
                    <?php echo apply_filters('the_content', wp_kses_post($agreement_text)); ?>
                </div>
            </form>
        </div>
    </div>
</section>
<?php endif; ?>
