<?php
// Don't show header for products or when it's disabled.
$show_hero = !empty(get_post_meta(get_the_ID(), 'vo_hero_show', true));
if (get_post_type(get_the_ID()) === 'product' || !$show_hero) return;

$title    = !empty(get_post_meta(get_the_ID(), 'vo_hero_title', true)) ? get_post_meta(get_the_ID(), 'vo_hero_title', true) : get_the_title();
$subtitle = get_post_meta(get_the_ID(), 'vo_hero_subtitle', true);
$content  = get_post_meta(get_the_ID(), 'vo_hero_content', true);

// Background image
$bg_thumb = get_post_meta(get_the_ID(), 'vo_hero_thumb_base64', true);
$bg_image = wp_get_attachment_image_url((int) get_post_meta(get_the_ID(), 'vo_hero_bg_image', true), 'vo-fullwidth');
$style = $bg_image ? "background-image: url(${bg_image})" : '';

// Class
$class = is_front_page() ? 'hero--home' : '';

// Button
$button      = get_post_meta(get_the_ID(), 'vo_hero_add_button', true);
$button_text = get_post_meta(get_the_ID(), 'vo_hero_button_text', true);
$button_link = (int) get_post_meta(get_the_ID(), 'vo_hero_button_link', true);

// Link
$link      = get_post_meta(get_the_ID(), 'vo_hero_add_link', true);
$link_text = get_post_meta(get_the_ID(), 'vo_hero_link_text', true);
$link_link = (int) get_post_meta(get_the_ID(), 'vo_hero_link', true);

// Layout
$title_size = get_post_meta(get_the_ID(), 'vo_hero_title_size', true);
$align_content_v = get_post_meta(get_the_ID(), 'vo_hero_align_content_vertical', true);
$align_content_h = get_post_meta(get_the_ID(), 'vo_hero_align_content_horizontal', true);
$class_title_size = !empty($title_size) ? 'hero--title-' . $title_size : '';
$class_align_v = !empty($align_content_v) ? 'hero--vertical-' . $align_content_v : 'hero--vertical-center';
$class_align_h = !empty($align_content_h) ? 'hero--horizontal-' . $align_content_h : 'hero--horizontal-center';
$class .= ' ' . $class_title_size;
$class .= ' ' . $class_align_v;
$class .= ' ' . $class_align_h;

// Allow tags
$tags = array(
    'br' => array(),
    'b' => array(),
);

// Focal Point
$focal_point_class = vo_get_focal_point_section_prefix_class_name('hero');
$class .= ' ' . $focal_point_class;

$class_column = $class_align_h === 'center' ? 'small-12 medium-10 large-8' : 'small-12';

echo vo_get_focal_point_style('hero');
?>

<div class="hero <?php echo esc_attr($class); ?>" style="<?php echo esc_attr($style); ?>">
    <div class="block__arrow"></div>
    <?php if (!empty($bg_thumb) && !empty($bg_image)) : ?>
        <div
            class="hero__thumb"
            aria-hidden="true"
            style="background-image: url('<?php echo esc_attr($bg_thumb); ?>');"
            data-vo-full-image="<?php echo esc_url($bg_image); ?>"
        ></div>
    <?php endif; ?>

    <div class="hero__inner row <?php if (empty($align_content_h) || $align_content_h === 'center') : ?>align-center<?php endif; ?>">
        <div class="<?php echo esc_attr($class_column); ?> columns">
            <?php if (!empty($title)) : ?>
                <h2 class="hero__title" data-animated><?php echo vo_kses($title, $tags); ?></h2>
            <?php endif; ?>

            <?php if (!empty($subtitle)) : ?>
                <h3 class="hero__subtitle" data-animated><?php echo vo_kses($subtitle, $tags); ?></h3>
            <?php endif; ?>

            <?php if (!empty($button) || !empty($link)) : ?>
                <div class="hero__actions" data-animated>
                    <?php if (!empty($link) && !empty($link_text) && !empty($link_link)) : ?>
                        <div class="hero__link-container">
                            <a class="hero__link" href="<?php echo get_permalink($link_link); ?>"><?php echo esc_html($link_text); ?></a>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($button) && !empty($button_text) && !empty($button_link)) : ?>
                        <div class="hero__button">
                            <a class="button button--white" href="<?php echo get_permalink($button_link); ?>"><?php echo esc_html($button_text); ?></a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
