<div class="vo-cart">
    <div class="vo-cart__inner">
        <?php wc_print_notices(); ?>

        <?php do_action( 'woocommerce_before_cart' ); ?>

        <form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
            <?php do_action( 'woocommerce_before_cart_table' ); ?>

            <?php do_action( 'woocommerce_before_cart_contents' ); ?>

            <?php
            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) :
                $_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                $product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) :
                    $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
                    ?>

                    <div class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'vo-cart__item', $cart_item, $cart_item_key ) ); ?>">

                        <div class="vo-cart__header">
                            <h2 class="vo-cart__title">
                                <?php
                                if ( ! $product_permalink ) {
                                    echo apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key ) . '&nbsp;';
                                } else {
                                    echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_title() ), $cart_item, $cart_item_key );
                                }
                                ?>
                            </h2>
                            <div class="vo-cart__remove">
                                <?php
                                echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
                                    '<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">%s</a>',
                                    esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                                    __( 'Remove', 'woocommerce' ),
                                    esc_attr( $product_id ),
                                    esc_attr( $_product->get_sku() ),
                                    __( 'Remove', 'woocommerce' )
                                ), $cart_item_key );
                                ?>
                            </div>
                        </div>

                        <div class="vo-cart__content">

                            <div class="vo-cart__thumbnail">
                                <?php
                                $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

                                echo ( ! $product_permalink ) ? $thumbnail : sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail );
                                ?>
                            </div>

                            <div class="vo-cart__quantity">
                                <?php
                                if ( $_product->is_sold_individually() ) {
                                    $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                                } else {
                                    $product_quantity = woocommerce_quantity_input( array(
                                        'input_name'   => "cart[{$cart_item_key}][qty]",
                                        'input_value'  => $cart_item['quantity'],
                                        'max_value'    => $_product->get_max_purchase_quantity(),
                                        'min_value'    => '0',
                                        'product_name' => $_product->get_name(),
                                    ), $_product, false );
                                }

                                echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item );
                                ?>
                            </div>

                            <div class="vo-cart__attributes">
                                <?php
                                $attributes = $_product->is_type( 'simple' ) ? null : $_product->get_attributes();

                                // Get value of first attribute
                                // NOTE: this won't work well with multiple attributes
                                echo ! empty( $attributes ) ? array_values( $attributes )[0] : '';
                                ?>
                            </div>

                            <div class="vo-cart__price">
                              <?php

                              //echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                              echo wc_price(vo_html_price_to_float( vo_get_variation_price( $_product->get_id() ?? null ) ));
                              ?>
                            </div>

                        </div>
                    </div>

                <?php
                endif;
            endforeach;
            ?>

            <?php do_action( 'woocommerce_cart_contents' ); ?>

            <?php if ( wc_coupons_enabled() ) { ?>
                <div class="coupon vo-cart__coupon">
                    <input type="text" name="coupon_code" class="vo-cart__coupon-input" id="coupon_code" value=""
                           placeholder="<?php esc_attr_e( 'Apply a promotional code', THEME_SLUG ); ?>"/>
                    <button type="submit" class="vo-cart__coupon-button" name="apply_coupon"
                            value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"></button>
                    <?php do_action( 'woocommerce_cart_coupon' ); ?>
                </div>
            <?php } ?>


            <div class="vo-cart__totals">

                <div class="cart_totals <?php echo ( WC()->customer->has_calculated_shipping() ) ? 'calculated_shipping' : ''; ?>">

                    <?php do_action( 'woocommerce_before_cart_totals' ); ?>

                    <table class="shop_table shop_table_responsive">
                        <tr class="cart-subtotal">
                            <th><?php _e( 'Subtotal', 'woocommerce' ); ?></th>
                            <td data-title="<?php esc_attr_e( 'Subtotal', 'woocommerce' ); ?>"><?php wc_cart_totals_subtotal_html(); ?></td>
                        </tr>

                        <?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
                            <tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
                                <th><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
                                <td data-title="<?php echo esc_attr( wc_cart_totals_coupon_label( $coupon, false ) ); ?>"><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
                            </tr>
                        <?php endforeach; ?>

                        <?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>

                            <?php do_action( 'woocommerce_cart_totals_before_shipping' ); ?>

                            <?php wc_cart_totals_shipping_html(); ?>

                            <?php do_action( 'woocommerce_cart_totals_after_shipping' ); ?>

                        <?php elseif ( WC()->cart->needs_shipping() && 'yes' === get_option( 'woocommerce_enable_shipping_calc' ) ) : ?>

                            <tr class="shipping">
                                <th><?php _e( 'Shipping', 'woocommerce' ); ?></th>
                                <td data-title="<?php esc_attr_e( 'Shipping', 'woocommerce' ); ?>"><?php woocommerce_shipping_calculator(); ?></td>
                            </tr>

                        <?php endif; ?>

                        <?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
                            <tr class="fee">
                                <th><?php echo esc_html( $fee->name ); ?></th>
                                <td data-title="<?php echo esc_attr( $fee->name ); ?>"><?php wc_cart_totals_fee_html( $fee ); ?></td>
                            </tr>
                        <?php endforeach; ?>

                        <?php if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) :
                            $taxable_address = WC()->customer->get_taxable_address();
                            $estimated_text = WC()->customer->is_customer_outside_base() && ! WC()->customer->has_calculated_shipping()
                                ? sprintf( ' <small>' . __( '(estimated for %s)', 'woocommerce' ) . '</small>', WC()->countries->estimated_for_prefix( $taxable_address[0] ) . WC()->countries->countries[ $taxable_address[0] ] )
                                : '';

                            if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
                                <?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : ?>
                                    <tr class="tax-rate tax-rate-<?php echo sanitize_title( $code ); ?>">
                                        <th><?php echo esc_html( $tax->label ) . $estimated_text; ?></th>
                                        <td data-title="<?php echo esc_attr( $tax->label ); ?>"><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <tr class="tax-total">
                                    <th><?php echo esc_html( WC()->countries->tax_or_vat() ) . $estimated_text; ?></th>
                                    <td data-title="<?php echo esc_attr( WC()->countries->tax_or_vat() ); ?>"><?php wc_cart_totals_taxes_total_html(); ?></td>
                                </tr>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php do_action( 'woocommerce_cart_totals_before_order_total' ); ?>

                        <tr class="order-total">
                            <th><?php _e( 'Total', 'woocommerce' ); ?></th>
                            <td data-title="<?php esc_attr_e( 'Total', 'woocommerce' ); ?>"><?php wc_cart_totals_order_total_html(); ?></td>
                        </tr>

                        <?php do_action( 'woocommerce_cart_totals_after_order_total' ); ?>
                    </table>

                </div>
            </div>

            <?php do_action( 'woocommerce_cart_actions' ); ?>

            <?php wp_nonce_field( 'woocommerce-cart' ); ?>

            <?php do_action( 'woocommerce_after_cart_contents' ); ?>

            <?php do_action( 'woocommerce_after_cart_table' ); ?>

            <?php if ( ! empty( WC()->cart->cart_contents ) ) : ?>
                <div class="vo-cart__actions">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="vo-cart__continue button">
                        <?php esc_html_e( 'Continue shopping', THEME_SLUG ); ?>
                    </a>

                    <?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
                </div>
            <?php endif; ?>

            <button type="submit" class="vo-cart__update" name="update_cart"
                    value="<?php esc_attr_e( 'Update cart', 'woocommerce' ); ?>"></button>

        </form>
        <?php do_action( 'woocommerce_after_cart' ); ?>
    </div>
</div>
