<?php
/**
 * When using this template part, these variables are required. Use the
 * `vo_get_template_part` function to pass them to the template part.
 *
 * @var int $count ACF counter, used to get the post meta of the correct block.
 */

$prefix     = "vo_page_builder_{$count}_";
$content    = get_post_meta(get_the_ID(), $prefix . 'content', true);
$title      = get_post_meta(get_the_ID(), $prefix . 'title', true);


// Image
$image_id    = (int) get_post_meta(get_the_ID(), $prefix . 'image', true);
$image_url   = !empty($image_id) ? wp_get_attachment_image_url($image_id, 'vo-half') : '';
$image_right = (int) get_post_meta(get_the_ID(), $prefix . 'image_right', true);


$background_pattern = (bool) get_post_meta(get_the_ID(), $prefix . 'background_pattern', true);

// Add link or button
$add_link       = (int) get_post_meta(get_the_ID(), $prefix . 'add_link', true);
$link_type      = get_post_meta(get_the_ID(), $prefix . 'link_type', true);
$link_text      = get_post_meta(get_the_ID(), $prefix . 'link_text', true);
$link           = (int) get_post_meta(get_the_ID(), $prefix . 'link', true);
$link_class     = $link_type === 'button' ? 'button' : '';
$type_rough     = (!empty($image_right)) ? true : false;
$type_elegant   = (empty($image_right)) ? true : false;
$class          = $type_elegant ? 'block--two-blocks--rough block--two-blocks--inverted' : 'block--two-blocks--rough';
$class          .= !empty($background_pattern) ? ' block--two-blocks--pattern': '';

$text_column    = 'small-12 medium-8 large-7';
$image_column   = 'small-12 medium-4 large-5';

if (empty($content)) {
    return;
}
?>

<section class="block block--two-blocks <?php echo esc_attr($class); ?>">
    <?php if (!empty($background_pattern)) : ?>
        <div class="block__background-overlay" data-animated></div>
    <?php endif; ?>
    <div class="row two-blocks__inner">
        <div class="small-12 columns">
            <?php if (!empty($title)) : ?>
                <div class="row two-blocks__header align-center">
                    <div class="column small-12 medium-10">
                        <h2 class="block__title" data-animated>
                            <?php echo esc_html($title); ?>
                        </h2>
                    </div>
                </div>
            <?php endif; ?>
            <div class="row block__inner">
                <?php if (!empty($image_id)) : ?>
                    <div class="column column--image <?php echo $image_column; ?>">
                        <div class="block__half block__half--image <?php echo !empty($image_right) ? 'block__half--fixed' : ''; ?>" data-animated>
                            <div class="two-blocks__image" style="background-image: url('<?php echo esc_url($image_url); ?>')"></div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (!empty($content)) : ?>
                    <div class="column column--text <?php echo $text_column; ?>">
                        <div class="block__half <?php echo empty($image_right) ? 'block__half--fixed' : ''; ?>" data-animated>
                            <?php echo apply_filters('the_content', wp_kses_post($content)); ?>
                            <?php if (!empty($add_link) && !empty($link) && !empty($link_text)) : ?>
                                <a href="<?php echo get_permalink($link); ?>" class="block__link <?php echo esc_attr($link_class); ?>">
                                    <?php echo esc_html($link_text); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
