<?php
/**
 * When using this template part, these variables are required. Use the
 * `vo_get_template_part` function to pass them to the template part.
 *
 * @var int $count ACF counter, used to get the post meta of the correct block.
 */

$prefix   = "vo_page_builder_{$count}_";
$title    = get_post_meta(get_the_ID(), $prefix . 'title', true);
$subtitle = get_post_meta(get_the_ID(), $prefix . 'subtitle', true);
$content  = get_post_meta(get_the_ID(), $prefix . 'content', true);

$class = '';

// Type
$type = get_post_meta(get_the_ID(), $prefix . 'type', true);

// Image Effect
$effect = get_post_meta(get_the_ID(), $prefix . 'image_effect', true);
$class .= $effect === 'fade' ? 'block--fade' : '';

// Position
$position     = get_post_meta(get_the_ID(), $prefix . 'position', true);
$column_class = $position === 'center' ? 'medium-6' : 'medium-5';
$row_class    = !empty($position) ? "align-${position}" : '';
$class       .= !empty($position) ? " block--${position}" : '';

// Background Color
$bg_color = get_post_meta(get_the_ID(), $prefix . 'bg_color', true);
$class .= !(empty($bg_color)) ? " block--bg-color--${bg_color}" : ' block--bg-color--white';

// Background image
$bg_image       = wp_get_attachment_image_url((int) get_post_meta(get_the_ID(), $prefix . 'bg_image', true), 'vo-fullwidth');
$style          = $bg_image ? "background-image: url(${bg_image})" : '';
$class          .= !empty($bg_image) ? ' text--image' : '';
$class          .= (!empty($style) && !empty($type) && $type === 'text_image') ? " block--has-image" : '';
$class          .= (!empty($style) && !empty($type) && $type === 'text_hero') ? " block--hero" : '';
$column_class   = !empty($style) ? 'medium-10 large-5' : 'medium-5';

// Text Color
$color  = get_post_meta(get_the_ID(), $prefix . 'color', true);
$class .= !empty($color) ? " block--${color}" : '';

// Text Align
$text_align = get_post_meta(get_the_ID(), $prefix . 'text_align', true);
$class     .= !empty($text_align) ? " text-${text_align}" : ' text-center';

// Column size
$column_size = get_post_meta(get_the_ID(), $prefix . 'column_size', true);
$column_class = !empty($column_size) && $column_size === 'full' ? 'medium-12': $column_class;
$column_class = !empty($column_size) && $column_size === 'half' ? 'medium-10 large-5': $column_class;
$column_class = !empty($column_size) && $column_size === 'large' ? 'medium-10 large-8': $column_class;

// Spacing
$spacing = get_post_meta(get_the_ID(), $prefix . 'spacing', true);
$class  .= !empty($spacing) ? " block--spacing-${spacing}" : '';

// Title Size
$title_size = get_post_meta(get_the_ID(), $prefix . 'title_size', true);
$class     .= !empty($title_size) ? " block--title-${title_size}" : '';

// Title Aling
$title_align = get_post_meta(get_the_ID(), $prefix . 'title_align', true);
$title_class = !empty($title_align) ? " text-${title_align}" : '';

// Add link or button
$add_link    = (int) get_post_meta(get_the_ID(), $prefix . 'add_link', true);
$link_type   = get_post_meta(get_the_ID(), $prefix . 'link_type', true);
$link_text   = get_post_meta(get_the_ID(), $prefix . 'link_text', true);
$link        = (int) get_post_meta(get_the_ID(), $prefix . 'link', true);
$link_class  = $link_type === 'button' ? 'button' : 'block__link--link';
$link_class .= $link_type === 'button' && $color === 'white' ? ' button--white' : '';

// USPS images
$usps_enable = (bool) get_post_meta(get_the_ID(), $prefix . 'usps_enable', true);
$usps_image_mobile = wp_get_attachment_image_url((int) get_post_meta(get_the_ID(), $prefix . 'usps_images_mobile', true), 'large');
$usps_image_desktop = wp_get_attachment_image_url((int) get_post_meta(get_the_ID(), $prefix . 'usps_images_desktop', true), 'large');

// Figure image
$figure_enable  = (bool) get_post_meta(get_the_ID(), $prefix . 'figure_enable', true);
$figure_image   = wp_get_attachment_image((int) get_post_meta(get_the_ID(), $prefix . 'figure_image', true), 'large');
$figure_caption = get_post_meta(get_the_ID(), $prefix . 'figure_caption', true);

// Focal Point
$focal_point_class = vo_get_focal_point_section_prefix_class_name($count);
$class .= ' ' . $focal_point_class;

echo vo_get_focal_point_style($count,  $prefix . 'focal_point');
?>

<section class="block block--text <?php echo esc_attr($class); ?>" style="<?php echo esc_attr($style); ?>">

    <?php if (!empty($style)) : ?>
        <div class="block__image" style="<?php echo esc_attr($style); ?>">

        </div>
    <?php endif; ?>

    <div class="block__wrapper">
        <div class="row <?php echo esc_attr($row_class); ?>">
            <div class="small-12 <?php echo esc_attr($column_class); ?> columns">
                <div class="block__inner" data-animated>
                    <?php if (!empty($title)) : ?>
                        <h3 class="block__title <?php echo esc_attr($title_class); ?>"><?php echo wp_kses_post($title, ['br' => []]); ?></h3>
                    <?php endif; ?>

                    <?php if (!empty($subtitle)) : ?>
                        <h4 class="block__subtitle"><?php echo wp_kses_post($subtitle, ['br' => []]); ?></h4>
                    <?php endif; ?>

                    <?php if (!empty($content)) : ?>
                        <div class="block__content">
                            <?php echo apply_filters('the_content', wp_kses_post($content)); ?>
                        </div>
                    <?php endif; ?>

                    <?php if ($figure_enable && !empty($figure_image)) : ?>
                        <div class="block__figure" data-animated>
                            <figure>
                                <?php echo $figure_image; ?>
                                <?php if (!empty($figure_caption)) : ?>
                                    <figcaption><?php echo esc_html($figure_caption); ?></figcaption>
                                <?php endif; ?>
                            </figure>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($add_link) && !empty($link) && !empty($link_text)) : ?>
                        <a href="<?php echo get_permalink($link); ?>" class="block__link <?php echo esc_attr($link_class); ?>">
                            <?php echo esc_html($link_text); ?>
                        </a>
                    <?php endif; ?>

                    <?php if ($usps_enable && !empty($usps_image_mobile) && !empty($usps_image_desktop)) : ?>
                        <div class="block__usps">
                            <picture data-animated>
                                <source media="(min-width: 640px)" srcset="<?php echo $usps_image_desktop; ?>">
                                <img src="<?php echo $usps_image_mobile; ?>" alt="Flowers" style="width:auto;">
                            </picture>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

</section>
