<?php
/**
 * When using this template part, these variables are required. Use the
 * `vo_get_template_part` function to pass them to the template part.
 *
 * @var int $count ACF counter, used to get the post meta of the correct block.
 */

$prefix = "vo_page_builder_{$count}_";
$title  = get_post_meta(get_the_ID(), $prefix . 'title', true);
$slides = (int) get_post_meta(get_the_ID(), $prefix . 'slides', true);
$align_title = get_post_meta(get_the_ID(), $prefix . 'align_title', true);
$class_title = !empty($align_title) ? 'text-' . $align_title : '';

if (empty($slides)) return;
?>

<section class="block block--slider">
    <?php if (!empty($title)) : ?>
        <div class="row">
            <div class="small-12 columns <?php echo esc_attr($class_title); ?>" data-animated>
                <h3 class="block__title"><?php echo esc_html($title); ?></h3>
            </div>
        </div>
    <?php endif; ?>

    <div class="slider" data-animated>
        <div class="row">
            <div class="small-12 columns">
                <div class="slider__wrapper">
                    <?php for ($i = 0; $i < $slides; $i++) :
                        $product_id = (int) get_post_meta(get_the_ID(), $prefix . 'slides_' . $i . '_product_id', true);
                        ?>
                        <?php if (!empty($product_id)) :
                            $product                    = wc_get_product($product_id);
                            $product_index_prefix       = "product-index-{$count}";
                            $product_title              = $product->get_title();
                            $product_short_description  = get_the_excerpt($product_id);
                            $product_link               = $product->get_permalink();
                            $product_image_id           = $product->get_image_id();
                            $product_slider_image_id    = get_post_meta($product_id, 'vo_product_image_slider_image', true);
                            $product_bg_color           = get_post_meta($product_id, 'vo_product_bg_color', true);
                            $product_bg_color           = !empty($product_bg_color) ? 'data-background-color="' . esc_attr($product_bg_color) . '"' : '';
                            $product_link_text          = __('Learn more', THEME_SLUG);

                            $product_image_id           = !empty($product_slider_image_id) ? $product_slider_image_id : $product_image_id;
                            $class_product_image        = !empty($product_slider_image_id) ? 'slider__image--overwritten' : '';
                            ?>

                            <div class="slider__item <?php echo ($i === 0) ? 'slider__item--active' : ''; ?>" <?php echo $product_bg_color; ?>>
                                <?php if (!empty($product_title)) : ?>
                                    <h4 class="slider__panel-title"><?php echo esc_html($product_title); ?></h4>
                                <?php endif; ?>
                                <div class="slider__inner small-12 medium-8 large-12">
                                    <header class="slider__header slider__header--mobile">
                                        <?php if (!empty($product_title)) : ?>
                                            <h3 class="slider__title"><?php echo esc_html($product_title); ?></h3>
                                        <?php endif; ?>

                                        <?php if (!empty($product_short_description)) : ?>
                                            <div class="slider__content">
                                                <?php echo apply_filters('the_content', wp_kses_post($product_short_description)); ?>
                                            </div>
                                        <?php endif; ?>

                                        <?php if (!empty($product_link) && !empty($product_link_text)) : ?>
                                            <a href="<?php echo $product_link; ?>" class="slider__link">
                                                <?php echo esc_html($product_link_text); ?>
                                            </a>
                                        <?php endif; ?>
                                    </header>

                                    <div class="row">
                                        <div class="slider__column slider__column--image column small-12 large-6">
                                            <?php if (!empty($product_image_id)) : ?>
                                                <div class="slider__image <?php echo esc_attr($class_product_image); ?>">
                                                    <?php echo wp_get_attachment_image($product_image_id, 'vo-half'); ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="slider__column slider__column--content column small-12 large-6">
                                            <?php if (!empty($product_id)) :
                                                $attributes = $product->get_attributes();
                                                $children = $product->get_children();
                                                ?>
                                                <header class="slider__header slider__header--desktop">
                                                    <?php if (!empty($product_title)) : ?>
                                                        <h3 class="slider__title"><?php echo esc_html($product_title); ?></h3>
                                                    <?php endif; ?>

                                                    <?php if (!empty($product_short_description)) : ?>
                                                        <div class="slider__content">
                                                            <?php echo apply_filters('the_content', wp_kses_post($product_short_description)); ?>
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php if (!empty($product_link) && !empty($product_link_text)) : ?>
                                                        <a href="<?php echo $product_link; ?>" class="slider__link">
                                                            <?php echo esc_html($product_link_text); ?>
                                                        </a>
                                                    <?php endif; ?>
                                                </header>
                                                <div class="vo-add-to-cart vo-add-to-cart--white">
                                                    <div class="products__price">
                                                        <span class="products__price-amount"><?php echo vo_get_variation_price($children[0]); ?></span>
                                                    </div>
                                                    <div class="products__actions">
                                                        <div>
                                                            <?php foreach ($attributes as $key => $attribute) :
                                                                $name = "{$product_index_prefix}-attribute-{$key}-{$product_id}";
                                                                $attribute_options = $attribute['options'];
                                                                ?>

                                                                <label class="products__label">
                                                                    <?php echo esc_html($attribute['name']); ?>
                                                                </label>

                                                                <?php if (!empty($attribute_options)): ?>
                                                                    <?php foreach ($attribute_options as $index => $option) :
                                                                        $option_id = "{$product_index_prefix}-attribute-{$option}-{$product_id}";
                                                                        ?>

                                                                        <input
                                                                                type="radio"
                                                                                data-variation-id="<?php echo esc_attr($children[$index]); ?>"
                                                                                data-variation-price="<?php echo vo_html_price_to_float(vo_get_variation_price($children[$index])); ?>"
                                                                                data-attribute-name="<?php echo esc_attr($key); ?>"
                                                                                value="<?php echo esc_attr($option); ?>"
                                                                                name="<?php echo esc_attr($name); ?>"
                                                                                id="<?php echo esc_attr($option_id); ?>"
                                                                            <?php echo $index === 0 ? 'checked="checked"' : ''; ?>
                                                                        >

                                                                        <label class="products__attribute-label" for="<?php echo esc_attr($option_id); ?>">
                                                                            <?php echo esc_html($option); ?>
                                                                        </label>

                                                                    <?php endforeach; ?>
                                                                <?php endif; ?>
                                                            <?php endforeach; ?>
                                                        </div>
                                                    </div>
                                                    <div class="products__button-qty">
                                                        <div class="row collapse">
                                                            <div class="column shrink">
                                                                <div class="quantity">
                                                                    <label class="products__label"><?php _e('Quantity', THEME_SLUG); ?></label>
                                                                    <div class="quantity__input-container">
                                                                        <button class="quantity__change quantity__change--minus">–</button>
                                                                        <button class="quantity__change quantity__change--plus">+</button>
                                                                        <input type="number" readonly class="quantity__input input-text qty text" step="1" min="1" name="quantity" value="1" title="Qty" size="4" pattern="[0-9]*" inputmode="numeric" aria-labelledby="" max="">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="column">
                                                                <button class="vo-add-to-cart__button products__button button button--black" data-product-id="<?php echo esc_attr($product_id); ?>">
                                                                    <span class="products__button-text"><?php esc_html_e('Add to cart', THEME_SLUG); ?></span>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endfor; ?>
                </div>
            </div>
        </div>
    </div>
</section>
