<?php
/**
 * When using this template part, these variables are required. Use the
 * `vo_get_template_part` function to pass them to the template part.
 *
 * @var int $count ACF counter, used to get the post meta of the correct block.
 */

$prefix   = "vo_page_builder_{$count}_";
$bg_image = wp_get_attachment_image_url( (int) get_post_meta( get_the_ID(), $prefix . 'bg_image', true ), 'vo-fullwidth' );

$title           = get_post_meta( get_the_ID(), $prefix . 'title', true );
$subtitle        = get_post_meta( get_the_ID(), $prefix . 'subtitle', true );
$type            = get_post_meta( get_the_ID(), $prefix . 'type', true );
$wholesale_title = get_post_meta( get_the_ID(), $prefix . 'wholesale_title', true );
$wholesale_text  = get_post_meta( get_the_ID(), $prefix . 'wholesale_text', true );
$category        = get_post_meta( get_the_ID(), $prefix . 'category', true );
$query_param     = $type === 'wholesale' ? 'NOT LIKE' : 'LIKE';

$args = [
    'post_type'  => 'product',
    'meta_query' => [
        [
            'key'     => 'wwpp_product_wholesale_visibility_filter',
            'value'   => 'all',
            'compare' => $query_param
        ],
    ],
];

if ( ! empty( $category ) ) {
    $args['tax_query'] = [
        [
            'taxonomy' => 'product_cat',
            'field'    => 'id',
            'terms'    => $category,
        ],
    ];
}

$query = new WP_Query( $args );

// Wholesale
if ( $type === 'wholesale' ) {
    $wholesale_roles = array_keys( maybe_unserialize( get_option( 'wwp_options_registered_custom_roles' ) ) );
    $user            = get_userdata( get_current_user_id() );
    $user_role       = $user ? $user->roles[0] : null;
}

// Focal Point
$focal_point_class = vo_get_focal_point_section_prefix_class_name( $count );
$class             = $focal_point_class;

echo vo_get_focal_point_style( $count, $prefix . 'focal_point' );
?>

<section
        class="block block--products <?php echo esc_attr( $class ); ?>" <?php echo ! empty( $bg_image ) ? 'style="background-image: url(' . esc_url( $bg_image ) . ');"' : ''; ?>>
    <div class="block__wrapper">

        <?php if ( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
            <div class="row align-center">
                <div class="small-12 columns">
                    <div class="block__inner" data-animated>
                        <?php if ( ! empty( $title ) ) : ?>
                            <h3 class="block__title"><?php echo esc_html( $title ); ?></h3>
                        <?php endif; ?>

                        <?php if ( ! empty( $subtitle ) ) : ?>
                            <div class="block__content"><?php echo esc_html( $subtitle ); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ( $query->have_posts() ) : ?>

            <div class="row">
                <div class="small-12 columns">
                    <?php if ( $type === 'wholesale' && $user_role !== 'administrator' && ! in_array( $user_role, $wholesale_roles ) ) : ?>
                        <?php if ( ! empty( $wholesale_title ) ) : ?>
                            <h2><?php echo esc_html( $wholesale_title ); ?></h2>
                        <?php endif; ?>
                        <?php if ( ! empty( $wholesale_text ) ) : ?>
                            <div><?php echo apply_filters( 'the_content', wp_kses_post( $wholesale_text ) ); ?></div>
                        <?php endif; ?>
                    <?php else : ?>
                        <div class="products">
                            <?php while ( $query->have_posts() ) : $query->the_post();
                                $id                        = get_the_ID();
                                $image                     = wp_get_attachment_image_src( get_post_thumbnail_id( $id ), '1x1' )[0];
                                $image_overview            = wp_get_attachment_image_url( (int) get_post_meta( $id, 'vo_product_image_overview_image', true ), '1x1' );
                                $image                     = ! empty( $image_overview ) ? $image_overview : $image;
                                $product                   = wc_get_product( $id );
                                $product_index_prefix      = "product-index-{$count}";
                                $product_short_description = get_the_excerpt( $id );
                                $attributes                = $product->get_attributes();
                                $children                  = $product->get_children();
                                $slug                      = sanitize_title( get_the_title() );
                                $downloads                 = $product->get_downloads();
                                $has_downloads             = count( $downloads ) > 0;
                                $class_item                = 'products__item--' . $slug . ( $has_downloads ? ' products__item--downloadable' : '' );
                                ?>

                                <div class="products__item <?php echo esc_attr( $class_item ); ?>" data-animated>
                                    <div class="products__header">
                                        <?php if ( ! empty( $image ) ) : ?>
                                            <?php if ( ! $has_downloads ): ?>
                                                <a class="products__image" href="<?php the_permalink(); ?>"
                                                   style="background-image: url(<?php echo esc_url( $image ); ?>);">
                                                </a>
                                            <?php else: ?>
                                                <div class="products__image"
                                                     style="background-image: url(<?php echo esc_url( $image ); ?>);">
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <h3 class="products__title">
                                            <?php if ( ! $has_downloads ): ?>
                                                <a href="<?php the_permalink(); ?>">
                                                    <?php echo get_the_title(); ?>
                                                </a>
                                            <?php else: ?>
                                                <?php echo get_the_title(); ?>
                                            <?php endif; ?>
                                        </h3>

                                        <?php if ( ! empty( $product_short_description ) ) : ?>
                                            <div class="products__short-description">
                                                <?php echo apply_filters( 'the_content', wp_kses_post( $product_short_description ) ); ?>
                                            </div>
                                        <?php endif; ?>


                                        <?php if ( ! $has_downloads ): ?>
                                            <a href="<?php echo get_permalink(); ?> " class="products__link">
                                                <?php esc_html_e( 'View product', THEME_SLUG ); ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <?php if ( $has_downloads ): ?>
                                        <div class="products__download-buttons">
                                            <h4>Downloads</h4>
                                            <ul>
                                                <?php /** @var WC_Product_Download $download */
                                                foreach ( $downloads as $download ):?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $download->get_file() ) ?>"
                                                           target="_blank">
                                                            <?php echo esc_html( $download->get_name() ); ?>
                                                        </a>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    <?php else: ?>
                                        <div class="products__add-to-cart">
                                            <div class="vo-add-to-cart">
                                                <div class="products__actions">
                                                    <?php if ( ! empty( $attributes ) ) : ?>
                                                        <div>
                                                            <?php foreach ( $attributes as $key => $attribute ) :
                                                                $name = "{$product_index_prefix}-attribute-{$key}-{$id}";
                                                                ?>

                                                                <label class="products__label">
                                                                    <?php echo esc_html( $attribute->get_name() ); ?>
                                                                </label>

                                                                <?php foreach ( $attribute->get_options() as $i => $option ) :
                                                                $option_id = "{$product_index_prefix}-attribute-{$option}-{$id}";
                                                                ?>

                                                                <input
                                                                        type="radio"
                                                                        data-variation-id="<?php echo esc_attr( $children[ $i ] ?? 0 ); ?>"
                                                                        data-variation-price="<?php echo vo_html_price_to_float( $product->is_type( 'simple' ) ? wc_get_price_to_display( $product ) : vo_get_variation_price( $children[ $i ] ) ); ?>"
                                                                        data-attribute-name="<?php echo esc_attr( $key ); ?>"
                                                                        value="<?php echo esc_attr( $option ); ?>"
                                                                        name="<?php echo esc_attr( $name ); ?>"
                                                                        id="<?php echo esc_attr( $option_id ); ?>"
                                                                    <?php echo $i === 0 ? 'checked="checked"' : ''; ?>
                                                                >

                                                                <label class="products__attribute-label"
                                                                       for="<?php echo esc_attr( $option_id ); ?>">
                                                                    <?php echo esc_html( $option ); ?>
                                                                </label>

                                                            <?php endforeach; ?>
                                                            <?php endforeach; ?>
                                                        </div>
                                                        <div class="products__price">
                                                            <span class="products__price-amount"><?php echo $product->is_type( 'simple' ) ? $product->get_price_html() : vo_get_variation_price( $children[0] ); ?></span>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="products__button-qty">
                                                    <div class="row collapse">
                                                        <div class="column shrink">
                                                            <div class="quantity">
                                                                <label class="products__label"><?php _e( 'Quantity', THEME_SLUG ); ?></label>
                                                                <div class="quantity__input-container">
                                                                    <button class="quantity__change quantity__change--minus">
                                                                        –
                                                                    </button>
                                                                    <button class="quantity__change quantity__change--plus">
                                                                        +
                                                                    </button>
                                                                    <input type="number" readonly
                                                                           class="quantity__input input-text qty text"
                                                                           step="1" min="1" name="quantity" value="1"
                                                                           title="Qty" size="4" pattern="[0-9]*"
                                                                           inputmode="numeric" aria-labelledby=""
                                                                           max="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="column">
                                                            <button class="vo-add-to-cart__button products__button button button--black"
                                                                    data-product-id="<?php echo esc_attr( $id ); ?>">
                                                                <span class="products__button-text"><?php esc_html_e( 'Add to cart', THEME_SLUG ); ?></span>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>

                            <?php endwhile; ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <?php wp_reset_postdata(); ?>
        <?php endif; ?>

    </div>
</section>
