<?php
/**
 * When using this template part, these variables are required. Use the
 * `vo_get_template_part` function to pass them to the template part.
 *
 * @var int $count ACF counter, used to get the post meta of the correct block.
 */

$prefix   = "vo_page_builder_{$count}_";
$bg_image = wp_get_attachment_image_url( (int) get_post_meta( get_the_ID(), $prefix . 'bg_image', true ), 'vo-fullwidth' );

$title           = get_post_meta( get_the_ID(), $prefix . 'title', true );
$subtitle        = get_post_meta( get_the_ID(), $prefix . 'subtitle', true );
$type            = get_post_meta( get_the_ID(), $prefix . 'type', true );
$wholesale_title = get_post_meta( get_the_ID(), $prefix . 'wholesale_title', true );
$wholesale_text  = get_post_meta( get_the_ID(), $prefix . 'wholesale_text', true );
$category        = get_post_meta( get_the_ID(), $prefix . 'category', true );
$query_param     = $type === 'wholesale' ? 'NOT LIKE' : 'LIKE';

$args = [
    'post_type'  => 'product',
    'meta_query' => [
        [
            'key'     => 'wwpp_product_wholesale_visibility_filter',
            'value'   => 'all',
            'compare' => $query_param
        ],
    ],
];

if ( ! empty( $category ) ) {
    $args['tax_query'] = [
        [
            'taxonomy' => 'product_cat',
            'field'    => 'id',
            'terms'    => $category,
        ],
    ];
}

$query = new WP_Query( $args );

// Wholesale
if ( $type === 'wholesale' ) {
    $wholesale_roles = array_keys( maybe_unserialize( get_option( 'wwp_options_registered_custom_roles' ) ) );
    $user            = get_userdata( get_current_user_id() );
    $user_role       = $user ? $user->roles[0] : null;
}

// Focal Point
$focal_point_class = vo_get_focal_point_section_prefix_class_name( $count );
$class             = $focal_point_class;

echo vo_get_focal_point_style( $count, $prefix . 'focal_point' );
?>

<section
        class="block block--products <?php echo esc_attr( $class ); ?>" <?php echo ! empty( $bg_image ) ? 'style="background-image: url(' . esc_url( $bg_image ) . ');"' : ''; ?>>
    <div class="block__wrapper">

        <?php if ( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
            <div class="row align-center">
                <div class="small-12 columns">
                    <div class="block__inner" data-animated>
                        <?php if ( ! empty( $title ) ) : ?>
                            <h3 class="block__title"><?php echo esc_html( $title ); ?></h3>
                        <?php endif; ?>

                        <?php if ( ! empty( $subtitle ) ) : ?>
                            <div class="block__content"><?php echo esc_html( $subtitle ); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ( $query->have_posts() ) : ?>

            <div class="row">
                <div class="small-12 columns">
                    <?php if ( $type === 'wholesale' && $user_role !== 'administrator' && ! in_array( $user_role, $wholesale_roles ) ) : ?>
                        <?php if ( ! empty( $wholesale_title ) ) : ?>
                            <h2><?php echo esc_html( $wholesale_title ); ?></h2>
                        <?php endif; ?>
                        <?php if ( ! empty( $wholesale_text ) ) : ?>
                            <div><?php echo apply_filters( 'the_content', wp_kses_post( $wholesale_text ) ); ?></div>
                        <?php endif; ?>
                    <?php else : ?>
                    <div class="products products-list">

                        <?php while ( $query->have_posts() ) : $query->the_post();
                            $id                        = get_the_ID();
                            $image                     = wp_get_attachment_image_src( get_post_thumbnail_id( $id ), '1x1' )[0];
                            $image_overview            = wp_get_attachment_image_url( (int) get_post_meta( $id, 'vo_product_image_overview_image', true ), '1x1' );
                            $image                     = ! empty( $image_overview ) ? $image_overview : $image;
                            $product                   = wc_get_product( $id );
                            $product_index_prefix      = "product-index-{$count}";
                            $product_short_description = get_the_excerpt( $id );
                            $children                  = $product->get_children();
                            $bg_color                  = get_post_meta( $id, 'vo_product_bg_color', true );
                            $bg_image_id               = get_post_meta( $id, 'vo_product_bg_image', true );


                            $bg_class     = ! empty( $bg_color ) ? ' product-block--' . $bg_color : '';
                            $bg_img_class = ! empty( $bg_image_id ) ? ' product-block--' . $bg_image_id : '';

                            $products_to_loop = array();
                            if ( count( $children ) ) {
                                foreach ( $children as $child ) {
                                    $products_to_loop[] = wc_get_product( $child );
                                }
                            } else {
                                $products_to_loop = array( $product );
                            }
                            ?>
                            <?php foreach ( $products_to_loop as $product ): ?>

                                <?php
                                $id              = $product->get_id();
                                $wholesale_price = vo_html_price_to_float( vo_get_variation_price( $id ?? null ) );
                                $msrp_price      = $product->get_price();
                                $slug            = sanitize_title( $product->get_title() );
                                $class_item      = 'products-list__item--' . $slug;
                                $attributes      = $product->get_attributes();
                                $addon           = null;

                                if ( !$product->is_type( 'simple' ) ) {
                                    foreach ( $attributes as $key => $attribute ) {
                                        $addon .= ' <small>(' . $attribute . ')</small>';
                                    }
                                }
                                ?>


                                <div class="products-list__item products-list__item--single <?php echo esc_attr( $class_item ); ?>"
                                     data-animated
                                     data-price-msrp="<?php echo esc_attr( $msrp_price ) ?>"
                                     data-price-wholesale="<?php echo esc_attr( $wholesale_price ) ?>"
                                     data-productid="<?php echo esc_attr( $id ); ?>">
                                    <div class="products-list__thumbnail products-list__item--col">
                                        <?php if ( ! empty( $image ) ) : ?>
                                            <a class="products-list__image" href="<?php the_permalink(); ?>"
                                               style="background-image: url(<?php echo esc_url( $image ); ?>);">
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="products-list__title products-list__item--col">
                                        <!--                                    <a href="-->
                                        <?php //the_permalink(); ?><!--">-->
                                        <!--                                        --><?php //echo get_the_title(); ?>
                                        <!--                                    </a>-->
                                        <?php echo get_the_title() . $addon; ?>
                                    </div>
                                    <div class="products-list__price products-list__item--col">
                                        <?php if ( $msrp_price !== null ): ?>
                                            <label class="products-list__label">
                                                <?php _e( 'MSRP Per Piece' ) ?>
                                            </label>
                                            <div class="products__price products-list__price">
                                                <span class="products__price-amount products-list__price-amount"><?php echo wc_price( $msrp_price ); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="products-list__wholesale-price products-list__item--col">
                                        <?php if ( $wholesale_price !== '' ): ?>
                                            <label class="products-list__label">
                                                <?php _e( 'Wholesale' ) ?>
                                            </label>
                                            <div class="products__price products-list__wholesale-price">
                                                <span class="products__wholesale-price-amount products-list__wholesale-price-amount"><?php echo wc_price( $wholesale_price ) ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="products-list__cart products-list__item--col vo-add-to-cart">
                                        <div class="products-list__button-qty">
                                            <div class="row collapse">
                                                <div class="column shrink">
                                                    <div class="quantity">
                                                        <div class="quantity__input-container">
                                                            <button class="quantity__change quantity__change--minus">
                                                                –
                                                            </button>
                                                            <button class="quantity__change quantity__change--plus">
                                                                +
                                                            </button>
                                                            <input type="number" readonly
                                                                   class="quantity__input input-text qty text"
                                                                   step="1" min="1" name="quantity" value="1"
                                                                   title="Qty" size="4" pattern="[0-9]*"
                                                                   inputmode="numeric" aria-labelledby=""
                                                                   max=""/>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="column">
                                                    <button class="vo-add-to-cart__button products-list__button button button--black"
                                                            data-product-id="<?php echo esc_attr( $id ); ?>">
                                                        <span class="products-list__button-text"><?php esc_html_e( 'Add to cart', THEME_SLUG ); ?></span>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="products-list__item--ajax products-list__item--row product-block products-list__more-info <?php echo esc_attr( $bg_class . $bg_img_class ) ?>"></div>
                                </div>
                            <?php endforeach; ?>
                        <?php endwhile; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <?php wp_reset_postdata(); ?>
        <?php endif; ?>
    </div>
</section>
