<?php
/**
 * When using this template part, these variables are required. Use the
 * `vo_get_template_part` function to pass them to the template part.
 *
 * @var int $count ACF counter, used to get the post meta of the correct block.
 */

$prefix         = "vo_page_builder_{$count}_";
$title          = get_post_meta(get_the_ID(), $prefix . 'title', true);
$product_id     = get_post_meta(get_the_ID(), $prefix . 'product_id', true);
?>

<section class="block block--product">

    <div class="block__header">
        <div class="row align-center">
            <div class="small-12 medium-10 large-8 columns">
                <div class="block__inner text-center" data-animated>
                    <?php if (!empty($title)) : ?>
                        <h3 class="block__title <?php echo esc_attr($title_class); ?>"><?php echo wp_kses_post($title, ['br' => []]); ?></h3>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php if (!empty($product_id)) :
        $product                = wc_get_product($product_id);
        $product_index_prefix   = "product-index-{$count}";
        $product_title          = $product->get_title();
        $product_image          = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'vo-fullwidth')[0];
        $product_image_overview = wp_get_attachment_image_url((int) get_post_meta($product_id, 'vo_product_image_overview_image', true), 'vo-fullwidth');
        $product_image          = !empty($product_image_overview ) ? $product_image_overview  : $product_image;
        $attributes             = $product->get_attributes();
        $children               = $product->get_children();
        ?>
        <div class="block__product">
            <div class="row">
                <div class="small-12 columns">
                    <div class="block__product-inner" data-animated>
                        <?php if (!empty($product_image)) : ?>
                            <a class="block__product-image" href="<?php echo get_the_permalink($product_id); ?>" style="background-image: url(<?php echo esc_url($product_image); ?>);">
                            </a>
                        <?php endif; ?>
                        <div class="row align-center">
                            <div class="column small-11 medium-8 large-6">
                                <div class="block__product-content">
                                    <h3 class="block__product-title">
                                        <a href="<?php echo get_the_permalink($product_id); ?>">
                                            <?php echo esc_html($product_title); ?>
                                        </a>
                                    </h3>
                                    <div class="vo-add-to-cart">
                                        <div class="products__actions">
                                            <div>
                                                <?php foreach ($attributes as $key => $attribute) :
                                                    $name = "{$product_index_prefix}-attribute-{$key}-{$product_id}";
                                                    $attribute_options = $attribute['options'];
                                                    ?>

                                                    <label class="products__label">
                                                        <?php echo esc_html($attribute['name']); ?>
                                                    </label>

                                                    <?php if (!empty($attribute_options)): ?>
                                                        <?php foreach ($attribute_options as $index => $option) :
                                                            $option_id = "{$product_index_prefix}-attribute-{$option}-{$product_id}";
                                                            ?>

                                                            <input
                                                                    type="radio"
                                                                    data-variation-id="<?php echo esc_attr($children[$index]); ?>"
                                                                    data-variation-price="<?php echo vo_html_price_to_float(vo_get_variation_price($children[$index])); ?>"
                                                                    data-attribute-name="<?php echo esc_attr($key); ?>"
                                                                    value="<?php echo esc_attr($option); ?>"
                                                                    name="<?php echo esc_attr($name); ?>"
                                                                    id="<?php echo esc_attr($option_id); ?>"
                                                                <?php echo $index === 0 ? 'checked="checked"' : ''; ?>
                                                            >

                                                            <label class="products__attribute-label" for="<?php echo esc_attr($option_id); ?>">
                                                                <?php echo esc_html($option); ?>
                                                            </label>

                                                        <?php endforeach; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            </div>

                                            <div class="quantity">
                                                <label class="products__label"><?php _e('Quantity', THEME_SLUG); ?></label>
                                                <div class="quantity__input-container">
                                                    <button class="quantity__change quantity__change--minus">–</button>
                                                    <button class="quantity__change quantity__change--plus">+</button>
                                                    <input type="number" readonly class="quantity__input input-text qty text" step="1" min="1" name="quantity" value="1" title="Qty" size="4" pattern="[0-9]*" inputmode="numeric" aria-labelledby="" max="">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="products__button-qty">

                                        </div>
                                        <button
                                                class="vo-add-to-cart__button products__button button button--black"
                                                data-product-id="<?php echo esc_attr($product_id); ?>"
                                        >
                                            <span class="products__button-text">
                                                <?php esc_html_e('Add to cart', THEME_SLUG); ?>
                                            </span>
                                            —
                                            <span class="products__button-price"><?php echo vo_get_variation_price($children[0]); ?></span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</section>
