<?php
/**
 * When using this template part, these variables are required. Use the
 * `vo_get_template_part` function to pass them to the template part.
 *
 * @var int $count ACF counter, used to get the post meta of the correct block.
 */

$prefix   = "vo_page_builder_{$count}_";

$title = vo_get_option('newsletter_title');
$subtitle = vo_get_option('newsletter_subtitle');
$image_id = vo_get_option('newsletter_image');
$image = !empty($image_id) ? wp_get_attachment_image_url($image_id, 'large') : '';
$form_id = vo_get_option('newsletter_form_id');
?>

<section class="block block--newsletter block--title-large newsletter <?php echo esc_attr($class); ?>">
    <div class="row align-center">
        <div class="newsletter__content column small-12 medium-6 large-5">
            <div class="block__newsletter">
                <?php if (!empty($title)) : ?>
                    <h3 class="block__title"><?php echo wp_kses_post($title, ['br' => []]); ?></h3>
                <?php endif; ?>

                <?php if (!empty($subtitle)) : ?>
                    <p class="block__subtitle"><?php echo wp_kses_post($subtitle, ['br' => []]); ?></p>
                <?php endif; ?>

                <?php if (vo_validate_gravity_form_id($form_id)) : ?>
                    <div class="newsletter__form">
                        <?php gravity_form($form_id, false, false, false, null, true); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="newsletter__visual column small-12 medium-6 large-7">
            <div class="newsletter__visual-inner">
                <div class="newsletter__image" style="background-image: url('<?php echo esc_attr($image); ?>')"></div>
            </div>
        </div>
    </div>
</section>
