<?php
$prefix                 = "vo_page_builder_{$count}_";
$top_title              = get_post_meta(get_the_ID(), $prefix . 'content_top_title', true);
$top_download_file_id   = get_post_meta(get_the_ID(), $prefix . 'content_top_download_file', true);
$top_download_text      = get_post_meta(get_the_ID(), $prefix . 'content_top_download_text', true);
$top_download_file      = !empty($top_download_file_id) ? wp_get_attachment_url($top_download_file_id) : '';
$bottom_title           = get_post_meta(get_the_ID(), $prefix . 'content_bottom_title', true);
$bottom_text            = get_post_meta(get_the_ID(), $prefix . 'content_bottom_text', true);
$background_image_id    = get_post_meta(get_the_ID(), $prefix . 'bg_image', true);
$background_image       = wp_get_attachment_image_src($background_image_id, 'vo-fullwidth')[0];

// Focal Point
$focal_point_class = vo_get_focal_point_section_prefix_class_name($count);
$class = $focal_point_class;

echo vo_get_focal_point_style($count,  $prefix . 'focal_point', 'image-text__image');
?>

<section class="block block--image-text-blocks <?php echo esc_attr($class); ?>">

    <div class="image-text__image" style="background-image: url(<?php echo esc_url($background_image); ?>)">
    </div>

    <div class="image-text__block image-text__block--top">
        <div class="row align-center">
            <div class="small-12 medium-10 large-8 columns">
                <div class="image-text__block-inner" data-animated>
                    <?php if (!empty($top_title)) : ?>
                        <h1 class="image-text__block-title"><?php echo esc_html($top_title); ?></h1>
                    <?php endif; ?>
                    <?php if (!empty($top_download_file) && !empty($top_download_text)) : ?>
                        <a href="<?php echo esc_url($top_download_file); ?>" class="image-text__block-download">
                            <span class="text"><?php echo esc_html($top_download_text); ?></span>
                            <span class="icon"><?php get_template_part(THEME_SVG, 'icon-download-cloud.svg'); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="image-text__block image-text__block--bottom">
        <div class="row align-center">
            <div class="small-12 medium-10 large-8 columns">
                <div class="image-text__block-inner" data-animated>
                    <?php if (!empty($bottom_title)) : ?>
                        <h3 class="image-text__block-title"><?php echo esc_html($bottom_title); ?></h3>
                    <?php endif; ?>

                    <?php if (!empty($bottom_text)) : ?>
                        <div class="image-text__block-content">
                            <?php echo apply_filters('the_content', wp_kses_post($bottom_text)); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
