<?php
$prefix             = "vo_page_builder_{$count}_";
$header_title       = get_post_meta(get_the_ID(), $prefix . 'header_title', true);
$header_subtitle    = get_post_meta(get_the_ID(), $prefix . 'header_subtitle', true);
$block_text         = get_post_meta(get_the_ID(), $prefix . 'block_text', true);
$block_button       = get_post_meta(get_the_ID(), $prefix . 'block_button', true);
$block_button_text  = (!empty($block_button)) ? $block_button['title'] : '';
$block_button_link  = (!empty($block_button)) ? $block_button['url'] : '';

$distributors_content_find_text         = get_option('options_vo_distributor_content_find_text');
$distributors_content_locations_text    = get_option('options_vo_distributor_content_locations_text');
$distributors_content_open_in_maps_text = get_option('options_vo_distributor_content_open_in_maps_text');
$distributors_locations                 = get_option('options_vo_distributor_locations');
?>
<section class="block block--contact">

    <div class="contact">
        <div class="contact__header" data-animated>
            <div class="row align-center">
                <div class="column large-6">
                    <?php if (!empty($header_title)) : ?>
                        <h1 class="contact__header-title"><?php echo $header_title; ?></h1>
                    <?php endif; ?>
                    <?php if (!empty($header_subtitle)) : ?>
                        <h2 class="contact__header-subtitle"><?php echo $header_subtitle; ?></h2>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="contact__block">
            <div class="row align-center">
                <div class="column medium-10 large-8">
                    <div class="contact__block-inner" data-animated>
                        <div class="contact__block-item contact__block-item--contact">
                            <?php if (!empty($block_text)) : ?>
                                <div class="contact__block-text">
                                    <?php echo apply_filters('the_content', wp_kses_post($block_text)); ?>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($block_button_link) && !empty($block_button_text)) : ?>
                                <div class="contact__block-button">
                                    <a href="<?php echo esc_url($block_button_link); ?>" class="button button--primary"><?php echo esc_html($block_button_text); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="contact__block-item contact__block-item--distributor">
                            <?php if (!empty($distributors_content_find_text)) : ?>
                                <h4 class="contact__block-title"><?php echo esc_html($distributors_content_find_text); ?></h4>
                            <?php endif; ?>
                            <?php if (!empty($distributors_locations)) : ?>
                                <div class="contact__block-locations">
                                    <?php if (!empty($distributors_content_locations_text)) : ?>
                                        <div class="contact__block-subtitle">
                                            <?php echo esc_html($distributors_content_locations_text); ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="row">
                                        <?php for ($i = 0; $i < $distributors_locations; $i++) :
                                            $text   = get_option('options_vo_distributor_locations_' . $i . '_text');
                                            $map    = get_option('options_vo_distributor_locations_' . $i . '_map');
                                            $link   = (!empty($map)) ? 'https://www.google.com/maps/search/?api=1&query=' . $map['address'] : '';
                                            ?>
                                            <div class="column small-12 medium-6">
                                                <div class="contact__block-location">
                                                    <?php if (!empty($text)) : ?>
                                                        <div>
                                                            <?php echo apply_filters('the_content', wp_kses_post($text)); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if (!empty($link) && !empty($distributors_content_open_in_maps_text)) : ?>
                                                        <a href="<?php echo esc_url($link); ?>" target="_blank"><?php echo esc_html($distributors_content_open_in_maps_text); ?></a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
