<?php
/**
 * When using this template part, these variables are required. Use the
 * `vo_get_template_part` function to pass them to the template part.
 *
 * @var int $count ACF counter, used to get the post meta of the correct block.
 */

$prefix = "vo_page_builder_{$count}_";
$title  = get_post_meta(get_the_ID(), $prefix . 'title', true);
$accordion = (int) get_post_meta(get_the_ID(), $prefix . 'items', true);

if (empty($accordion)) return;
?>

<section class="block block--accordion">
    <?php if (!empty($title)) : ?>
        <div class="row">
            <div class="small-12 columns text-center">
                <h3 class="block__title"><?php echo esc_html($title); ?></h3>
            </div>
        </div>
    <?php endif; ?>

    <div class="accordion">
        <div class="row align-center">
            <div class="small-12 medium-8 columns">
                <div class="accordion__wrapper" data-accordion data-multi-expand="false" data-allow-all-closed="true">
                    <?php for ($i = 0; $i < $accordion; $i++) :
                        $title = get_post_meta(get_the_ID(), $prefix . 'items_' . $i . '_title', true);
                        $content = get_post_meta(get_the_ID(), $prefix . 'items_' . $i . '_content', true);
                        ?>

                        <div class="accordion__item <?php echo ($i === 0) ? 'is-active' : ''; ?>" data-accordion-item>
                            <a href="#" class="accordion-title"><?php if (!empty($title)) : ?><?php echo esc_html($title); ?><?php endif; ?></a>
                            <div class="accordion-content" data-tab-content>
                                <?php if (!empty($content)) : ?>
                                    <?php echo apply_filters('the_content', wp_kses_post($content)); ?>
                                <?php endif; ?>
                            </div>
                        </div>

                    <?php endfor; ?>
                </div>
            </div>
        </div>
    </div>
</section>
