<?php
$title           = get_option('options_vo_age_title');
$subtitle        = get_option('options_vo_age_subtitle');
$age_limit       = (int) get_option('options_vo_age_limit');
$age_limit_label = get_option('options_vo_age_limit_label');
$checkbox_text   = get_option('options_vo_age_checkbox_text');
$button_text     = get_option('options_vo_age_button_text');
$agreement_text  = get_option('options_vo_age_agreement_text');
$error           = get_option('options_vo_age_error');
?>

<div class="age-verification" hidden>
    <div class="age-verification__inner">
        <img class="age-verification__logo" src="<?php echo THEME_URI_SVG; ?>/logo--black.svg" alt="<?php bloginfo('name'); ?>" aria-hidden="true">

        <form data-age-limit="<?php echo esc_attr($age_limit); ?>">
            <div>
                <h2 class="age-verification__title"><?php echo esc_html($title); ?></h2>
                <span class="age-verification__subtitle"><?php echo esc_html($subtitle); ?></span>
            </div>
            <?php if (!empty($error)) : ?>
                <span class="age-verification__error" hidden data-animated data-animated-visible><?php echo esc_html($error); ?></span>
            <?php endif; ?>
            <input class="age-verification__input age-verification__input--year" type="number" name="year" required="required" placeholder="YYYY" min="1900" max="2100" step="1">
            <input class="age-verification__input age-verification__input--month" type="number" name="month"  required="required" placeholder="MM" min="01" max="12" step="1">
            <div>
                <span class="age-verification__label"><?php echo esc_html($age_limit_label); ?></span>
            </div>
            <label for="remember">
                <input type="checkbox" name="remember" checked>
                <span><?php echo esc_html($checkbox_text); ?></span>
            </label>
            <input type="submit" class="age-verification__button button button--primary button--large" value="<?php echo esc_attr($button_text); ?>">
            <div class="age-verification__footer">
                <?php echo apply_filters('the_content', wp_kses_post($agreement_text)); ?>
            </div>
        </form>
    </div>
</div>

<script>
// We want this code to run as quickly as possible.
var isVerified = localStorage.getItem('vo-age-verified') === 'true';

if (!isVerified) {
    var ageVerification = document.querySelector('.age-verification');
    var yearInput = ageVerification.querySelector('.age-verification__input--year');

    ageVerification.removeAttribute('hidden');
    yearInput.focus();
}
</script>
