<?php
/**
 * This template gets all its content from our ACF page builder.
 *
 * We use vo_get_template_part to get the correct template part
 * and pass the $count variable, needed for get_post_meta.
 *
 * For more info on this function, see helpers.php.
 */

$blocks = get_post_meta(get_the_ID(), 'vo_page_builder', true);

get_header();

while (have_posts()) : the_post();
    the_content(sprintf(
        __('Continue reading %s', THEME_SLUG),
        the_title('<span class="screen-reader-text">', '</span>', false)
    ));
endwhile;

if (!empty($blocks)) :
    foreach ($blocks as $count => $block) :
        vo_get_template_part('template-parts/blocks/block', $block, ['count' => $count]);
    endforeach;
endif;

get_footer();
