<?php
/**
 * This template gets all its content from our ACF page builder.
 *
 * We use vo_get_template_part to get the correct template part
 * and pass the $count variable, needed for get_post_meta.
 *
 * For more info on this function, see helpers.php.
 */

$blocks = get_post_meta(get_the_ID(), 'vo_page_builder', true);
$stack_start = false;
$stack_end = false;

if (!empty($blocks)) :
    foreach ($blocks as $count => $block) :
        switch ($block) :
            case 'stack_blocks_start':
                $stack_start = true;
                break;
            case 'stack_blocks_end':
                $stack_end = true;
                break;
        endswitch;
    endforeach;
endif;

get_header();

if (!empty($blocks)) :
    foreach ($blocks as $count => $block) :

        switch ($block) :
            case 'stack_blocks_start':

                if ($stack_start && $stack_end) :
                    ?>
                    <section class="block--stacked-blocks">
                    <?php
                endif;

                break;
            case 'stack_blocks_end':
                if ($stack_start && $stack_end) :
                    ?>
                    </section>
                    <?php
                endif;
                break;
        endswitch;

        vo_get_template_part('template-parts/blocks/block', $block, ['count' => $count]);
    endforeach;
endif;

get_footer();
