<?php

/**
 * AJAX
 *
 * Please read the documentation at <https://codex.wordpress.org/AJAX_in_Plugins#Ajax_on_the_Viewer-Facing_Side>.
 * ----------------------------------------------------------------------------
 */

add_action( 'wp_ajax_vo_add_to_cart', 'vo_add_to_cart' );
add_action( 'wp_ajax_nopriv_vo_add_to_cart', 'vo_add_to_cart' );

add_action( 'wp_ajax_vo_added_to_cart_message', 'vo_added_to_cart_message' );
add_action( 'wp_ajax_nopriv_vo_added_to_cart_message', 'vo_added_to_cart_message' );

add_action( 'wp_ajax_vo_product_show_more_info', 'vo_product_show_more_info' );
add_action( 'wp_ajax_nopriv_vo_product_show_more_info', 'vo_product_show_more_info' );

/**
 * Add To Cart.
 */
function vo_add_to_cart() {
    check_ajax_referer( 'vo-ajax', 'security' );

    // By default, assume adding to cart was unsuccessful.
    $success = false;

    // Check if WooCommerce is installed.
    if ( function_exists( 'WC' ) ) {
        // Get relevant info from the AJAX call.
        $id             = isset( $_POST['id'] ) ? $_POST['id'] : '';
        $quantity       = isset( $_POST['quantity'] ) ? $_POST['quantity'] : 1;
        $variation_id   = isset( $_POST['variationId'] ) ? $_POST['variationId'] : 0;
        $attribute      = isset( $_POST['attribute'] ) ? 'attribute_' . $_POST['attribute'] : '';
        $attributeValue = isset( $_POST['attributeValue'] ) ? $_POST['attributeValue'] : '';

        // Add the item to the cart. WC()->cart->add_to_cart returns a boolean
        // depending on whether or not the product was added successfully.
        $success = ! empty( WC()->cart->add_to_cart( $id, $quantity, $variation_id, [ $attribute => $attributeValue ] ) );
    }

    header( 'Content-Type: application/json' );
    echo json_encode( [ 'success' => $success ] );
    die();
}

function vo_added_to_cart_message() {
    check_ajax_referer( 'vo-ajax', 'security' );
    global $woocommerce;
    $product_id    = isset( $_POST['productId'] ) ? $_POST['productId'] : '';
    $product       = wc_get_product( $product_id );
    $product_title = $product->get_title();
    $cart_url      = wc_get_cart_url();
    $message       = sprintf( __( '<a href="%s" class="button">View cart</a> "%s" has been added to your cart.', 'woocommerce' ), $cart_url, $product_title );

    $output = array(
        'error'  => false,
        'output' => '',
    );
    ob_start();
    ?>
    <div class="vo-woocommerce-message">
        <div class="row">
            <div class="column">
                <div class="woocommerce-message">
                    <div class="woocommerce-message__inner">
                        <span><?php echo $message; ?></span>
                        <span class="woocommerce-message__close">
                            <span></span>
                            <span></span>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    $output['output'] = ob_get_clean();

    wp_reset_postdata();

    header( 'Content-Type: application/json' );
    echo json_encode( $output );
    die();
}

function vo_product_show_more_info() {
    // return product info so we can display it in the wholesale product list
    check_ajax_referer( 'vo-ajax', 'security' );
    $product_id = isset( $_POST['id'] ) ? $_POST['id'] : '';
    $product = wc_get_product( $product_id );

    if ($product->is_type('variation')) {
      $product = wc_get_product( $product->get_parent_id() );
    }

    $html = '<div class="product">';
    $html .= '<div class="products-list__more-info--block products-list__more-info--image">';
    $html .= $product->get_image();
    $html .= '</div>';
    $html .= '<div class="products-list__more-info--block">';
    $html .= '<h3 class="products-list__more-info--title">';
    $html .= $product->get_title();
    $html .= ' </h3>';
    $html .= '<div class="products-list__more-info--description">';
    $html .= $product->get_description();
    $html .= '</div>';
    $html .= '</div>';
    $html .= '</div>';

    wp_send_json_success( $html );
}