<?php

if (!function_exists('acf_add_local_field_group'))  return;

$colors = [
    'tiramisu-havana'  => __('Havana Myst (Brown)', THEME_SLUG),
    'kingston-delight' => __('Kingston Delight (Green)', THEME_SLUG),
    'rock-melon-berry' => __('Rock Melon Berry (Blue)', THEME_SLUG),
    'kingston-xtreme'  => __('Kingston Xtreme (Red)', THEME_SLUG),
    'imperial-custard' => __('Imperial Custard (Yellow)', THEME_SLUG),
    'supreme-fruits'   => __('Supreme Fruits (Purple)', THEME_SLUG),
    'elyx-kit'         => __('Elyx kit', THEME_SLUG),
    'none'             => __('None', THEME_SLUG),
];

/**
 * Theme Settings
 * ---------------------------------------------------------------
 */

$theme_settings = [
    'key' => 'key_vo_settings',
    'title' => __('Settings', THEME_SLUG),
    'position' => 'acf_after_title',
    'fields' => [
        [
            'key' => 'key_vo_age_tab',
            'name' => '',
            'label' => __('Age Verification', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_age_title',
            'name' => 'vo_age_title',
            'label' => __('Title', THEME_SLUG),
            'type' => 'text',
        ],
        [
            'key' => 'key_vo_age_subtitle',
            'name' => 'vo_age_subtitle',
            'label' => __('Subtitle', THEME_SLUG),
            'type' => 'text',
        ],
        [
            'key' => 'key_vo_age_limit',
            'name' => 'vo_age_limit',
            'label' => __('Age Limit', THEME_SLUG),
            'type' => 'number',
            'wrapper' => [
                'width' => 50
            ],
        ],
        [
            'key' => 'key_vo_age_limit_label',
            'name' => 'vo_age_limit_label',
            'label' => __('Age Limit Label', THEME_SLUG),
            'type' => 'text',
            'wrapper' => [
                'width' => 50
            ],
        ],
        [
            'key' => 'key_vo_age_checkbox_text',
            'name' => 'vo_age_checkbox_text',
            'label' => __('Checkbox Text', THEME_SLUG),
            'type' => 'text',
            'wrapper' => [
                'width' => 50
            ],
        ],
        [
            'key' => 'key_vo_age_button_text',
            'name' => 'vo_age_button_text',
            'label' => __('Button Text', THEME_SLUG),
            'type' => 'text',
            'wrapper' => [
                'width' => 50
            ],
        ],
        [
            'key' => 'key_vo_age_agreement_text',
            'name' => 'vo_age_agreement_text',
            'label' => __('Agreement Text', THEME_SLUG),
            'type' => 'wysiwyg',
        ],
        [
            'key' => 'key_vo_age_limit_error',
            'name' => 'vo_age_error',
            'label' => __('Error Text', THEME_SLUG),
            'type' => 'text',
        ],
        [
            'key' => 'key_theme_newsletter_tab',
            'name' => '',
            'label' => __('Newsletter', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_theme_newsletter',
            'name' => 'newsletter',
            'label' => __('Newsletter', THEME_SLUG),
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'key_theme_newsletter_title',
                    'name' => 'title',
                    'label' => __('Title', THEME_SLUG),
                    'type' => 'text',
                    'instructions' => __('Type &lt;br&gt; to add a line break.', THEME_SLUG),
                ],
                [
                    'key' => 'key_theme_newsletter_subtitle',
                    'name' => 'subtitle',
                    'label' => __('Subtitle', THEME_SLUG),
                    'type' => 'text',
                    'instructions' => __('Type &lt;br&gt; to add a line break.', THEME_SLUG),
                ],
                [
                    'key' => 'key_theme_newsletter_image',
                    'name' => 'image',
                    'label' => __('Image', THEME_SLUG),
                    'type' => 'image',
                ],
                vo_acf_select_gravity_form('key_theme_newsletter_form'),
            ],
        ],

        [
            'key' => 'key_vo_footer_tab',
            'name' => '',
            'label' => __('Footer', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_footer_header',
            'name' => 'vo_footer_header',
            'label' => __('Header content', THEME_SLUG),
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'key_vo_footer_header_title',
                    'name' => 'title',
                    'label' => __('Title', THEME_SLUG),
                    'type' => 'text',
                ],
                [
                    'key' => 'key_vo_footer_header_text',
                    'name' => 'text',
                    'label' => __('Text', THEME_SLUG),
                    'type' => 'textarea',
                ],
            ],
        ],
        [
            'key' => 'key_vo_footer_copyright',
            'name' => 'vo_footer_copyright',
            'label' => __('Copyright', THEME_SLUG),
            'type' => 'text',
            'wrapper' => [
                'width' => 50
            ]
        ],
        [
            'key' => 'key_vo_footer_credits',
            'name' => 'vo_footer_credits',
            'label' => __('Credits', THEME_SLUG),
            'type' => 'text',
            'wrapper' => [
                'width' => 50
            ]
        ],
        [
            'key' => 'key_vo_distributor_tab',
            'name' => '',
            'label' => __('Distributors', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_distributor_content',
            'name' => 'vo_distributor_content',
            'label' => __('Header content', THEME_SLUG),
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'key_vo_distributor_content_find_text',
                    'name' => 'find_text',
                    'label' => __('Find an ELYX distributor Text', THEME_SLUG),
                    'type' => 'text',
                ],
                [
                    'key' => 'key_vo_distributor_content_locations_text',
                    'name' => 'locations_text',
                    'label' => __('Locations Text', THEME_SLUG),
                    'type' => 'text',
                ],
                [
                    'key' => 'key_vo_distributor_content_open_in_maps_text',
                    'name' => 'open_in_maps_text',
                    'label' => __('Open in Maps Text', THEME_SLUG),
                    'type' => 'text',
                ],
            ],
        ],
        [
            'key' => 'key_vo_distributor_locations',
            'name' => 'vo_distributor_locations',
            'label' => __('Locations', THEME_SLUG),
            'type' => 'repeater',
            'layout' => 'block',
            'button_label' => __('Add Location', THEME_SLUG),
            'sub_fields' => [
                [
                    'key' => 'key_vo_distributor_locations_text',
                    'name' => 'text',
                    'label' => __('Locations Text', THEME_SLUG),
                    'type' => 'textarea',
                    'rows' => 4
                ],
                [
                    'key' => 'key_vo_distributor_locations_map',
                    'name' => 'map',
                    'label' => __('Map', THEME_SLUG),
                    'type' => 'google_map',
                ],
            ],
        ],
        [
            'key' => 'key_vo_page_404_tab',
            'name' => '',
            'label' => __('Page 404', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_page_404_text',
            'name' => 'vo_page_404_text',
            'label' => __('404 Text', THEME_SLUG),
            'type' => 'textarea',
        ],
    ],
    'location' => [
        [
            [
                'param' => 'options_page',
                'operator' => '==',
                'value' => 'vo-theme-settings',
            ],
        ],
    ]
];

acf_add_local_field_group($theme_settings);

/**
 * Hero
 * ---------------------------------------------------------------
 */

$hero = [
    'key' => 'key_vo_hero',
    'title' => __('Hero', THEME_SLUG),
    'position' => 'acf_after_title',
    'hide_on_screen' => [
        0 => 'the_content',
    ],
    'location' => [
        [
            [
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'page',
            ],
        ],
    ],
    'fields' => [
        [
            'key' => 'key_vo_hero_content_tab',
            'label' => __('Content', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_hero_show',
            'name' => 'vo_hero_show',
            'label' => __('Show hero', THEME_SLUG),
            'type' => 'true_false',
        ],
        [
            'key' => 'key_vo_hero_title',
            'name' => 'vo_hero_title',
            'label' => __('Title', THEME_SLUG),
            'type' => 'text',
        ],
        [
            'key' => 'key_vo_hero_subtitle',
            'name' => 'vo_hero_subtitle',
            'label' => __('Subtitle', THEME_SLUG),
            'type' => 'text',
        ],
        [
            'key' => 'key_vo_hero_bg_image_tab',
            'label' => __('Background Image', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_hero_bg_image',
            'name' => 'vo_hero_bg_image',
            'label' => __('Background Image', THEME_SLUG),
            'type' => 'image',
        ],
        vo_acf_focal_point_fields('hero'),
        [
            'key' => 'key_vo_hero_button_tab',
            'label' => __('Button', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_hero_add_button',
            'name' => 'vo_hero_add_button',
            'label' => __('Add button?', THEME_SLUG),
            'type' => 'true_false',
        ],
        [
            'key' => 'key_vo_hero_button_text',
            'name' => 'vo_hero_button_text',
            'label' => __('Text', THEME_SLUG),
            'type' => 'text',
        ],
        [
            'key' => 'key_vo_hero_button_link',
            'name' => 'vo_hero_button_link',
            'label' => __('Link', THEME_SLUG),
            'type' => 'page_link',
        ],
        [
            'key' => 'key_vo_hero_link_tab',
            'label' => __('Link', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_hero_add_link',
            'name' => 'vo_hero_add_link',
            'label' => __('Add link?', THEME_SLUG),
            'type' => 'true_false',
        ],
        [
            'key' => 'key_vo_hero_link_text',
            'name' => 'vo_hero_link_text',
            'label' => __('Text', THEME_SLUG),
            'type' => 'text',
        ],
        [
            'key' => 'key_vo_hero_link',
            'name' => 'vo_hero_link',
            'label' => __('Link', THEME_SLUG),
            'type' => 'page_link',
        ],
        [
            'key' => 'key_vo_hero_layout_tab',
            'label' => __('Layout', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_hero_title_size',
            'name' => 'vo_hero_title_size',
            'label' => __('Title size', THEME_SLUG),
            'type' => 'radio',
            'default_value' => 'normal',
            'choices' => [
                'normal' => __('Normal', THEME_SLUG),
                'large'  => __('Large', THEME_SLUG),
            ],
        ],
        [
            'key' => 'key_vo_hero_align_content',
            'name' => 'vo_hero_align_content_horizontal',
            'label' => __('Align Content Horizontal', THEME_SLUG),
            'type' => 'radio',
            'default_value' => 'center',
            'choices' => [
                'left' => __('Left', THEME_SLUG),
                'center'  => __('Center', THEME_SLUG),
            ],
        ],
        [
            'key' => 'key_vo_hero_align_content_vertical',
            'name' => 'vo_hero_align_content_vertical',
            'label' => __('Align Content Vertical', THEME_SLUG),
            'type' => 'radio',
            'default_value' => 'center',
            'choices' => [
                'center'  => __('Center', THEME_SLUG),
                'bottom' => __('Bottom', THEME_SLUG),
            ],
        ],
    ],
];

acf_add_local_field_group($hero);

/**
 * Product
 * ---------------------------------------------------------------
 */

$product = [
    'key' => 'key_vo_product',
    'title' => __('Product Options', THEME_SLUG),
    'position' => 'acf_after_title',
    'hide_on_screen' => [
        0 => 'the_content',
    ],
    'location' => [
        [
            [
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'product',
            ],
        ],
    ],
    'fields' => [
        [
            'key' => 'key_vo_product_content_tab',
            'label' => __('Content', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_product_bg_color',
            'label' => __('Background Color', THEME_SLUG),
            'name' => 'vo_product_bg_color',
            'type' => 'radio',
            'choices' => $colors,
        ],
        [
            'key' => 'key_vo_product_bg_image',
            'label' => __('Background Image', THEME_SLUG),
            'name' => 'vo_product_bg_image',
            'type' => 'image',
        ],
        [
            'key' => 'key_vo_product_tabs_tab',
            'label' => __('Tabs', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_product_tabs',
            'name' => 'vo_product_tabs',
            'label' => __('Tabs', THEME_SLUG),
            'type' => 'repeater',
            'layout' => 'block',
            'button_label' => __('Add Tab', THEME_SLUG),
            'sub_fields' => [
                [
                    'key' => 'key_vo_product_tabs_name',
                    'name' => 'name',
                    'label' => __('Name', THEME_SLUG),
                    'type' => 'text',
                ],
                [
                    'key' => 'key_vo_product_tabs_title',
                    'name' => 'title',
                    'label' => __('Title', THEME_SLUG),
                    'type' => 'text',
                ],
                [
                    'key' => 'key_vo_product_tabs_content',
                    'name' => 'content',
                    'label' => __('Content', THEME_SLUG),
                    'type' => 'wysiwyg',
                ],
            ],
        ],
        [
            'key' => 'key_vo_product_image_tab',
            'label' => __('Images Overwrite', THEME_SLUG),
            'type' => 'tab',
            'placement' => 'left',
        ],
        [
            'key' => 'key_vo_product_image',
            'name' => 'vo_product_image',
            'label' => __('Product images', THEME_SLUG),
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'key_vo_product_image_overview_image',
                    'name' => 'overview_image',
                    'label' => __('Overview Image', THEME_SLUG),
                    'instructions' => __('Only upload an image here if you want to overwrite the default image in the "Product overview" for this product. The default image in the product overview is the "Product image".', THEME_SLUG),
                    'type' => 'image',
                    'wrapper' => [
                        'width' => 50
                    ]
                ],
                [
                    'key' => 'key_vo_product_image_slider_image',
                    'name' => 'slider_image',
                    'label' => __('Slider image', THEME_SLUG),
                    'instructions' => __('Only upload an image here if you want to overwrite the default slider image for this product. The default image in the slider is the "Product image".', THEME_SLUG),
                    'type' => 'image',
                    'wrapper' => [
                        'width' => 50
                    ]
                ],
            ],
        ],
    ],
];

acf_add_local_field_group($product);


/**
 * Page Builder
 */

$page_builder = [
    'key' => 'key_vo_page_builder',
    'title' => __('Page Builder', THEME_SLUG),
    'style' => 'seamless',
    'location' => [
        [
            [
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'page'
            ],
        ],
        [
            [
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'product'
            ],
        ],
    ],
    'fields' => [
        [
            'key' => 'key_vo_page_builder_builder',
            'name' => 'vo_page_builder',
            'label' => __('Page Builder', THEME_SLUG),
            'button_label' => __('New Block', THEME_SLUG),
            'type' => 'flexible_content',
            'layouts' => [
                /**
                 * Text Block
                 */
                [
                    'key' => 'key_page_builder_text',
                    'label' => __('Text', THEME_SLUG),
                    'name' => 'text',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_text_tab_content',
                            'name' => '',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_text_title',
                            'name' => 'title',
                            'label' => __('Title', THEME_SLUG),
                            'instructions' => __('Type &lt;br&gt; to add a line break.', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_text_subtitle',
                            'name' => 'subtitle',
                            'label' => __('Subtitle', THEME_SLUG),
                            'instructions' => __('Type &lt;br&gt; to add a line break.', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_text_content',
                            'name' => 'content',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'wysiwyg',
                        ],
                        [
                            'key' => 'key_page_builder_text_tab_bg',
                            'name' => '',
                            'label' => __('Background', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_text_bg_color',
                            'name' => 'bg_color',
                            'label' => __('Background color', THEME_SLUG),
                            'instructions' => __('Pick a background color.', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'none',
                            'choices' => [
                                'none' => __('None', THEME_SLUG),
                                'white' => __('White', THEME_SLUG),
                                'gray' => __('Gray', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_bg_image',
                            'name' => 'bg_image',
                            'label' => __('Background Image', THEME_SLUG),
                            'instructions' => __('Optional: add a background image to the block.', THEME_SLUG),
                            'type' => 'image',
                        ],
                        vo_acf_focal_point_fields('text'),
                        [
                            'key' => 'key_page_builder_text_image_effect',
                            'name' => 'image_effect',
                            'label' => __('Image Effect', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'none',
                            'choices' => [
                                'none'   => __('No effect', THEME_SLUG),
                                'fade' => __('Fade (add a white fading background on top of the image)', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_tab_layout',
                            'name' => '',
                            'label' => __('Layout', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_text_position',
                            'name' => 'position',
                            'label' => __('Position', THEME_SLUG),
                            'instructions' => __('Pick the position of the text.', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'left',
                            'choices' => [
                                'left'   => __('Left', THEME_SLUG),
                                'center' => __('Center', THEME_SLUG),
                                'right'  => __('Right', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_color',
                            'name' => 'color',
                            'label' => __('Color', THEME_SLUG),
                            'instructions' => __('Pick a text color.', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'black',
                            'choices' => [
                                'black' => __('Black', THEME_SLUG),
                                'white' => __('White', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_text_align',
                            'name' => 'text_align',
                            'label' => __('Text Align', THEME_SLUG),
                            'instructions' => __('Pick the text alignment for this box.', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'left',
                            'choices' => [
                                'left' => __('Left', THEME_SLUG),
                                'center'  => __('Center', THEME_SLUG),
                                'right'  => __('Right', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_spacing',
                            'name' => 'spacing',
                            'label' => __('Spacing', THEME_SLUG),
                            'instructions' => __('Pick the amount of space between the text and the edge of the box.', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'normal',
                            'choices' => [
                                'normal' => __('Normal', THEME_SLUG),
                                'large'  => __('Large', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_column_size',
                            'name' => 'column_size',
                            'label' => __('Column Size', THEME_SLUG),
                            'instructions' => __('Pick the column size for the box (only works for larger screens then mobile).', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'half',
                            'choices' => [
                                'half' => __('Half', THEME_SLUG),
                                'large' => __('Large', THEME_SLUG),
                                'full'  => __('Full', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_title_size',
                            'name' => 'title_size',
                            'label' => __('Title Size', THEME_SLUG),
                            'instructions' => __('Pick the size of the title.', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'normal',
                            'choices' => [
                                'normal' => __('Normal', THEME_SLUG),
                                'large'  => __('Large', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_title_align',
                            'name' => 'title_align',
                            'label' => __('Title Align', THEME_SLUG),
                            'instructions' => __('Pick the title alignment for this box.', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'left',
                            'choices' => [
                                'left' => __('Left', THEME_SLUG),
                                'center'  => __('Center', THEME_SLUG),
                                'right'  => __('Right', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_type',
                            'name' => 'type',
                            'label' => __('Type', THEME_SLUG),
                            'instructions' => __('Select a type', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'text',
                            'choices' => [
                                'text' => __('Text', THEME_SLUG),
                                'text_image' => __('Place image above text on mobile and tablet', THEME_SLUG),
                                'text_hero' => __('Display block as Hero (background image with large spacing)', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_tab_link',
                            'name' => '',
                            'label' => __('Link/Button', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_text_link_message',
                            'name' => 'link_message',
                            'label' => ' ',
                            'type' => 'message',
                            'message' => __('Add a link or button to the bottom of the block.', THEME_SLUG),
                        ],
                        [
                            'key' => 'key_page_builder_text_add_link',
                            'name' => 'add_link',
                            'label' => __('Add link or button?', THEME_SLUG),
                            'type' => 'true_false',
                        ],
                        [
                            'key' => 'key_page_builder_text_link_text',
                            'name' => 'link_text',
                            'label' => __('Text', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_text_link',
                            'name' => 'link',
                            'label' => __('Link', THEME_SLUG),
                            'type' => 'page_link',
                        ],
                        [
                            'key' => 'key_page_builder_text_link_type',
                            'name' => 'link_type',
                            'label' => __('Type', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'link',
                            'choices' => [
                                'link'   => __('Link', THEME_SLUG),
                                'button' => __('Button', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_tab_figure',
                            'name' => '',
                            'label' => __('Figure', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_text_figure_message',
                            'name' => 'figure_message',
                            'label' => ' ',
                            'type' => 'message',
                            'message' => __("Add a Figure to display a graph/image for ELYX/others (CBD purity based on…)", THEME_SLUG),
                        ],
                        [
                            'key' => 'key_page_builder_text_figure_enable',
                            'name' => 'figure_enable',
                            'label' => __('Enable Figure', THEME_SLUG),
                            'type' => 'true_false',
                            'ui' => true
                        ],
                        [
                            'key' => 'key_page_builder_text_figure_figure',
                            'name' => 'figure',
                            'label' => __('Figure', THEME_SLUG),
                            'type' => 'group',
                            'layout' => 'block',
                            'sub_fields' => [
                                [
                                    'key' => 'key_page_builder_text_figure_figure_image',
                                    'name' => 'image',
                                    'label' => __('Image', THEME_SLUG),
                                    'type' => 'image',
                                    'wrapper' => [
                                        'width' => 50
                                    ]
                                ],
                                [
                                    'key' => 'key_page_builder_text_figure_figure_caption',
                                    'name' => 'caption',
                                    'label' => __('Caption', THEME_SLUG),
                                    'type' => 'textarea',
                                    'wrapper' => [
                                        'width' => 50
                                    ]
                                ],
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_text_tab_usps',
                            'name' => '',
                            'label' => __('Usps', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_text_usps_message',
                            'name' => 'usps_message',
                            'label' => ' ',
                            'type' => 'message',
                            'message' => __("Add images for USP's (mobile & desktop) to the bottom of this block.", THEME_SLUG),
                        ],
                        [
                            'key' => 'key_page_builder_text_usps_enable',
                            'name' => 'usps_enable',
                            'label' => __('Enable USP images', THEME_SLUG),
                            'type' => 'true_false',
                            'ui' => true
                        ],
                        [
                            'key' => 'key_page_builder_text_usps_images',
                            'name' => 'usps_images',
                            'label' => __('Images', THEME_SLUG),
                            'type' => 'group',
                            'layout' => 'block',
                            'sub_fields' => [
                                [
                                    'key' => 'key_page_builder_text_usps_images_image_mobile',
                                    'name' => 'mobile',
                                    'label' => __('Mobile', THEME_SLUG),
                                    'type' => 'image',
                                    'wrapper' => [
                                        'width' => 50
                                    ]
                                ],
                                [
                                    'key' => 'key_page_builder_text_usps_images_image_desktop',
                                    'name' => 'desktop',
                                    'label' => __('Desktop', THEME_SLUG),
                                    'type' => 'image',
                                    'wrapper' => [
                                        'width' => 50
                                    ]
                                ],
                            ],
                        ],
                    ],
                ],
                /**
                 * Image Block
                 */
                [
                    'key' => 'key_page_builder_image',
                    'label' => __('Image', THEME_SLUG),
                    'name' => 'image',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_image_tab_image',
                            'name' => '',
                            'label' => __('Image', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_image',
                            'name' => 'image',
                            'label' => __('Image', THEME_SLUG),
                            'type' => 'image',
                        ],
                    ],
                ],
                /**
                 * Image Text
                 */
                [
                    'key' => 'key_page_builder_image_text_blocks',
                    'label' => __('Image Text Blocks', THEME_SLUG),
                    'name' => 'image_text_blocks',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_image_text_blocks_tab_content_top',
                            'label' => __('Content Block Top', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_image_text_blocks_content_top_title',
                            'name' => 'content_top_title',
                            'label' => __('Title', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_image_text_blocks_content_top_download_text',
                            'name' => 'content_top_download_text',
                            'label' => __('Download Text', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_image_text_blocks_content_top_download_file',
                            'name' => 'content_top_download_file',
                            'label' => __('Download File', THEME_SLUG),
                            'type' => 'file',
                        ],
                        [
                            'key' => 'key_page_builder_image_text_blocks_tab_content_bottom',
                            'label' => __('Content Block Bottom', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_image_text_blocks_content_bottom_title',
                            'name' => 'content_bottom_title',
                            'label' => __('Title', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_image_text_blocks_content_bottom_text',
                            'name' => 'content_bottom_text',
                            'label' => __('Text', THEME_SLUG),
                            'type' => 'wysiwyg',
                        ],
                        [
                            'key' => 'key_page_builder_image_text_blocks_background_image_tab',
                            'label' => __('Background Image', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_image_text_blocks_background_image_bg_image',
                            'name' => 'bg_image',
                            'label' => __('Background Image', THEME_SLUG),
                            'type' => 'image',
                        ],
                        vo_acf_focal_point_fields('image_text_blocks'),
                    ],
                ],
                /**
                 * Newsletter Block
                 */
                [
                    'key' => 'key_page_builder_newsletter',
                    'label' => __('Newsletter', THEME_SLUG),
                    'name' => 'newsletter',
                    'display' => 'row',
                    'max' => 1,
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_newsletter_message',
                            'name' => 'message',
                            'label' => ' ',
                            'type' => 'message',
                            'message' => __('This will load the content for the newsletter automatically if it\'s correctly set at the "Theme Settings - Newsletter".', THEME_SLUG),
                        ],
                    ],
                ],
                /**
                 * Two Blocks
                 */
                [
                    'key' => 'key_page_builder_two_blocks',
                    'label' => __('Two Blocks', THEME_SLUG),
                    'name' => 'two-blocks',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_two_blocks_tab_content',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_title',
                            'name' => 'title',
                            'label' => __('Title', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_content',
                            'name' => 'content',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'wysiwyg',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_tab_image',
                            'label' => __('Image', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_image',
                            'name' => 'image',
                            'label' => __('Image', THEME_SLUG),
                            'type' => 'image',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_tab_link',
                            'name' => '',
                            'label' => __('Link/Button', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_link_message',
                            'name' => 'link_message',
                            'label' => ' ',
                            'type' => 'message',
                            'message' => __('Add a link or button to the bottom of the block.', THEME_SLUG),
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_add_link',
                            'name' => 'add_link',
                            'label' => __('Add link or button?', THEME_SLUG),
                            'type' => 'true_false',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_link_text',
                            'name' => 'link_text',
                            'label' => __('Text', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_link',
                            'name' => 'link',
                            'label' => __('Link', THEME_SLUG),
                            'type' => 'page_link',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_link_type',
                            'name' => 'link_type',
                            'label' => __('Type', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'link',
                            'choices' => [
                                'link'   => __('Link', THEME_SLUG),
                                'button' => __('Button', THEME_SLUG),
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_tab_layout',
                            'name' => '',
                            'label' => __('Layout', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_image_right',
                            'name' => 'image_right',
                            'label' => __('Image on the right', THEME_SLUG),
                            'instructions' => __('By default, the image is shown on the left.', THEME_SLUG),
                            'type' => 'true_false',
                        ],
                        [
                            'key' => 'key_page_builder_two_blocks_background_pattern',
                            'name' => 'background_pattern',
                            'label' => __('Enable background pattern', THEME_SLUG),
                            'type' => 'true_false',
                        ],
                    ],
                ],
                /**
                 * Slider
                 */
                [
                    'key' => 'key_page_builder_slider',
                    'label' => __('Slider', THEME_SLUG),
                    'name' => 'slider',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_slider_tab_content',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_slider_title',
                            'name' => 'title',
                            'label' => __('Title', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_slider_slides',
                            'name' => 'slides',
                            'label' => __('Slides', THEME_SLUG),
                            'type' => 'repeater',
                            'layout' => 'block',
                            'min' => 1,
                            'button_label' => __('Add Slider Item', THEME_SLUG),
                            'sub_fields' => [
                                [
                                    'key' => 'key_page_builder_slider_slides_product_id',
                                    'name' => 'product_id',
                                    'label' => __('Select Product', THEME_SLUG),
                                    'type' => 'post_object',
                                    'post_type' => 'product',
                                    'multiple' => 0,
                                    'return_format' => 'id',
                                    'required' => 1
                                ],
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_slider_tab_layout',
                            'name' => '',
                            'label' => __('Layout', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_slider_align_title',
                            'name' => 'align_title',
                            'label' => __('Align Title', THEME_SLUG),
                            'type' => 'radio',
                            'default' => 'left',
                            'choices' => [
                                'left'   => __('Left', THEME_SLUG),
                                'center' => __('Center', THEME_SLUG),
                                'right'  => __('Right', THEME_SLUG),
                            ],
                        ],
                    ],
                ],
                /**
                 * Product
                 */
                [
                    'key' => 'key_page_builder_product',
                    'label' => __('Product', THEME_SLUG),
                    'name' => 'product',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_product_tab_content',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_product_title',
                            'name' => 'title',
                            'label' => __('Title', THEME_SLUG),
                            'instructions' => __('Type &lt;br&gt; to add a line break.', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_product_product_id',
                            'name' => 'product_id',
                            'label' => __('Select Product', THEME_SLUG),
                            'type' => 'post_object',
                            'post_type' => 'product',
                            'multiple' => 0,
                            'return_format' => 'id',
                            'required' => 1
                        ],
                    ],
                ],
                /**
                 * Products
                 */
                [
                    'key' => 'key_page_builder_products',
                    'label' => __('Products', THEME_SLUG),
                    'name' => 'products',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_products_tab_content',
                            'name' => '',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_products_type',
                            'name' => 'type',
                            'label' => __('Type', THEME_SLUG),
                            'type' => 'radio',
                            'choices' => [
                                'normal' => __('Normal', THEME_SLUG),
                                'wholesale' => __('Wholesale', THEME_SLUG),
                            ]
                        ],
                        [
                            'key' => 'key_page_builder_products_category',
                            'name' => 'category',
                            'label' => __('Category', THEME_SLUG),
                            'instructions' => __('Optional. When no category is chosen, all products will be shown.', THEME_SLUG),
                            'type' => 'checkbox',
                            'choices' => []
                        ],
                        [
                            'key' => 'key_page_builder_products_title',
                            'name' => 'title',
                            'label' => __('Title', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_products_subtitle',
                            'name' => 'subtitle',
                            'label' => __('Subtitle', THEME_SLUG),
                            'type' => 'textarea',
                            'rows' => 4,
                        ],
                        [
                            'key' => 'key_page_builder_products_wholesale_message',
                            'name' => 'wholesale_message',
                            'label' => ' ',
                            'message' => __('The text below will be shown on a wholesale block if the user does not have a wholesale account.', THEME_SLUG),
                            'type' => 'message',
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'key_page_builder_products_type',
                                        'operator' => '==',
                                        'value' => 'wholesale'
                                    ]
                                ]
                            ]
                        ],
                        [
                            'key' => 'key_page_builder_products_wholesale_title',
                            'name' => 'wholesale_title',
                            'label' => __('Wholesale Title', THEME_SLUG),
                            'type' => 'text',
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'key_page_builder_products_type',
                                        'operator' => '==',
                                        'value' => 'wholesale'
                                    ]
                                ]
                            ]
                        ],
                        [
                            'key' => 'key_page_builder_products_wholesale_text',
                            'name' => 'wholesale_text',
                            'label' => __('Wholesale Text', THEME_SLUG),
                            'type' => 'wysiwyg',
                            'rows' => 4,
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'key_page_builder_products_type',
                                        'operator' => '==',
                                        'value' => 'wholesale'
                                    ]
                                ]
                            ]
                        ],
                        [
                            'key' => 'key_page_builder_products_tab_bg_image',
                            'label' => __('Background Image', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_products_bg_image',
                            'name' => 'bg_image',
                            'label' => __('Background Image', THEME_SLUG),
                            'type' => 'image',
                        ],
                        vo_acf_focal_point_fields('products'),
                    ],
                ],

                /**
                 * Products List
                 */
                [
                    'key' => 'key_page_builder_products_list',
                    'label' => __('Products list', THEME_SLUG),
                    'name' => 'products_list',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_products_list_tab_content',
                            'name' => '',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_products_list_type',
                            'name' => 'type',
                            'label' => __('Type', THEME_SLUG),
                            'type' => 'radio',
                            'choices' => [
                                'normal' => __('Normal', THEME_SLUG),
                                'wholesale' => __('Wholesale', THEME_SLUG),
                            ]
                        ],
                        [
                            'key' => 'key_page_builder_products_list_category',
                            'name' => 'category',
                            'label' => __('Category', THEME_SLUG),
                            'instructions' => __('Optional. When no category is chosen, all products will be shown.', THEME_SLUG),
                            'type' => 'checkbox',
                            'choices' => []
                        ],
                        [
                            'key' => 'key_page_builder_products_list_title',
                            'name' => 'title',
                            'label' => __('Title', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_products_list_subtitle',
                            'name' => 'subtitle',
                            'label' => __('Subtitle', THEME_SLUG),
                            'type' => 'textarea',
                            'rows' => 4,
                        ],
                        [
                            'key' => 'key_page_builder_products_list_wholesale_message',
                            'name' => 'wholesale_message',
                            'label' => ' ',
                            'message' => __('The text below will be shown on a wholesale block if the user does not have a wholesale account.', THEME_SLUG),
                            'type' => 'message',
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'key_page_builder_products_list_type',
                                        'operator' => '==',
                                        'value' => 'wholesale'
                                    ]
                                ]
                            ]
                        ],
                        [
                            'key' => 'key_page_builder_products_list_wholesale_title',
                            'name' => 'wholesale_title',
                            'label' => __('Wholesale Title', THEME_SLUG),
                            'type' => 'text',
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'key_page_builder_products_list_type',
                                        'operator' => '==',
                                        'value' => 'wholesale'
                                    ]
                                ]
                            ]
                        ],
                        [
                            'key' => 'key_page_builder_products_list_wholesale_text',
                            'name' => 'wholesale_text',
                            'label' => __('Wholesale Text', THEME_SLUG),
                            'type' => 'wysiwyg',
                            'rows' => 4,
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'key_page_builder_products_list_type',
                                        'operator' => '==',
                                        'value' => 'wholesale'
                                    ]
                                ]
                            ]
                        ],
                        [
                            'key' => 'key_page_builder_products_list_tab_bg_image',
                            'label' => __('Background Image', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_products_list_bg_image',
                            'name' => 'bg_image',
                            'label' => __('Background Image', THEME_SLUG),
                            'type' => 'image',
                        ],
                        vo_acf_focal_point_fields('products_list'),
                    ],
                ],

                /**
                 * Contact
                 */
                [
                    'key' => 'key_page_builder_contact',
                    'label' => __('Contact', THEME_SLUG),
                    'name' => 'contact',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_contact_tab_content',
                            'name' => '',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_contact_header',
                            'name' => 'header',
                            'label' => __('Header', THEME_SLUG),
                            'type' => 'group',
                            'layout' => 'block',
                            'sub_fields' => [
                                [
                                    'key' => 'key_page_builder_contact_header_title',
                                    'name' => 'title',
                                    'label' => __('Title', THEME_SLUG),
                                    'type' => 'text',
                                ],
                                [
                                    'key' => 'key_page_builder_contact_header_subtitle',
                                    'name' => 'subtitle',
                                    'label' => __('Subtitle', THEME_SLUG),
                                    'type' => 'text',
                                ],
                            ],
                        ],
                        [
                            'key' => 'key_page_builder_contact_block',
                            'name' => 'block',
                            'label' => __('Block', THEME_SLUG),
                            'type' => 'group',
                            'layout' => 'block',
                            'sub_fields' => [
                                [
                                    'key' => 'key_page_builder_contact_block_text',
                                    'name' => 'text',
                                    'label' => __('Text', THEME_SLUG),
                                    'type' => 'textarea',
                                    'rows' => 4,
                                ],
                                [
                                    'key' => 'key_page_builder_contact_block_button',
                                    'name' => 'button',
                                    'label' => __('Button', THEME_SLUG),
                                    'type' => 'link',
                                ],
                            ],
                        ],
                    ],
                ],

                /**
                 * Accordion
                 */
                [
                    'key' => 'key_page_builder_accordion',
                    'name' => 'accordion',
                    'label' => __('Accordion', THEME_SLUG),
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_accordion_tab_content',
                            'label' => __('Content', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_accordion_title',
                            'name' => 'title',
                            'label' => __('Title', THEME_SLUG),
                            'type' => 'text',
                        ],
                        [
                            'key' => 'key_page_builder_accordion_items',
                            'name' => 'items',
                            'label' => __('Accordion Items', THEME_SLUG),
                            'type' => 'repeater',
                            'layout' => 'block',
                            'button_label' => __('Add Accordion Item', THEME_SLUG),
                            'sub_fields' => [
                                [
                                    'key' => 'key_page_builder_accordion_items_title',
                                    'name' => 'title',
                                    'label' => __('Title', THEME_SLUG),
                                    'type' => 'text',
                                ],
                                [
                                    'key' => 'key_page_builder_accordion_items_content',
                                    'name' => 'content',
                                    'label' => __('Content', THEME_SLUG),
                                    'type' => 'wysiwyg',
                                ],
                            ],
                        ],
                    ]
                ],


                /**
                 * Stack Blocks START
                 */
                [
                    'key' => 'key_page_builder_stack_blocks_start',
                    'label' => __('Stack Blocks Start', THEME_SLUG),
                    'name' => 'stack_blocks_start',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_stack_blocks_start_instructions',
                            'name' => '',
                            'label' => __('Instructions', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_stack_blocks_start_instructions_message',
                            'name' => 'instructions_message',
                            'label' => __('Message', THEME_SLUG),
                            'type' => 'message',
                            'message' => __("All blocks under this 'Stack Blocks Start' will be stacked for specific style elements (gradient). Make sure to close the stacked blocks with the block 'Stack Blocks End'.", THEME_SLUG),
                        ],
                    ],
                ],
                /**
                 * Stack Blocks END
                 */
                [
                    'key' => 'key_page_builder_stack_blocks_end',
                    'label' => __('Stack Blocks End', THEME_SLUG),
                    'name' => 'stack_blocks_end',
                    'display' => 'row',
                    'sub_fields' => [
                        [
                            'key' => 'key_page_builder_stack_blocks_end_instructions',
                            'name' => '',
                            'label' => __('Instructions', THEME_SLUG),
                            'type' => 'tab',
                            'placement' => 'left',
                        ],
                        [
                            'key' => 'key_page_builder_stack_blocks_end_instructions_message',
                            'name' => 'instructions_message',
                            'label' => __('Message', THEME_SLUG),
                            'type' => 'message',
                            'message' => __("All blocks above this 'Stack Blocks End' will be stacked for specific style elements (gradient). Make sure to start the stacked blocks with the block 'Stack Blocks Start'.", THEME_SLUG),
                        ],
                    ],
                ],
            ],
        ],
    ],
];

acf_add_local_field_group($page_builder);
