<?php

/**
 * add_action() or remove_action() calls.
 *
 * Please read the documentation at <https://developer.wordpress.org/reference/functions/add_action/>.
 * ----------------------------------------------------------------------------
 */

remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'rest_output_link_wp_head', 10);
remove_action('template_redirect', 'rest_output_link_header', 11);
remove_action('xmlrpc_rsd_apis', 'rest_output_rsd');

add_action('init', 'vo_acf_redirect');
add_action('init', 'vo_disable_wp_emojicons');
add_action('wp', 'vo_remove_woocommerce_items');
add_action('admin_menu', 'vo_change_admin_menu_order');
add_action('save_post', 'vo_add_base64_hero_thumb', 20);

add_action('woocommerce_admin_order_data_after_shipping_address', 'vo_shipping_fields_display_admin_order_meta', 10, 1);
add_action('woocommerce_admin_order_data_after_billing_address', 'vo_billing_fields_display_admin_order_meta', 10, 1);

if (!empty ($GLOBALS['sitepress'])) {
    add_action('wp_head', 'vo_remove_wpml_generator_tag', 0);
}


/**
 * Custom functions called by add_action() function.
 * ----------------------------------------------------------------------------
 */

/**
 * Redirect ACF pages to Admin dashboard
 */
function vo_acf_redirect() {
    if (!is_admin()) {
        return;
    }

    if (isset($_GET['post_type']) && $_GET['post_type'] === 'acf-field-group') {
        wp_redirect(admin_url());
        die();
    }
}

/**
 * Disable WordPress Emojicons
 */
function vo_disable_wp_emojicons() {
    remove_action('admin_print_styles', 'print_emoji_styles');
    remove_action('wp_head', 'print_emoji_detection_script', 7);
    remove_action('admin_print_scripts', 'print_emoji_detection_script');
    remove_action('wp_print_styles', 'print_emoji_styles');
    remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
    remove_filter('the_content_feed', 'wp_staticize_emoji');
    remove_filter('comment_text_rss', 'wp_staticize_emoji');
    add_filter('tiny_mce_plugins', 'vo_disable_emojicons_tinymce');
}

/**
 * Disable WordPress Emojicons from TinyMCE
 * @param $plugins
 * @return array
 */
function vo_disable_emojicons_tinymce($plugins) {
    $output = array();
    if (is_array($plugins)) {
        $output = array_diff($plugins, array('wpemoji'));
    }
    return $output;
}

/**
 * Remove WPML generator tag
 */
function vo_remove_wpml_generator_tag() {
    remove_action(current_filter(), array($GLOBALS['sitepress'], 'meta_generator_tag'));
}

/**
 * Change admin menu order
 */
function vo_change_admin_menu_order() {
    global $menu;
    $newMenu = array();
    foreach ($menu as $position => $data) {
        // Array key '2' is the URL of the menu item
        switch ($data[2]) {
            case 'admin.php?page=savvii_dashboard' :
                $newMenu[999] = $data;
                unset($menu[$position]);
                break;
        }
    }
    $menu = $menu + $newMenu;
}

/**
 * Adds a fallback for the document title tag
 */
if (!function_exists('_wp_render_title_tag')) :
    function vo_theme_slug_render_title() {
?>
        <title><?php wp_title('|', true, 'right'); ?></title>
<?php
    }
    add_action('wp_head', 'vo_theme_slug_render_title');
endif;

/**
 * Add a Base64 encoded version of the hero image thumbnail
 * to the post meta of the post/page being updated.
 *
 * @param int $post_id ID of the post that's being updated.
 */
function vo_add_base64_hero_thumb($post_id) {
    // If this is just a revision, don't do anything.
    if (wp_is_post_revision($post_id)) {
        return;
    }

    // If this isn't a regular page or post, don't proceed.
    $post_type = get_post_type($post_id);

    if ($post_type != 'page' && $post_type != 'post') {
        return;
    }

    // Get the ID of the hero image.
    $thumb_id = (int) get_post_meta($post_id, 'vo_hero_bg_image', true);

    // Check if the post has a hero image.
    if (!empty($thumb_id)) {
        // Get the thumbnail version of the hero image.
        $thumb = wp_get_attachment_image_src($thumb_id, 'vo-mini-thumb');
        // Get the MIME type of the hero image.
        $thumb_mime = get_post_mime_type($thumb_id);
        // Pass the hero image URL and MIME type into our helper function.
        $thumb_base64 = vo_get_data_uri($thumb[0], $thumb_mime);

        if (!empty($thumb_base64)) {
            update_post_meta($post_id, 'vo_hero_thumb_base64', $thumb_base64);
        }
    } else {
        // If there's no hero image, delete any old values.
        delete_post_meta($post_id, 'vo_hero_thumb_base64');
    }
}

/**
 * Remove the default WooCommerce breadcrumbs on single product pages.
 */
function vo_remove_woocommerce_items() {
    if (is_product()) {
        remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
    }
}

function vo_shipping_fields_display_admin_order_meta($order) {
    echo '<strong>' . __('House number') . ':</strong> ' . get_post_meta($order->id, '_shipping_house_number', true) . '<br>';
    echo '<strong>' . __('Addition') . ':</strong> ' . get_post_meta($order->id, '_shipping_addition', true) . '';
}

function vo_billing_fields_display_admin_order_meta($order) {
    echo '<strong>' . __('House number') . ':</strong> ' . get_post_meta($order->id, '_billing_house_number', true) . '<br>';
    echo '<strong>' . __('Addition') . ':</strong> ' . get_post_meta($order->id, '_billing_addition', true) . '';
}
