<!DOCTYPE html>
<!--[if IE 7]><html class="ie ie7" <?php language_attributes(); ?>><![endif]-->
<!--[if IE 8]><html class="ie ie8" <?php language_attributes(); ?>><![endif]-->
<!--[if !(IE 7) | !(IE 8) ]><!--><html <?php language_attributes(); ?>><!--<![endif]-->
    <head>
        <meta charset="<?php bloginfo('charset'); ?>" />
        <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1" />

        <link rel="apple-touch-icon-precomposed" sizes="57x57" href="<?php echo THEME_URI_IMAGES; ?>/favicon/apple-touch-icon-57x57.png" />
        <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo THEME_URI_IMAGES; ?>/favicon/apple-touch-icon-114x114.png" />
        <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo THEME_URI_IMAGES; ?>/favicon/apple-touch-icon-72x72.png" />
        <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo THEME_URI_IMAGES; ?>/favicon/apple-touch-icon-144x144.png" />
        <link rel="apple-touch-icon-precomposed" sizes="60x60" href="<?php echo THEME_URI_IMAGES; ?>/favicon/apple-touch-icon-60x60.png" />
        <link rel="apple-touch-icon-precomposed" sizes="120x120" href="<?php echo THEME_URI_IMAGES; ?>/favicon/apple-touch-icon-120x120.png" />
        <link rel="apple-touch-icon-precomposed" sizes="76x76" href="<?php echo THEME_URI_IMAGES; ?>/favicon/apple-touch-icon-76x76.png" />
        <link rel="apple-touch-icon-precomposed" sizes="152x152" href="<?php echo THEME_URI_IMAGES; ?>/favicon/apple-touch-icon-152x152.png" />
        <link rel="icon" type="image/png" href="<?php echo THEME_URI_IMAGES; ?>/favicon/favicon-196x196.png" sizes="196x196" />
        <link rel="icon" type="image/png" href="<?php echo THEME_URI_IMAGES; ?>/favicon/favicon-96x96.png" sizes="96x96" />
        <link rel="icon" type="image/png" href="<?php echo THEME_URI_IMAGES; ?>/favicon/favicon-32x32.png" sizes="32x32" />
        <link rel="icon" type="image/png" href="<?php echo THEME_URI_IMAGES; ?>/favicon/favicon-16x16.png" sizes="16x16" />
        <link rel="icon" type="image/png" href="<?php echo THEME_URI_IMAGES; ?>/favicon/favicon-128.png" sizes="128x128" />
        <meta name="application-name" content="&nbsp;"/>
        <meta name="msapplication-TileColor" content="#FFFFFF" />
		<meta name="google-site-verification" content="YKWhTH5mVmYIFJ4RxGwiQJzHzZYQcY5GZK6sFU5Z4sw" />
        <meta name="msapplication-TileImage" content="<?php echo THEME_URI_IMAGES; ?>/favicon/mstile-144x144.png" />
        <meta name="msapplication-square70x70logo" content="<?php echo THEME_URI_IMAGES; ?>/favicon/mstile-70x70.png" />
        <meta name="msapplication-square150x150logo" content="<?php echo THEME_URI_IMAGES; ?>/favicon/mstile-150x150.png" />
        <meta name="msapplication-wide310x150logo" content="<?php echo THEME_URI_IMAGES; ?>/favicon/mstile-310x150.png" />
        <meta name="msapplication-square310x310logo" content="<?php echo THEME_URI_IMAGES; ?>/favicon/mstile-310x310.png" />
        <link rel="icon" type="image/x-icon" href="<?php echo THEME_URI_IMAGES; ?>/favicon/favicon.ico" />
        <link rel="shortcut icon" type="image/x-icon" href="<?php echo THEME_URI_IMAGES; ?>/favicon/favicon.ico" />
        <link rel="icon" type="image/x-icon" href="<?php echo THEME_URI_IMAGES; ?>/favicon/favicon.ico" />
        <link rel="shortcut icon" type="image/x-icon" href="<?php echo THEME_URI_IMAGES; ?>/favicon/favicon.ico" />

        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

        <?php wp_head(); ?>

    </head>

    <body <?php body_class(); ?>>
        <?php
        if (function_exists('gtm4wp_the_gtm_tag')) {
            gtm4wp_the_gtm_tag();
        }
        $account_url = get_permalink(get_option('woocommerce_myaccount_page_id'));
        ?>

        <?php get_template_part('template-parts/age-verification'); ?>

        <div class="container">
            <header class="header" data-animated data-animation="slide-down">
                <div class="header__inner">
                    <div class="row align-justify">
                        <div class="column header__column header__column--logo shrink">
                            <?php if (is_front_page()) : ?>
                                <h1 class="logo">
                                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                                        <img src="<?php echo THEME_URI_SVG; ?>/logo.svg" alt="<?php bloginfo('name'); ?>">
                                    </a>
                                </h1>
                            <?php else : ?>
                                <h2 class="logo">
                                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                                        <img src="<?php echo THEME_URI_SVG; ?>/logo.svg" alt="<?php bloginfo('name'); ?>">
                                    </a>
                                </h2>
                            <?php endif; ?>
                        </div>

                        <div class="column header__column header__column--menu">
                            <?php if (has_nav_menu('primary')) : ?>
                                <nav class="header__navigation show-for-large">
                                    <?php
                                    wp_nav_menu(array(
                                        'theme_location' => 'primary',
                                        'menu_class' => 'header__menu',
                                        'container' => false
                                    ));
                                    ?>
                                </nav>
                            <?php endif; ?>
                            <?php if (has_nav_menu('mobile')) : ?>
                                <button class="header__navigation-mobile-trigger hide-for-large">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </button>
                                <nav class="header__navigation-mobile">
                                    <div class="hide-for-medium">
                                        <?php
                                        wp_nav_menu(array(
                                            'theme_location' => 'mobile',
                                            'menu_class' => 'header__mobile-menu',
                                            'container' => false
                                        ));
                                        ?>
                                    </div>
                                    <div class="hide-for-small-only hide-for-large">
                                        <div class="row medium-collapse">
                                            <div class="column medium-4">
                                                <?php
                                                wp_nav_menu(array(
                                                    'theme_location' => 'tablet-1-3',
                                                    'menu_class' => 'header__mobile-menu',
                                                    'container' => false
                                                ));
                                                ?>
                                            </div>
                                            <div class="column medium-4">
                                                <?php
                                                wp_nav_menu(array(
                                                    'theme_location' => 'tablet-2-3',
                                                    'menu_class' => 'header__mobile-menu',
                                                    'container' => false
                                                ));
                                                ?>
                                            </div>
                                            <div class="column medium-4">
                                                <?php
                                                wp_nav_menu(array(
                                                    'theme_location' => 'tablet-3-3',
                                                    'menu_class' => 'header__mobile-menu',
                                                    'container' => false
                                                ));
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </nav>
                            <?php endif; ?>
                        </div>
                        <div class="column header__column header__column--cart shrink">
                            <div class="header__cart-content-count hide-for-large">
                                <?php
                                if (array_key_exists('woocommerce', $GLOBALS)) :
                                    global $woocommerce;
                                    $cart_url = wc_get_cart_url();

                                    if (!empty($cart_url)) :
                                        $cart_count = WC()->cart->get_cart_contents_count();
                                        ?>
                                        <div class="counter"
                                             data-cart-count="<?php echo esc_attr($cart_count); ?>"
                                             data-cart-url="<?php echo esc_url($cart_url); ?>">
                                            <a href="<?php echo esc_url($cart_url); ?>" class="header__link <?php if ($cart_count > 0) : ?>header__link--counter<?php endif; ?>">
                                        <span class="header__link-content--bag">
                                            <?php get_template_part(THEME_SVG, 'shopping-bag.svg'); ?>
                                        </span>
                                                <span class="header__link-content--counter">
                                            <?php esc_html_e($cart_count); ?>
                                        </span>
                                            </a>
                                        </div>
                                        <?php
                                    endif;
                                endif;
                                ?>
                            </div>
                            <div class="header__items show-for-large">
                                <?php if (!empty($account_url)) : ?>
                                    <a href="<?php echo esc_url($account_url); ?>" class="header__link header__link--login <?php if (is_account_page()) : ?>is-active<?php endif; ?>">
                                        <?php
                                        if (is_user_logged_in()) {
                                            esc_html_e('My account', THEME_SLUG);
                                        } else {
                                            esc_html_e('Log In', THEME_SLUG);
                                        }
                                        ?>
                                    </a>
                                <?php endif; ?>
                                <?php
                                if (array_key_exists('woocommerce', $GLOBALS)) :
                                    global $woocommerce;
                                    $cart_url = wc_get_cart_url();

                                    if (!empty($cart_url)) :
                                        $cart_count = WC()->cart->get_cart_contents_count();
                                        ?>
                                        <div class="header__cart-content-count">
                                            <div class="counter"
                                                 data-cart-count="<?php echo esc_attr($cart_count); ?>"
                                                 data-cart-url="<?php echo esc_url($cart_url); ?>">
                                                <a href="<?php echo esc_url($cart_url); ?>" class="header__link <?php if ($cart_count > 0) : ?>header__link--counter<?php endif; ?> <?php if (is_cart()) : ?>is-active<?php endif; ?>">
                                            <span class="header__link-content--bag">
                                                <?php get_template_part(THEME_SVG, 'shopping-bag.svg'); ?>
                                            </span>
                                                    <span class="header__link-content--counter">
                                                <?php esc_html_e($cart_count); ?>
                                            </span>
                                                </a>
                                            </div>
                                        </div>
                                        <?php
                                    endif;
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <?php get_template_part('template-parts/hero'); ?>
