<?php

class VO_Theme {

    function __construct() {
        $this->themeConstants();
        $this->themeActions();
    }

    function themeConstants() {
        define( 'THEME_SLUG', get_template() );
        define( 'THEME_DIR', get_template_directory() );
        define( 'THEME_DIR_ASSETS', THEME_DIR . '/assets' );
        define( 'THEME_DIR_CSS', THEME_DIR_ASSETS . '/css' );
        define( 'THEME_DIR_JS', THEME_DIR_ASSETS . '/js' );
        define( 'THEME_DIR_COMPONENTS', THEME_DIR_ASSETS . '/components' );
        define( 'THEME_DIR_IMAGES', THEME_DIR_ASSETS . '/images' );
        define( 'THEME_DIR_SVG', THEME_DIR_ASSETS . '/svg' );
        define( 'THEME_DIR_INCLUDES', THEME_DIR . '/includes' );
        define( 'THEME_DIR_VENDOR', THEME_DIR . '/vendor' );
        define( 'THEME_URI', get_template_directory_uri() );
        define( 'THEME_URI_ASSETS', THEME_URI . '/assets' );
        define( 'THEME_URI_CSS', THEME_URI_ASSETS . '/css' );
        define( 'THEME_URI_JS', THEME_URI_ASSETS . '/js' );
        define( 'THEME_URI_COMPONENTS', THEME_URI_ASSETS . '/components' );
        define( 'THEME_URI_IMAGES', THEME_URI_ASSETS . '/images' );
        define( 'THEME_URI_SVG', THEME_URI_ASSETS . '/svg' );
        define( 'THEME_URI_INCLUDES', THEME_URI . '/includes' );
        define( 'THEME_URI_VENDOR', THEME_URI . '/vendor' );
        define( 'THEME_SVG', 'assets/svg/inline' );
    }

    function themeActions() {
        add_action( 'after_setup_theme', array( $this, 'themeSetup' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'themeStylesAndScripts' ), 999 );
        add_action( 'login_enqueue_scripts', array( $this, 'loginStylesAndScripts' ), 999 );
        add_action( 'widgets_init', array( $this, 'themeSidebars' ) );
    }

    function themeSetup() {
        $this->themeSupports();
        $this->themeIncludes();
        $this->themeMenus();
    }

    function themeSupports() {
        load_theme_textdomain( THEME_SLUG, THEME_DIR . '/languages' );
        load_theme_textdomain( THEME_SLUG, THEME_DIR . '/languages/admin' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );

        // Enable support for Post Thumbnails on posts and pages.
        add_theme_support( 'post-thumbnails' );
        // set_post_thumbnail_size(300, 300, true);

        add_image_size( '1x1', 800, 800, true );
        add_image_size( 'vo-fullwidth', 1920, 9999 );
        add_image_size( 'vo-half', 950, 9999 );
        add_image_size( 'vo-mini-thumb', 15, 9999 );
        // add_image_size('4x3', 800, 600, true);

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support( 'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption'
        ) );

        /**
         * Add support for WooCommerce but remove support for unnecessary
         * features.
         */
        add_theme_support( 'woocommerce' );
        remove_theme_support( 'wc-product-gallery-zoom' );
        remove_theme_support( 'wc-product-gallery-lightbox' );
        remove_theme_support( 'wc-product-gallery-slider' );
    }

    function themeIncludes() {
        require_once( THEME_DIR_INCLUDES . '/filters.php' );
        require_once( THEME_DIR_INCLUDES . '/actions.php' );
        require_once( THEME_DIR_INCLUDES . '/helpers.php' );
        require_once( THEME_DIR_INCLUDES . '/shortcodes.php' );
        require_once( THEME_DIR_INCLUDES . '/widgets.php' );
        require_once( THEME_DIR_INCLUDES . '/ajax.php' );
        require_once( THEME_DIR_INCLUDES . '/admin/custom-post-types.php' );
        require_once( THEME_DIR_INCLUDES . '/admin/taxonomies.php' );

        if ( is_admin() ) {
            // Include ACF Pro
            require_once( THEME_DIR_VENDOR . '/advanced-custom-fields-pro/acf.php' );
            if ( class_exists( 'acf' ) ) {
                require_once( THEME_DIR_INCLUDES . '/admin/meta-boxes.php' );
                require_once( THEME_DIR_INCLUDES . '/admin/pages.php' );
            }
        }
    }

    function themeMenus() {
        register_nav_menu( 'primary', __( 'Primary Menu', THEME_SLUG ) );
        register_nav_menu( 'explore', __( 'Explore Menu', THEME_SLUG ) );
        register_nav_menu( 'account', __( 'Account Menu', THEME_SLUG ) );
        register_nav_menu( 'follow-us', __( 'Follow Us Menu', THEME_SLUG ) );
        register_nav_menu( 'legal', __( 'Legal Menu', THEME_SLUG ) );
        register_nav_menu( 'mobile', __( 'Mobile Menu', THEME_SLUG ) );
        register_nav_menu( 'tablet-1-3', __( 'Tablet Menu 1/3', THEME_SLUG ) );
        register_nav_menu( 'tablet-2-3', __( 'Tablet Menu 2/3', THEME_SLUG ) );
        register_nav_menu( 'tablet-3-3', __( 'Tablet Menu 3/3', THEME_SLUG ) );
    }

    function themeStylesAndScripts() {
        // Deregisters
        wp_deregister_script( 'jquery' );

        // Stylesheets
        wp_enqueue_style( 'vo.stylesheet', get_stylesheet_uri(), false, filemtime( THEME_DIR . '/style.css' ) );

        // JavaScripts
        wp_enqueue_script( 'jquery', THEME_URI_COMPONENTS . '/jquery/dist/jquery.min.js', false, false, false );
        wp_enqueue_script( 'jquery.migrate', THEME_URI_COMPONENTS . '/jquery-migrate/jquery-migrate.min.js', array( 'jquery' ), false, false );
        wp_enqueue_script( 'foundation', THEME_URI_COMPONENTS . '/foundation/dist/js/foundation.min.js', array( 'jquery' ), false, true );
        wp_enqueue_script( 'intersection-observer-polyfill', 'https://cdn.polyfill.io/v2/polyfill.js?features=IntersectionObserver', array(), false, true );

        if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
            wp_enqueue_script( 'comment-reply' );
        }

        global $pageNr;
        wp_enqueue_script( 'vo.app', THEME_URI_JS . '/app.min.js', array(
            'jquery',
            'foundation'
        ), filemtime( THEME_DIR_JS . '/app.min.js' ), true );
        wp_localize_script( 'vo.app', 'customData', array(
            'ajaxURL'      => admin_url( 'admin-ajax.php' ),
            'ajaxSecurity' => wp_create_nonce( 'vo-ajax' ),
            'pageNr'       => ( $pageNr ) ? $pageNr : 1,
            'priceDisplay' => array(
                'decimals'       => wc_get_price_decimals(),
                'separator'      => wc_get_price_decimal_separator(),
                'currency'       => get_woocommerce_currency(),
                'currencySymbol' => get_woocommerce_currency_symbol()
            )
        ) );
    }

    function loginStylesAndScripts() {
        wp_enqueue_style( 'vo.login', THEME_URI_CSS . '/login.css', false, filemtime( THEME_DIR_CSS . '/login.css' ) );
    }

    function themeSidebars() {
        register_sidebar( array(
            'name'          => __( 'Primary Sidebar', THEME_SLUG ),
            'id'            => 'sidebar-primary',
            'description'   => __( 'Primary sidebar', THEME_SLUG ),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<h3 class="widget__title">',
            'after_title'   => '</h3>',
        ) );
    }

}

add_filter( 'style_loader_src', 'rtm_remove_ver_css_js', 9999, 2 );
add_filter( 'script_loader_src', 'rtm_remove_ver_css_js', 9999, 2 );

function rtm_remove_ver_css_js( $src, $handle ) {
    $handles_with_version = [ 'style' ]; // <-- Adjust to your needs!

    if ( strpos( $src, 'ver=' ) && ! in_array( $handle, $handles_with_version, true ) ) {
        $src = remove_query_arg( 'ver', $src );
    }

    return $src;
}


add_filter( 'woocommerce_login_redirect', 'rtm_wc_user_redirect', 10, 2 );
/**
 * Redirect users to custom URL based on their role after login
 *
 * @param string $redirect
 * @param object $user
 *
 * @return string
 */
function rtm_wc_user_redirect( $redirect, $user ) {
    $wholesale_roles = array_keys( maybe_unserialize( get_option( 'wwp_options_registered_custom_roles' ) ) );


    // Get the first of all the roles assigned to the user
    $role      = $user->roles[0];

    if ( array_search( $role, $wholesale_roles ) !== false ) {

        // Use the option from the WWLC plugin to get the login redirect page
        if ( function_exists( 'wwlc_get_url_of_page_option' ) ) {
            return wwlc_get_url_of_page_option( 'wwlc_general_login_redirect_page' );
        }
    }

    return $redirect;
}


new VO_Theme();
