        </div><!-- .container -->

        <?php
        $footer_header_title = get_option('options_vo_footer_header_title');
        $footer_header_text = get_option('options_vo_footer_header_text');
        $footer_copyright = get_option('options_vo_footer_copyright');
        $footer_credits = get_option('options_vo_footer_credits');
        $menus = [
            'explore',
            'account',
            'follow-us',
            'legal'
        ];
        ?>
        <footer class="footer footer--page">

            <div class="footer__container">
                <div class="row">
                    <div class="column small-12 large-4 footer__header">
                        <div class="footer__logos">
                            <div class="footer__logo footer__logo--stacked">
                                <?php get_template_part(THEME_SVG, 'logo-stacked.svg'); ?>
                            </div>
                            <div class="footer__logo footer__logo--line">
                                <?php get_template_part(THEME_SVG, 'logo.svg'); ?>
                            </div>
                        </div>
                        <div class="footer__content">
                            <?php if (!empty($footer_header_title)) : ?>
                                <div class="footer__title">
                                    <?php echo esc_html($footer_header_title); ?>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($footer_header_text)) : ?>
                                <div class="footer__text">
                                    <?php echo apply_filters('the_content', wp_kses_post($footer_header_text)); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php if (!empty($menus)) : ?>
                        <div class="column small-12 large-8 footer__navigations">
                            <div class="row">
                                <?php foreach ($menus as $menu) : ?>
                                    <?php if (has_nav_menu($menu)) :
                                        $menu_title = wp_get_nav_menu_object($menu)->name;
                                        ?>
                                        <div class="column small-6 medium-3 footer__navigation footer__navigation--<?php echo esc_attr($menu); ?>">
                                            <nav>
                                                <?php if (!empty($menu_title)) : ?>
                                                    <h4 class="footer__navigation-title"><?php echo esc_html($menu_title); ?></h4>
                                                <?php endif; ?>
                                                <?php
                                                wp_nav_menu(array(
                                                    'theme_location' => $menu,
                                                    'menu_class' => 'footer__menu',
                                                    'container' => false
                                                ));
                                                ?>
                                            </nav>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <?php if (!empty($footer_copyright)) : ?>
                <div class="footer__copyright">
                    <div class="row">
                        <div class="column small-12">
                            <div class="row align-center">
                                <?php if (!empty($footer_credits)) : ?>
                                    <div class="column small-12 medium-6">
                                        <div class="footer__credits">
                                            <a class="footer__credits-link" href="<?php echo esc_url('https://bravoure.nl/'); ?>" target="_blank">
                                                <span class="footer__credits-text"><?php echo esc_html($footer_credits); ?></span>
                                                <span class="footer__credits-icon"><?php get_template_part(THEME_SVG, 'icon-bravoure.svg'); ?></span>
                                            </a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="column small-12 <?php if (!empty($footer_credits)) : ?>medium-6<?php endif; ?>">
                                    <div class="footer__copyright-text">
                                        <?php echo '&copy; ' . date('Y') . ' ' . esc_html($footer_copyright); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

        </footer>

        <?php wp_footer(); ?>
    </body>
</html>
