<?php
include_once 'google-fonts.php';

if (!function_exists ('add_action')) {
		header('Status: 403 Forbidden');
		header('HTTP/1.1 403 Forbidden');
		exit();
}
global $qode_options_elision;
$qode_options_elision  = get_option('qode_options_elision');

class Qode_Theme_Options {

	//constructor of class
	function __construct() {
		add_action('admin_menu', array(&$this, 'qode_admin_menu'));
		add_action('admin_init', array(&$this, 'register_qode_theme_settings'));
	}

	function init_qode_theme_options() {
		global $qode_options_elision;
		if(isset($qode_options_elision['reset_to_defaults'])){ 
			if( $qode_options_elision['reset_to_defaults'] == 'yes' ) delete_option( "qode_options_elision");
		}
		if (! get_option("qode_options_elision")) {
			add_option( "qode_options_elision",
				array( // intitialize the 'qode_options_elision' array with the following key => value pairs:
					"reset_to_defaults" => '',
					"number_of_chars" => 45,
					"first_color" => '',
					"second_color" => '',
					"third_color" => '',
					"fourth_color" => '',
					"background_color" => '',
					"background_color_box" => '',
					"highlight_color" => '',
					"selection_color" => '',
					"favicon_image" => QODE_ROOT."/img/favicon.ico",
					"background_image" => '',
					"patern_background_image" => '',
					"google_fonts" => '-1',
					"page_transitions" => '0',
					"boxed" => 'no',
					"loading_animation" => 'off',
					"qode_like" => 'on',
					"portfolio_qode_like" => 'on',
					"loading_image" => '',
					"smooth_scroll" => 'yes',
					"responsiveness" => 'yes',
					"show_back_button" => 'yes',
					"elements_animation_on_touch" => 'no',
					"parallax_speed" => '1',
					"parallax_minheight" => '400',
					"parallax_onoff" => 'on',
					"internal_no_ajax_links" => '',
					"custom_css" => '',
					"custom_js" => '',
					"meta_keywords" => '',
					"meta_description" => '',
					"disable_qode_seo" => 'no',
					"h1_color" => '',
					"h1_google_fonts" => '-1',
					"h1_fontsize" => '',
					"h1_lineheight" => '',
					"h1_fontstyle" => '',
					"h1_fontweight" => '',
					"h2_color" => '',
					"h2_google_fonts" => '-1',
					"h2_fontsize" => '',
					"h2_lineheight" => '',
					"h2_fontstyle" => '',
					"h2_fontweight" => '',
					"h3_color" => '',
					"h3_google_fonts" => '-1',
					"h3_fontsize" => '',
					"h3_lineheight" => '',
					"h3_fontstyle" => '',
					"h3_fontweight" => '',
					"h4_color" => '',
					"h4_google_fonts" => '-1',
					"h4_fontsize" => '',
					"h4_lineheight" => '',
					"h4_fontstyle" => '',
					"h4_fontweight" => '',
					"h5_color" => '',
					"h5_google_fonts" => '-1',
					"h5_fontsize" => '',
					"h5_lineheight" => '',
					"h5_fontstyle" => '',
					"h5_fontweight" => '',
					"h6_color" => '',
					"h6_google_fonts" => '-1',
					"h6_fontsize" => '',
					"h6_lineheight" => '',
					"h6_fontstyle" => '',
					"h6_fontweight" => '',
					"h6_letterspacing" => '',
					"text_color" => '',
					"text_google_fonts" => '-1',
					"text_fontsize" => '',
					"text_lineheight" => '',
					"text_fontstyle" => '',
					"text_fontweight" => '',
					"text_margin" => '',
					"link_color" => '',
					"link_hovercolor" => '',
					"link_fontstyle" => '',
					"link_fontweight" => '',
					"link_fontdecoration" => '',
					"page_title_color" => '',
					"page_title_google_fonts" => '-1',
					"page_title_fontsize" => '',
					"page_title_lineheight" => '',
					"page_title_fontstyle" => '',
					"page_title_fontweight" => '',
					"menu_color" => '',
					"menu_hovercolor" => '',
					"menu_google_fonts" => '-1',
					"menu_fontsize" => '',
					"menu_lineheight" => '',
					"menu_fontstyle" => '',
					"menu_fontweight" => '',
					"header_in_grid" => 'yes',
					"header_top_area" => 'no',
					"header_sticky" => 'yes',
					"header_style" => '',
					"menu_in_center" => 'no',
					"header_top_background_color" => '',
					"header_background_color" => '',
					"header_background_color_scroll" => '',
					"header_background_transparency_initial" => '',
					"header_background_transparency_scroll" => '',
					"logo_animation" => "no",
					"logo_image" => QODE_ROOT."/img/logo.png",
					"logo_image_dark" => QODE_ROOT."/img/logo_black.png",
					"logo_image_sticky" => QODE_ROOT."/img/logo_black.png",
					"center_logo_image" => 'no',
					"header_height" => '',
					"header_height_scroll" => '',
					"scroll_amount_for_sticky" => '',
					"dropdown_background_color" => '',
					"dropdown_background_transparency" => '',
					"dropdown_color" => '',
					"dropdown_hovercolor" => '',
					"dropdown_google_fonts" => '-1',
					"dropdown_fontsize" => '',
					"dropdown_lineheight" => '',
					"dropdown_fontstyle" => '',
					"dropdown_fontweight" => '',
					"dropdown_color_thirdlvl" => '',
					"dropdown_hovercolor_thirdlvl" => '',
					"dropdown_google_fonts_thirdlvl" => '-1',
					"dropdown_fontsize_thirdlvl" => '',
					"dropdown_lineheight_thirdlvl" => '',
					"dropdown_fontstyle_thirdlvl" => '',
					"dropdown_fontweight_thirdlvl" => '',
					"sticky_color" => '',
					"sticky_hovercolor" => '',
					"sticky_google_fonts" => '-1',
					"sticky_fontsizel" => '',
					"sticky_lineheight" => '',
					"sticky_fontstyle" => '',
					"sticky_fontweight" => '',
					"mobile_color" => '',
					"mobile_hovercolor" => '',
					"mobile_google_fonts" => '-1',
					"mobile_fontsize" => '',
					"mobile_lineheight" => '',
					"mobile_fontstyle" => '',
					"mobile_fontweight" => '',
					"mobile_separator_color" => '',
					"mobile_bottom_background_color" => '',
					"mobile_top_background_color" => '',
					"mobile_letter_spacing" => '',
					"header_separator_thickness" => '',
					"title_style" => '1',
					"title_background_color" => '',
					"responsive_title_image" => '',
					"fixed_title_image" => '',
					"title_image" => '',
					"title_height" => '',
					"page_title_position" => '0',
					"footer_in_grid" => 'no',
					"footer_text" => 'yes',
					"show_footer_top" => 'yes',
					"footer_top_columns" => '4',
					"footer_top_title_color" => '',
					"footer_top_text_color" => '',
					"footer_link_color" => '',
					"footer_link_hover_color" => '',
					"footer_top_background_color" => '',
					"footer_bottom_text_color" => '',
					"footer_bottom_background_color" => '',
					"enable_side_area" => 'yes',
					"side_area_title" => '',
					"side_area_background_color" => '',
					"side_area_text_color" => '',
					"side_area_title_color" => '',
					"separator_thickness" => '',
					"separator_topmargin" => '',
					"separator_bottommargin" => '',
					"button_title_color" => '',
					"button_title_hovercolor" => '',
					"button_title_google_fonts" => '-1',
					"button_title_fontsize" => '',
					"button_title_lineheight" => '',
					"button_title_fontstyle" => '',
					"button_title_fontweight" => '',
					"button_size" => '',
					"button_backgroundcolor" => '',
					"button_backgroundcolor_hover" => '',
					"message_title_color" => '',
					"message_title_google_fonts" => '-1',
					"message_title_fontsize" => '',
					"message_title_lineheight" => '',
					"message_title_fontstyle" => '',
					"message_title_fontweight" => '',
					"message_backgroundcolor" => '',
					"message_bordercolor" => '',
					"message_icon_color" => '',
					"message_icon_fontsize" => '',
					"blockquote_font_color" => '',
					"blockquote_border_color" => '',
					"blockquote_background_color" => '',
					"social_icon_backgroundcolor" => '',
					"smooth_background_color" => '',
					"smooth_bar_color" => '',
					"portfolio_style" => '1',
					"lightbox_single_project" => 'no',
					"portfolio_columns_number" => '2',
					"portfolio_single_sidebar" => 'default',
					"portfolio_single_sidebar_custom_display" => '',
					"portfolio_single_slug" => '',
					"blog_quote_link_box_color" => '',
					"pagination" => '1',
					"blog_style" => '1',
					"category_blog_sidebar" => 'default',
					"blog_hide_comments" => 'no',
					"blog_page_range" => '',
					"number_of_chars" => '45',
					"number_of_chars_masonry" => '',
					"number_of_chars_large_image" => '',
					"blog_single_sidebar" => 'default',
					"blog_single_sidebar_custom_display" => '',
					"blog_author_info" => 'no',
					"receive_mail" => '',
					"enable_contact_form" => 'no',
					"hide_contact_form_website" => 'no',
					"email_from" => '',
					"email_subject" => '',
					"use_recaptcha" => 'no',
					"recaptcha_public_key" => '',
					"recaptcha_private_key" => '',
					"contact_heading_above" => '',
					"enable_google_map" => 'no',
					"google_maps_pin_image" => QODE_ROOT."/img/pin.png",
					"google_maps_address" => '',
					"google_maps_address2" => '',
					"google_maps_address3" => '',
					"google_maps_address4" => '',
					"google_maps_address5" => '',
					"google_maps_zoom" => '12',
					"google_maps_height" => '750',
					"google_maps_style" => 'yes',
					"google_maps_color" => '',
					"google_maps_scroll_wheel" => 'no',
					"google_maps_iframe" => '',
					"404_title" => '',
					"404_subtitle" => '',
					"404_text" => '',
					"404_backlabel" => '',
					"enable_social_share" => 'no',
					"enable_facebook_share" => 'no',
					"enable_twitter_share" => 'no',
					"enable_google_plus" => 'no',
                    "enable_linkedin" => 'no',
                    "enable_tumblr" => 'no',
                    "enable_pinterest" => 'no',
                    "enable_vk" => 'no',
                    "facebook_icon" => '',
                    "twitter_icon" => '',
                    "google_plus_icon" => '',
                    "linkedin_icon" => '',
                    "tumblr_icon" => '',
                    "pinterest_icon" => '',
                    "vk_icon" => '',
					"twitter_via" => ''
				)
			);
		} 
	}

	function register_qode_theme_settings() {
	    register_setting( 'qode_options_elision_page', 'qode_options_elision', array(&$this, 'validate_options') );
	    // register_setting( 'qode_options_elision_page', array(&$this, 'another_of_my_options') );
	}
	//extend the admin menu
	function qode_admin_menu() {
		$this->init_qode_theme_options();
		//Add the Qode options page to the Themes' menu
		$this->pagehook = add_menu_page('Qode Theme', esc_html__('Qode Options', 'elision-core'), 'manage_options', 'qode_options_elision_page', array(&$this, 'qode_generate_options_page'));
		add_action('load-'.$this->pagehook, array(&$this, 'on_load_page'));
	}

	function on_load_page() {
		
		// load javascripts to allow drag/drop, expand/collapse and hide/show of boxes
		add_meta_box('qode-general-options-metabox', esc_html__('Options', 'elision-core'), array(&$this, 'general_options_contentbox'), $this->pagehook, 'normal', 'core');
	
	}

	function qode_generate_options_page() {

		// global screen column value to be able to have a sidebar in WordPress 2.8+
		global $screen_layout_columns, $qode_options_elision;

		/* Messages to display saved and reset */
		if ( isset( $_REQUEST['settings-updated'] ) || isset( $_REQUEST['updated'] ) ) {
			echo '<div id="message" class="updated fade"><p><strong>' . esc_html__( 'Settings saved.', 'elision-core' ) . '</strong></p></div>';
			
			do_action( 'elision_qode_action_after_theme_option_save' );
		}
		?>
		<div id="qode-metaboxes-general" class="wrap">
		    <div style="float:left; padding:10px 10px 10px 0;"></div>
		    <?php $current_theme = wp_get_theme(); ?>
		    <h2 style="padding-top:25px;"><?php echo esc_attr($current_theme->get('Name')).' - '.esc_html__('Theme Options - Version', 'elision-core' ).' '.$current_theme->get('Version'); ?></h2>

		    <form method="post" action="options.php">
<?php			settings_fields( 'qode_options_elision_page' ); // Checks that the user can update options and also redirect the user back to the correct admin page (this form).
			$options = get_option('qode_options_elision');
			// Allows the 'closed' state of metaboxes to be remembered
			wp_nonce_field('closedpostboxes', 'closedpostboxesnonce', false );
			// Allows the order of metaboxes to be remembered
			wp_nonce_field('meta-box-order', 'meta-box-order-nonce', false ); ?>

			<div id="poststuff" class="metabox-holder<?php echo 2 == $screen_layout_columns ? ' has-right-sidebar' : ''; ?>">
				<div id="post-body" class="has-sidebar">
					<div id="post-body-content" class="has-sidebar-content">
<?php					    do_meta_boxes($this->pagehook, 'normal', $options); ?>
<?php					    do_meta_boxes($this->pagehook, 'additional', $options); ?>
					    <fieldset style="margin:2px 0 0;"><legend class="screen-reader-text"><span><?php esc_attr_e('Reset to defaults', 'elision-core') ?></span></legend>
						<label for="reset_to_defaults">
						    <input name="qode_options_elision[reset_to_defaults]" type="checkbox" id="reset_to_defaults" value="yes" />
						    <?php esc_attr_e('Reset to defaults', 'elision-core') ?>
						</label>
					    </fieldset>
					    <p class="submit">
						<input type="hidden" id="qode_submit" value="1" name="qode_submit" />
						<input class="button-primary" type="submit" name="submit" value="<?php esc_attr_e('Save Changes', 'elision-core') ?>" />
					    </p>
					</div>
				</div>
				<br class="clear"/>
			</div>
		    </form>
		</div>
		<script type="text/javascript">
		    //<![CDATA[
		    jQuery(document).ready( function($) {
			    // close postboxes that should be closed
			    $('.if-js-closed').removeClass('if-js-closed').addClass('closed');
			    // postboxes setup
			    postboxes.add_postbox_toggles('<?php echo elision_qode_get_module_part($this->pagehook); ?>');
		    });
		    //]]>
		</script>
<?php	}

	/**
	 * Validate user input
	 *
	 * @param array $input, an array of user input
	 * @return array Return an input array of sanitized input
	 */
	function validate_options( $input ) {
	global $qode_options_elision;
		$input['number_of_chars'] = is_numeric( $input['number_of_chars'] ) ? absint($input['number_of_chars']) : $qode_options_elision['number_of_chars'];
		return $input;
	}
      


	/**************************************************************************************/
	/**** Below you will find the callback method for each of the registered metaboxes ****/
	/**************************************************************************************/

	function general_options_contentbox( $options ) {
		global $fontArrays;
	?>
		
		<div class="sections">
			<h3><?php esc_html_e( 'Global options', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('First main color', 'elision-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['first_color']){ echo 'background-color:'.esc_attr($options['first_color'] ).';'; } ?>"></div></div>
								<input name="qode_options_elision[first_color]" type="text" value="<?php if ($options['first_color']) { echo esc_attr($options['first_color']); } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Default first main color', 'elision-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #eb005d;" title="#eb005d"></span></div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Second main color', 'elision-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['second_color']){ echo 'background-color:'.esc_attr($options['second_color']).';'; } ?>"></div></div>
								<input name="qode_options_elision[second_color]" type="text" value="<?php if ($options['second_color']) { echo esc_attr($options['second_color']); } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Default second main color', 'elision-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; border: 1px solid #ededed; background-color: #f6f6f6;" title="#f6f6f6"></span></div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Third main color', 'elision-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['third_color']){ echo 'background-color:'.esc_attr($options['third_color']).';'; } ?>"></div></div>
								<input name="qode_options_elision[third_color]" type="text" value="<?php if(isset($options['third_color'])){ if ($options['third_color']) { echo esc_attr($options['third_color']); } } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Default third main color', 'elision-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; border: 1px solid #ededed; background-color: #ffffff;" title="#ffffff"></span></div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Fourth main color', 'elision-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['fourth_color']){ echo 'background-color:'.esc_attr($options['fourth_color']).';'; } ?>"></div></div>
								<input name="qode_options_elision[fourth_color]" type="text" value="<?php if(isset($options['fourth_color'])){ if ($options['fourth_color']) { echo esc_attr($options['fourth_color']); } } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Default fourth main color', 'elision-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #000000;" title="#000000"></span></div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Background color (content)', 'elision-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['background_color']){ echo 'background-color:'.esc_attr($options['background_color']).';'; } ?>"></div></div>
								<input name="qode_options_elision[background_color]" type="text" value="<?php if ($options['background_color']) { echo esc_attr($options['background_color']); } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Default background color', 'elision-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; border: 1px solid #e0dede; background-color: #fff;" title="#fff"></span></div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Background color (body)', 'elision-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['background_color_box']){ echo 'background-color:'.esc_attr($options['background_color_box']).';'; } ?>"></div></div>
								<input name="qode_options_elision[background_color_box]" type="text" value="<?php if (isset($options['background_color_box'])) { echo esc_attr($options['background_color_box']); } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Default boxed background color', 'elision-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; border: 1px solid #e0dede; background-color: #f6f6f6;" title="#f6f6f6"></span></div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Highlight color', 'elision-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['highlight_color']){ echo 'background-color:'.esc_attr($options['highlight_color']).';'; } ?>"></div></div>
								<input name="qode_options_elision[highlight_color]" type="text"  value="<?php if ($options['highlight_color']) { echo esc_attr($options['highlight_color']); } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Default highlight color', 'elision-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #eb005d;" title="#eb005d"></span></div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Selection color', 'elision-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['selection_color']){ echo 'background-color:'.esc_attr($options['selection_color']).';'; } ?>"></div></div>
								<input name="qode_options_elision[selection_color]" type="text"  value="<?php if ($options['selection_color']) { echo esc_attr($options['selection_color']); } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Default selection color', 'elision-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #eb005d;" title="#eb005d"></span></div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Background image', 'elision-core'); ?></td>
							<td>	
								<div class="inline" style="width: 600px;">
								<input type="text" id="background_image" name="qode_options_elision[background_image]" class="background_image" value="<?php if (isset($options['background_image'])) { echo esc_attr($options['background_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Pattern background image', 'elision-core'); ?></td>
							<td>	
								<div class="inline" style="width: 600px;">
								<input type="text" id="pattern_background_image" name="qode_options_elision[pattern_background_image]" class="pattern_background_image" value="<?php if (isset($options['pattern_background_image'])) { echo esc_attr($options['pattern_background_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Favicon image', 'elision-core'); ?></td>
							<td>	
								<div class="inline" style="width: 600px;">
								<input type="text" id="favicon_image" name="qode_options_elision[favicon_image]" class="favicon_image" value="<?php if ($options['favicon_image']) { echo esc_attr($options['favicon_image']); } else { echo QODE_ROOT."/img/favicon.ico"; } ?>" size="70">
								<input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
								</div>
							</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Google fonts', 'elision-core'); ?></td>
								<td>
							<select name="qode_options_elision[google_fonts]">
							<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
							<?php foreach($fontArrays as $fontArray) { ?> 
								<option <?php if ($options['google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
							<?php } ?>
								
							</select>
							<?php esc_html_e('Choose Font', 'elision-core'); ?>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Page transition', 'elision-core'); ?></td>
								<td>
							<select name="qode_options_elision[page_transitions]">
								<option <?php if ($options['page_transitions'] == 0) { echo "selected='selected'"; } ?> value="0"><?php esc_html_e( 'No animation', 'elision-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Up/Down', 'elision-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Fade', 'elision-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Up/Down (In) / Fade (Out)', 'elision-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e( 'Left/Right', 'elision-core' ); ?></option>
							</select>
							<?php esc_html_e('In order for animation to work properly, you must choose "Post name" in permalinks settings', 'elision-core'); ?>
								</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Boxed', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[boxed]">
									<option <?php if(isset($options['boxed'])){ $boxed = $options['boxed']; if ($boxed == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['boxed'])){ $boxed = $options['boxed']; if ($boxed == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Loading animation', 'elision-core'); ?></td>
								<td>
									<select name="qode_options_elision[loading_animation]">
										<option <?php if (isset($options['loading_animation'])){ $loading_animation = $options['loading_animation']; if ($loading_animation == 'on') { echo "selected='selected'"; } } ?> value="on"><?php esc_html_e( 'On', 'elision-core' ); ?></option>
										<option <?php if (isset($options['loading_animation'])){ $loading_animation = $options['loading_animation']; if ($loading_animation == 'off') { echo "selected='selected'"; } } ?> value="off"><?php esc_html_e( 'Off', 'elision-core' ); ?></option>
									</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Loading image', 'elision-core'); ?></td>
							<td>	
								<div class="inline" style="width: 600px;">
								<input type="text" id="loading_image" name="qode_options_elision[loading_image]" class="loading_image" value="<?php if (isset($options['loading_image']) && $options['loading_image'] != "") { echo esc_attr($options['loading_image']); } else { echo ""; } ?>" size="70">
								<input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Smooth scroll', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[smooth_scroll]">
									<option <?php if(isset($options['smooth_scroll'])){ $smooth_scroll = $options['smooth_scroll']; if ($smooth_scroll == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
                                    <option <?php if(isset($options['smooth_scroll'])){ $smooth_scroll = $options['smooth_scroll']; if ($smooth_scroll == 'no_chrome_opera') { echo "selected='selected'"; } }  ?> value="no_chrome_opera"><?php esc_html_e( 'No (Chrome/Opera fix active)', 'elision-core' ); ?></option>
									<option <?php if(isset($options['smooth_scroll'])){ $smooth_scroll = $options['smooth_scroll']; if ($smooth_scroll == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
									<option <?php if(isset($options['smooth_scroll'])){ $smooth_scroll = $options['smooth_scroll']; if ($smooth_scroll == 'yes_not_ios') { echo "selected='selected'"; } } ?> value="yes_not_ios"><?php esc_html_e( 'Yes (but not on Mac devices)', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Responsiveness', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[responsiveness]">
									<option <?php if(isset($options['responsiveness'])){ $responsiveness = $options['responsiveness']; if ($responsiveness == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
									<option <?php if(isset($options['responsiveness'])){ $responsiveness = $options['responsiveness']; if ($responsiveness == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Show back button', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[show_back_button]">
									<option <?php if(isset($options['show_back_button'])){ $show_back_button = $options['show_back_button']; if ($show_back_button == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['show_back_button'])){ $show_back_button = $options['show_back_button']; if ($show_back_button == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Elements animation on mobile/touch devices', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[elements_animation_on_touch]">
									<option <?php if(isset($options['elements_animation_on_touch'])){ $elements_animation_on_touch = $options['elements_animation_on_touch']; if ($elements_animation_on_touch == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['elements_animation_on_touch'])){ $elements_animation_on_touch = $options['elements_animation_on_touch']; if ($elements_animation_on_touch == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Google Analytics Account ID', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[google_analytics_code]" type="text" value="<?php if (isset($options['google_analytics_code'])) { echo esc_attr($options['google_analytics_code']); } ?>" size="63" maxlength="500" />
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Google Maps API key', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[google_maps_api_key]" type="text" value="<?php if (isset($options['google_maps_api_key'])) { echo esc_attr($options['google_maps_api_key']); } ?>" size="63" maxlength="500" />
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('List of internal URLs loaded without AJAX (separated with comma)', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="internal_no_ajax_links" name="qode_options_elision[internal_no_ajax_links]" cols="60" rows="5"><?php if (isset($options['internal_no_ajax_links'])) { echo esc_attr($options['internal_no_ajax_links']); } ?></textarea>
								</div>
								
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('Custom css', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="custom_css" name="qode_options_elision[custom_css]" cols="60" rows="5"><?php if ($options['custom_css']) { echo esc_attr($options['custom_css']); } ?></textarea>
								</div>
								
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('Custom js', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="custom_js" name="qode_options_elision[custom_js]" cols="60" rows="5"><?php if ($options['custom_js']) { echo esc_attr($options['custom_js']); } ?></textarea>
								</div><br/>
								<?php esc_html_e('jQuery selector is "$j" because of the conflict mode', 'elision-core'); ?>
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('Meta Keywords', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="meta_keywords" name="qode_options_elision[meta_keywords]" cols="60" rows="5"><?php if ($options['meta_keywords']) { echo esc_attr($options['meta_keywords']); } ?></textarea>
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('Meta Description', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="meta_description" name="qode_options_elision[meta_description]" cols="60" rows="5"><?php if ($options['meta_description']) { echo esc_attr($options['meta_description']); } ?></textarea>
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Disable Qode SEO', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[disable_qode_seo]">
									<option <?php if(isset($options['disable_qode_seo'])){ $disable_qode_seo = $options['disable_qode_seo']; if ($disable_qode_seo == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['disable_qode_seo'])){ $disable_qode_seo = $options['disable_qode_seo']; if ($disable_qode_seo == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'General font options', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Headings', 'elision-core' ); ?></h2></td></tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H1 style', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h1_color']){ echo 'background-color:'.esc_attr($options['h1_color']).';'; } ?>"></div></div>
										<input name="qode_options_elision[h1_color]" type="text" value="<?php if ($options['h1_color']) { echo esc_attr($options['h1_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'elision-core'); ?>
										<select name="qode_options_elision[h1_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h1_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h1_fontsize]" type="text" value="<?php if ($options['h1_fontsize']) { echo esc_attr($options['h1_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h1_lineheight]" type="text" value="<?php if ($options['h1_lineheight']) { echo esc_attr($options['h1_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[h1_fontstyle]">
											<option <?php if ($options['h1_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h1_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if ($options['h1_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[h1_fontweight]">
											<option <?php if ($options['h1_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h1_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H2 style', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h2_color']){ echo 'background-color:'.esc_attr($options['h2_color']).';'; } ?>"></div></div>
										<input name="qode_options_elision[h2_color]" type="text" value="<?php if ($options['h2_color']) { echo esc_attr($options['h2_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'elision-core'); ?>
										<select name="qode_options_elision[h2_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h2_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h2_fontsize]" type="text" value="<?php if ($options['h2_fontsize']) { echo esc_attr($options['h2_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h2_lineheight]" type="text" value="<?php if ($options['h2_lineheight']) { echo esc_attr($options['h2_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[h2_fontstyle]">
											<option <?php if ($options['h2_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h2_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if ($options['h2_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[h2_fontweight]">
											<option <?php if ($options['h2_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h2_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H3 style', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h3_color']){ echo 'background-color:'.esc_attr($options['h3_color'], 'qode').';'; } ?>"></div></div>
										<input name="qode_options_elision[h3_color]" type="text" value="<?php if ($options['h3_color']) { echo esc_attr($options['h3_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'elision-core'); ?>
										<select name="qode_options_elision[h3_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h3_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h3_fontsize]" type="text" value="<?php if ($options['h3_fontsize']) { echo esc_attr($options['h3_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h3_lineheight]" type="text" value="<?php if ($options['h3_lineheight']) { echo esc_attr($options['h3_lineheight'], 'qode'); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[h3_fontstyle]">
											<option <?php if ($options['h3_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h3_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if ($options['h3_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[h3_fontweight]">
											<option <?php if ($options['h3_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h3_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H4 style', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h4_color']){ echo 'background-color:'.esc_attr($options['h4_color'], 'qode').';'; } ?>"></div></div>
										<input name="qode_options_elision[h4_color]" type="text" value="<?php if ($options['h4_color']) { echo esc_attr($options['h4_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'elision-core'); ?>
										<select name="qode_options_elision[h4_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h4_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h4_fontsize]" type="text" value="<?php if ($options['h4_fontsize']) { echo esc_attr($options['h4_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h4_lineheight]" type="text" value="<?php if ($options['h4_lineheight']) { echo esc_attr($options['h4_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[h4_fontstyle]">
											<option <?php if ($options['h4_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h4_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if ($options['h4_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[h4_fontweight]">
											<option <?php if ($options['h4_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h4_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H5 style', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h5_color']){ echo 'background-color:'.esc_attr($options['h5_color']).';'; } ?>"></div></div>
										<input name="qode_options_elision[h5_color]" type="text" value="<?php if ($options['h5_color']) { echo esc_attr($options['h5_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'elision-core'); ?>
										<select name="qode_options_elision[h5_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h5_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h5_fontsize]" type="text" value="<?php if ($options['h5_fontsize']) { echo esc_attr($options['h5_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h5_lineheight]" type="text" value="<?php if ($options['h5_lineheight']) { echo esc_attr($options['h5_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[h5_fontstyle]">
											<option <?php if ($options['h5_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h5_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if ($options['h5_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[h5_fontweight]">
											<option <?php if ($options['h5_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h5_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H6 style', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h6_color']){ echo 'background-color:'.esc_attr($options['h6_color']).';'; } ?>"></div></div>
										<input name="qode_options_elision[h6_color]" type="text" value="<?php if ($options['h6_color']) { echo esc_attr($options['h6_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'elision-core'); ?>
										<select name="qode_options_elision[h6_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h6_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h6_fontsize]" type="text" value="<?php if ($options['h6_fontsize']) { echo esc_attr($options['h6_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[h6_lineheight]" type="text" value="<?php if ($options['h6_lineheight']) { echo esc_attr($options['h6_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[h6_fontstyle]">
											<option <?php if ($options['h6_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h6_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if ($options['h6_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[h6_fontweight]">
											<option <?php if ($options['h6_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h6_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Letter spacing', 'elision-core'); ?>
										<input name="qode_options_elision[h6_letterspacing]" type="text" value="<?php if (isset($options['h6_letterspacing']) && $options['h6_letterspacing']) { echo esc_attr($options['h6_letterspacing']); } ?>" size="10" maxlength="10" />
									</div>
								</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Text', 'elision-core' ); ?></h2></td></tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Text style', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['text_color']){ echo 'background-color:'.esc_attr($options['text_color']).';'; } ?>"></div></div>
										<input name="qode_options_elision[text_color]" type="text" value="<?php if ($options['text_color']) { echo esc_attr($options['text_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'elision-core'); ?>
										<select name="qode_options_elision[text_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['text_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[text_fontsize]" type="text" value="<?php if ($options['text_fontsize']) { echo esc_attr($options['text_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[text_lineheight]" type="text" value="<?php if ($options['text_lineheight']) { echo esc_attr($options['text_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[text_fontstyle]">
											<option <?php if ($options['text_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['text_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if ($options['text_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[text_fontweight]">
											<option <?php if ($options['text_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['text_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Top/Bottom margin (px)', 'elision-core'); ?>
										<input name="qode_options_elision[text_margin]" type="text" value="<?php if (isset($options['text_margin'])) { echo esc_attr($options['text_margin']); } ?>" size="10" maxlength="10" />
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Link style', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['link_color']){ echo 'background-color:'.esc_attr($options['link_color']).';'; } ?>"></div></div>
										<input name="qode_options_elision[link_color]" type="text" value="<?php if ($options['link_color']) { echo esc_attr($options['link_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Hover color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['link_hovercolor']){ echo 'background-color:'.esc_attr($options['link_hovercolor']).';'; } ?>"></div></div>
										<input name="qode_options_elision[link_hovercolor]" type="text" value="<?php if ($options['link_hovercolor']) { echo esc_attr($options['link_hovercolor']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[link_fontstyle]">
											<option <?php if ($options['link_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['link_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if ($options['link_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[link_fontweight]">
											<option <?php if ($options['link_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['link_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font decoration', 'elision-core'); ?>
										<select name="qode_options_elision[link_fontdecoration]">
											<option <?php if ($options['link_fontdecoration'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['link_fontdecoration'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'none', 'elision-core' ); ?></option>
											<option <?php if ($options['link_fontdecoration'] == "bold") { echo "selected='selected'"; } ?> value="underline"><?php esc_html_e( 'underline', 'elision-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Page title', 'elision-core' ); ?></h2></td></tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Page title style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['page_title_color']){ echo 'background-color:'.esc_attr($options['page_title_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[page_title_color]" type="text" value="<?php if ($options['page_title_color']) { echo esc_attr($options['page_title_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'elision-core'); ?>
									<select name="qode_options_elision[page_title_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['page_title_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font size (px)', 'elision-core'); ?>
									<input name="qode_options_elision[page_title_fontsize]" type="text" value="<?php if ($options['page_title_fontsize']) { echo esc_attr($options['page_title_fontsize']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Line height (px)', 'elision-core'); ?>
									<input name="qode_options_elision[page_title_lineheight]" type="text" value="<?php if ($options['page_title_lineheight']) { echo esc_attr($options['page_title_lineheight']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font style', 'elision-core'); ?>
									<select name="qode_options_elision[page_title_fontstyle]">
										<option <?php if ($options['page_title_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['page_title_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
										
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font weight', 'elision-core'); ?>
									<select name="qode_options_elision[page_title_fontweight]">
										<option <?php if ($options['page_title_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['page_title_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Header and Footer', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Header', 'elision-core' ); ?></h2></td></tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Header in grid', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[header_in_grid]">
										<option <?php if(isset($options['header_in_grid'])){ if ($options['header_in_grid'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if(isset($options['header_in_grid'])){ if ($options['header_in_grid'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>	
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Show header top area', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[header_top_area]">
										<option <?php if(isset($options['header_top_area'])){ if ($options['header_top_area'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if(isset($options['header_top_area'])){ if ($options['header_top_area'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>	
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Show sticky header', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[header_sticky]">
										<option <?php if(isset($options['header_sticky'])){ if ($options['header_sticky'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>	
										<option <?php if(isset($options['header_sticky'])){ if ($options['header_sticky'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Header style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[header_style]">
										<option <?php if(isset($options['header_style'])){ if ($options['header_style'] == "") { echo "selected='selected'"; }} ?> value=""></option>
										<option <?php if(isset($options['header_style'])){ if ($options['header_style'] == "light") { echo "selected='selected'"; }} ?> value="light"><?php esc_html_e( 'Light', 'elision-core' ); ?></option>
										<option <?php if(isset($options['header_style'])){ if ($options['header_style'] == "dark") { echo "selected='selected'"; }} ?> value="dark"><?php esc_html_e( 'Dark', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Menu in center', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[menu_in_center]">
										<option <?php if(isset($options['menu_in_center'])){ if ($options['menu_in_center'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if(isset($options['menu_in_center'])){ if ($options['menu_in_center'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>	
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Top background color', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Background Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['header_top_background_color']){ echo 'background-color:'.esc_attr($options['header_top_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[header_top_background_color]" type="text" value="<?php if (isset($options['header_top_background_color'])) { echo esc_attr($options['header_top_background_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Bottom background color', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Initial', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['header_background_color']){ echo 'background-color:'.esc_attr($options['header_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[header_background_color]" type="text" value="<?php if (isset($options['header_background_color'])) { echo esc_attr($options['header_background_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Sticky', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['header_background_color_scroll'])) { if($options['header_background_color_scroll']){ echo 'background-color:'.esc_attr($options['header_background_color_scroll']).';'; } }?>"></div></div>
									<input name="qode_options_elision[header_background_color_scroll]" type="text" value="<?php if (isset($options['header_background_color_scroll'])) { echo esc_attr($options['header_background_color_scroll']); } ?>" size="10" maxlength="10" />
								</div>
								<?php esc_html_e('Default value for initial background transparency is 0', 'elision-core'); ?>
							</td>
						</tr>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Transparency', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Initial', 'elision-core'); ?>
									<input name="qode_options_elision[header_background_transparency_initial]" type="text" value="<?php if (isset($options['header_background_transparency_initial'])) { echo esc_attr($options['header_background_transparency_initial']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Sticky', 'elision-core'); ?>
									<input name="qode_options_elision[header_background_transparency_scroll]" type="text" value="<?php if (isset($options['header_background_transparency_scroll'])) { echo esc_attr($options['header_background_transparency_scroll']); } ?>" size="10" maxlength="10" />
								</div>
								<?php esc_html_e('(from 0 to 1)', 'elision-core'); ?>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Logo animation on hover', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[logo_animation]">
										<option <?php if(isset($options['logo_animation'])){ if ($options['logo_animation'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if(isset($options['logo_animation'])){ if ($options['logo_animation'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>	
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="top" width="150"><?php esc_html_e('Logo', 'elision-core'); ?></td>
							<td>
								<div class="inline" style="width: 700px;">
									<?php esc_html_e('Logo image (normal/light)', 'elision-core'); ?>
									<input type="text" id="logo_image" name="qode_options_elision[logo_image]" class="logo_image" value="<?php if (isset($options['logo_image'])) { echo esc_attr($options['logo_image']); } else { echo QODE_ROOT."/img/logo.png"; } ?>" size="70">
									<input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
								</div><br/><br/>
								<div class="inline" style="width: 700px;">
									<?php esc_html_e('Logo image (dark)', 'elision-core'); ?>
									<input type="text" id="logo_image_dark" name="qode_options_elision[logo_image_dark]" class="logo_image_dark" value="<?php if (isset($options['logo_image_dark'])) { echo esc_attr($options['logo_image_dark']); } else { echo QODE_ROOT."/img/logo_black.png"; } ?>" size="70">
									<input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
								</div><br/><br/>
								<div class="inline"style="width: 700px;">
									<?php esc_html_e('Logo image (sticky header)', 'elision-core'); ?>
									<input type="text" id="logo_image_sticky" name="qode_options_elision[logo_image_sticky]" class="logo_image_sticky" value="<?php if (isset($options['logo_image_sticky'])) { echo esc_attr($options['logo_image_sticky']); } else { echo QODE_ROOT."/img/logo_black.png"; } ?>" size="70">
									<input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Center logo', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[center_logo_image]">
									<option <?php if(isset($options['center_logo_image'])){ $center_logo_image = $options['center_logo_image']; if ($center_logo_image == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['center_logo_image'])){ $center_logo_image = $options['center_logo_image']; if ($center_logo_image == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
								<td scope="row" width="150"><?php esc_html_e('Header height', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Initial (px)', 'elision-core'); ?>
										<input name="qode_options_elision[header_height]" type="text" value="<?php if (isset($options['header_height'])) { echo esc_attr($options['header_height']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Sticky (px)', 'elision-core'); ?>
										<input name="qode_options_elision[header_height_scroll]" type="text" value="<?php if (isset($options['header_height_scroll'])) { echo esc_attr($options['header_height_scroll']); } ?>" size="10" maxlength="10" />
									</div>
								</td>
						</tr>
						<tr valign="top">
								<td scope="row" width="150"><?php esc_html_e('Scroll amount for sticky appear (px)', 'elision-core'); ?></td>
								<td>
									<div class="inline">
										<input name="qode_options_elision[scroll_amount_for_sticky]" type="text" value="<?php if (isset($options['scroll_amount_for_sticky'])) { echo esc_attr($options['scroll_amount_for_sticky']); } ?>" size="10" maxlength="10" />
									</div>
								</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Dropdown main menu', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Background color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['dropdown_background_color'])){ echo 'background-color:'.esc_attr($options['dropdown_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[dropdown_background_color]" type="text" value="<?php if (isset($options['dropdown_background_color'])) { echo esc_attr($options['dropdown_background_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Transparency (From 0 to 1)', 'elision-core'); ?>
									<input name="qode_options_elision[dropdown_background_transparency]" type="text" value="<?php if (isset($options['dropdown_background_transparency'])) { echo esc_attr($options['dropdown_background_transparency']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('1st level menu style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['menu_color']){ echo 'background-color:'.esc_attr($options['menu_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[menu_color]" type="text" value="<?php if ($options['menu_color']) { echo esc_attr($options['menu_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover/Active color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['menu_hovercolor'])){ echo 'background-color:'.esc_attr($options['menu_hovercolor']).';'; } ?>"></div></div>
									<input name="qode_options_elision[menu_hovercolor]" type="text" value="<?php if (isset($options['menu_hovercolor'])) { echo esc_attr($options['menu_hovercolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'elision-core'); ?>
									<select name="qode_options_elision[menu_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['menu_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font size (px)', 'elision-core'); ?>
									<input name="qode_options_elision[menu_fontsize]" type="text" value="<?php if ($options['menu_fontsize']) { echo esc_attr($options['menu_fontsize']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Line height (px)', 'elision-core'); ?>
									<input name="qode_options_elision[menu_lineheight]" type="text" value="<?php if ($options['menu_lineheight']) { echo esc_attr($options['menu_lineheight']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font style', 'elision-core'); ?>
									<select name="qode_options_elision[menu_fontstyle]">
										<option <?php if ($options['menu_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['menu_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
										<option <?php if ($options['menu_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
										
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font weight', 'elision-core'); ?>
									<select name="qode_options_elision[menu_fontweight]">
										<option <?php if ($options['menu_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['menu_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
										<option <?php if ($options['menu_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
										<option <?php if ($options['menu_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
										<option <?php if ($options['menu_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
										<option <?php if ($options['menu_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
										<option <?php if ($options['menu_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
										<option <?php if ($options['menu_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
										<option <?php if ($options['menu_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('2nd level menu style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['dropdown_color'])){ echo 'background-color:'.esc_attr($options['dropdown_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[dropdown_color]" type="text" value="<?php if (isset($options['dropdown_color'])) { echo esc_attr($options['dropdown_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover/Active color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['dropdown_hovercolor'])){ echo 'background-color:'.esc_attr($options['dropdown_hovercolor']).';'; } ?>"></div></div>
									<input name="qode_options_elision[dropdown_hovercolor]" type="text" value="<?php if (isset($options['dropdown_hovercolor'])) { echo esc_attr($options['dropdown_hovercolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'elision-core'); ?>
									<select name="qode_options_elision[dropdown_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['dropdown_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[dropdown_fontsize]" type="text" value="<?php if ($options['dropdown_fontsize']) { echo esc_attr($options['dropdown_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[dropdown_lineheight]" type="text" value="<?php if ($options['dropdown_lineheight']) { echo esc_attr($options['dropdown_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[dropdown_fontstyle]">
											<option <?php if ($options['dropdown_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['dropdown_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if ($options['dropdown_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[dropdown_fontweight]">
											<option <?php if ($options['dropdown_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['dropdown_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
										</select>
									</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('3rd level menu style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['dropdown_color_thirdlvl'])){ echo 'background-color:'.esc_attr($options['dropdown_color_thirdlvl']).';'; } ?>"></div></div>
									<input name="qode_options_elision[dropdown_color_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_color_thirdlvl'])) { echo esc_attr($options['dropdown_color_thirdlvl']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover/Active color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['dropdown_hovercolor_thirdlvl'])){ echo 'background-color:'.esc_attr($options['dropdown_hovercolor_thirdlvl']).';'; } ?>"></div></div>
									<input name="qode_options_elision[dropdown_hovercolor_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_hovercolor_thirdlvl'])) { echo esc_attr($options['dropdown_hovercolor_thirdlvl']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'elision-core'); ?>
									<select name="qode_options_elision[dropdown_google_fonts_thirdlvl]">
										<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if(isset($options['dropdown_google_fonts_thirdlvl'])){ $dropdown_google_fonts_thirdlvl = $options['dropdown_google_fonts_thirdlvl']; if ($dropdown_google_fonts_thirdlvl == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[dropdown_fontsize_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_fontsize_thirdlvl'])) { echo esc_attr($options['dropdown_fontsize_thirdlvl']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[dropdown_lineheight_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_lineheight_thirdlvl'])) { echo esc_attr($options['dropdown_lineheight_thirdlvl']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[dropdown_fontstyle_thirdlvl]">
											<option <?php if(isset($options['dropdown_fontstyle_thirdlvl'])){ $dropdown_fontstyle_thirdlvl = $options['dropdown_fontstyle_thirdlvl']; if ($dropdown_fontstyle_thirdlvl == '') { echo "selected='selected'"; } } ?> value=""></option>
											<option <?php if(isset($options['dropdown_fontstyle_thirdlvl'])){ $dropdown_fontstyle_thirdlvl = $options['dropdown_fontstyle_thirdlvl']; if ($dropdown_fontstyle_thirdlvl == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontstyle_thirdlvl'])){ $dropdown_fontstyle_thirdlvl = $options['dropdown_fontstyle_thirdlvl']; if ($dropdown_fontstyle_thirdlvl == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>	
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[dropdown_fontweight_thirdlvl]">
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '') { echo "selected='selected'"; } } ?> value=""></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '200') { echo "selected='selected'"; } } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '300') { echo "selected='selected'"; } } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '400') { echo "selected='selected'"; } } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '500') { echo "selected='selected'"; } } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '600') { echo "selected='selected'"; } } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '700') { echo "selected='selected'"; } } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '800') { echo "selected='selected'"; } } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '900') { echo "selected='selected'"; } } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
										</select>
									</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Sticky menu', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['sticky_color'])){ echo 'background-color:'.esc_attr($options['sticky_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[sticky_color]" type="text" value="<?php if (isset($options['sticky_color'])) { echo esc_attr($options['sticky_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover/Active color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['sticky_hovercolor'])){ echo 'background-color:'.esc_attr($options['sticky_hovercolor']).';'; } ?>"></div></div>
									<input name="qode_options_elision[sticky_hovercolor]" type="text" value="<?php if (isset($options['sticky_hovercolor'])) { echo esc_attr($options['sticky_hovercolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'elision-core'); ?>
									<select name="qode_options_elision[sticky_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if(isset($options['sticky_google_fonts'])){ $sticky_google_fonts = $options['sticky_google_fonts']; if ($sticky_google_fonts == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[sticky_fontsize]" type="text" value="<?php if (isset($options['sticky_fontsize'])) { echo esc_attr($options['sticky_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[sticky_lineheight]" type="text" value="<?php if (isset($options['sticky_lineheight'])) { echo esc_attr($options['sticky_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[sticky_fontstyle]">
											<option <?php if(isset($options['sticky_fontstyle'])){ $sticky_fontstyle = $options['sticky_fontstyle']; if ($sticky_fontstyle == '') { echo "selected='selected'"; } } ?> value=""></option>
											<option <?php if(isset($options['sticky_fontstyle'])){ $sticky_fontstyle = $options['sticky_fontstyle']; if ($sticky_fontstyle == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if(isset($options['sticky_fontstyle'])){ $sticky_fontstyle = $options['sticky_fontstyle']; if ($sticky_fontstyle == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>	
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[sticky_fontweight]">
											<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '') { echo "selected='selected'"; } } ?> value=""></option>
											<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '200') { echo "selected='selected'"; } } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '300') { echo "selected='selected'"; } } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '400') { echo "selected='selected'"; } } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '500') { echo "selected='selected'"; } } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '600') { echo "selected='selected'"; } } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '700') { echo "selected='selected'"; } } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '800') { echo "selected='selected'"; } } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '900') { echo "selected='selected'"; } } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
										</select>
									</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Mobile menu style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['mobile_color'])){ echo 'background-color:'.esc_attr($options['mobile_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[mobile_color]" type="text" value="<?php if (isset($options['mobile_color'])) { echo esc_attr($options['mobile_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover/Active color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['mobile_hovercolor'])){ echo 'background-color:'.esc_attr($options['mobile_hovercolor']).';'; } ?>"></div></div>
									<input name="qode_options_elision[mobile_hovercolor]" type="text" value="<?php if (isset($options['mobile_hovercolor'])) { echo esc_attr($options['mobile_hovercolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'elision-core'); ?>
									<select name="qode_options_elision[mobile_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if(isset($options['mobile_google_fonts'])){ $mobile_google_fonts = $options['mobile_google_fonts']; if ($mobile_google_fonts == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'elision-core'); ?>
										<input name="qode_options_elision[mobile_fontsize]" type="text" value="<?php if (isset($options['mobile_fontsize'])) { echo esc_attr($options['mobile_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'elision-core'); ?>
										<input name="qode_options_elision[mobile_lineheight]" type="text" value="<?php if (isset($options['mobile_lineheight'])) { echo esc_attr($options['mobile_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'elision-core'); ?>
										<select name="qode_options_elision[mobile_fontstyle]">
											<option <?php if(isset($options['mobile_fontstyle'])){ $mobile_fontstyle = $options['mobile_fontstyle']; if ($mobile_fontstyle == '') { echo "selected='selected'"; } } ?> value=""></option>
											<option <?php if(isset($options['mobile_fontstyle'])){ $mobile_fontstyle = $options['mobile_fontstyle']; if ($mobile_fontstyle == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
											<option <?php if(isset($options['mobile_fontstyle'])){ $mobile_fontstyle = $options['mobile_fontstyle']; if ($mobile_fontstyle == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>	
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'elision-core'); ?>
										<select name="qode_options_elision[mobile_fontweight]">
											<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '') { echo "selected='selected'"; } } ?> value=""></option>
											<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '200') { echo "selected='selected'"; } } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
											<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '300') { echo "selected='selected'"; } } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
											<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '400') { echo "selected='selected'"; } } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
											<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '500') { echo "selected='selected'"; } } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
											<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '600') { echo "selected='selected'"; } } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
											<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '700') { echo "selected='selected'"; } } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
											<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '800') { echo "selected='selected'"; } } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
											<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '900') { echo "selected='selected'"; } } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
										</select>
									</div><br /><br />
									<div class="inline">
										<?php esc_html_e('Separator color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if (isset($options['mobile_separator_color'])){ echo 'background-color:'.esc_attr($options['mobile_separator_color']).';'; } ?>"></div></div>
										<input name="qode_options_elision[mobile_separator_color]" type="text" value="<?php if (isset($options['mobile_separator_color'])) { echo esc_attr($options['mobile_separator_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Top background color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if (isset($options['mobile_top_background_color'])){ echo 'background-color:'.esc_attr($options['mobile_top_background_color']).';'; } ?>"></div></div>
										<input name="qode_options_elision[mobile_top_background_color]" type="text" value="<?php if (isset($options['mobile_top_background_color'])) { echo esc_attr($options['mobile_top_background_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Bottom background color', 'elision-core'); ?>
										<div class="colorSelector"><div style="<?php if (isset($options['mobile_bottom_background_color'])){ echo 'background-color:'.esc_attr($options['mobile_bottom_background_color']).';'; } ?>"></div></div>
										<input name="qode_options_elision[mobile_bottom_background_color]" type="text" value="<?php if (isset($options['mobile_bottom_background_color'])) { echo esc_attr($options['mobile_bottom_background_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Letter spacing', 'elision-core'); ?>
										<input name="qode_options_elision[mobile_letter_spacing]" type="text" value="<?php if (isset($options['mobile_letter_spacing'])) { echo esc_attr($options['mobile_letter_spacing']); } ?>" size="10" maxlength="10" />
									</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Title', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Title style', 'elision-core'); ?>
									<select name="qode_options_elision[title_style]">
										<option <?php if(isset($options['title_style'])){ $title_style = $options['title_style']; if ($title_style == 'standard') { echo "selected='selected'"; } } ?> value="standard"><?php esc_html_e('Standard', 'elision-core'); ?></option>
										<option <?php if(isset($options['title_style'])){ $title_style = $options['title_style']; if ($title_style == 'title_on_bottom') { echo "selected='selected'"; } } ?> value="title_on_bottom"><?php esc_html_e('Title on Bottom', 'elision-core'); ?></option>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Background color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['title_background_color'])){ echo 'background-color:'.esc_attr($options['title_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[title_background_color]" type="text" value="<?php if (isset($options['title_background_color'])) { echo esc_attr($options['title_background_color']); } ?>" size="10" maxlength="10" />
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Responsive title image', 'elision-core'); ?>
									<select name="qode_options_elision[responsive_title_image]">
										<option <?php if(isset($options['responsive_title_image'])){ $responsive_title_image = $options['responsive_title_image']; if ($responsive_title_image == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if(isset($options['responsive_title_image'])){ $responsive_title_image = $options['responsive_title_image']; if ($responsive_title_image == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
									</select>
								</div>
								<div class="inline" style="width: 600px;">
									<?php esc_html_e('Title image', 'elision-core'); ?>
									<input type="text" id="title_image" name="qode_options_elision[title_image]" class="title_image" value="<?php if (isset($options['title_image'])) { echo esc_attr($options['title_image']); } ?>" size="70">
									<input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Parallax title image', 'elision-core'); ?>
									<select name="qode_options_elision[fixed_title_image]">
										<option <?php if(isset($options['fixed_title_image'])){ $fixed_title_image = $options['fixed_title_image']; if ($fixed_title_image == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if(isset($options['fixed_title_image'])){ $fixed_title_image = $options['fixed_title_image']; if ($fixed_title_image == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
										<option <?php if(isset($options['fixed_title_image'])){ $fixed_title_image = $options['fixed_title_image']; if ($fixed_title_image == 'yes_zoom') { echo "selected='selected'"; } } ?> value="yes_zoom"><?php esc_html_e( 'Yes, with zoom out', 'elision-core' ); ?></option>
									</select>
									<?php esc_html_e('Only if title image is not responsive', 'elision-core'); ?>
								</div>
								<div class="inline">
									<?php esc_html_e('Title height (px)', 'elision-core'); ?>
									<input name="qode_options_elision[title_height]" type="text" value="<?php if (isset($options['title_height'])) { echo esc_attr($options['title_height']); } ?>" size="10" maxlength="10" />
									<?php esc_html_e('Only if title image is not responsive', 'elision-core'); ?>
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Title position for standard title', 'elision-core'); ?>
									<select name="qode_options_elision[page_title_position]">
										<option <?php if ($options['page_title_position'] == 0) { echo "selected='selected'"; } ?> value="0"></option>
										<option <?php if ($options['page_title_position'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Left', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_position'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Center', 'elision-core' ); ?></option>
										<option <?php if ($options['page_title_position'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Right', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Footer', 'elision-core' ); ?></h2></td></tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Footer in grid', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[footer_in_grid]">
										<option <?php if(isset($options['footer_in_grid'])) { if ($options['footer_in_grid'] == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if(isset($options['footer_in_grid'])) { if ($options['footer_in_grid'] == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>		
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Show footer top', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[show_footer_top]">
										<option <?php if(isset($options['show_footer_top'])) { if ($options['show_footer_top'] == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
										<option <?php if(isset($options['show_footer_top'])) { if ($options['show_footer_top'] == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>		
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Footer top columns', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[footer_top_columns]">
										<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "1") { echo "selected='selected'"; } } ?> value="1"><?php esc_html_e( '1', 'elision-core' ); ?></option>
										<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "2") { echo "selected='selected'"; } } ?> value="2"><?php esc_html_e( '2', 'elision-core' ); ?></option>
										<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "3") { echo "selected='selected'"; } } ?> value="3"><?php esc_html_e( '3', 'elision-core' ); ?></option>
										<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "4") { echo "selected='selected'"; } } ?> value="4"><?php esc_html_e( '4', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Show footer bottom', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[footer_text]">
										<option <?php if ($options['footer_text'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if ($options['footer_text'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
										
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Footer top colors', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Title color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_top_title_color']){ echo 'background-color:'.esc_attr($options['footer_top_title_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[footer_top_title_color]" type="text" value="<?php if ($options['footer_top_title_color']) { echo esc_attr($options['footer_top_title_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Text color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_top_text_color']){ echo 'background-color:'.esc_attr($options['footer_top_text_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[footer_top_text_color]" type="text" value="<?php if ($options['footer_top_text_color']) { echo esc_attr($options['footer_top_text_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Link color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['footer_link_color'])){ echo 'background-color:'.esc_attr($options['footer_link_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[footer_link_color]" type="text" value="<?php if (isset($options['footer_link_color'])) { echo esc_attr($options['footer_link_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Link hover color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['footer_link_hover_color'])){ echo 'background-color:'.esc_attr($options['footer_link_hover_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[footer_link_hover_color]" type="text" value="<?php if (isset($options['footer_link_hover_color'])){ echo esc_attr($options['footer_link_hover_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Background color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_top_background_color']){ echo 'background-color:'.esc_attr($options['footer_top_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[footer_top_background_color]" type="text" value="<?php if ($options['footer_top_background_color']) { echo esc_attr($options['footer_top_background_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Footer bottom colors', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Text color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_bottom_text_color']){ echo 'background-color:'.esc_attr($options['footer_bottom_text_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[footer_bottom_text_color]" type="text" value="<?php if ($options['footer_bottom_text_color']) { echo esc_attr($options['footer_bottom_text_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Background color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_bottom_background_color']){ echo 'background-color:'.esc_attr($options['footer_bottom_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[footer_bottom_background_color]" type="text" value="<?php if (isset($options['footer_bottom_background_color'])) { echo esc_attr($options['footer_bottom_background_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Elements', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Separator', 'elision-core' ); ?></h2></td></tr>
						<tr valign="middle">
							<td valign="middle"></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['separator_color'])){ echo 'background-color:'.esc_attr($options['separator_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[separator_color]" type="text" value="<?php if (isset($options['separator_color'])) { echo esc_attr($options['separator_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Thickness (px)', 'elision-core'); ?>
									<input name="qode_options_elision[separator_thickness]" type="text" value="<?php if ($options['separator_thickness']) { echo esc_attr($options['separator_thickness']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Top margin (px)', 'elision-core'); ?>
									<input name="qode_options_elision[separator_topmargin]" type="text" value="<?php if ($options['separator_topmargin']) { echo esc_attr($options['separator_topmargin']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Bottom margin (px)', 'elision-core'); ?>
									<input name="qode_options_elision[separator_bottommargin]" type="text" value="<?php if ($options['separator_bottommargin']) { echo esc_attr($options['separator_bottommargin']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Buttons', 'elision-core' ); ?></h2></td></tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Button style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['button_title_color']){ echo 'background-color:'.esc_attr($options['button_title_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[button_title_color]" type="text" value="<?php if ($options['button_title_color']) { echo esc_attr($options['button_title_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['button_title_hovercolor']){ echo 'background-color:'.esc_attr($options['button_title_hovercolor']).';'; } ?>"></div></div>
									<input name="qode_options_elision[button_title_hovercolor]" type="text" value="<?php if ($options['button_title_hovercolor']) { echo esc_attr($options['button_title_hovercolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'elision-core'); ?>
									<select name="qode_options_elision[button_title_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['button_title_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font size (px)', 'elision-core'); ?>
									<input name="qode_options_elision[button_title_fontsize]" type="text" value="<?php if ($options['button_title_fontsize']) { echo esc_attr($options['button_title_fontsize']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Line height (px)', 'elision-core'); ?>
									<input name="qode_options_elision[button_title_lineheight]" type="text" value="<?php if ($options['button_title_lineheight']) { echo esc_attr($options['button_title_lineheight']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font style', 'elision-core'); ?>
									<select name="qode_options_elision[button_title_fontstyle]">
										<option <?php if ($options['button_title_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['button_title_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
										<option <?php if ($options['button_title_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
										
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font weight', 'elision-core'); ?>
									<select name="qode_options_elision[button_title_fontweight]">
										<option <?php if ($options['button_title_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['button_title_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
										
									</select>
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Background color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['button_backgroundcolor']){ echo 'background-color:'.esc_attr($options['button_backgroundcolor']).';'; } ?>"></div></div>
									<input name="qode_options_elision[button_backgroundcolor]" type="text" value="<?php if ($options['button_backgroundcolor']) { echo esc_attr($options['button_backgroundcolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover background color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['button_backgroundcolor_hover']) && $options['button_backgroundcolor_hover']){ echo 'background-color:'.esc_attr($options['button_backgroundcolor_hover']).';'; } ?>"></div></div>
									<input name="qode_options_elision[button_backgroundcolor_hover]" type="text" value="<?php if (isset($options['button_backgroundcolor_hover']) && $options['button_backgroundcolor_hover']) { echo esc_attr($options['button_backgroundcolor_hover']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Message box', 'elision-core' ); ?></h2></td></tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Message box style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['message_title_color']){ echo 'background-color:'.esc_attr($options['message_title_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[message_title_color]" type="text" value="<?php if ($options['message_title_color']) { echo esc_attr($options['message_title_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'elision-core'); ?>
									<select name="qode_options_elision[message_title_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'elision-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['message_title_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font size (px)', 'elision-core'); ?>
									<input name="qode_options_elision[message_title_fontsize]" type="text" value="<?php if ($options['message_title_fontsize']) { echo esc_attr($options['message_title_fontsize']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Line height (px)', 'elision-core'); ?>
									<input name="qode_options_elision[message_title_lineheight]" type="text" value="<?php if ($options['message_title_lineheight']) { echo esc_attr($options['message_title_lineheight']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font style', 'elision-core'); ?>
									<select name="qode_options_elision[message_title_fontstyle]">
										<option <?php if ($options['message_title_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['message_title_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'elision-core' ); ?></option>
										<option <?php if ($options['message_title_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'elision-core' ); ?></option>
										
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font weight', 'elision-core'); ?>
									<select name="qode_options_elision[message_title_fontweight]">
										<option <?php if ($options['message_title_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['message_title_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'elision-core' ); ?></option>
										<option <?php if ($options['message_title_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'elision-core' ); ?></option>
										<option <?php if ($options['message_title_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'elision-core' ); ?></option>
										<option <?php if ($options['message_title_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'elision-core' ); ?></option>
										<option <?php if ($options['message_title_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'elision-core' ); ?></option>
										<option <?php if ($options['message_title_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'elision-core' ); ?></option>
										<option <?php if ($options['message_title_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'elision-core' ); ?></option>
										<option <?php if ($options['message_title_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'elision-core' ); ?></option>
										
									</select>
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Background color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['message_backgroundcolor']){ echo 'background-color:'.esc_attr($options['message_backgroundcolor']).';'; } ?>"></div></div>
									<input name="qode_options_elision[message_backgroundcolor]" type="text" class="colorpicker-input" value="<?php if ($options['message_backgroundcolor']) { echo esc_attr($options['message_backgroundcolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Border color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['message_bordercolor']) && $options['message_bordercolor']){ echo 'background-color:'.esc_attr($options['message_bordercolor']).';'; } ?>"></div></div>
									<input name="qode_options_elision[message_bordercolor]" type="text" class="colorpicker-input" value="<?php if (isset($options['message_bordercolor']) && $options['message_bordercolor']) { echo esc_attr($options['message_bordercolor']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Message icon style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['message_icon_color']) && $options['message_icon_color']){ echo 'background-color:'.esc_attr($options['message_icon_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[message_icon_color]" type="text" value="<?php if (isset($options['message_icon_color']) && $options['message_icon_color']) { echo esc_attr($options['message_icon_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font size (px)', 'elision-core'); ?>
									<input name="qode_options_elision[message_icon_fontsize]" type="text" value="<?php if (isset($options['message_icon_fontsize']) && $options['message_icon_fontsize']) { echo esc_attr($options['message_icon_fontsize']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Blockquote', 'elision-core' ); ?></h2></td></tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Blockquote style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['blockquote_font_color']){ echo 'background-color:'.esc_attr($options['blockquote_font_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[blockquote_font_color]" type="text" value="<?php if ($options['blockquote_font_color']) { echo esc_attr($options['blockquote_font_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Background Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['blockquote_background_color']) && $options['blockquote_background_color']){ echo 'background-color:'.esc_attr($options['blockquote_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[blockquote_background_color]" type="text" value="<?php if (isset($options['blockquote_background_color']) &&  $options['blockquote_background_color']) { echo esc_attr($options['blockquote_background_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Border Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['blockquote_border_color']) && $options['blockquote_border_color']){ echo 'background-color:'.esc_attr($options['blockquote_border_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[blockquote_border_color]" type="text" value="<?php if (isset($options['blockquote_border_color']) &&  $options['blockquote_border_color']) { echo esc_attr($options['blockquote_border_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Social Icon', 'elision-core' ); ?></h2></td></tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Background Color', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Background Color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['social_icon_backgroundcolor']){ echo 'background-color:'.esc_attr($options['social_icon_backgroundcolor']).';'; } ?>"></div></div>
									<input name="qode_options_elision[social_icon_backgroundcolor]" type="text" value="<?php if ($options['social_icon_backgroundcolor']) { echo esc_attr($options['social_icon_backgroundcolor']); } ?>" size="10" maxlength="12" />
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Smooth Scroll', 'elision-core' ); ?></h2></td></tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Smooth scroll style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Background color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['smooth_background_color']){ echo 'background-color:'.esc_attr($options['smooth_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[smooth_background_color]" type="text" value="<?php if(isset($options['smooth_background_color'])){ if ($options['smooth_background_color']) { echo esc_attr($options['smooth_background_color']); } } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Bar color', 'elision-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['smooth_bar_color']){ echo 'background-color:'.esc_attr($options['smooth_bar_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[smooth_bar_color]" type="text" value="<?php if(isset($options['smooth_bar_color'])){ if ($options['smooth_bar_color']) { echo esc_attr($options['smooth_bar_color']); } } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Side Area', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Enable Side Area', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[enable_side_area]">
										<option <?php if ((isset($options['enable_side_area'])) && $options['enable_side_area'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
										<option <?php if ((isset($options['enable_side_area'])) && $options['enable_side_area'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Side Area Title', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<input name="qode_options_elision[side_area_title]" type="text" value="<?php if(isset($options['side_area_title'])) { if ($options['side_area_title']) { echo esc_attr($options['side_area_title']); } } ?>" />
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Background Color', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<div class="colorSelector"><div style="<?php if (isset($options['side_area_background_color']) && $options['side_area_background_color']){ echo 'background-color:'.esc_attr($options['side_area_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[side_area_background_color]" type="text" value="<?php if(isset($options['side_area_background_color'])){ if ($options['side_area_background_color']) { echo esc_attr($options['side_area_background_color']); } } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Text Color', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<div class="colorSelector"><div style="<?php if (isset($options['side_area_text_color']) && $options['side_area_text_color']){ echo 'background-color:'.esc_attr($options['side_area_text_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[side_area_text_color]" type="text" value="<?php if(isset($options['side_area_text_color'])){ if ($options['side_area_text_color']) { echo esc_attr($options['side_area_text_color']); } } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Title Color', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<div class="colorSelector"><div style="<?php if (isset($options['side_area_title_color']) && $options['side_area_title_color']){ echo 'color:'.esc_attr($options['side_area_title_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[side_area_title_color]" type="text" value="<?php if(isset($options['side_area_title_color'])){ if ($options['side_area_title_color']) { echo esc_attr($options['side_area_title_color']); } } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Content Bottom Area', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Enable Content Bottom Area', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[enable_content_bottom_area]">
										<option <?php if ((isset($options['enable_content_bottom_area'])) && $options['enable_content_bottom_area'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
										<option <?php if ((isset($options['enable_content_bottom_area'])) && $options['enable_content_bottom_area'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Content bottom sidebar to display', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[content_bottom_sidebar_custom_display]">
									<option value="" <?php if(isset($options['content_bottom_sidebar_custom_display'])){ $content_bottom_sidebar_custom_display = $options['content_bottom_sidebar_custom_display'];  if ($content_bottom_sidebar_custom_display == "" ) { echo "selected='selected'";  } }?>></option>
									<?php
									foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
										if(elision_qode_is_user_made_sidebar(ucwords($sidebar['name']))){
									?>
										<option value="<?php echo ucwords( $sidebar['id'] ); ?>" <?php if(isset($options['content_bottom_sidebar_custom_display'])){ $content_bottom_sidebar_custom_display = $options['content_bottom_sidebar_custom_display'];  if ($content_bottom_sidebar_custom_display == ucwords( $sidebar['id'] ) ) { echo "selected='selected'";  } }?>>
											<?php echo ucwords( $sidebar['name'] ); ?>
										</option>
										<?php	
											}
										}
										?>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td valign="middle" width="150"><?php esc_html_e('Content bottom in grid', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[content_bottom_in_grid]">
										<option <?php if(isset($options['content_bottom_in_grid'])){ if ($options['content_bottom_in_grid'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if(isset($options['content_bottom_in_grid'])){ if ($options['content_bottom_in_grid'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>	
									</select>
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Background Color', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<div class="colorSelector"><div style="<?php if (isset($options['content_bottom_background_color']) && $options['content_bottom_background_color']){ echo 'background-color:'.esc_attr($options['content_bottom_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[content_bottom_background_color]" type="text" value="<?php if(isset($options['content_bottom_background_color'])){ if ($options['content_bottom_background_color']) { echo esc_attr($options['content_bottom_background_color']); } } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Parallax', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Parallax speed', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<input name="qode_options_elision[parallax_speed]" type="text" value="<?php if ($options['parallax_speed']) { echo esc_attr($options['parallax_speed']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Parallax on touch devices', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[parallax_onoff]">
									<option <?php if ($options['parallax_onoff'] == "on") { echo "selected='selected'"; } ?> value="on"><?php esc_html_e( 'On', 'elision-core' ); ?></option>
									<option <?php if ($options['parallax_onoff'] == "off") { echo "selected='selected'"; } ?> value="off"><?php esc_html_e( 'Off', 'elision-core' ); ?></option>
								</select>
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Parallax min height (px)', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<input name="qode_options_elision[parallax_minheight]" type="text" value="<?php if ($options['parallax_minheight']) { echo esc_attr($options['parallax_minheight']); } ?>" size="10" maxlength="10" />
									<?php esc_html_e('Set min-height for last two stages', 'elision-core'); ?>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<h3><?php esc_html_e( 'Portfolio', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Portfolio single', 'elision-core' ); ?></h2></td></tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Portfolio style', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[portfolio_style]">
									<option <?php if ($options['portfolio_style'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Portfolio small images', 'elision-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Portfolio small slider', 'elision-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 5) { echo "selected='selected'"; } ?> value="5"><?php esc_html_e( 'Portfolio big images', 'elision-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Portfolio big slider', 'elision-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e( 'Portfolio custom', 'elision-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 7) { echo "selected='selected'"; } ?> value="7"><?php esc_html_e( 'Portfolio full width custom', 'elision-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 6) { echo "selected='selected'"; } ?> value="6"><?php esc_html_e( 'Portfolio gallery', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Portfolio Qode Like', 'elision-core'); ?></td>
								<td>
									<select name="qode_options_elision[portfolio_qode_like]">
										<option <?php if (isset($options['portfolio_qode_like'])){ $portfolio_qode_like = $options['portfolio_qode_like']; if ($portfolio_qode_like == 'on') { echo "selected='selected'"; } } ?> value="on"><?php esc_html_e( 'On', 'elision-core' ); ?></option>
										<option <?php if (isset($options['portfolio_qode_like'])){ $portfolio_qode_like = $options['portfolio_qode_like']; if ($portfolio_qode_like == 'off') { echo "selected='selected'"; } } ?> value="off"><?php esc_html_e( 'Off', 'elision-core' ); ?></option>
									</select>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Lightbox for single project', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[lightbox_single_project]">
										<option <?php if(isset($options['lightbox_single_project'])){ $lightbox_single_project = $options['lightbox_single_project']; if ($lightbox_single_project == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
										<option <?php if(isset($options['lightbox_single_project'])){ $lightbox_single_project = $options['lightbox_single_project']; if ($lightbox_single_project == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Number of columns for Portfolio gallery style', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_elision[portfolio_columns_number]">
										<option <?php if(isset($options['portfolio_columns_number'])){ $portfolio_columns_number = $options['portfolio_columns_number']; if ($options['portfolio_columns_number'] == 2) { echo "selected='selected'"; } } ?> value="2"><?php esc_html_e( '2 columns', 'elision-core' ); ?></option>
										<option <?php if(isset($options['portfolio_columns_number'])){ $portfolio_columns_number = $options['portfolio_columns_number']; if ($options['portfolio_columns_number'] == 3) { echo "selected='selected'"; } } ?> value="3"><?php esc_html_e( '3 columns', 'elision-core' ); ?></option>
										<option <?php if(isset($options['portfolio_columns_number'])){ $portfolio_columns_number = $options['portfolio_columns_number']; if ($options['portfolio_columns_number'] == 4) { echo "selected='selected'"; } } ?> value="4"><?php esc_html_e( '4 columns', 'elision-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Sidebar layout', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[portfolio_single_sidebar]">
									<option <?php if(isset($options['portfolio_single_sidebar'])){$portfolio_single_sidebar = $options['portfolio_single_sidebar']; if ($portfolio_single_sidebar == "default") { echo "selected='selected'"; } } ?> value="default"><?php esc_html_e( 'No Sidebar', 'elision-core' ); ?></option>
									<option <?php if(isset($options['portfolio_single_sidebar'])){$portfolio_single_sidebar = $options['portfolio_single_sidebar']; if ($portfolio_single_sidebar == 1) { echo "selected='selected'"; } } ?> value="1"><?php esc_html_e( 'Sidebar 1/3 right', 'elision-core' ); ?></option>
									<option <?php if(isset($options['portfolio_single_sidebar'])){$portfolio_single_sidebar = $options['portfolio_single_sidebar']; if ($portfolio_single_sidebar == 2) { echo "selected='selected'"; } } ?> value="2"><?php esc_html_e( 'Sidebar 1/4 right', 'elision-core' ); ?></option>
									<option <?php if(isset($options['portfolio_single_sidebar'])){$portfolio_single_sidebar = $options['portfolio_single_sidebar']; if ($portfolio_single_sidebar == 3) { echo "selected='selected'"; } } ?> value="3"><?php esc_html_e( 'Sidebar 1/3 left', 'elision-core' ); ?></option>
									<option <?php if(isset($options['portfolio_single_sidebar'])){$portfolio_single_sidebar = $options['portfolio_single_sidebar']; if ($portfolio_single_sidebar == 4) { echo "selected='selected'"; } } ?> value="4"><?php esc_html_e( 'Sidebar 1/4 left', 'elision-core' ); ?></option>
									
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Sidebar to display', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[portfolio_single_sidebar_custom_display]">
									<option value="" <?php if(isset($options['portfolio_single_sidebar_custom_display'])){ $portfolio_single_sidebar_custom_display = $options['portfolio_single_sidebar_custom_display'];  if ($portfolio_single_sidebar_custom_display == "" ) { echo "selected='selected'";  } }?>></option>
									<?php
									foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
										if(elision_qode_is_user_made_sidebar(ucwords($sidebar['name']))){
									?>
										<option value="<?php echo ucwords( $sidebar['id'] ); ?>" <?php if(isset($options['portfolio_single_sidebar_custom_display'])){ $portfolio_single_sidebar_custom_display = $options['portfolio_single_sidebar_custom_display'];  if ($portfolio_single_sidebar_custom_display == ucwords( $sidebar['id'] ) ) { echo "selected='selected'";  } }?>>
											<?php echo ucwords( $sidebar['name'] ); ?>
										</option>
										<?php	
											}
										}
										?>
								</select>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Portfolio single slug', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<input name="qode_options_elision[portfolio_single_slug]" type="text" value="<?php if (isset($options['portfolio_single_slug']) && $options['portfolio_single_slug'] != "") { echo esc_attr($options['portfolio_single_slug']); } ?>" />
									<?php echo sprintf(esc_html__('When you put the slug for portfolio page, you should navigate to ','elision-core').'<code>%s</code>'.esc_html__(' and click save button.','elision-core'), '<a href="'. admin_url('options-permalink.php') .'">'. esc_html__('Settings -> Permalinks','elision-core') .'</a>'); ?>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Blog', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Quote/Link box color', 'elision-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['blog_quote_link_box_color']){ echo 'background-color:'.esc_attr($options['blog_quote_link_box_color']).';'; } ?>"></div></div>
								<input name="qode_options_elision[blog_quote_link_box_color]" type="text" value="<?php if (isset($options['blog_quote_link_box_color']) && $options['blog_quote_link_box_color']) { echo esc_attr($options['blog_quote_link_box_color']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Blog list', 'elision-core' ); ?></h2></td></tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Pagination', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[pagination]">
									<option <?php if ($options['pagination'] == 0) { echo "selected='selected'"; } ?> value="0"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if ($options['pagination'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Choose blog layout', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[blog_style]">
									<option <?php if ($options['blog_style'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e('Blog Large Image', 'elision-core'); ?></option>
									<option <?php if ($options['blog_style'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e('Blog Masonry', 'elision-core'); ?></option>
									<option <?php if ($options['blog_style'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e('Blog Large Image Whole Post', 'elision-core'); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Blog sidebar', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[category_blog_sidebar]">
									<option <?php if ($options['category_blog_sidebar'] == "default") { echo "selected='selected'"; } ?> value="default"><?php esc_html_e( 'No Sidebar', 'elision-core' ); ?></option>
									<option <?php if ($options['category_blog_sidebar'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Sidebar 1/3 right', 'elision-core' ); ?></option>
									<option <?php if ($options['category_blog_sidebar'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Sidebar 1/4 right', 'elision-core' ); ?></option>
									<option <?php if ($options['category_blog_sidebar'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Sidebar 1/3 left', 'elision-core' ); ?></option>
									<option <?php if ($options['category_blog_sidebar'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e( 'Sidebar 1/4 left', 'elision-core' ); ?></option>
									
								</select>
								<?php esc_html_e('For category list', 'elision-core'); ?>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Hide comments', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[blog_hide_comments]">
									<option <?php if(isset($options['blog_hide_comments'])){ $blog_hide_comments = $options['blog_hide_comments']; if ($blog_hide_comments == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['blog_hide_comments'])){ $blog_hide_comments = $options['blog_hide_comments']; if ($blog_hide_comments == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Blog Qode Like', 'elision-core'); ?></td>
								<td>
									<select name="qode_options_elision[qode_like]">
										<option <?php if (isset($options['qode_like'])){ $qode_like = $options['qode_like']; if ($qode_like == 'on') { echo "selected='selected'"; } } ?> value="on"><?php esc_html_e( 'On', 'elision-core' ); ?></option>
										<option <?php if (isset($options['qode_like'])){ $qode_like = $options['qode_like']; if ($qode_like == 'off') { echo "selected='selected'"; } } ?> value="off"><?php esc_html_e( 'Off', 'elision-core' ); ?></option>
									</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Page Range For Pagination', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[blog_page_range]" type="text" value="<?php if (isset($options['blog_page_range']) && $options['blog_page_range']) { echo esc_attr($options['blog_page_range']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Number of words', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[number_of_chars]" type="text" class="colorpicker-input" value="<?php if ($options['number_of_chars']) { echo esc_attr($options['number_of_chars']); } ?>" size="10" maxlength="10" />
								<?php esc_html_e('Number of words in blog listing', 'elision-core'); ?>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Number of words in masonry blog template', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[number_of_chars_masonry]" type="text" class="colorpicker-input" value="<?php if ($options['number_of_chars_masonry']) { echo esc_attr($options['number_of_chars_masonry']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Number of words in large image blog template', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[number_of_chars_large_image]" type="text" class="colorpicker-input" value="<?php if ($options['number_of_chars_large_image']) { echo esc_attr($options['number_of_chars_large_image']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Blog single', 'elision-core' ); ?></h2></td></tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Sidebar layout', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[blog_single_sidebar]">
									<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == "default") { echo "selected='selected'"; } } ?> value="default"><?php esc_html_e( 'No Sidebar', 'elision-core' ); ?></option>
									<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == 1) { echo "selected='selected'"; } } ?> value="1"><?php esc_html_e( 'Sidebar 1/3 right', 'elision-core' ); ?></option>
									<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == 2) { echo "selected='selected'"; } } ?> value="2"><?php esc_html_e( 'Sidebar 1/4 right', 'elision-core' ); ?></option>
									<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == 3) { echo "selected='selected'"; } } ?> value="3"><?php esc_html_e( 'Sidebar 1/3 left', 'elision-core' ); ?></option>
									<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == 4) { echo "selected='selected'"; } } ?> value="4"><?php esc_html_e( 'Sidebar 1/4 left', 'elision-core' ); ?></option>
									
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Sidebar to display', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[blog_single_sidebar_custom_display]">
									<option value="" <?php if(isset($options['blog_single_sidebar_custom_display'])){ $blog_single_sidebar_custom_display = $options['blog_single_sidebar_custom_display'];  if ($blog_single_sidebar_custom_display == "" ) { echo "selected='selected'";  } }?>></option>
									<?php
									foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
										if(elision_qode_is_user_made_sidebar(ucwords($sidebar['name']))){
									?>
										<option value="<?php echo ucwords( $sidebar['id'] ); ?>" <?php if(isset($options['blog_single_sidebar_custom_display'])){ $blog_single_sidebar_custom_display = $options['blog_single_sidebar_custom_display'];  if ($blog_single_sidebar_custom_display == ucwords( $sidebar['id'] ) ) { echo "selected='selected'";  } }?>>
											<?php echo ucwords( $sidebar['name'] ); ?>
										</option>
										<?php	
											}
										}
										?>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Show Blog Author', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[blog_author_info]">
									<option <?php if(isset($options['blog_author_info'])){$blog_author_info = $options['blog_author_info']; if ($blog_author_info == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['blog_author_info'])){$blog_author_info = $options['blog_author_info']; if ($blog_author_info == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e('Contact page', 'elision-core'); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Mail send to', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[receive_mail]" type="text" value="<?php if ($options['receive_mail']) { echo esc_attr($options['receive_mail']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Enable Contact Form', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[enable_contact_form]">
									<option <?php if ($options['enable_contact_form'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if ($options['enable_contact_form'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Hide Website Field', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[hide_contact_form_website]">
									<option <?php if(isset($options['hide_contact_form_website'])){ $hide_contact_form_website = $options['hide_contact_form_website']; if ($hide_contact_form_website == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['hide_contact_form_website'])){ $hide_contact_form_website = $options['hide_contact_form_website']; if ($hide_contact_form_website == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Email From', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[email_from]" type="text" value="<?php if ($options['email_from']) { echo esc_attr($options['email_from']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Email Subject', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[email_subject]" type="text" value="<?php if ($options['email_subject']) { echo esc_attr($options['email_subject']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Use reCaptcha', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[use_recaptcha]">
									<option <?php if ($options['use_recaptcha'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if ($options['use_recaptcha'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('ReCaptcha public key', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[recaptcha_public_key]" type="text" value="<?php if ($options['recaptcha_public_key']) { echo esc_attr($options['recaptcha_public_key']); } ?>"  />
							
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('ReCaptcha private key', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[recaptcha_private_key]" type="text" value="<?php if ($options['recaptcha_private_key']) { echo esc_attr($options['recaptcha_private_key']); } ?>"  />
							</td>
						</tr>			
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Heading above contact form', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[contact_heading_above]" type="text" value="<?php if ($options['contact_heading_above']) { echo esc_attr($options['contact_heading_above']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Enable Google Map', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[enable_google_map]">
									<option <?php if ($options['enable_google_map'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if ($options['enable_google_map'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<?php if($options['enable_google_map'] == "yes") : ?>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Pin image', 'elision-core'); ?></td>
							<td>	
								<div class="inline" style="width: 600px;">
								<input type="text" id="google_maps_pin_image" name="qode_options_elision[google_maps_pin_image]" class="google_maps_pin_image" value="<?php if (isset($options['google_maps_pin_image'])) { echo esc_attr($options['google_maps_pin_image']); } else { echo QODE_ROOT."/img/pin.png"; } ?>" size="70">
								<input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address', 'elision-core'); ?></td>
							<td>
								<input id="google_maps_address" name="qode_options_elision[google_maps_address]" value="<?php if (isset($options['google_maps_address'])) { echo esc_attr($options['google_maps_address']); } ?>" size="130" />
								<?php esc_html_e('Example (Louvre Museum, Paris, France)', 'elision-core'); ?>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address 2', 'elision-core'); ?></td>
							<td>
								<input id="google_maps_address2" name="qode_options_elision[google_maps_address2]" value="<?php if (isset($options['google_maps_address2'])) { echo esc_attr($options['google_maps_address2']); } ?>" size="130" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address 3', 'elision-core'); ?></td>
							<td>
								<input id="google_maps_address3" name="qode_options_elision[google_maps_address3]" value="<?php if (isset($options['google_maps_address3'])) { echo esc_attr($options['google_maps_address3']); } ?>" size="130" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address 4', 'elision-core'); ?></td>
							<td>
								<input id="google_maps_address4" name="qode_options_elision[google_maps_address4]" value="<?php if (isset($options['google_maps_address4'])) { echo esc_attr($options['google_maps_address4']); } ?>" size="130" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address 5', 'elision-core'); ?></td>
							<td>
								<input id="google_maps_address5" name="qode_options_elision[google_maps_address5]" value="<?php if (isset($options['google_maps_address5'])) { echo esc_attr($options['google_maps_address5']); } ?>" size="130" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map zoom', 'elision-core'); ?></td>
							<td>
								<input id="google_maps_zoom" name="qode_options_elision[google_maps_zoom]" value="<?php if (isset($options['google_maps_zoom'])) { echo esc_attr($options['google_maps_zoom']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map height (px)', 'elision-core'); ?></td>
							<td>
								<input id="google_maps_height" name="qode_options_elision[google_maps_height]" value="<?php if (isset($options['google_maps_height'])) { echo esc_attr($options['google_maps_height']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map style', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[google_maps_style]">
									<option <?php if(isset($options['google_maps_style'])){ $google_maps_style = $options['google_maps_style']; if ($google_maps_style == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['google_maps_style'])){ $google_maps_style = $options['google_maps_style']; if ($google_maps_style == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map color', 'elision-core'); ?></td>
							<td>
								<div class="inline">
									<div class="colorSelector"><div style="<?php if ($options['google_maps_color']){ echo 'background-color:'.esc_attr($options['google_maps_color']).';'; } ?>"></div></div>
									<input name="qode_options_elision[google_maps_color]" type="text" value="<?php if(isset($options['google_maps_color'])){ if ($options['google_maps_color']) { echo esc_attr($options['google_maps_color']); } } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>	
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map scroll on mouse wheel', 'elision-core'); ?></td>
							<td>
								<select name="qode_options_elision[google_maps_scroll_wheel]">
									<option <?php if(isset($options['google_maps_scroll_wheel'])){ $google_maps_scroll_wheel = $options['google_maps_scroll_wheel']; if ($google_maps_scroll_wheel == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
									<option <?php if(isset($options['google_maps_scroll_wheel'])){ $google_maps_scroll_wheel = $options['google_maps_scroll_wheel']; if ($google_maps_scroll_wheel == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
								</select>
							</td>
						</tr>
						<?php endif; ?>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( '404 page', 'elision-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Title', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[404_title]" type="text" value="<?php if ($options['404_title']) { echo esc_attr($options['404_title']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Subtitle', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[404_subtitle]" type="text" value="<?php if (isset($options['404_subtitle']) && $options['404_subtitle']) { echo esc_attr($options['404_subtitle']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Text', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[404_text]" type="text" value="<?php if ($options['404_text']) { echo esc_attr($options['404_text']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Back to home label', 'elision-core'); ?></td>
							<td>
								<input name="qode_options_elision[404_backlabel]" type="text" value="<?php if ($options['404_backlabel']) { echo esc_attr($options['404_backlabel']); } ?>"  />
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
            <h3><?php esc_html_e( 'Social', 'elision-core' ); ?></h3>
            <div>
                <table class="form-table">
                    <tbody>
                    <tr valign="top">
                        <td scope="row" width="150"><?php esc_html_e('Enable Social Share', 'elision-core'); ?></td>
                        <td>
                            <select name="qode_options_elision[enable_social_share]">
                                <option <?php if(isset($options['enable_social_share'])){ $enable_social_share = $options['enable_social_share']; if ($enable_social_share == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
                                <option <?php if(isset($options['enable_social_share'])){ $enable_social_share = $options['enable_social_share']; if ($enable_social_share == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
                            </select>
                        </td>
                    </tr>
                    <tr valign="top">
                        <td scope="row" width="150"><?php esc_html_e('Facebook', 'elision-core'); ?></td>
                        <td>
                            <div class="inline">
                                <?php esc_html_e('Enable Facebook', 'elision-core'); ?>
                                <select name="qode_options_elision[enable_facebook_share]">
                                    <option <?php if(isset($options['enable_facebook_share'])){ $enable_facebook_share = $options['enable_facebook_share']; if ($enable_facebook_share == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
                                    <option <?php if(isset($options['enable_facebook_share'])){ $enable_facebook_share = $options['enable_facebook_share']; if ($enable_facebook_share == "yes") { echo "selected='selected'"; } }?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
                                </select>
                            </div>
                            <div class="inline" style="width: 780px;">
                                <?php esc_html_e('Share Icon', 'elision-core'); ?>
                                <input type="text" id="facebook_icon" name="qode_options_elision[facebook_icon]" class="facebook_icon" value="<?php if (isset($options['facebook_icon'])) { echo esc_attr($options['facebook_icon']); } ?>" size="70">
                                <input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
                            </div>
                        </td>
                    </tr>
                    <tr valign="top">
                        <td scope="row" width="150"><?php esc_html_e('Twitter', 'elision-core'); ?></td>
                        <td>
                            <div class="inline">
                                <?php esc_html_e('Enable Twitter', 'elision-core'); ?>
                                <select name="qode_options_elision[enable_twitter_share]">
                                    <option <?php if(isset($options['enable_twitter_share'])){ $enable_twitter_share = $options['enable_twitter_share']; if ($enable_twitter_share == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
                                    <option <?php if(isset($options['enable_twitter_share'])){ $enable_twitter_share = $options['enable_twitter_share']; if ($enable_twitter_share == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
                                </select>
                            </div>
                            <div class="inline" style="width: 780px;">
                                <?php esc_html_e('Share Icon', 'elision-core'); ?>
                                <input type="text" id="twitter_icon" name="qode_options_elision[twitter_icon]" class="twitter_icon" value="<?php if (isset($options['twitter_icon'])) { echo esc_attr($options['twitter_icon']); } ?>" size="70">
                                <input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
                            </div>
                            <div class="inline">
                                <?php esc_html_e('Via', 'elision-core'); ?>
                                <input name="qode_options_elision[twitter_via]" type="text" value="<?php if (isset($options['twitter_via'])) { echo esc_attr($options['twitter_via']); } ?>"  />
                            </div>
                        </td>
                    </tr>
                    <tr valign="top">
                        <td scope="row" width="150"><?php esc_html_e('Google +', 'elision-core'); ?></td>
                        <td>
                            <div class="inline">
                                <?php esc_html_e('Enable Google +', 'elision-core'); ?>
                                <select name="qode_options_elision[enable_google_plus]">
                                    <option <?php if(isset($options['enable_google_plus'])){ $enable_google_plus = $options['enable_google_plus']; if ($enable_google_plus == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
                                    <option <?php if(isset($options['enable_google_plus'])){ $enable_google_plus = $options['enable_google_plus']; if ($enable_google_plus == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
                                </select>
                            </div>
                            <div class="inline" style="width: 780px;">
                                <?php esc_html_e('Share Icon', 'elision-core'); ?>
                                <input type="text" id="google_plus_icon" name="qode_options_elision[google_plus_icon]" class="google_plus_icon" value="<?php if (isset($options['google_plus_icon'])) { echo esc_attr($options['google_plus_icon']); } ?>" size="70">
                                <input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
                            </div>
                        </td>
                    </tr>
                    <tr valign="top">
                        <td scope="row" width="150"><?php esc_html_e('LinkedIn', 'elision-core'); ?></td>
                        <td>
                            <div class="inline">
                                <?php esc_html_e('Enable LinkedIn', 'elision-core'); ?>
                                <select name="qode_options_elision[enable_linkedin]">
                                    <option <?php if(isset($options['enable_linkedin'])){ $enable_linkedin = $options['enable_linkedin']; if ($enable_linkedin == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
                                    <option <?php if(isset($options['enable_linkedin'])){ $enable_linkedin = $options['enable_linkedin']; if ($enable_linkedin == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
                                </select>
                            </div>
                            <div class="inline" style="width: 780px;">
                                <?php esc_html_e('Share Icon', 'elision-core'); ?>
                                <input type="text" id="linkedin_icon" name="qode_options_elision[linkedin_icon]" class="linkedin_icon" value="<?php if (isset($options['linkedin_icon'])) { echo esc_attr($options['linkedin_icon']); } ?>" size="70">
                                <input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
                            </div>
                        </td>
                    </tr>
                    <tr valign="top">
                        <td scope="row" width="150"><?php esc_html_e('Tumblr', 'elision-core'); ?></td>
                        <td>
                            <div class="inline">
                                <?php esc_html_e('Enable Tumblr', 'elision-core'); ?>
                                <select name="qode_options_elision[enable_tumblr]">
                                    <option <?php if(isset($options['enable_tumblr'])){ $enable_tumblr = $options['enable_tumblr']; if ($enable_tumblr == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
                                    <option <?php if(isset($options['enable_tumblr'])){ $enable_tumblr = $options['enable_tumblr']; if ($enable_tumblr == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
                                </select>
                            </div>
                            <div class="inline" style="width: 780px;">
                                <?php esc_html_e('Tumblr Icon', 'elision-core'); ?>
                                <input type="text" id="tumblr_icon" name="qode_options_elision[tumblr_icon]" class="tumblr_icon" value="<?php if (isset($options['tumblr_icon'])) { echo esc_attr($options['tumblr_icon']); } ?>" size="70">
                                <input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
                            </div>
                        </td>
                    </tr>
                    <tr valign="top">
                        <td scope="row" width="150"><?php esc_html_e('Pinterest', 'elision-core'); ?></td>
                        <td>
                            <div class="inline">
                                <?php esc_html_e('Enable Pinterest', 'elision-core'); ?>
                                <select name="qode_options_elision[enable_pinterest]">
                                    <option <?php if(isset($options['enable_pinterest'])){ $enable_pinterest = $options['enable_pinterest']; if ($enable_pinterest == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
                                    <option <?php if(isset($options['enable_pinterest'])){ $enable_pinterest = $options['enable_pinterest']; if ($enable_pinterest == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
                                </select>
                            </div>
                            <div class="inline" style="width: 780px;">
                                <?php esc_html_e('Pinterest Icon', 'elision-core'); ?>
                                <input type="text" id="pinterest_icon" name="qode_options_elision[pinterest_icon]" class="pinterest_icon" value="<?php if (isset($options['pinterest_icon'])) { echo esc_attr($options['pinterest_icon']); } ?>" size="70">
                                <input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
                            </div>
                        </td>
                    </tr>
                    <tr valign="top">
                        <td scope="row" width="150"><?php esc_html_e('VK', 'elision-core'); ?></td>
                        <td>
                            <div class="inline">
                                <?php esc_html_e('Enable VK', 'elision-core'); ?>
                                <select name="qode_options_elision[enable_vk]">
                                    <option <?php if(isset($options['enable_vk'])){ $enable_vk = $options['enable_vk']; if ($enable_vk == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
                                    <option <?php if(isset($options['enable_vk'])){ $enable_vk = $options['enable_vk']; if ($enable_vk == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
                                </select>
                            </div>
                            <div class="inline" style="width: 780px;">
                                <?php esc_html_e('VK Icon', 'elision-core'); ?>
                                <input type="text" id="vk_icon" name="qode_options_elision[vk_icon]" class="vk_icon" value="<?php if (isset($options['vk_icon'])) { echo esc_attr($options['vk_icon']); } ?>" size="70">
                                <input class="upload_button" type="button" value="<?php esc_attr_e( 'Upload file', 'elision-core' ); ?>">
                            </div>
                        </td>
                    </tr>
                    <tr valign="top">
                        <td scope="row" width="150"><?php esc_html_e('Show For', 'elision-core'); ?></td>
                        <td>
                            <?php
                            $args_post_types = array(
                                'public'   => true
                            );
                            $post_types = get_post_types($args_post_types);
                            foreach ($post_types as $post_type ) {

                                $post_type_object = get_post_type_object($post_type );
                                ?>
                                <input type="checkbox" value="<?php echo esc_attr($post_type); ?>" <?php if (isset($options["post_types_names_$post_type"]) && ($options["post_types_names_$post_type"] == "$post_type")){ echo "checked='checked'"; }?> name="qode_options_elision[post_types_names_<?php echo esc_attr($post_type); ?>]" /><?php echo " " . $post_type_object->labels->singular_name;  ?><br /><br />

                            <?php } ?>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <?php		display_save_changes_button(); ?>
            </div>
		</div>
<?php	}


} // end of qode_Theme_Options Class



function display_save_changes_button() {
	    echo ('
		    <table class="form-table">
			<tbody>
			    <tr valign="middle">
				<th scope="row" width="150">&nbsp;</th>
				<td>
				    <div class="submit" style="padding:10px 0 0 80px; float:right; clear:both;">
					<input type="hidden" id="qode_submit" value="1" name="qode_submit"/>
					<input class="button-primary" type="submit" name="submit" value="'.esc_attr__('Save Changes', 'elision-core').'" />
				    </div>
				</td>
			    </tr>
			</tbody>
		    </table>');
}




$my_Qode_Theme_Options = new Qode_Theme_Options();


