<?php

/* Create Portfolio, Testimonial, Slider and Carousel post type */
if ( ! function_exists( 'elision_core_create_post_type' ) ) {
	function elision_core_create_post_type() {
		global $qode_options_elision;
		$slug = 'portfolio_page';
		if ( isset( $qode_options_elision['portfolio_single_slug'] ) && $qode_options_elision['portfolio_single_slug'] != "" ) {
			$slug = $qode_options_elision['portfolio_single_slug'];
		}
		
		register_post_type( 'portfolio_page',
			array(
				'labels'        => array(
					'name'          => esc_html__( 'Portfolio', 'elision-core' ),
					'singular_name' => esc_html__( 'Portfolio Item', 'elision-core' ),
					'add_item'      => esc_html__( 'New Portfolio Item', 'elision-core' ),
					'add_new_item'  => esc_html__( 'Add New Portfolio Item', 'elision-core' ),
					'edit_item'     => esc_html__( 'Edit Portfolio Item', 'elision-core' )
				),
				'public'        => true,
				'has_archive'   => true,
				'rewrite'       => array( 'slug' => $slug ),
				'menu_position' => 4,
				'show_ui'       => true,
				'supports'      => array(
					'author',
					'title',
					'editor',
					'thumbnail',
					'excerpt',
					'page-attributes',
					'revisions'
				)
			)
		);
		
		register_post_type( 'testimonials',
			array(
				'labels'              => array(
					'name'          => esc_html__( 'Testimonials', 'elision-core' ),
					'singular_name' => esc_html__( 'Testimonial', 'elision-core' ),
					'add_item'      => esc_html__( 'New Testimonial', 'elision-core' ),
					'add_new_item'  => esc_html__( 'Add New Testimonial', 'elision-core' ),
					'edit_item'     => esc_html__( 'Edit Testimonial', 'elision-core' )
				),
				'public'              => false,
				'show_in_menu'        => true,
				'rewrite'             => array( 'slug' => 'testimonials' ),
				'menu_position'       => 4,
				'show_ui'             => true,
				'has_archive'         => false,
				'exclude_from_search' => true,
				'hierarchical'        => false,
				'supports'            => array( 'title', 'thumbnail' )
			)
		);
		
		register_post_type( 'slides',
			array(
				'labels'              => array(
					'name'          => esc_html__( 'Qode Slider', 'elision-core' ),
					'menu_name'     => esc_html__( 'Qode Slider', 'elision-core' ),
					'all_items'     => esc_html__( 'Slides', 'elision-core' ),
					'add_new'       => esc_html__( 'Add New Slide', 'elision-core' ),
					'singular_name' => esc_html__( 'Slide', 'elision-core' ),
					'add_item'      => esc_html__( 'New Slide', 'elision-core' ),
					'add_new_item'  => esc_html__( 'Add New Slide', 'elision-core' ),
					'edit_item'     => esc_html__( 'Edit Slide', 'elision-core' )
				),
				'public'              => false,
				'show_in_menu'        => true,
				'rewrite'             => array( 'slug' => 'slides' ),
				'menu_position'       => 4,
				'show_ui'             => true,
				'has_archive'         => false,
				'exclude_from_search' => true,
				'hierarchical'        => false,
				'supports'            => array( 'title', 'thumbnail', 'page-attributes' ),
				'menu_icon'           => QODE_ROOT . '/img/favicon.ico'
			)
		);
		
		register_post_type( 'carousels',
			array(
				'labels'              => array(
					'name'          => esc_html__( 'Qode Carousel', 'elision-core' ),
					'menu_name'     => esc_html__( 'Qode Carousel', 'elision-core' ),
					'all_items'     => esc_html__( 'Carousel Items', 'elision-core' ),
					'add_new'       => esc_html__( 'Add New Carousel Item', 'elision-core' ),
					'singular_name' => esc_html__( 'Carousel Item', 'elision-core' ),
					'add_item'      => esc_html__( 'New Carousel Item', 'elision-core' ),
					'add_new_item'  => esc_html__( 'Add New Carousel Item', 'elision-core' ),
					'edit_item'     => esc_html__( 'Edit Carousel Item', 'elision-core' )
				),
				'public'              => false,
				'show_in_menu'        => true,
				'rewrite'             => array( 'slug' => 'carousels' ),
				'menu_position'       => 4,
				'show_ui'             => true,
				'has_archive'         => false,
				'exclude_from_search' => true,
				'hierarchical'        => false,
				'supports'            => array( 'title' ),
				'menu_icon'           => QODE_ROOT . '/img/favicon.ico'
			)
		);
		
		/* Create Portfolio Categories */
		
		$labels = array(
			'name'              => esc_html__( 'Portfolio Categories', 'elision-core' ),
			'singular_name'     => esc_html__( 'Portfolio Category', 'elision-core' ),
			'search_items'      => esc_html__( 'Search Portfolio Categories', 'elision-core' ),
			'all_items'         => esc_html__( 'All Portfolio Categories', 'elision-core' ),
			'parent_item'       => esc_html__( 'Parent Portfolio Category', 'elision-core' ),
			'parent_item_colon' => esc_html__( 'Parent Portfolio Category:', 'elision-core' ),
			'edit_item'         => esc_html__( 'Edit Portfolio Category', 'elision-core' ),
			'update_item'       => esc_html__( 'Update Portfolio Category', 'elision-core' ),
			'add_new_item'      => esc_html__( 'Add New Portfolio Category', 'elision-core' ),
			'new_item_name'     => esc_html__( 'New Portfolio Category Name', 'elision-core' ),
			'menu_name'         => esc_html__( 'Portfolio Categories', 'elision-core' ),
		);
		
		register_taxonomy( 'portfolio_category', array( 'portfolio_page' ), array(
			'hierarchical' => true,
			'labels'       => $labels,
			'show_ui'      => true,
			'query_var'    => true,
			'rewrite'      => array( 'slug' => 'portfolio-category' ),
		) );
		
		/* Create Testimonials Category */
		
		$labels = array(
			'name'              => esc_html__( 'Testimonials Categories', 'elision-core' ),
			'singular_name'     => esc_html__( 'Testimonial Category', 'elision-core' ),
			'search_items'      => esc_html__( 'Search Testimonials Categories', 'elision-core' ),
			'all_items'         => esc_html__( 'All Testimonials Categories', 'elision-core' ),
			'parent_item'       => esc_html__( 'Parent Testimonial Category', 'elision-core' ),
			'parent_item_colon' => esc_html__( 'Parent Testimonial Category:', 'elision-core' ),
			'edit_item'         => esc_html__( 'Edit Testimonials Category', 'elision-core' ),
			'update_item'       => esc_html__( 'Update Testimonials Category', 'elision-core' ),
			'add_new_item'      => esc_html__( 'Add New Testimonials Category', 'elision-core' ),
			'new_item_name'     => esc_html__( 'New Testimonials Category Name', 'elision-core' ),
			'menu_name'         => esc_html__( 'Testimonials Categories', 'elision-core' ),
		);
		
		register_taxonomy( 'testimonials_category', array( 'testimonials' ), array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'           => array( 'slug' => 'testimonials-category' ),
		) );
		
		/* Create Slider Category */
		
		$labels = array(
			'name'              => esc_html__( 'Sliders', 'elision-core' ),
			'singular_name'     => esc_html__( 'Slider', 'elision-core' ),
			'search_items'      => esc_html__( 'Search Sliders', 'elision-core' ),
			'all_items'         => esc_html__( 'All Sliders', 'elision-core' ),
			'parent_item'       => esc_html__( 'Parent Slider', 'elision-core' ),
			'parent_item_colon' => esc_html__( 'Parent Slider:', 'elision-core' ),
			'edit_item'         => esc_html__( 'Edit Slider', 'elision-core' ),
			'update_item'       => esc_html__( 'Update Slider', 'elision-core' ),
			'add_new_item'      => esc_html__( 'Add New Slider', 'elision-core' ),
			'new_item_name'     => esc_html__( 'New Slider Name', 'elision-core' ),
			'menu_name'         => esc_html__( 'Sliders', 'elision-core' ),
		);
		
		register_taxonomy( 'slides_category', array( 'slides' ), array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'           => array( 'slug' => 'slides-category' ),
		) );
		
		/* Create Carousel Category */
		
		$labels = array(
			'name'              => esc_html__( 'Carousels', 'elision-core' ),
			'singular_name'     => esc_html__( 'Carousel', 'elision-core' ),
			'search_items'      => esc_html__( 'Search Carousels', 'elision-core' ),
			'all_items'         => esc_html__( 'All Carousels', 'elision-core' ),
			'parent_item'       => esc_html__( 'Parent Carousel', 'elision-core' ),
			'parent_item_colon' => esc_html__( 'Parent Carousel:', 'elision-core' ),
			'edit_item'         => esc_html__( 'Edit Carousel', 'elision-core' ),
			'update_item'       => esc_html__( 'Update Carousel', 'elision-core' ),
			'add_new_item'      => esc_html__( 'Add New Carousel', 'elision-core' ),
			'new_item_name'     => esc_html__( 'New Carousel Name', 'elision-core' ),
			'menu_name'         => esc_html__( 'Carousels', 'elision-core' ),
		);
		
		register_taxonomy( 'carousels_category', array( 'carousels' ), array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'           => array( 'slug' => 'carousels-category' ),
		) );
	}
	
	add_action( 'init', 'elision_core_create_post_type', 0 );
}