<?php

include_once 'shortcodes/shortcodes.php';
include_once 'qode-options.php';
include_once 'custom-fields.php';
include_once 'custom-fields-post-formats.php';
include_once 'qode-custom-post-types.php';
include_once 'qode-like.php';
include_once 'qode-seo.php';
include_once 'widgets/helper.php';

add_filter( 'widget_text', 'do_shortcode' );
add_filter( 'call_to_action_widget', 'do_shortcode' );

if ( ! function_exists( 'elision_core_add_google_analytic' ) ) {
	function elision_core_add_google_analytic() {
		global $qode_options_elision;
		
		if ( isset( $qode_options_elision['google_analytics_code'] ) && $qode_options_elision['google_analytics_code'] != "" ) { ?>
			<script>
				var _gaq = _gaq || [];
				_gaq.push(['_setAccount', '<?php echo esc_attr( $qode_options_elision['google_analytics_code'] ); ?>']);
				_gaq.push(['_trackPageview']);
				
				(function () {
					var ga = document.createElement('script');
					ga.type = 'text/javascript';
					ga.async = true;
					ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
					var s = document.getElementsByTagName('script')[0];
					s.parentNode.insertBefore(ga, s);
				})();
			</script>
		<?php }
	}
	
	add_action( 'elision_qode_after_wrapper_inner_begin', 'elision_core_add_google_analytic' );
}

if ( ! function_exists( 'elision_core_add_content_classes' ) ) {
	function elision_core_add_content_classes( $classes ) {
		$qode_page_id = elision_qode_get_page_id();
		$animation    = get_post_meta( $qode_page_id, "qode_show-animation", true );
		
		if ( ! empty( $_SESSION['qode_animation'] ) && $animation == "" ) {
			$animation = $_SESSION['qode_animation'];
		}
		
		if ( ! empty( $animation ) ) {
			$classes .= ' ' . $animation;
		}
		
		return $classes;
	}
	
	add_filter( 'elision_qode_content_classes', 'elision_core_add_content_classes' );
}

if ( ! function_exists( 'elision_core_add_inline_html_after_content' ) ) {
	function elision_core_add_inline_html_after_content() {
		global $qode_options_elision;
		$qode_page_id = elision_qode_get_page_id();
		$animation    = get_post_meta( $qode_page_id, "qode_show-animation", true );
		
		if ( ! empty( $_SESSION['qode_animation'] ) && $animation == "" ) {
			$animation = $_SESSION['qode_animation'];
		}
		
		if ( $qode_options_elision['page_transitions'] == "1" || $qode_options_elision['page_transitions'] == "2" || $qode_options_elision['page_transitions'] == "3" || $qode_options_elision['page_transitions'] == "4" || ( $animation == "updown" ) || ( $animation == "fade" ) || ( $animation == "updown_fade" ) || ( $animation == "leftright" ) ) { ?>
			<div class="meta">
				
				<?php
				/**
				 * qode_ajax_meta hook
				 *
				 * @hooked qode_ajax_meta - 10
				 */
				do_action( 'qode_ajax_meta' ); ?>
				<span id="qode_page_id"><?php echo esc_attr( $qode_page_id ); ?></span>
				<div class="body_classes"><?php echo implode( ',', get_body_class() ); ?></div>
			</div>
		<?php }
	}
	
	add_action( 'elision_qode_after_content_begin', 'elision_core_add_inline_html_after_content' );
}

if ( ! function_exists( 'elision_core_add_inline_style_after_content_inner' ) ) {
	function elision_core_add_inline_style_after_content_inner() {
		$qode_page_id = elision_qode_get_page_id();
		
		$header_color_transparency_per_page = "";
		if(get_post_meta($qode_page_id, "qode_header_color_per_page", true) != ""){
			$header_color_transparency_per_page = get_post_meta($qode_page_id, "qode_header_color_transparency_per_page", true);
		}
		
		$header_color_per_page = "";
		if(get_post_meta($qode_page_id, "qode_header_color_per_page", true) != ""){
			if($header_color_transparency_per_page != ""){
				$header_background_color = elision_qode_hex2rgb(get_post_meta($qode_page_id, "qode_header_color_per_page", true));
				$header_color_per_page = "<style type='text/css'>
				@media only screen and (min-width: 1000px){
					.header_bottom { background-color:rgba(" . $header_background_color[0] . ", " . $header_background_color[1] . ", " . $header_background_color[2] . ", " . $header_color_transparency_per_page . "); }
				}
				</style>";
			}else{
				$header_color_per_page = "<style type='text/css'>
				@media only screen and (min-width: 1000px){
					.header_bottom { background-color:" . get_post_meta($qode_page_id, "qode_header_color_per_page", true) . "; }
				}
				</style>";
			}
		}
		
		echo elision_qode_get_module_part( $header_color_per_page );
	}
	
	add_action( 'elision_qode_after_content_inner_begin', 'elision_core_add_inline_style_after_content_inner' );
}

if ( ! function_exists( 'elision_core_visual_composer_custom_shortcodce_css' ) ) {
	function elision_core_visual_composer_custom_shortcodce_css() {
		if ( elision_qode_visual_composer_installed() ) {
			if ( is_page() || is_single() || is_singular( 'portfolio_page' ) ) {
				$shortcodes_custom_css = get_post_meta( elision_qode_get_page_id(), '_wpb_shortcodes_custom_css', true );
				if ( ! empty( $shortcodes_custom_css ) ) {
					echo '<style type="text/css" data-type="vc_shortcodes-custom-css-' . elision_qode_get_page_id() . '">';
					echo elision_qode_get_module_part( $shortcodes_custom_css );
					echo '</style>';
				}
				$post_custom_css = get_post_meta( elision_qode_get_page_id(), '_wpb_post_custom_css', true );
				if ( ! empty( $post_custom_css ) ) {
					echo '<style type="text/css" data-type="vc_custom-css-' . elision_qode_get_page_id() . '">';
					echo elision_qode_get_module_part( $post_custom_css );
					echo '</style>';
				}
			}
		}
	}
	
	add_action( 'qode_visual_composer_custom_shortcodce_css', 'elision_core_visual_composer_custom_shortcodce_css' );
}

// QODE CUSTOM TAXONOMY FIELD
if ( ! function_exists( 'elision_core_slides_category_taxonomy_custom_fields' ) ) {
	function elision_core_slides_category_taxonomy_custom_fields( $tag ) {
		$t_id      = $tag->term_id; // Get the ID of the term you're editing
		$term_meta = get_option( "taxonomy_term_$t_id" );
		?>
		
		<tr class="form-field">
			<th scope="row" valign="top">
				<label for="shortcode"><?php esc_html_e( 'Effect on header (dark/light style)', 'elision-core' ); ?></label>
			</th>
			<td>
				<select name="term_meta[header_effect]" id="term_meta[header_effect]">
					<option <?php if ( $term_meta['header_effect'] == 'no' ) {
						echo "selected='selected'";
					} ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
					<option <?php if ( $term_meta['header_effect'] == 'yes' ) {
						echo "selected='selected'";
					} ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
				</select>
			</td>
		</tr>
		<tr class="form-field">
			<th scope="row" valign="top">
				<label for="shortcode"><?php esc_html_e( 'Show prev/next thumbs', 'elision-core' ); ?></label>
			</th>
			<td>
				<select name="term_meta[slider_thumbs]" id="term_meta[slider_thumbs]">
					<option <?php if ( $term_meta['slider_thumbs'] == 'no' ) {
						echo "selected='selected'";
					} ?> value="no"><?php esc_html_e( 'No', 'elision-core' ); ?></option>
					<option <?php if ( $term_meta['slider_thumbs'] == 'yes' ) {
						echo "selected='selected'";
					} ?> value="yes"><?php esc_html_e( 'Yes', 'elision-core' ); ?></option>
				</select>
			</td>
		</tr>
		<tr class="form-field">
			<th scope="row" valign="top">
				<label for="shortcode"><?php esc_html_e( 'Slider shortcode', 'elision-core' ); ?></label>
			</th>
			<td>
				<input type="text" name="term_meta[shortcode]" id="term_meta[shortcode]" size="25" style="width:60%;" value="<?php echo esc_attr( $tag->slug ) ? "[qode_slider slider='" . $tag->slug . "' auto_start='true' animation_type='slide' slide_animation='6000' height='' background_color='']" : ""; ?>" readonly><br/>
				<span class="description"><?php esc_html_e( 'Use this shortcode to insert it on page', 'elision-core' ); ?></span>
			</td>
		</tr>
		
		<?php
	}
	
	add_action( 'slides_category_edit_form_fields', 'elision_core_slides_category_taxonomy_custom_fields', 10, 2 );
}

if ( ! function_exists( 'elision_core_save_taxonomy_custom_fields' ) ) {
	function elision_core_save_taxonomy_custom_fields( $term_id ) {
		if ( isset( $_POST['term_meta'] ) ) {
			$t_id      = $term_id;
			$term_meta = get_option( "taxonomy_term_$t_id" );
			$cat_keys  = array_keys( $_POST['term_meta'] );
			foreach ( $cat_keys as $key ) {
				if ( isset( $_POST['term_meta'][ $key ] ) ) {
					$term_meta[ $key ] = $_POST['term_meta'][ $key ];
				}
			}
			
			update_option( "taxonomy_term_$t_id", $term_meta );
		}
	}
	
	add_action( 'edited_slides_category', 'elision_core_save_taxonomy_custom_fields', 10, 2 );
}

if ( ! function_exists( 'elision_core_theme_columns' ) ) {
	function elision_core_theme_columns( $theme_columns ) {
		$new_columns = array(
			'cb'        => '<input type="checkbox" />',
			'name'      => esc_html__( 'Name', 'elision-core' ),
			'shortcode' => esc_html__( 'Shortcode', 'elision-core' ),
			'slug'      => esc_html__( 'Slug', 'elision-core' ),
			'posts'     => esc_html__( 'Posts', 'elision-core' )
		);
		
		return $new_columns;
	}
	
	add_filter( "manage_edit-slides_category_columns", 'elision_core_theme_columns' );
}

if ( ! function_exists( 'elision_core_manage_theme_columns' ) ) {
	function elision_core_manage_theme_columns( $out, $column_name, $theme_id ) {
		$theme = get_term( $theme_id, 'slides_category' );
		switch ( $column_name ) {
			case 'shortcode':
				$out .= "[qode_slider slider='" . $theme->slug . "' auto_start='true' animation_type='slide' slide_animation='6000' height='' background_color='']";
				break;
			
			default:
				break;
		}
		
		return $out;
	}
	
	add_filter( "manage_slides_category_custom_column", 'elision_core_manage_theme_columns', 10, 3 );
}

if ( ! function_exists( 'elision_core_enqueue_additional_css_styles' ) ) {
	function elision_core_enqueue_additional_css_styles() {
		$icon_packs = array(
			'font-awesome'
		);
		
		foreach ( $icon_packs as $icon_pack ) {
			wp_enqueue_style( "elision-" . $icon_pack, QODE_CSS_ROOT . "/" . $icon_pack . "/css/" . $icon_pack . ".min.css" );
		}
	}
	
	add_action( 'elision_qode_action_enqueue_before_main_css', 'elision_core_enqueue_additional_css_styles' );
}