<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_Subscriptions' ) ) :

/** 
 *
 * @class WCPBC_Subscriptions
 * @version	2.1.6
 */
class WCPBC_Subscriptions {

	/**
	 * Hook actions and filters
	 *
	 * @since 1.0
	 */
	public static function init() {				
	
		add_filter( 'wc_price_based_country_price_meta_keys', array( __CLASS__ , 'price_meta_keys' ) );
		add_filter( 'wc_price_based_country_parent_product_types', array( __CLASS__ , 'parent_product_types' ) );
		
		add_action( 'wc_price_based_country_frontend_princing_init', array( __CLASS__ , 'frontend_init' ) );
		
		add_action( 'wc_price_based_country_admin_init', array( __CLASS__ , 'admin_includes' ) );

		add_action( 'wc_price_based_country_before_product_options_pricing', array( __CLASS__ , 'product_options_pricing' ), 10, 2 );
		add_action( 'wc_price_based_country_before_product_variable_options_pricing', array( __CLASS__ , 'product_variable_options_pricing' ), 10, 4 );		
		
		add_action( 'woocommerce_process_product_meta_subscription', array( 'WCPBC_Admin_Product_Data', 'process_product_simple_countries_prices' ), 10 ) ;						
		add_action( 'wc_price_based_country_process_product_meta_subscription', array( __CLASS__ , 'process_product_meta_subscription' ), 10, 5 ) ;											
		add_action( 'wc_price_based_country_process_product_meta_variable-subscription', array( __CLASS__ , 'process_product_meta_subscription' ), 10, 5 ) ;											
		add_action( 'wc_price_based_country_quick_or_bulk_edit_save_subscription', array( __CLASS__ , 'quick_or_bulk_edit_save_subscription' ), 10, 3 );
		
		add_action( 'woocommerce_bulk_edit_variations', array( __CLASS__, 'bulk_edit_variations' ), 25, 4 );	
		add_action( 'woocommerce_variable_product_sync_data', array( __CLASS__ , 'variable_product_sync'),  20 );			
		
	}	
	
	/**
	 * Add product subscriptions price meta keys
	 *
	 * @return array
	 */
	public static function price_meta_keys( $meta_keys ) {
		array_push( $meta_keys, '_subscription_price', '_subscription_sign_up_fee' );
		return $meta_keys;
	}
	
	/**
	 * Add variable subscriptions product type
	 *
	 * @return array
	 */
	public static function parent_product_types( $types ) {
		array_push( $types, 'variable-subscription' );
		return $types;
	}
	
	/**
	 * Frontend init hooks
	 *
	 * @since 1.0
	 */
	public static function frontend_init() {		
		add_filter( 'woocommerce_product_class', array( __CLASS__ , 'overwrite_subscription_classes' ), 110, 4 );		
		add_filter( 'woocommerce_product_get__subscription_sign_up_fee', array( __CLASS__ , 'subscription_sign_up_fee' ), 10, 2 );		
		add_filter( 'woocommerce_product_variation_get__subscription_sign_up_fee', array( __CLASS__ , 'subscription_sign_up_fee' ), 10, 2 );		
		add_filter( 'woocommerce_product_get__subscription_price', array( __CLASS__ , 'subscription_price' ), 10, 2 );		
		add_filter( 'woocommerce_product_get__min_price_variation_id', array( __CLASS__ , 'min_price_variation_id' ), 10, 2 );		
		add_filter( 'woocommerce_product_variation_get__subscription_price', array( __CLASS__ , 'variation_subscription_price' ), 10, 2 );		
	}

	/**
	 * Overwrite WC_Product_Subscription class
	 *
	 * @since 1.0
	 */
	public static function overwrite_subscription_classes( $classname, $product_type, $post_type, $product_id ) {		
		
		if ( $classname === 'WC_Product_Subscription_Legacy' ) {

			require_once( 'includes/class-wcpbc-product-subscription.php' );

			$classname = 'WCPBC_Product_Subscription';

		} elseif ( $classname == 'WC_Product_Variable_Subscription_Legacy' ) {

			require_once( 'includes/class-wcpbc-product-variable-subscription.php' );			

			$classname = 'WCPBC_Product_Variable_Subscription';

		} elseif ( $classname === 'WC_Product_Subscription' && ! class_exists( 'WC_Product_Subscription_Legacy' ) ) {

			require_once( 'includes/legacy/class-wcpbc-product-subscription-legacy.php' );			

			$classname = 'WCPBC_Product_Subscription_Legacy';

		}  elseif ( $classname == 'WC_Product_Variable_Subscription' && ! class_exists( 'WC_Product_Variable_Subscription_Legacy' ) ) {

			require_once( 'includes/legacy/class-wcpbc-product-variable-subscription-legacy.php' );			

			$classname = 'WCPBC_Product_Variable_Subscription_Legacy';

		}

		return $classname;
	}

	/**
	 * Return subscription sign up fee
	 *
	 * @since 1.1.3
	 */
	public static function subscription_sign_up_fee( $value, $data ) {
		return $data->get_meta( '_' . WCPBC()->customer->zone_id . '_subscription_sign_up_fee' );		
	}

	/**
	 * Return subscription price for variable subscription products
	 *
	 * @since 1.1.3
	 */
	public static function subscription_price( $value, $data ) {		
		return $data->get_meta( '_' . WCPBC()->customer->zone_id . '_price' );		
	}

	/**
	 * Return subscription min price variation ID for variable subscription products
	 *
	 * @since 1.1.4
	 */
	public static function min_price_variation_id( $value, $data ) {		
		return $data->get_meta( '_' . WCPBC()->customer->zone_id . '_min_price_variation_id' );		
	}

	/**
	 * Return subscription price for variation subscription product
	 *
	 * @since 1.1.4
	 */
	public static function variation_subscription_price( $value, $data ) {
		return $data->get_meta( '_' . WCPBC()->customer->zone_id . '_subscription_price' );		
	}
	
	/**
	 * Admin includes
	 *
	 * @since 1.1.2
	 */
	public static function admin_includes() {		
		include_once('includes/class-wcpbc-subscription-reports.php');					
	}

	/**
	 * Output the subscription specific pricing fields on the "Edit Product" admin page.
	 *
	 * @since 1.0
	 */
	public static function product_options_pricing ( $id_prefix, $currency ) {

		echo '<div class="show_if_subscription">';

		// Subscription Price
		woocommerce_wp_text_input( array(
			'id'          => $id_prefix . '_subscription_price',
			'class'       => 'short wc_input_price wcpbc_subscription_price',
			// translators: %s is a currency symbol / code
			'label'       => sprintf( __( 'Subscription Price (%s)', 'woocommerce-subscriptions' ),  get_woocommerce_currency_symbol( $currency ) ),
			'placeholder' => _x( 'e.g. 5.90', 'example price', 'woocommerce-subscriptions' ),
			'type'        => 'text',
			'custom_attributes' => array(
					'step' => 'any',
					'min'  => '0',
			),
		) );		

		// Sign-up Fee
		woocommerce_wp_text_input( array(
			'id'          => $id_prefix . '_subscription_sign_up_fee',
			'class'       => 'short wc_input_price',
			// translators: %s is a currency symbol / code
			'label'       => sprintf( __( 'Sign-up Fee (%s)', 'woocommerce-subscriptions' ), get_woocommerce_currency_symbol( $currency ) ),
			'placeholder' => _x( 'e.g. 9.90', 'example price', 'woocommerce-subscriptions' ),
			'description' => __( 'Optionally include an amount to be charged at the outset of the subscription. The sign-up fee will be charged immediately, even if the product has a free trial or the payment dates are synced.', 'woocommerce-subscriptions' ),
			'desc_tip'    => true,
			'type'        => 'text',
			'custom_attributes' => array(
				'step' => 'any',
				'min'  => '0',
			),
		) );

		echo '</div>';

	}

	/**
	 * Output the subscription specific pricing fields on the "Edit Variable Product" admin page.
	 *
	 * @since 1.0
	 */
	public static function product_variable_options_pricing( $key, $currency, $loop, $variation) {

		$_variable_subscription_sign_up_fee = wc_format_localized_price( get_post_meta( $variation->ID, '_' . $key . '_subscription_sign_up_fee', true) );
		$_variable_subscription_price = wc_format_localized_price( get_post_meta( $variation->ID, '_' . $key . '_subscription_price', true) );

		?>

		<div class="show_if_variable-subscription">

			<p class="form-row form-row-first">
				<label><?php  printf( __( 'Sign-up Fee: (%s)', 'woocommerce-subscriptions' ) ,  get_woocommerce_currency_symbol( $currency ) ); ?></label>
				<input type="text" size="5" id="<?php echo '_' . $key . '_variable_subscription_sign_up_fee_' . $loop; ?>" name="<?php echo '_' . $key . '_variable_subscription_sign_up_fee[' . $loop. ']'; ?>" value="<?php echo esc_attr( $_variable_subscription_sign_up_fee ); ?>" class="wc_input_price" />
			</p>
			<p class="form-row form-row-last">
				<label><?php printf( __( 'Subscription Price (%s)', 'woocommerce-subscriptions' ) ,  get_woocommerce_currency_symbol( $currency ) ); ?></label>
				<input type="text" size="5" id="<?php echo '_' . $key . '_variable_subscription_price_' . $loop; ?>" name="<?php echo '_' . $key . '_variable_subscription_price[' . $loop. ']'; ?>" value="<?php if ( isset( $_variable_subscription_price ) ) echo esc_attr( $_variable_subscription_price ); ?>" class="wc_input_price wcpbc_subscription_price" />
			</p>

		</div>

		<?php
	}

	/**
	 * Save country options pricing for subscription products
	 *
	 * @since 1.1
	 * @param int $post_id
	 * @param string $zone_prepended
	 * @param array $zone
	 * @param string $price_method
	 * @param int $loop
	 */
	public static function process_product_meta_subscription( $post_id, $zone_prepended, $zone, $price_method, $loop ) {
		
		if ( $price_method == 'exchange_rate') {			
			
			if ( $loop === FALSE ) {
				$_subscription_price 		= $_POST['_subscription_price'];
				$_subscription_sign_up_fee	= $_POST['_subscription_sign_up_fee'];
			}else {				
				$_subscription_price 		= $_POST['variable_subscription_price'][$loop];
				$_subscription_sign_up_fee	= $_POST['variable_subscription_sign_up_fee'][$loop];
			}
			
			$_subscription_price 		= ( $_subscription_price !== '' ? wc_format_decimal( $_subscription_price ) * $zone['exchange_rate'] : '' );
			$_subscription_sign_up_fee 	= ( $_subscription_sign_up_fee !== '' ? wc_format_decimal( $_subscription_sign_up_fee ) * $zone['exchange_rate'] : '' );

		} else {	
	
			if ( $loop !== FALSE ) {	
				$_subscription_price 		= wc_format_decimal( $_POST[$zone_prepended . '_variable_subscription_price'][$loop] );
				$_subscription_sign_up_fee 	= wc_format_decimal( $_POST[$zone_prepended . '_variable_subscription_sign_up_fee'][$loop] );

			} else {
				$_subscription_price 		= wc_format_decimal( $_POST[$zone_prepended . '_subscription_price'] );
				$_subscription_sign_up_fee 	= wc_format_decimal( $_POST[$zone_prepended . '_subscription_sign_up_fee'] );
			}			
		}

		update_post_meta( $post_id, $zone_prepended . '_subscription_price', $_subscription_price );
		update_post_meta( $post_id, $zone_prepended . '_subscription_sign_up_fee', $_subscription_sign_up_fee );

		/**
		 * If subscription_price = 0 and price = '' must set price = subscription_price
		 */
		$_price = get_post_meta( $post_id, $zone_prepended . '_price', true );

		if (empty( $_price ) && $_price !== '0' && $_subscription_price == '0' ) {
			update_post_meta( $post_id, $zone_prepended . '_price', $_subscription_price );
		}
	}		
	
	/**
	 * Quick or Bulk product edit.
	 */
	public static function quick_or_bulk_edit_save_subscription( $product, $zone_prepended, $zone ) {
		
		$_subscription_price 		= get_post_meta( $product->id, '_subscription_price', true);
		$_subscription_sign_up_fee	= get_post_meta( $product->id, '_subscription_sign_up_fee', true);
		
		$_subscription_price 		= ( $_subscription_price !== '' ? $_subscription_price * $zone['exchange_rate'] : '' );
		$_subscription_sign_up_fee 	= ( $_subscription_sign_up_fee !== '' ? $_subscription_sign_up_fee * $zone['exchange_rate'] : '' );
		
		update_post_meta( $product->id, $zone_prepended . '_subscription_price', $_subscription_price );
		update_post_meta( $product->id, $zone_prepended . '_subscription_sign_up_fee', $_subscription_sign_up_fee );		
	}
	
	/**
	 * Sync variable product prices
	 */
	public static function variable_product_sync( $product ) {
		
		$product_id = $product->get_id();
		
		foreach ( array_keys( WCPBC()->get_regions() ) as $region_key ) {

			$min_subscription_sign_up_fee = get_post_meta( $product_id, '_' . $region_key . '_min_variation_subscription_sign_up_fee', true );
			
			if ( ! empty( $min_subscription_sign_up_fee ) || $min_subscription_sign_up_fee === '0' ) {
				
				// Store _subscription_sign_up_fee				
				$product->add_meta_data( '_' . $region_key . '_subscription_sign_up_fee', $min_subscription_sign_up_fee, true );
			}			
		}
		
		// Sync price with subscription price when is 0
		if ( '0' == get_post_meta( $product_id, '_subscription_price', true ) && '' === get_post_meta( $product_id, '_price', true ) ) {
			$product->set_price('0');
		}					
	}
	
	/**
	 * Bulk edit variations via AJAX.
	 */
	public static function bulk_edit_variations( $bulk_action, $data, $product_id, $variations ) {	
		if ( in_array( $bulk_action, array( 'variable_subscription_sign_up_fee', 'variable_regular_price', 'variable_regular_price_increase', 'variable_regular_price_decrease' ) ) 
			&& ( ( isset( $_POST['product_type'] ) && 'variable-subscription' !== $_POST['product_type'] ) || WC_Subscriptions_Product::is_subscription( $product_id ) )
			)  {
			
			foreach ( WCPBC()->get_regions() as $zone_id => $zone_data ) {				
				$meta_prefix = '_' . $zone_id;				
				
				foreach ( $variations as $variation_id ) {
					$price_method = get_post_meta( $variation_id, $meta_prefix . '_price_method', true );
					if ( $price_method == 'exchange_rate' || ! $price_method ) {
							
							$_subscription_sign_up_fee = get_post_meta( $variation_id, '_subscription_sign_up_fee', true );
							$_subscription_price = get_post_meta( $variation_id, '_subscription_price', true );
							
							update_post_meta( $variation_id, $meta_prefix . '_subscription_sign_up_fee', $_subscription_sign_up_fee !== '' ? $_subscription_sign_up_fee * $zone_data['exchange_rate'] : '' );							
							update_post_meta( $variation_id, $meta_prefix . '_subscription_price', $_subscription_price !== '' ? $_subscription_price * $zone_data['exchange_rate'] : '' );							
					}
				}
			}
		}

		// wcpbc variable bluck edit 		
		if ( $bulk_action !== 'wcpbc_variable_bluck_edit' || ! isset( $data['value'] ) || empty( $data['action'] ) || empty( $data['zone_id'] ) || ! array_key_exists( $data['zone_id'], WCPBC()->get_regions() ) ){
			return;
		}

		foreach ( $variations as $variation_id ) {

			$field_value = get_post_meta( $variation_id, "_{$data['zone_id']}_regular_price", true );			
			update_post_meta( $variation_id, "_{$data['zone_id']}_subscription_price", $field_value );			
		}
	}		
}

endif; // ! class_exists( 'WCPBC_Subscriptions' )

WCPBC_Subscriptions::init();