<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_Product_Addons' ) ) :

/** 
 *
 * @class WCPBC_Product_Addons
 * @version	2.1.7
 */
class WCPBC_Product_Addons {

	/**
	 * Hook actions and filters
	 *
	 * @since 2.1.0
	 */
	public static function init() {		
		add_action( 'wc_price_based_country_frontend_princing_init', array( __CLASS__, 'princing_init' ) );
		add_action( 'woocommerce_init', array( __CLASS__, 'enqueue_js' ) );
		add_action( 'wc_ajax_wc_price_based_country_pro_get_currency', array( __CLASS__, 'echo_woocommerce_currency' ) );		
		add_action( 'product_page_global_addons', array( __CLASS__, 'global_addons_admin' ), 20 );		
		add_action( 'woocommerce_product_write_panel_tabs', array( __CLASS__, 'tab' ), 11 );
		add_action( 'woocommerce_product_data_panels', array( __CLASS__, 'panel' ) );
		add_action( 'woocommerce_process_product_meta', array( __CLASS__, 'process_meta_box' ), 10, 2 );		
	}

	/**
	 * Init pricing hooks
	 */
	public static function princing_init() {		
		add_filter( 'get_product_addons_fields', array( __CLASS__, 'product_addons_fields' ), 10, 2 );
	}

	/**
	 * Enqueue js to set the correct currency format to addons.js params
	 */
	public static function enqueue_js() {

		if ( ! wcpbc_is_woocommerce_frontend() ) {
	 		// Do only if woocommerce frontend have been loaded
	 		return;	 		
	 	}	 

		wc_enqueue_js("
			jQuery( document ).ready( function( $ ){
				if ( typeof woocommerce_addons_params !== 'undefined' && typeof woocommerce_addons_params.currency_format !== 'undefined' ) {
					var currency = '" . get_woocommerce_currency() . "';					
					woocommerce_addons_params.currency_format = woocommerce_addons_params.currency_format.replace( '[code]', currency );

					// Ajax action to get currency (fix cache issues)
					$.post( woocommerce_params.wc_ajax_url.toString().replace( '%%endpoint%%', 'wc_price_based_country_pro_get_currency' ), function( data ) {										
						if ( data && data != currency ) {
							woocommerce_addons_params.currency_format = woocommerce_addons_params.currency_format.replace( currency, data );
							$('.addon').trigger( 'change' );
						}
					}, 'text' );		
				}
			} );
		");
	}

	/**
	 * Display currency currency (used by ajax action)
	 */
	public static function echo_woocommerce_currency() {
		echo get_woocommerce_currency();
	}

	/**
	 * Return addons based on country.
	 *
	 * @param array $addons
 	 * @param int $post_id
	 */
	public static function product_addons_fields( $addons, $post_id ) {
		
		$zone_id	   = WCPBC()->customer->zone_id;
		$exchange_rate = WCPBC()->customer->exchange_rate;
		$zone_pricing  = array_filter( (array) get_post_meta( $post_id, '_product_addons_zone_pricing', true ) );	
		$pricing 	   = ! empty( $zone_pricing[ $zone_id ] ) ? $zone_pricing[ $zone_id ] : false;				

		foreach ( $addons as $ka => $addon ) {				
			
			$price_method = ! empty( $pricing[ $ka ]['price_method'] ) ? 'manual' : 'exchange_rate';

			foreach ( $addon['options'] as $ko => $option ) {

				if ( 'exchange_rate' === $price_method || ! isset( $pricing[$ka]['price'][$ko] ) ) {

					$addons[$ka]['options'][$ko]['price'] = empty( $addons[$ka]['options'][$ko]['price'] ) ? 0 : $addons[$ka]['options'][$ko]['price'] * $exchange_rate;

				} else {

					$addons[$ka]['options'][$ko]['price'] = $pricing[$ka]['price'][$ko];
				}				
			}
		}		
		
		return $addons;
	}

	/**
	 * Save zone pricing for addons
	 *
	 * @param int $post_id
	 * @param array $product_addons	 
	 * @return array zone pricing for add-ons
	 */
	private static function save_zone_pricing_data( $post_id, $product_addons ) {

		$post_data = wc_clean( $_POST['_product_addons_zone_pricing'] );
		$pricing   = array();

		foreach ( WCPBC()->get_regions() as $zone_id => $zone ) {

			$zone_pricing = array();

			foreach ( $product_addons as $loop => $addon ) {

				$zone_pricing[ $loop ][ 'price_method' ] = ! empty( $post_data[ $zone_id ][ $loop ][ 'price_method' ] ) ? $post_data[ $zone_id ][ $loop ][ 'price_method' ] : 'exchange_rate';							

				foreach ( $addon['options'] as $index => $option ) {

					if ( 'manual'=== $zone_pricing[ $loop ][ 'price_method' ] ) {
						if ( isset( $post_data[ $zone_id ][ $loop ][ 'price' ][ $index ] ) ) {
							$zone_pricing[ $loop ]['price'][$index] = wc_format_decimal( $post_data[ $zone_id ][ $loop ][ 'price' ][ $index ] );	
						} else {
							$zone_pricing[ $loop ]['price'][$index] = wc_format_decimal( $option[ 'price' ] * $zone[ 'exchange_rate' ] );	
						}
						
					} 								
				}							
			}

			$pricing[ $zone_id ] = $zone_pricing;
		}					

		update_post_meta( $post_id, '_product_addons_zone_pricing', $pricing );
	}

	/**
	 * Controls the global addons admin page.
	 */
	public static function global_addons_admin() {		

		if ( ! empty( $_GET['add'] ) || ! empty( $_GET['edit'] ) ) {

			// Get post_id
			$post_id = ! empty( $_GET['edit'] ) ? absint( $_GET['edit'] ) : '';
			$post_id = empty( $edit_id ) && ! empty( $_POST['edit_id'] ) ? absint( $_POST['edit_id'] ) : $post_id;									

			if ( ! empty( $post_id ) ) {
				
				$global_addon 	= get_post( $post_id );				
				$product_addons = array_filter( (array) get_post_meta( $global_addon->ID, '_product_addons', true ) );								

				if ( ! empty( $_POST['_product_addons_zone_pricing'] ) ) {

					self::save_zone_pricing_data( $global_addon->ID, $product_addons );					
				}

				$zone_pricing = array_filter( (array) get_post_meta( $global_addon->ID, '_product_addons_zone_pricing', true ) );						
			}			

			include( WC_Product_Price_Based_Country_Pro::plugin_path() . 'includes/admin/views/product-addons/html-global-admin-add.php');	
		}
	}

	/**
	 * Add product tab.
	 */
	public static function tab() {
		?><li class="addons_tab product_addons"><a href="#wcpbc_product_addons_data"><span><?php _e( 'Add-ons zone pricing', 'wc-price-based-country' ); ?></span></a></li><?php
	}

	/**
	 * Add product panel.
	 */
	public static function panel() {
		global $post;

		$product_addons = array_filter( (array) get_post_meta( $post->ID, '_product_addons', true ) );
		$zone_pricing 	= array_filter( (array) get_post_meta( $post->ID, '_product_addons_zone_pricing', true ) );								

		include( WC_Product_Price_Based_Country_Pro::plugin_path() . 'includes/admin/views/product-addons/html-addon-panel.php' );
	}

	/**
	 * Process meta box.
	 *
	 * @param int $post_id Post ID.
	 */
	public static function process_meta_box( $post_id, $post ) {
		
		if ( ! empty( $_POST['_product_addons_zone_pricing'] ) ) {
			$product_addons = array_filter( (array) get_post_meta( $post_id, '_product_addons', true ) );								
			self::save_zone_pricing_data( $post_id, $product_addons );					
		}		
	}

}

WCPBC_Product_Addons::init();

endif;
