<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_Bundles' ) ) :

/** 
 *
 * @class WCPBC_Bundles
 * @version	1.0.2
 */
class WCPBC_Bundles {

	/**
	 * Hook actions and filters
	 *
	 * @since 1.0
	 */
	public static function init() {
		add_action( 'wc_price_based_country_pro_installed', array( __CLASS__, 'install') );
		add_action( 'woocommerce_process_product_meta_bundle', array( 'WCPBC_Admin_Product_Data', 'process_product_simple_countries_prices' ) ) ;			
		add_action( 'wc_price_based_country_process_product_meta_bundle', array( __CLASS__, 'process_product_bundle' ), 10, 5 ) ;											
		add_filter( 'wc_price_based_country_price_meta_keys', array( __CLASS__, 'bundles_price_meta_keys' ) );		
		
	}
	
	/**
	 * Install. Update product bundles price meta_keys from regular, sale and price meta_keys
	 *
	 * @return array
	 */
	public static function install() {		

		foreach ( array_keys( get_option( 'wc_price_based_country_regions', array() ) ) as $zone_slug ) {						

			$posts = get_posts( array(
				'posts_per_page'	=> -1,
				'post_type' 		=> 'product',
				'tax_query' 		=> array(
					array(
						'taxonomy' => 'product_type',
						'field'    => 'slug',
						'terms'    => 'bundle'
					)
				),
				'meta_query' 		=> array(
					'relation'		=> 'AND',
					array(
						'key'	=> "_{$zone_slug}_price_method",
						'value'	=> 'manual'
					),
					array(
						'key'		=> "_{$zone_slug}_wc_pb_base_price",
						'compare'	=> 'NOT EXISTS'
					)
				)
			) );
		
			foreach ( $posts as $post ) {
				self::process_product_bundle( $post->ID, "_{$zone_slug}", null, null, null );			
			}
		}
	}

	/**
	 * Add product bundles pricing meta keys
	 *
	 * @return array
	 */
	public static function bundles_price_meta_keys( $meta_keys ) {
		array_push( $meta_keys, '_wc_pb_base_regular_price', '_wc_pb_base_sale_price', '_wc_pb_base_price' );	
		return $meta_keys;
	}
	
	/**
	 * Save base pricing
	 *
	 * @since 1.1
	 * @param int $post_id
	 * @param string $zone_prepended
	 * @param array $zone
	 * @param string $price_method
	 * @param int $loop
	 */
	public static function process_product_bundle( $post_id, $zone_prepended, $zone, $price_method, $loop ) {
	
		$regular_price = get_post_meta( $post_id, $zone_prepended . '_regular_price', true );
		$sale_price    = get_post_meta( $post_id, $zone_prepended . '_sale_price', true );
		$price 		   = get_post_meta( $post_id, $zone_prepended . '_price', true );
		
		update_post_meta( $post_id, $zone_prepended . '_wc_pb_base_regular_price', $regular_price );
		update_post_meta( $post_id, $zone_prepended . '_wc_pb_base_sale_price', $sale_price );
		update_post_meta( $post_id, $zone_prepended . '_wc_pb_base_price', $price );		
	}

}

endif;

WCPBC_Bundles::init();

