<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_Bookings' ) ) :

/** 
 *
 * @class WCPBC_Bookings
 * @version	2.1.8
 */
class WCPBC_Bookings {

	/**
	 * @var int
	 */
	private static $admin_resource_fields = null;

	/**
	 * Hook actions and filters	 	
	 */
	public static function init() {		
		add_filter( 'wc_price_based_country_price_meta_keys', array( __CLASS__, 'booking_cost_meta_keys' ) );												
		add_action( 'wc_price_based_country_frontend_princing_init', array( __CLASS__, 'pricing_init' ) );		
		add_filter( 'woocommerce_product_data_tabs', array( __CLASS__, 'register_tab' ), 20 );
		add_action( 'woocommerce_product_data_panels', array( __CLASS__, 'init_resource_field' ), 1 );
		add_action( 'woocommerce_bookings_after_resource_block_cost', array( __CLASS__, 'after_resource_block_cost' ), 10, 2 );
		add_action( 'woocommerce_product_data_panels', array( __CLASS__, 'booking_panels' ) );		
		add_action( 'woocommerce_process_product_meta_booking', array( __CLASS__, 'save_data' ) );		
		add_filter( 'woocommerce_add_cart_item_data', array( __CLASS__, 'add_cart_item_data' ), 11, 2 );
		add_filter( 'woocommerce_get_cart_item_from_session', array( __CLASS__, 'get_cart_item_from_session' ), 11, 3 );				
	}

	/**
	 * Add booking product cost meta keys
	 *
	 * @return array
	 */
	public static function booking_cost_meta_keys( $meta_keys ) {
		array_push( $meta_keys, '_wc_booking_base_cost', '_wc_booking_cost', '_wc_display_cost' );	
		return $meta_keys;
	}


	/**
	 * Add filter needed to pricing zone
	 */
	public static function pricing_init() {
		add_filter( 'woocommerce_product_get_pricing', array( __CLASS__, 'get_pricing' ), 10, 2 );				
		add_filter( 'woocommerce_product_get_resource_base_costs', array( __CLASS__, 'get_resource_base_costs' ), 10, 2 );
		add_filter( 'woocommerce_product_get_resource_block_costs', array( __CLASS__, 'get_resource_block_costs' ), 10, 2 );
	}

	/**
	 * Return booking product pricing prop
	 *
	 * @param array
	 * @param WC_Product $product
	 * @return array
	 */
	public static function get_pricing( $value, $product ) {

		if ( 'WC_Product_Booking' === get_class( $product ) ) {

			$zone_id 	  = WCPBC()->customer->zone_id;			
			$price_method = get_post_meta( $product->get_id(), "_{$zone_id}_price_method" );			
			$pricing 	  = get_post_meta( $product->get_id(), "_{$zone_id}_pricing" );

			foreach ( $value as $i => $data ) {

				if ( 'manual' !== $price_method ) {

					$value[ $i ][ 'cost' ] 		= ! empty( $data[ 'cost' ] ) ? $data[ 'cost' ] * WCPBC()->customer->exchange_rate : $data[ 'cost' ];
					$value[ $i ][ 'base_cost' ] = ! empty( $data[ 'base_cost' ] ) ? $data[ 'base_cost' ] * WCPBC()->customer->exchange_rate : $data[ 'base_cost' ];

				} else {

					$value[ $i ][ 'cost' ] 		= isset( $pricing[ $i ][ 'cost' ] ) ? $pricing[ $i ][ 'cost' ] : '';
					$value[ $i ][ 'base_cost' ] = isset( $pricing[ $i ][ 'base_cost' ] ) ? $pricing[ $i ][ 'base_cost' ] : '';
				}
			}				
		}

		return $value;
	}

	/**
	 * Return booking product resource base cost
	 *
	 * @param array $value
	 * @param WC_Product $product
	 * @return array
	 */
	public static function get_resource_base_costs( $value, $product ) {
		if ( 'WC_Product_Booking' == get_class( $product ) ) {
			$value = self::get_resource_costs( $product->get_id(), $value );
		}	

		return $value;	
	}

	/**
	 * Return booking product resource base cost
	 *
	 * @param array $value
	 * @param WC_Product $product
	 * @return array
	 */
	public static function get_resource_block_costs( $value, $product ) {
		if ( 'WC_Product_Booking' == get_class( $product ) ) {
			$value = self::get_resource_costs( $product->get_id(), $value, 'block' );
		}	

		return $value;	
	}

	/**
	 * Return booking product resource costs array
	 *
	 * @param array $value
	 * @param WC_Product $product
	 * @return array
	 */
	private static function get_resource_costs( $post_id, $costs, $field = 'base' ) {

		$zone_id 	  = WCPBC()->customer->zone_id;
		$zone_costs   = get_post_meta( $post_id, "_{$zone_id}_resource_{$field}_costs", true );			
		$price_method = get_post_meta( $post_id, "_{$zone_id}_resource_price_method", true );	

		foreach ( $costs as $id => $value ) {

			if ( ! isset( $zone_costs[ $id ] ) || empty( $price_method[ $id ] ) || 'manual' !== $price_method[ $id ] ) {
				$cost[ $id ] = empty( $value ) ? $value : $value * WCPBC()->customer->exchange_rate;
			} else {
				$cost[ $id ] = $zone_costs[ $id ];
			}
		}

		return $cost;
	}

	/**
	 * Add tabs to WC 2.6+
	 *
	 * @param  array $tabs
	 * @return array
	 */
	public static function register_tab( $tabs ) {
	
		$tabs['wcpbc_bookings_pricing'] = array(
			'label'  => __( 'Pricing Zone Costs' , 'wc-price-based-country' ),
			'target' => 'wcpbc_bookings_pricing',
			'class'  => array(
				'show_if_booking'
			),
			'priority' => 80,
		);

		return $tabs;
	}

	/**
	 * Init resource field to manage resources output
	 */
	public static function init_resource_field() {

		global $post, $bookable_product;

		if ( empty( $bookable_product ) || $bookable_product->get_id() !== $post->ID ) {
			$bookable_product = new WC_Product_Booking( $post->ID );			
		}

		// Init resource fields variable;
		self::$admin_resource_fields = array(
			'loop' => 0,
			'ids'  => $bookable_product->get_resource_ids()
		);

		foreach ( array_keys( get_option( 'wc_price_based_country_regions', array() ) ) as $zone_id ) {
			self::$admin_resource_fields['base_costs'][$zone_id] 	= get_post_meta( get_the_ID(), "_{$zone_id}_resource_base_costs", true );	
			self::$admin_resource_fields['block_costs'][$zone_id] 	= get_post_meta( get_the_ID(), "_{$zone_id}_resource_block_costs", true );	
			self::$admin_resource_fields['price_method'][$zone_id] 	= get_post_meta( get_the_ID(), "_{$zone_id}_resource_price_method", true );	
		}
	}

	/**
	 * Display the resource pricing fields
	 *
	 * @param int $resource_id
	 * @param int $post_id
	 */
	public static function after_resource_block_cost( $resource_id, $post_id ) {	
		if ( empty( $_POST['loop'] ) ) {
			
			$loop 		   = self::$admin_resource_fields['loop'];
			self::$admin_resource_fields['loop']++;
			
			$resource_id   = current( self::$admin_resource_fields['ids'] );
			next( self::$admin_resource_fields['ids'] );

			$base_costs    = self::$admin_resource_fields['base_costs'];
			$block_costs   = self::$admin_resource_fields['block_costs'];
			$price_methods = self::$admin_resource_fields['price_method'];
		} else {
			$loop = intval( $_POST['loop'] );
			$resource_id   = '';
			$base_costs    = '';
			$block_costs   = '';
			$price_methods = '';
		}
		 
		include( WC_Product_Price_Based_Country_Pro::plugin_path() . 'includes/admin/views/bookings/html-resource.php');				
		
	}

	/**
	 * Show the booking panels views
	 */
	public static function booking_panels() {	

		// Get pricing rows
		$pricing_rows = get_post_meta( get_the_ID(), '_wc_booking_pricing', true );

		// Fill intervals
		$intervals = array( 
			'months' => array(
				'1' => __( 'January', 'woocommerce-bookings' ),
				'2' => __( 'February', 'woocommerce-bookings' ),
				'3' => __( 'March', 'woocommerce-bookings' ),
				'4' => __( 'April', 'woocommerce-bookings' ),
				'5' => __( 'May', 'woocommerce-bookings' ),
				'6' => __( 'June', 'woocommerce-bookings' ),
				'7' => __( 'July', 'woocommerce-bookings' ),
				'8' => __( 'August', 'woocommerce-bookings' ),
				'9' => __( 'September', 'woocommerce-bookings' ),
				'10' => __( 'October', 'woocommerce-bookings' ),
				'11' => __( 'November', 'woocommerce-bookings' ),
				'12' => __( 'December', 'woocommerce-bookings' ),
			),
			'days' => array(
				'1' => __( 'Monday', 'woocommerce-bookings' ),
				'2' => __( 'Tuesday', 'woocommerce-bookings' ),
				'3' => __( 'Wednesday', 'woocommerce-bookings' ),
				'4' => __( 'Thursday', 'woocommerce-bookings' ),
				'5' => __( 'Friday', 'woocommerce-bookings' ),
				'6' => __( 'Saturday', 'woocommerce-bookings' ),
				'7' => __( 'Sunday', 'woocommerce-bookings' ),
			)
		);
		
		for ( $i = 1; $i <= 52; $i ++ ) {
			$intervals['weeks'][ $i ] = sprintf( __( 'Week %s', 'woocommerce-bookings' ), $i );
		}

		// Range type labels
		$type_labels  = array(			
				'custom'  => __( 'Date range', 'wc-price-based-country' ),
				'months'  => __( 'Range of months', 'wc-price-based-country' ),
				'weeks'   => __( 'Range of weeks', 'wc-price-based-country' ),
				'days' 	  => __( 'Range of days', 'wc-price-based-country' ),
				'time' 	  => __( 'Time Range', 'wc-price-based-country' ),
				'persons' => __( 'Person count', 'wc-price-based-country' ),
				'blocks'  => __( 'Block count', 'wc-price-based-country' ),
				'time'    => __( 'Time Range (all week)', 'wc-price-based-country' ),
				'time:range'  => __( 'Date Range with time', 'wc-price-based-country' )			
		);

		$modifier_labels = array(
			'' 		 => '+',
			'minus'  => '-',
			'times'  => "&times;",
			'divide' => "&divide;"
		);

		foreach ( $intervals['days'] as $key => $label ) {
			$type_labels[ 'time:' . $key ] = $label;
		}

		
		include( WC_Product_Price_Based_Country_Pro::plugin_path() . 'includes/admin/views/bookings/html-pricing.php');				
	}

	/**
	 * Display range part of booking pricing
	 *
	 * @param array $data pricing row data
	 * @param string $range_type
	 * @param array $intervals
	 */
	private static function the_range( $data, $intervals ) {		
		
		$type = $data[ 'type' ];
		$from = $data[ 'from' ];
		$to   = $data[ 'to' ];
		
		if ( isset( $intervals[ $type ][ $from ] ) ) {
			$from = $intervals[ $type ][ $from ];
		}

		if ( isset( $intervals[ $type ][ $to ] ) ) {
			$to = $intervals[ $type ][ $to ];
		}

		if ( isset( $data[ 'from_date' ] ) ) {
			$from = $data[ 'from_date' ] . ' ' . $from;
		}

		if ( isset( $data[ 'to_date' ] ) ) {
			$to = $data[ 'to_date' ] . ' ' . $to;
		}
		echo '<td style="border-right: none; width: 150px;"><p>' . $from . '</p></td>';
		echo '<td style="border-right: none;"><p>' . __( 'to', 'woocommerce-bookings' ) . '</p></td>';
		echo '<td style="width: 150px;"><p>' . $to . '</p></td>';				
	}		

	/**
	 * Save meta data
	 * 
	 * @param int $post_id 
	 */
	public static function save_data( $post_id ) {

		$has_resources = isset( $_POST['resource_id'] ) && isset( $_POST['_wc_booking_has_resources'] );		

		foreach ( WCPBC()->get_regions() as $zone_id => $zone ) {			

			$price_method = wc_clean( $_POST[ "_{$zone_id}_booking_price_method" ] );	
			$pricing      = array();			
			$resources 	  = array();

			if ( $has_resources ) {
				$resources = self::get_posted_resources( $zone_id, $zone['exchange_rate'] );
			}

			if ( 'exchange_rate' === $price_method ) {

				$costs['booking_cost'] 	   	= wc_clean( $_POST['_wc_booking_cost'] );
				$costs['booking_base_cost'] = wc_clean( $_POST['_wc_booking_base_cost'] );				
				$costs['display_cost'] 		= wc_clean( $_POST['_wc_display_cost'] );				

				foreach ( $costs as $index => $value ) {
					$costs[ $index ] = ! empty( $value ) ?  wc_format_decimal( $value * $zone['exchange_rate'] ) : $value ;
				}				

				$row_size = isset( $_POST['wc_booking_pricing_type'] ) ? sizeof( $_POST['wc_booking_pricing_type'] ) : 0;
				for ( $i = 0; $i < $row_size; $i ++ ) {
					$pricing[ $i ]['base_cost'] = ! empty( $_POST['wc_booking_pricing_base_cost'][ $i ] ) ? wc_format_decimal( wc_clean( $_POST['wc_booking_pricing_base_cost'][ $i ] ) * $zone['exchange_rate'] ) : '';
					$pricing[ $i ]['cost'] 		= ! empty( $_POST['wc_booking_pricing_cost'][ $i ] ) ? wc_format_decimal( wc_clean( $_POST['wc_booking_pricing_cost'][ $i ] ) * $zone['exchange_rate'] ) : '';
				}
				
			} else {
				
				// Price manually				
				$costs['booking_cost'] 	   	= wc_format_decimal( wc_clean( $_POST[ "_{$zone_id}_wc_booking_cost" ] ) );
				$costs['booking_base_cost'] = wc_format_decimal( wc_clean( $_POST[ "_{$zone_id}_wc_booking_base_cost" ] ) );				
				$costs['display_cost'] 		= wc_format_decimal( wc_clean( $_POST[ "_{$zone_id}_wc_display_cost" ] ) );												

				$row_size = isset( $_POST['wc_booking_pricing_type'] ) ? sizeof( $_POST['wc_booking_pricing_type'] ) : 0;

				for ( $i = 0; $i < $row_size; $i ++ ) {
					if ( isset( $_POST['wcpbc_booking_pricing_base_cost'][$i][$zone_id] ) ) {
						$pricing[ $i ]['base_cost'] = wc_format_decimal( wc_clean( $_POST['wcpbc_booking_pricing_base_cost'][$i][$zone_id] ) );
					} else {
						$pricing[ $i ]['base_cost'] = ! empty( $_POST['wc_booking_pricing_base_cost'][ $i ] ) ? wc_format_decimal( wc_clean( $_POST['wc_booking_pricing_base_cost'][ $i ] ) * $zone['exchange_rate'] ) : '';
					}

					if ( isset( $_POST['wcpbc_booking_pricing_cost'][$i][$zone_id] ) ) {
						$pricing[ $i ]['cost'] = wc_format_decimal( wc_clean( $_POST['wcpbc_booking_pricing_cost'][$i][$zone_id] ) );
					} else {						
						$pricing[ $i ]['cost'] = ! empty( $_POST['wc_booking_pricing_cost'][ $i ] ) ? wc_format_decimal( wc_clean( $_POST['wc_booking_pricing_cost'][ $i ] ) * $zone['exchange_rate'] ) : '';		
					}
				}										
			}			

			foreach ( $costs as $key => $value ) {
				update_post_meta( $post_id, "_{$zone_id}_wc_{$key}", $value );
			}
			update_post_meta( $post_id, "_{$zone_id}_pricing", $pricing );

			update_post_meta( $post_id, "_{$zone_id}_resource_base_costs", wp_list_pluck( $resources, 'base_cost' ) );			
			update_post_meta( $post_id, "_{$zone_id}_resource_block_costs", wp_list_pluck( $resources, 'block_cost' ) );			
			update_post_meta( $post_id, "_{$zone_id}_resource_price_method", wp_list_pluck( $resources, 'price_method' ) );			

			update_post_meta( $post_id, "_{$zone_id}_price", $costs[ 'display_cost' ] );
			update_post_meta( $post_id, "_{$zone_id}_price_method", $price_method );						
		}
	}

	/**
	 * Get posted resources
	 *
	 * @param string $type exchange_rate/manually
	 * @param string $zone_id
	 * @param float $rate
	 * @return array
	 */
	private static function get_posted_resources( $zone_id, $rate  ) {

		$resources = array();

		$resource_ids         	   = $_POST['resource_id'];
		$resource_menu_order  	   = $_POST['resource_menu_order'];
		$resource_price_method     = $_POST[ "_{$zone_id}_booking_resource_price_method" ];
		$resource_base_cost   	   = $_POST['resource_cost'];
		$resource_block_cost  	   = $_POST['resource_block_cost'];
		$resource_zone_base_cost   = $_POST[ "_{$zone_id}_booking_resource_cost" ];
		$resource_zone_block_cost  = $_POST[ "_{$zone_id}_booking_resource_block_cost" ];		

		foreach ( $resource_menu_order as $key => $value ) {
			$price_method = wc_clean( $resource_price_method[ $key ] );
			$base_cost    = empty( $price_method ) || $price_method == 'exchange_rate' ? wc_clean( $resource_base_cost[ $key ] ) : $resource_zone_base_cost[ $key ];
			$block_cost   = empty( $price_method ) || $price_method == 'exchange_rate' ? wc_clean( $resource_block_cost[ $key ] ) : $resource_zone_block_cost[ $key ];
			$_rate 		  = empty( $price_method ) || $price_method == 'exchange_rate' ? $rate : 1;

			$base_cost  = empty( $base_cost ) ? $base_cost : wc_format_decimal( $base_cost * $_rate );
			$block_cost = empty( $block_cost ) ? $block_cost : wc_format_decimal( $block_cost * $_rate );

			$resources[ absint( $resource_ids[ $key ] ) ] = array(
				'base_cost'  	=> $base_cost ,
				'block_cost' 	=> $block_cost,
				'price_method' 	=> $price_method
			);
		}

		return $resources;
	}

	/**
	 * Add posted data to the cart item
	 *
	 * @param mixed $cart_item_meta
	 * @param mixed $product_id
	 * @return array $cart_item_meta
	 */
	public static function add_cart_item_data( $cart_item_meta, $product_id ) {		

		if ( empty( $cart_item_meta['booking'] ) ) {
			return $cart_item_meta;
		}

		$cart_item_meta['booking']['_posted_data'] = $_POST;

		return $cart_item_meta;
	}	

	/**
	 * Get data from the session and add to the cart item's meta
	 *
	 * @param mixed $cart_item
	 * @param mixed $values
	 * @return array cart item
	 */
	public static function get_cart_item_from_session( $cart_item, $values, $cart_item_key ) {
		if ( empty( $values['booking']['_posted_data'] ) ) {
			return $cart_item;
		}

		// Recalculate the cost
		$cart_item['data']->set_qty( $cart_item['data']->get_qty() + 1 );
		$booking_form = new WC_Booking_Form( $cart_item['data'] );		
		$cost 		  = $booking_form->calculate_booking_cost( $values['booking']['_posted_data'] );		
		$cart_item['data']->set_qty( $cart_item['data']->get_qty() -1 );

		// Re-set the booking cost
		$cart_item['booking']['_cost'] = $cost;
		$cart_item['data']->set_price( $cost );							

		return $cart_item;
	}
	
}

endif;

WCPBC_Bookings::init();
