<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_FixerIo' ) ) :

/**
 *
 * @class WCPBC_FloatRates
 * @see http://fixer.io/ 
 * @version	2.1.7
 */
class WCPBC_FixerIo extends WCPBC_Exchange_Rates_Provider {	
		
	/**
	 * Constructor
	 */
	public function __construct() {		
		$this->name = 'fixer.io';
	}	
	
	/**
	 * Return API endpoint
	 *	 
	 * @return string
	 */
	protected function get_api_endpoint(){		
		return "https://api.fixer.io/latest?base={$this->from_currency}&symbols=" . implode(',', $this->to_currency);
	}

	/**
	 * Return rates array from response
	 *
	 * @param string $data
	 * @return array
	 */
	protected function parse_response( $data ){		
		$data = json_decode( $data, true );			
		$rates = $data['rates'];		

		return $rates;
	}
}

endif;

return new WCPBC_FixerIo();