<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Currency Switcher Widget
 *
 * @author   OscarGare
 * @category Widgets 
 * @version  1.0.6
 * @extends  WC_Widget
 */
class WCPBC_Widget_Currency_Switcher extends WC_Widget {

	/**
	 * @var string
	 */
	private static $_other_countries_text = '';

	/**
	 * Constructor
	 */
	public function __construct() {		
		$this->widget_description = __( 'A currency switcher for your store.', 'wc-price-based-country' );
		$this->widget_id          = 'wcpbc_currency_switcher';
		$this->widget_name        = __( 'WooCommerce Currency Switcher', 'wc-price-based-country' );
		$this->settings           = array(
			'title'  => array(
				'type'  => 'text',
				'std'   => __( 'Currency', 'wc-price-based-country' ),
				'label' => __( 'Title', 'wc-price-based-country' )
			),
			'currency_display_style'  => array(
				'type'  => 'display_style',
				'std'   => '',
				'label' => __( 'Currency display style', 'wc-price-based-country' )
			)
		);

		add_action( 'woocommerce_widget_field_display_style', array( $this, 'field_display_style' ), 10, 4 );

		parent::__construct();
	}

	/**
	 * Output currency display style field.
	 *	 
	 * @param string $key
	 * @param string $value
	 * @param array $setting
	 * @param object $instance
	 */
	public function field_display_style( $key, $value, $setting, $instance ) {
		?>
		<p>
			<label for="<?php echo $this->get_field_id( $key ); ?>"><?php echo $setting['label']; ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( $key ) ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" type="text" value="<?php echo esc_attr( $value ); ?>" placeholder="[name] ([symbol])" />			
		</p>
		<p class="description"><?php _e( 'Supports the following placeholders: [name] = currency name, [code] = currency code and [symbol] = currency symbol', 'wc-price-based-country' ); ?></p>
		<?php
	}	

	/**
	 * widget function.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 *
	 * @return void
	 */
	public function widget( $args, $instance ) {			

		$currencies = array();
		$countries  = array();

		$base_country 	= wc_get_base_location();
		$base_country 	= $base_country['country'];				

		$base_currency 	= wcpbc_get_base_currency();

		$selected_currency = $base_currency;	
		$customer_country  = wcpbc_get_woocommerce_country();				

		foreach ( WCPBC()->get_regions() as $region ) {		

			if ( ! count( $region['countries'] ) ) {
				continue;
			}

			if ( count( $region['countries'] ) > 1 && in_array( $base_country, $region[ 'countries'] ) ) {
				// Get first country that isn't base country
				foreach ( $region[ 'countries' ] as $region_country ) {
					if ( $region_country !== $base_country ) {
						$_country = $region_country;
						break;
					}
				}

			} else {
				$_country = $region[ 'countries']['0'];
			}			

			// Check selected currency
			if ( in_array( $customer_country, $region[ 'countries'] ) ) {
				$selected_currency = $region[ 'currency' ];
				$_country 		   = $customer_country;
			}

			// Add currency to array
			$currencies[ $_country ] = $region[ 'currency' ];

			// Add zone countries to array
			$countries = array_merge( $countries, $region[ 'countries'] );
		}
		
		// Add base country
		if ( ! in_array( $base_country, $countries ) ) {
			$currencies[ $base_country ] = $base_currency;
		} 

		// Add others countries currency
		if ( ! in_array( $base_currency, $currencies ) ) {
			$country_diff = array_diff( array_keys( WC()->countries->countries ), $countries );
			$_country = current( $country_diff );				
			$currencies[ $_country ] = $base_currency;		
		}		

		// filter currencies array
		$currencies = array_unique( $currencies );

		// generate select options array
		$options = array();
		
		$wc_currencies = get_woocommerce_currencies();			

		$display_style = empty( $instance['currency_display_style'] ) ? '[name] ([symbol])' : $instance['currency_display_style'];

		foreach ( $currencies as $country => $currency ) {

			$options[ $country ] = apply_filters( 'wc_price_based_country_currency_widget_text', 
				str_replace( array( '[code]', '[symbol]', '[name]', ' ' ), array( $currency, get_woocommerce_currency_symbol( $currency ), $wc_currencies[ $currency ], '&nbsp;' ), $display_style )
				, $currency
			);

			if ( $currency == $selected_currency ) {
				$selected_country = $country;				
			}
		}

		$this->widget_start( $args, $instance );						
		
		echo '<div class="wc-price-based-country">';
		wc_get_template('currency-switcher.php', array( 'options' => $options, 'selected_country' => $selected_country ), 'woocommerce-product-price-based-on-countries/', WC_Product_Price_Based_Country_Pro::plugin_path()  . 'templates/' );
		echo '</div>';
		
		$this->widget_end( $args );

	}	
	
}

?>