<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_Update_Exchange_Rates' ) ) :

/**
 *
 * Handle exchange rates updates from API providers
 *
 * @class    WCPBC_Update_Exchange_Rates
 * @version  2.1.7
 * @author   oscargare
 */
class WCPBC_Update_Exchange_Rates {
	
	/**
	 * Exchange provides.
	 *
	 * @var array
	 */
	private static $exchange_rates_providers = array();
	
	/**
	 * Init plugin, Hook actions and filters
	 *	 
	 */
	public static function init() {
		add_action( 'woocommerce_scheduled_sales', array( __CLASS__, 'update_exchange_rates'), 5 );
	}
	
	/**
	 * Get exchange rates providers.
	 *
	 * @return array
	 */
	public static function get_exchange_rates_providers() {	
		
		if ( empty( self::$exchange_rates_providers ) ) {			
			
			$exchange_rates_providers = array();				

			$exchange_rates_providers['floatrates'] 	= include('exchage-rates-providers/class-wcpbc-floatrates.php');			
			$exchange_rates_providers['fixerio'] 		= include('exchage-rates-providers/class-wcpbc-fixerio.php');						
			$exchange_rates_providers['yahoofinance'] 	= include('exchage-rates-providers/class-wcpbc-yahoofinance.php');						
			
			self::$exchange_rates_providers = apply_filters( 'pbc_aco_get_exchange_providers', $exchange_rates_providers );
		}		
		
		return self::$exchange_rates_providers; 
	}
	
	/**
	 * Update exchange rates
	 *
	 * @return void
	 */
	public static function update_exchange_rates() {

		$zones 		 = get_option( 'wc_price_based_country_regions', array() );			
		$to_currency = array();

		foreach ( $zones as $zone ) {
			if ( isset( $zone[ 'auto_exchange_rate' ] ) &&  $zone[ 'auto_exchange_rate' ] == 'yes' ) {
				$to_currency[] = $zone[ 'currency' ];
			}			
		}

		if ( $rates = self::get_exchange_rate_from_api( array_unique( $to_currency ) ) ) {

			foreach ( $zones as $zone_id => $zone ) {
				if ( isset( $zone[ 'auto_exchange_rate' ] ) && $zone[ 'auto_exchange_rate' ] == 'yes' && ! empty( $rates[ $zone[ 'currency' ] ] ) ) {
					$zones[ $zone_id ]['exchange_rate'] = $rates[ $zone[ 'currency' ] ];
				}				
			}

			update_option( 'wc_price_based_country_regions', $zones );			
			update_option( 'wc_price_based_country_timestamp', time() );		
		}		
	}		
	
	/**
	 * Retrun a exchange rate	 
	 *
	 * @param $to_currency array/string Currency code
	 * @return number
	 */	
	public static function get_exchange_rate_from_api( $to_currency ) {		

		$rates 		 = false;
		$single		 = is_array( $to_currency ) ? false : true;
		$to_currency = $single ? array( $to_currency ): $to_currency;

		$api_providers 		= self::get_exchange_rates_providers();
		$exchange_rate_api  = get_option( 'wc_price_based_country_exchange_rate_api', 'floatrates' );

		if ( $exchange_rate_api && isset( $api_providers[ $exchange_rate_api ] ) ) {

			$from_currency = get_option( 'woocommerce_currency');			
			$rates   	   = array();
			$_to_currency  = array();

			foreach ( $to_currency as $currency ) {				
				if ( $currency === $from_currency ) {
					$rates[ $currency ] = 1;
				} else {
					$_to_currency[] = $currency;
				}
			}

			if ( ! empty( $_to_currency ) ) {
				$rates = array_map( 'floatval', array_merge( $rates, $api_providers[ $exchange_rate_api ]->get_exchange_rates( $from_currency, $_to_currency ) ) );				
			}

			if ( $single ) {
				$rates = current( $rates );
			}						
		}

		return $rates;
	}		
}

endif;

WCPBC_Update_Exchange_Rates::init();