<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_Integrations_Pro' ) ) :

/**
 * Integrations 
 *
 * Handle integrations between PBC and 3rd-Party plugins
 *
 * @class    WCPBC_Integrations_Pro
 * @version  2.1.0
 * @author   oscargare
 */
class WCPBC_Integrations_Pro {

	/**
	 * Add built-in integrations
	 */
	public static function init() {

		$integrations = array(			
			'WC_Subscriptions'  => dirname( __FILE__ ) . '/integrations/woocommerce-subscriptions/class-wcpbc-subscriptions.php',			
			'WC_Bundles' 		=> dirname( __FILE__ ) . '/integrations/class-wcpbc-bundles.php',
			'WC_Product_Addons' => dirname( __FILE__ ) . '/integrations/class-wcpbc-product-addons.php',
			'WC_Bookings' 		=> dirname( __FILE__ ) . '/integrations/class-wcpbc-bookings.php'
		);
		
		foreach ( $integrations as $class => $integration_file ) {
			if( class_exists( $class ) ) {
				include_once( $integration_file );
			}
		}				
	}
}
endif;

add_action( 'plugins_loaded', array( 'WCPBC_Integrations_Pro', 'init' ) );


