<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_Exchange_Rates_Provider' ) ) :

/**
 *
 * @class WCPBC_Exchange_Rates_Provider
 * @version	2.1.7
 */
abstract class WCPBC_Exchange_Rates_Provider {	
	
	/**
	 * Exchange rates provider name.
	 *
	 * @var $name
	 */
	protected $name = '';

	/**	
	 *
	 * @var $from_currency
	 */
	protected $from_currency = false;

	/**	
	 *
	 * @var $from_currency
	 */
	protected $to_currency = array();

	/**
	 * Return provider name
	 *
	 * @return string
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Return API endpoint
	 *
	 * @param  string $from_currency
	 * @param  array $to_currency	 
	 * @return string
	 */
	abstract protected function get_api_endpoint();

	/**
	 * Return rates array from response
	 *
	 * @param string $data
	 * @return array
	 */
	abstract protected function parse_response( $data );

	/**
	 * Do request to enpoint
	 *	 
	 * @return array
	 */
	protected function do_request() {
		$api_endpoint = esc_url_raw( $this->get_api_endpoint() );
		$response 	  = wp_safe_remote_get( $api_endpoint, array(
			'timeout' => 15
		) );

		if ( is_wp_error( $response ) ) {
			return $response;
		}

		if ( empty( $response['response']['code'] ) || $response['response']['code'] != '200' ) {
			return new WP_Error( 'fail', $response['body'] );
		}
		
		return $this->parse_response( $response['body'] );
	}

	/**
	 * Return exchage rates array
	 *
	 * @param  string $from_currency
	 * @param  array $to_currency	 
	 * @return array
	 */
	public function get_exchange_rates( $from_currency, $to_currency ){

		$this->from_currency = $from_currency;
		$this->to_currency 	 = $to_currency;

		$rates = $this->do_request();

		if ( is_wp_error( $rates ) ) {		

			$logger = new WC_Logger();			
			$logger->add( 'wc_price_based_country', sprintf( __( 'Unable to update exchange rate from API: %s', 'wc-price-based-country' ) , $rates->get_error_message() ) );

			return array();
		}

		return $rates;
	}	
}

endif;